var t={name:"mermaid",version:"11.12.0",description:"Markdown-ish syntax for generating flowcharts, mindmaps, sequence diagrams, class diagrams, gantt charts, git graphs and more.",type:"module",module:"./dist/mermaid.core.mjs",types:"./dist/mermaid.d.ts",exports:{".":{types:"./dist/mermaid.d.ts",import:"./dist/mermaid.core.mjs",default:"./dist/mermaid.core.mjs"},"./*":"./*"},keywords:["diagram","markdown","flowchart","sequence diagram","gantt","class diagram","git graph","mindmap","packet diagram","c4 diagram","er diagram","pie chart","pie diagram","quadrant chart","requirement diagram","graph"],scripts:{clean:"rimraf dist",dev:"pnpm -w dev","docs:code":"typedoc src/defaultConfig.ts src/config.ts src/mermaid.ts && prettier --write ./src/docs/config/setup","docs:build":"rimraf ../../docs && pnpm docs:code && pnpm docs:spellcheck && tsx scripts/docs.cli.mts","docs:verify":"pnpm docs:code && pnpm docs:spellcheck && tsx scripts/docs.cli.mts --verify","docs:pre:vitepress":"pnpm --filter ./src/docs prefetch && rimraf src/vitepress && pnpm docs:code && tsx scripts/docs.cli.mts --vitepress && pnpm --filter ./src/vitepress install --no-frozen-lockfile --ignore-scripts","docs:build:vitepress":"pnpm docs:pre:vitepress && (cd src/vitepress && pnpm run build) && cpy --flat src/docs/landing/ ./src/vitepress/.vitepress/dist/landing","docs:dev":'pnpm docs:pre:vitepress && concurrently "pnpm --filter ./src/vitepress dev" "tsx scripts/docs.cli.mts --watch --vitepress"',"docs:dev:docker":'pnpm docs:pre:vitepress && concurrently "pnpm --filter ./src/vitepress dev:docker" "tsx scripts/docs.cli.mts --watch --vitepress"',"docs:serve":"pnpm docs:build:vitepress && vitepress serve src/vitepress","docs:spellcheck":'cspell "src/docs/**/*.md"',"docs:release-version":"tsx scripts/update-release-version.mts","docs:verify-version":"tsx scripts/update-release-version.mts --verify","types:build-config":"tsx scripts/create-types-from-json-schema.mts","types:verify-config":"tsx scripts/create-types-from-json-schema.mts --verify",checkCircle:"npx madge --circular ./src",prepublishOnly:"pnpm docs:verify-version"},repository:{type:"git",url:"https://github.com/mermaid-js/mermaid"},author:"Knut Sveidqvist",license:"MIT",standard:{ignore:["**/parser/*.js","dist/**/*.js","cypress/**/*.js"],globals:["page"]},dependencies:{"@braintree/sanitize-url":"^7.1.1","@iconify/utils":"^3.0.1","@mermaid-js/parser":"workspace:^","@types/d3":"^7.4.3",cytoscape:"^3.29.3","cytoscape-cose-bilkent":"^4.1.0","cytoscape-fcose":"^2.2.0",d3:"^7.9.0","d3-sankey":"^0.12.3","dagre-d3-es":"7.0.11",dayjs:"^1.11.18",dompurify:"^3.2.5",katex:"^0.16.22",khroma:"^2.1.0","lodash-es":"^4.17.21",marked:"^16.2.1",roughjs:"^4.6.6",stylis:"^4.3.6","ts-dedent":"^2.2.0",uuid:"^11.1.0"},devDependencies:{"@adobe/jsonschema2md":"^8.0.5","@iconify/types":"^2.0.0","@types/cytoscape":"^3.21.9","@types/cytoscape-fcose":"^2.2.4","@types/d3-sankey":"^0.12.4","@types/d3-scale":"^4.0.9","@types/d3-scale-chromatic":"^3.1.0","@types/d3-selection":"^3.0.11","@types/d3-shape":"^3.1.7","@types/jsdom":"^21.1.7","@types/katex":"^0.16.7","@types/lodash-es":"^4.17.12","@types/micromatch":"^4.0.9","@types/stylis":"^4.2.7","@types/uuid":"^10.0.0",ajv:"^8.17.1",canvas:"^3.1.2",chokidar:"3.6.0",concurrently:"^9.1.2","csstree-validator":"^4.0.1",globby:"^14.1.0",jison:"^0.4.18","js-base64":"^3.7.8",jsdom:"^26.1.0","json-schema-to-typescript":"^15.0.4",micromatch:"^4.0.8","path-browserify":"^1.0.1",prettier:"^3.5.3",remark:"^15.0.1","remark-frontmatter":"^5.0.0","remark-gfm":"^4.0.1",rimraf:"^6.0.1","start-server-and-test":"^2.0.13","type-fest":"^4.35.0",typedoc:"^0.28.12","typedoc-plugin-markdown":"^4.8.1",typescript:"~5.7.3","unist-util-flatmap":"^1.0.0","unist-util-visit":"^5.0.0",vitepress:"^1.6.4","vitepress-plugin-search":"1.0.4-alpha.22"},files:["dist/","README.md"],publishConfig:{access:"public"}},e=Object.create,r=Object.defineProperty,i=Object.getOwnPropertyDescriptor,n=Object.getOwnPropertyNames,a=Object.getPrototypeOf,o=Object.prototype.hasOwnProperty,s=(t,e)=>r(t,"name",{value:e,configurable:!0}),l=(t,e)=>()=>(e||t((e={exports:{}}).exports,e),e.exports),h=(t,e)=>{for(var i in e)r(t,i,{get:e[i],enumerable:!0})},c=(t,e,a,s)=>{if(e&&"object"==typeof e||"function"==typeof e)for(let l of n(e))!o.call(t,l)&&l!==a&&r(t,l,{get:()=>e[l],enumerable:!(s=i(e,l))||s.enumerable});return t},u=(t,e,r)=>(c(t,e,"default"),r),d=(t,i,n)=>(n=null!=t?e(a(t)):{},c(r(n,"default",{value:t,enumerable:!0}),t)),p=l((t,e)=>{!function(r,i){"object"==typeof t&&typeof e<"u"?e.exports=i():"function"==typeof define&&define.amd?define(i):(r=typeof globalThis<"u"?globalThis:r||self).dayjs=i()}(t,function(){var t=6e4,e=36e5,r="millisecond",i="second",n="minute",a="hour",o="day",l="week",h="month",c="quarter",u="year",d="date",p="Invalid Date",f=/^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[Tt\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/,g=/\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g,y={name:"en",weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),ordinal:s(function(t){var e=["th","st","nd","rd"],r=t%100;return"["+t+(e[(r-20)%10]||e[r]||e[0])+"]"},"ordinal")},m=s(function(t,e,r){var i=String(t);return!i||i.length>=e?t:""+Array(e+1-i.length).join(r)+t},"m"),x={s:m,z:s(function(t){var e=-t.utcOffset(),r=Math.abs(e),i=Math.floor(r/60),n=r%60;return(e<=0?"+":"-")+m(i,2,"0")+":"+m(n,2,"0")},"z"),m:s(function t(e,r){if(e.date()<r.date())return-t(r,e);var i=12*(r.year()-e.year())+(r.month()-e.month()),n=e.clone().add(i,h),a=r-n<0,o=e.clone().add(i+(a?-1:1),h);return+(-(i+(r-n)/(a?n-o:o-n))||0)},"t"),a:s(function(t){return t<0?Math.ceil(t)||0:Math.floor(t)},"a"),p:s(function(t){return{M:h,y:u,w:l,d:o,D:d,h:a,m:n,s:i,ms:r,Q:c}[t]||String(t||"").toLowerCase().replace(/s$/,"")},"p"),u:s(function(t){return void 0===t},"u")},b="en",k={};k[b]=y;var C="$isDayjsObject",w=s(function(t){return t instanceof T||!(!t||!t[C])},"S"),_=s(function t(e,r,i){var n;if(!e)return b;if("string"==typeof e){var a=e.toLowerCase();k[a]&&(n=a),r&&(k[a]=r,n=a);var o=e.split("-");if(!n&&o.length>1)return t(o[0])}else{var s=e.name;k[s]=e,n=s}return!i&&n&&(b=n),n||!i&&b},"t"),v=s(function(t,e){if(w(t))return t.clone();var r="object"==typeof e?e:{};return r.date=t,r.args=arguments,new T(r)},"O"),S=x;S.l=_,S.i=w,S.w=function(t,e){return v(t,{locale:e.$L,utc:e.$u,x:e.$x,$offset:e.$offset})};var T=function(){function y(t){this.$L=_(t.locale,null,!0),this.parse(t),this.$x=this.$x||t.x||{},this[C]=!0}s(y,"M");var m=y.prototype;return m.parse=function(t){this.$d=function(t){var e=t.date,r=t.utc;if(null===e)return new Date(NaN);if(S.u(e))return new Date;if(e instanceof Date)return new Date(e);if("string"==typeof e&&!/Z$/i.test(e)){var i=e.match(f);if(i){var n=i[2]-1||0,a=(i[7]||"0").substring(0,3);return r?new Date(Date.UTC(i[1],n,i[3]||1,i[4]||0,i[5]||0,i[6]||0,a)):new Date(i[1],n,i[3]||1,i[4]||0,i[5]||0,i[6]||0,a)}}return new Date(e)}(t),this.init()},m.init=function(){var t=this.$d;this.$y=t.getFullYear(),this.$M=t.getMonth(),this.$D=t.getDate(),this.$W=t.getDay(),this.$H=t.getHours(),this.$m=t.getMinutes(),this.$s=t.getSeconds(),this.$ms=t.getMilliseconds()},m.$utils=function(){return S},m.isValid=function(){return this.$d.toString()!==p},m.isSame=function(t,e){var r=v(t);return this.startOf(e)<=r&&r<=this.endOf(e)},m.isAfter=function(t,e){return v(t)<this.startOf(e)},m.isBefore=function(t,e){return this.endOf(e)<v(t)},m.$g=function(t,e,r){return S.u(t)?this[e]:this.set(r,t)},m.unix=function(){return Math.floor(this.valueOf()/1e3)},m.valueOf=function(){return this.$d.getTime()},m.startOf=function(t,e){var r=this,c=!!S.u(e)||e,p=S.p(t),f=s(function(t,e){var i=S.w(r.$u?Date.UTC(r.$y,e,t):new Date(r.$y,e,t),r);return c?i:i.endOf(o)},"l"),g=s(function(t,e){return S.w(r.toDate()[t].apply(r.toDate("s"),(c?[0,0,0,0]:[23,59,59,999]).slice(e)),r)},"$"),y=this.$W,m=this.$M,x=this.$D,b="set"+(this.$u?"UTC":"");switch(p){case u:return c?f(1,0):f(31,11);case h:return c?f(1,m):f(0,m+1);case l:var k=this.$locale().weekStart||0,C=(y<k?y+7:y)-k;return f(c?x-C:x+(6-C),m);case o:case d:return g(b+"Hours",0);case a:return g(b+"Minutes",1);case n:return g(b+"Seconds",2);case i:return g(b+"Milliseconds",3);default:return this.clone()}},m.endOf=function(t){return this.startOf(t,!1)},m.$set=function(t,e){var s,l=S.p(t),c="set"+(this.$u?"UTC":""),p=(s={},s[o]=c+"Date",s[d]=c+"Date",s[h]=c+"Month",s[u]=c+"FullYear",s[a]=c+"Hours",s[n]=c+"Minutes",s[i]=c+"Seconds",s[r]=c+"Milliseconds",s)[l],f=l===o?this.$D+(e-this.$W):e;if(l===h||l===u){var g=this.clone().set(d,1);g.$d[p](f),g.init(),this.$d=g.set(d,Math.min(this.$D,g.daysInMonth())).$d}else p&&this.$d[p](f);return this.init(),this},m.set=function(t,e){return this.clone().$set(t,e)},m.get=function(t){return this[S.p(t)]()},m.add=function(r,c){var d,p=this;r=Number(r);var f=S.p(c),g=s(function(t){var e=v(p);return S.w(e.date(e.date()+Math.round(t*r)),p)},"y");if(f===h)return this.set(h,this.$M+r);if(f===u)return this.set(u,this.$y+r);if(f===o)return g(1);if(f===l)return g(7);var y=(d={},d[n]=t,d[a]=e,d[i]=1e3,d)[f]||1,m=this.$d.getTime()+r*y;return S.w(m,this)},m.subtract=function(t,e){return this.add(-1*t,e)},m.format=function(t){var e=this,r=this.$locale();if(!this.isValid())return r.invalidDate||p;var i=t||"YYYY-MM-DDTHH:mm:ssZ",n=S.z(this),a=this.$H,o=this.$m,l=this.$M,h=r.weekdays,c=r.months,u=r.meridiem,d=s(function(t,r,n,a){return t&&(t[r]||t(e,i))||n[r].slice(0,a)},"h"),f=s(function(t){return S.s(a%12||12,t,"0")},"d"),y=u||function(t,e,r){var i=t<12?"AM":"PM";return r?i.toLowerCase():i};return i.replace(g,function(t,i){return i||function(t){switch(t){case"YY":return String(e.$y).slice(-2);case"YYYY":return S.s(e.$y,4,"0");case"M":return l+1;case"MM":return S.s(l+1,2,"0");case"MMM":return d(r.monthsShort,l,c,3);case"MMMM":return d(c,l);case"D":return e.$D;case"DD":return S.s(e.$D,2,"0");case"d":return String(e.$W);case"dd":return d(r.weekdaysMin,e.$W,h,2);case"ddd":return d(r.weekdaysShort,e.$W,h,3);case"dddd":return h[e.$W];case"H":return String(a);case"HH":return S.s(a,2,"0");case"h":return f(1);case"hh":return f(2);case"a":return y(a,o,!0);case"A":return y(a,o,!1);case"m":return String(o);case"mm":return S.s(o,2,"0");case"s":return String(e.$s);case"ss":return S.s(e.$s,2,"0");case"SSS":return S.s(e.$ms,3,"0");case"Z":return n}return null}(t)||n.replace(":","")})},m.utcOffset=function(){return 15*-Math.round(this.$d.getTimezoneOffset()/15)},m.diff=function(r,d,p){var f,g=this,y=S.p(d),m=v(r),x=(m.utcOffset()-this.utcOffset())*t,b=this-m,k=s(function(){return S.m(g,m)},"D");switch(y){case u:f=k()/12;break;case h:f=k();break;case c:f=k()/3;break;case l:f=(b-x)/6048e5;break;case o:f=(b-x)/864e5;break;case a:f=b/e;break;case n:f=b/t;break;case i:f=b/1e3;break;default:f=b}return p?f:S.a(f)},m.daysInMonth=function(){return this.endOf(h).$D},m.$locale=function(){return k[this.$L]},m.locale=function(t,e){if(!t)return this.$L;var r=this.clone(),i=_(t,e,!0);return i&&(r.$L=i),r},m.clone=function(){return S.w(this.$d,this)},m.toDate=function(){return new Date(this.valueOf())},m.toJSON=function(){return this.isValid()?this.toISOString():null},m.toISOString=function(){return this.$d.toISOString()},m.toString=function(){return this.$d.toUTCString()},y}(),M=T.prototype;return v.prototype=M,[["$ms",r],["$s",i],["$m",n],["$H",a],["$W",o],["$M",h],["$y",u],["$D",d]].forEach(function(t){M[t[1]]=function(e){return this.$g(e,t[0],t[1])}}),v.extend=function(t,e){return t.$i||(t(e,T,v),t.$i=!0),v},v.locale=_,v.isDayjs=w,v.unix=function(t){return v(1e3*t)},v.en=k[b],v.Ls=k,v.p={},v})}),f=d(p()),g={trace:0,debug:1,info:2,warn:3,error:4,fatal:5},y={trace:s((...t)=>{},"trace"),debug:s((...t)=>{},"debug"),info:s((...t)=>{},"info"),warn:s((...t)=>{},"warn"),error:s((...t)=>{},"error"),fatal:s((...t)=>{},"fatal")},m=s(function(t="fatal"){let e=g.fatal;"string"==typeof t?t.toLowerCase()in g&&(e=g[t]):"number"==typeof t&&(e=t),y.trace=()=>{},y.debug=()=>{},y.info=()=>{},y.warn=()=>{},y.error=()=>{},y.fatal=()=>{},e<=g.fatal&&(y.fatal=console.error?console.error.bind(console,x("FATAL"),"color: orange"):console.log.bind(console,"[35m",x("FATAL"))),e<=g.error&&(y.error=console.error?console.error.bind(console,x("ERROR"),"color: orange"):console.log.bind(console,"[31m",x("ERROR"))),e<=g.warn&&(y.warn=console.warn?console.warn.bind(console,x("WARN"),"color: orange"):console.log.bind(console,"[33m",x("WARN"))),e<=g.info&&(y.info=console.info?console.info.bind(console,x("INFO"),"color: lightblue"):console.log.bind(console,"[34m",x("INFO"))),e<=g.debug&&(y.debug=console.debug?console.debug.bind(console,x("DEBUG"),"color: lightgreen"):console.log.bind(console,"[32m",x("DEBUG"))),e<=g.trace&&(y.trace=console.debug?console.debug.bind(console,x("TRACE"),"color: lightgreen"):console.log.bind(console,"[32m",x("TRACE")))},"setLogLevel"),x=s(t=>`%c${(0,f.default)().format("ss.SSS")} : ${t} : `,"format");function b(t,e){let r;if(void 0===e)for(let e of t)null!=e&&(r<e||void 0===r&&e>=e)&&(r=e);else{let i=-1;for(let n of t)null!=(n=e(n,++i,t))&&(r<n||void 0===r&&n>=n)&&(r=n)}return r}function k(t,e){let r;if(void 0===e)for(let e of t)null!=e&&(r>e||void 0===r&&e>=e)&&(r=e);else{let i=-1;for(let n of t)null!=(n=e(n,++i,t))&&(r>n||void 0===r&&n>=n)&&(r=n)}return r}function C(t,e){return null==t||null==e?NaN:t<e?-1:t>e?1:t>=e?0:NaN}function w(t,e){return null==t||null==e?NaN:e<t?-1:e>t?1:e>=t?0:NaN}function _(t){let e,r,i;function n(t,i,n=0,a=t.length){if(n<a){if(0!==e(i,i))return a;do{let e=n+a>>>1;r(t[e],i)<0?n=e+1:a=e}while(n<a)}return n}function a(t,i,n=0,a=t.length){if(n<a){if(0!==e(i,i))return a;do{let e=n+a>>>1;r(t[e],i)<=0?n=e+1:a=e}while(n<a)}return n}function o(t,e,r=0,a=t.length){let o=n(t,e,r,a-1);return o>r&&i(t[o-1],e)>-i(t[o],e)?o-1:o}return 2!==t.length?(e=C,r=s((e,r)=>C(t(e),r),"compare2"),i=s((e,r)=>t(e)-r,"delta")):(e=t===C||t===w?t:v,r=t,i=t),s(n,"left"),s(a,"right"),s(o,"center"),{left:n,center:o,right:a}}function v(){return 0}function S(t){return null===t?NaN:+t}s(b,"max"),s(k,"min"),s(C,"ascending"),s(w,"descending"),s(_,"bisector"),s(v,"zero"),s(S,"number");var T=_(C),M=T.right;T.left,_(S).center;var B=M,A=class extends Map{static{s(this,"InternMap")}constructor(t,e=E){if(super(),Object.defineProperties(this,{_intern:{value:new Map},_key:{value:e}}),null!=t)for(let[e,r]of t)this.set(e,r)}get(t){return super.get(L(this,t))}has(t){return super.has(L(this,t))}set(t,e){return super.set(F(this,t),e)}delete(t){return super.delete($(this,t))}};function L({_intern:t,_key:e},r){let i=e(r);return t.has(i)?t.get(i):r}function F({_intern:t,_key:e},r){let i=e(r);return t.has(i)?t.get(i):(t.set(i,r),r)}function $({_intern:t,_key:e},r){let i=e(r);return t.has(i)&&(r=t.get(i),t.delete(i)),r}function E(t){return null!==t&&"object"==typeof t?t.valueOf():t}s(L,"intern_get"),s(F,"intern_set"),s($,"intern_delete"),s(E,"keyof");var D=Math.sqrt(50),O=Math.sqrt(10),I=Math.sqrt(2);function N(t,e,r){let i,n,a,o=(e-t)/Math.max(0,r),s=Math.floor(Math.log10(o)),l=o/Math.pow(10,s),h=l>=D?10:l>=O?5:l>=I?2:1;return s<0?(a=Math.pow(10,-s)/h,i=Math.round(t*a),n=Math.round(e*a),i/a<t&&++i,n/a>e&&--n,a=-a):(a=Math.pow(10,s)*h,i=Math.round(t/a),n=Math.round(e/a),i*a<t&&++i,n*a>e&&--n),n<i&&.5<=r&&r<2?N(t,e,2*r):[i,n,a]}function R(t,e,r){if(!((r=+r)>0))return[];if((t=+t)===(e=+e))return[t];let i=e<t,[n,a,o]=i?N(e,t,r):N(t,e,r);if(!(a>=n))return[];let s=a-n+1,l=new Array(s);if(i)if(o<0)for(let t=0;t<s;++t)l[t]=(a-t)/-o;else for(let t=0;t<s;++t)l[t]=(a-t)*o;else if(o<0)for(let t=0;t<s;++t)l[t]=(n+t)/-o;else for(let t=0;t<s;++t)l[t]=(n+t)*o;return l}function P(t,e,r){return N(t=+t,e=+e,r=+r)[2]}function z(t,e,r){r=+r;let i=(e=+e)<(t=+t),n=i?P(e,t,r):P(t,e,r);return(i?-1:1)*(n<0?1/-n:n)}function q(t,e,r){t=+t,e=+e,r=(n=arguments.length)<2?(e=t,t=0,1):n<3?1:+r;for(var i=-1,n=0|Math.max(0,Math.ceil((e-t)/r)),a=new Array(n);++i<n;)a[i]=t+i*r;return a}function j(t){return t}s(N,"tickSpec"),s(R,"ticks"),s(P,"tickIncrement"),s(z,"tickStep"),s(q,"range"),s(j,"default");var W=1e-6;function H(t){return"translate("+t+",0)"}function U(t){return"translate(0,"+t+")"}function Y(t){return e=>+t(e)}function V(t,e){return e=Math.max(0,t.bandwidth()-2*e)/2,t.round()&&(e=Math.round(e)),r=>+t(r)+e}function G(){return!this.__axis}function X(t,e){var r=[],i=null,n=null,a=6,o=6,l=3,h=typeof window<"u"&&window.devicePixelRatio>1?0:.5,c=1===t||4===t?-1:1,u=4===t||2===t?"x":"y",d=1===t||3===t?H:U;function p(s){var p=i??(e.ticks?e.ticks.apply(e,r):e.domain()),f=n??(e.tickFormat?e.tickFormat.apply(e,r):j),g=Math.max(a,0)+l,y=e.range(),m=+y[0]+h,x=+y[y.length-1]+h,b=(e.bandwidth?V:Y)(e.copy(),h),k=s.selection?s.selection():s,C=k.selectAll(".domain").data([null]),w=k.selectAll(".tick").data(p,e).order(),_=w.exit(),v=w.enter().append("g").attr("class","tick"),S=w.select("line"),T=w.select("text");C=C.merge(C.enter().insert("path",".tick").attr("class","domain").attr("stroke","currentColor")),w=w.merge(v),S=S.merge(v.append("line").attr("stroke","currentColor").attr(u+"2",c*a)),T=T.merge(v.append("text").attr("fill","currentColor").attr(u,c*g).attr("dy",1===t?"0em":3===t?"0.71em":"0.32em")),s!==k&&(C=C.transition(s),w=w.transition(s),S=S.transition(s),T=T.transition(s),_=_.transition(s).attr("opacity",W).attr("transform",function(t){return isFinite(t=b(t))?d(t+h):this.getAttribute("transform")}),v.attr("opacity",W).attr("transform",function(t){var e=this.parentNode.__axis;return d((e&&isFinite(e=e(t))?e:b(t))+h)})),_.remove(),C.attr("d",4===t||2===t?o?"M"+c*o+","+m+"H"+h+"V"+x+"H"+c*o:"M"+h+","+m+"V"+x:o?"M"+m+","+c*o+"V"+h+"H"+x+"V"+c*o:"M"+m+","+h+"H"+x),w.attr("opacity",1).attr("transform",function(t){return d(b(t)+h)}),S.attr(u+"2",c*a),T.attr(u,c*g).text(f),k.filter(G).attr("fill","none").attr("font-size",10).attr("font-family","sans-serif").attr("text-anchor",2===t?"start":4===t?"end":"middle"),k.each(function(){this.__axis=b})}return s(p,"axis"),p.scale=function(t){return arguments.length?(e=t,p):e},p.ticks=function(){return r=Array.from(arguments),p},p.tickArguments=function(t){return arguments.length?(r=null==t?[]:Array.from(t),p):r.slice()},p.tickValues=function(t){return arguments.length?(i=null==t?null:Array.from(t),p):i&&i.slice()},p.tickFormat=function(t){return arguments.length?(n=t,p):n},p.tickSize=function(t){return arguments.length?(a=o=+t,p):a},p.tickSizeInner=function(t){return arguments.length?(a=+t,p):a},p.tickSizeOuter=function(t){return arguments.length?(o=+t,p):o},p.tickPadding=function(t){return arguments.length?(l=+t,p):l},p.offset=function(t){return arguments.length?(h=+t,p):h},p}function Z(t){return X(1,t)}function Q(t){return X(3,t)}function K(){}function J(t){return null==t?K:function(){return this.querySelector(t)}}function tt(t){"function"!=typeof t&&(t=J(t));for(var e=this._groups,r=e.length,i=new Array(r),n=0;n<r;++n)for(var a,o,s=e[n],l=s.length,h=i[n]=new Array(l),c=0;c<l;++c)(a=s[c])&&(o=t.call(a,a.__data__,c,s))&&("__data__"in a&&(o.__data__=a.__data__),h[c]=o);return new Ge(i,this._parents)}function et(t){return null==t?[]:Array.isArray(t)?t:Array.from(t)}function rt(){return[]}function it(t){return null==t?rt:function(){return this.querySelectorAll(t)}}function nt(t){return function(){return et(t.apply(this,arguments))}}function at(t){t="function"==typeof t?nt(t):it(t);for(var e=this._groups,r=e.length,i=[],n=[],a=0;a<r;++a)for(var o,s=e[a],l=s.length,h=0;h<l;++h)(o=s[h])&&(i.push(t.call(o,o.__data__,h,s)),n.push(o));return new Ge(i,n)}function ot(t){return function(){return this.matches(t)}}function st(t){return function(e){return e.matches(t)}}s(H,"translateX"),s(U,"translateY"),s(Y,"number"),s(V,"center"),s(G,"entering"),s(X,"axis"),s(Z,"axisTop"),s(Q,"axisBottom"),s(K,"none"),s(J,"default"),s(tt,"default"),s(et,"array"),s(rt,"empty"),s(it,"default"),s(nt,"arrayAll"),s(at,"default"),s(ot,"default"),s(st,"childMatcher");var lt=Array.prototype.find;function ht(t){return function(){return lt.call(this.children,t)}}function ct(){return this.firstElementChild}function ut(t){return this.select(null==t?ct:ht("function"==typeof t?t:st(t)))}s(ht,"childFind"),s(ct,"childFirst"),s(ut,"default");var dt=Array.prototype.filter;function pt(){return Array.from(this.children)}function ft(t){return function(){return dt.call(this.children,t)}}function gt(t){return this.selectAll(null==t?pt:ft("function"==typeof t?t:st(t)))}function yt(t){"function"!=typeof t&&(t=ot(t));for(var e=this._groups,r=e.length,i=new Array(r),n=0;n<r;++n)for(var a,o=e[n],s=o.length,l=i[n]=[],h=0;h<s;++h)(a=o[h])&&t.call(a,a.__data__,h,o)&&l.push(a);return new Ge(i,this._parents)}function mt(t){return new Array(t.length)}function xt(){return new Ge(this._enter||this._groups.map(mt),this._parents)}function bt(t,e){this.ownerDocument=t.ownerDocument,this.namespaceURI=t.namespaceURI,this._next=null,this._parent=t,this.__data__=e}function kt(t){return function(){return t}}function Ct(t,e,r,i,n,a){for(var o,s=0,l=e.length,h=a.length;s<h;++s)(o=e[s])?(o.__data__=a[s],i[s]=o):r[s]=new bt(t,a[s]);for(;s<l;++s)(o=e[s])&&(n[s]=o)}function wt(t,e,r,i,n,a,o){var s,l,h,c=new Map,u=e.length,d=a.length,p=new Array(u);for(s=0;s<u;++s)(l=e[s])&&(p[s]=h=o.call(l,l.__data__,s,e)+"",c.has(h)?n[s]=l:c.set(h,l));for(s=0;s<d;++s)h=o.call(t,a[s],s,a)+"",(l=c.get(h))?(i[s]=l,l.__data__=a[s],c.delete(h)):r[s]=new bt(t,a[s]);for(s=0;s<u;++s)(l=e[s])&&c.get(p[s])===l&&(n[s]=l)}function _t(t){return t.__data__}function vt(t,e){if(!arguments.length)return Array.from(this,_t);var r=e?wt:Ct,i=this._parents,n=this._groups;"function"!=typeof t&&(t=kt(t));for(var a=n.length,o=new Array(a),s=new Array(a),l=new Array(a),h=0;h<a;++h){var c=i[h],u=n[h],d=u.length,p=St(t.call(c,c&&c.__data__,h,i)),f=p.length,g=s[h]=new Array(f),y=o[h]=new Array(f);r(c,u,g,y,l[h]=new Array(d),p,e);for(var m,x,b=0,k=0;b<f;++b)if(m=g[b]){for(b>=k&&(k=b+1);!(x=y[k])&&++k<f;);m._next=x||null}}return(o=new Ge(o,i))._enter=s,o._exit=l,o}function St(t){return"object"==typeof t&&"length"in t?t:Array.from(t)}function Tt(){return new Ge(this._exit||this._groups.map(mt),this._parents)}function Mt(t,e,r){var i=this.enter(),n=this,a=this.exit();return"function"==typeof t?(i=t(i))&&(i=i.selection()):i=i.append(t+""),null!=e&&((n=e(n))&&(n=n.selection())),null==r?a.remove():r(a),i&&n?i.merge(n).order():n}function Bt(t){for(var e=t.selection?t.selection():t,r=this._groups,i=e._groups,n=r.length,a=i.length,o=Math.min(n,a),s=new Array(n),l=0;l<o;++l)for(var h,c=r[l],u=i[l],d=c.length,p=s[l]=new Array(d),f=0;f<d;++f)(h=c[f]||u[f])&&(p[f]=h);for(;l<n;++l)s[l]=r[l];return new Ge(s,this._parents)}function At(){for(var t=this._groups,e=-1,r=t.length;++e<r;)for(var i,n=t[e],a=n.length-1,o=n[a];--a>=0;)(i=n[a])&&(o&&4^i.compareDocumentPosition(o)&&o.parentNode.insertBefore(i,o),o=i);return this}function Lt(t){function e(e,r){return e&&r?t(e.__data__,r.__data__):!e-!r}t||(t=Ft),s(e,"compareNode");for(var r=this._groups,i=r.length,n=new Array(i),a=0;a<i;++a){for(var o,l=r[a],h=l.length,c=n[a]=new Array(h),u=0;u<h;++u)(o=l[u])&&(c[u]=o);c.sort(e)}return new Ge(n,this._parents).order()}function Ft(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}function $t(){var t=arguments[0];return arguments[0]=this,t.apply(null,arguments),this}function Et(){return Array.from(this)}function Dt(){for(var t=this._groups,e=0,r=t.length;e<r;++e)for(var i=t[e],n=0,a=i.length;n<a;++n){var o=i[n];if(o)return o}return null}function Ot(){let t=0;for(let e of this)++t;return t}function It(){return!this.node()}function Nt(t){for(var e=this._groups,r=0,i=e.length;r<i;++r)for(var n,a=e[r],o=0,s=a.length;o<s;++o)(n=a[o])&&t.call(n,n.__data__,o,a);return this}s(pt,"children"),s(ft,"childrenFilter"),s(gt,"default"),s(yt,"default"),s(mt,"default"),s(xt,"default"),s(bt,"EnterNode"),bt.prototype={constructor:bt,appendChild:s(function(t){return this._parent.insertBefore(t,this._next)},"appendChild"),insertBefore:s(function(t,e){return this._parent.insertBefore(t,e)},"insertBefore"),querySelector:s(function(t){return this._parent.querySelector(t)},"querySelector"),querySelectorAll:s(function(t){return this._parent.querySelectorAll(t)},"querySelectorAll")},s(kt,"default"),s(Ct,"bindIndex"),s(wt,"bindKey"),s(_t,"datum"),s(vt,"default"),s(St,"arraylike"),s(Tt,"default"),s(Mt,"default"),s(Bt,"default"),s(At,"default"),s(Lt,"default"),s(Ft,"ascending"),s($t,"default"),s(Et,"default"),s(Dt,"default"),s(Ot,"default"),s(It,"default"),s(Nt,"default");var Rt="http://www.w3.org/1999/xhtml",Pt={svg:"http://www.w3.org/2000/svg",xhtml:Rt,xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};function zt(t){var e=t+="",r=e.indexOf(":");return r>=0&&"xmlns"!==(e=t.slice(0,r))&&(t=t.slice(r+1)),Pt.hasOwnProperty(e)?{space:Pt[e],local:t}:t}function qt(t){return function(){this.removeAttribute(t)}}function jt(t){return function(){this.removeAttributeNS(t.space,t.local)}}function Wt(t,e){return function(){this.setAttribute(t,e)}}function Ht(t,e){return function(){this.setAttributeNS(t.space,t.local,e)}}function Ut(t,e){return function(){var r=e.apply(this,arguments);null==r?this.removeAttribute(t):this.setAttribute(t,r)}}function Yt(t,e){return function(){var r=e.apply(this,arguments);null==r?this.removeAttributeNS(t.space,t.local):this.setAttributeNS(t.space,t.local,r)}}function Vt(t,e){var r=zt(t);if(arguments.length<2){var i=this.node();return r.local?i.getAttributeNS(r.space,r.local):i.getAttribute(r)}return this.each((null==e?r.local?jt:qt:"function"==typeof e?r.local?Yt:Ut:r.local?Ht:Wt)(r,e))}function Gt(t){return t.ownerDocument&&t.ownerDocument.defaultView||t.document&&t||t.defaultView}function Xt(t){return function(){this.style.removeProperty(t)}}function Zt(t,e,r){return function(){this.style.setProperty(t,e,r)}}function Qt(t,e,r){return function(){var i=e.apply(this,arguments);null==i?this.style.removeProperty(t):this.style.setProperty(t,i,r)}}function Kt(t,e,r){return arguments.length>1?this.each((null==e?Xt:"function"==typeof e?Qt:Zt)(t,e,r??"")):Jt(this.node(),t)}function Jt(t,e){return t.style.getPropertyValue(e)||Gt(t).getComputedStyle(t,null).getPropertyValue(e)}function te(t){return function(){delete this[t]}}function ee(t,e){return function(){this[t]=e}}function re(t,e){return function(){var r=e.apply(this,arguments);null==r?delete this[t]:this[t]=r}}function ie(t,e){return arguments.length>1?this.each((null==e?te:"function"==typeof e?re:ee)(t,e)):this.node()[t]}function ne(t){return t.trim().split(/^|\s+/)}function ae(t){return t.classList||new oe(t)}function oe(t){this._node=t,this._names=ne(t.getAttribute("class")||"")}function se(t,e){for(var r=ae(t),i=-1,n=e.length;++i<n;)r.add(e[i])}function le(t,e){for(var r=ae(t),i=-1,n=e.length;++i<n;)r.remove(e[i])}function he(t){return function(){se(this,t)}}function ce(t){return function(){le(this,t)}}function ue(t,e){return function(){(e.apply(this,arguments)?se:le)(this,t)}}function de(t,e){var r=ne(t+"");if(arguments.length<2){for(var i=ae(this.node()),n=-1,a=r.length;++n<a;)if(!i.contains(r[n]))return!1;return!0}return this.each(("function"==typeof e?ue:e?he:ce)(r,e))}function pe(){this.textContent=""}function fe(t){return function(){this.textContent=t}}function ge(t){return function(){var e=t.apply(this,arguments);this.textContent=e??""}}function ye(t){return arguments.length?this.each(null==t?pe:("function"==typeof t?ge:fe)(t)):this.node().textContent}function me(){this.innerHTML=""}function xe(t){return function(){this.innerHTML=t}}function be(t){return function(){var e=t.apply(this,arguments);this.innerHTML=e??""}}function ke(t){return arguments.length?this.each(null==t?me:("function"==typeof t?be:xe)(t)):this.node().innerHTML}function Ce(){this.nextSibling&&this.parentNode.appendChild(this)}function we(){return this.each(Ce)}function _e(){this.previousSibling&&this.parentNode.insertBefore(this,this.parentNode.firstChild)}function ve(){return this.each(_e)}function Se(t){return function(){var e=this.ownerDocument,r=this.namespaceURI;return r===Rt&&e.documentElement.namespaceURI===Rt?e.createElement(t):e.createElementNS(r,t)}}function Te(t){return function(){return this.ownerDocument.createElementNS(t.space,t.local)}}function Me(t){var e=zt(t);return(e.local?Te:Se)(e)}function Be(t){var e="function"==typeof t?t:Me(t);return this.select(function(){return this.appendChild(e.apply(this,arguments))})}function Ae(){return null}function Le(t,e){var r="function"==typeof t?t:Me(t),i=null==e?Ae:"function"==typeof e?e:J(e);return this.select(function(){return this.insertBefore(r.apply(this,arguments),i.apply(this,arguments)||null)})}function Fe(){var t=this.parentNode;t&&t.removeChild(this)}function $e(){return this.each(Fe)}function Ee(){var t=this.cloneNode(!1),e=this.parentNode;return e?e.insertBefore(t,this.nextSibling):t}function De(){var t=this.cloneNode(!0),e=this.parentNode;return e?e.insertBefore(t,this.nextSibling):t}function Oe(t){return this.select(t?De:Ee)}function Ie(t){return arguments.length?this.property("__data__",t):this.node().__data__}function Ne(t){return function(e){t.call(this,e,this.__data__)}}function Re(t){return t.trim().split(/^|\s+/).map(function(t){var e="",r=t.indexOf(".");return r>=0&&(e=t.slice(r+1),t=t.slice(0,r)),{type:t,name:e}})}function Pe(t){return function(){var e=this.__on;if(e){for(var r,i=0,n=-1,a=e.length;i<a;++i)r=e[i],t.type&&r.type!==t.type||r.name!==t.name?e[++n]=r:this.removeEventListener(r.type,r.listener,r.options);++n?e.length=n:delete this.__on}}}function ze(t,e,r){return function(){var i,n=this.__on,a=Ne(e);if(n)for(var o=0,s=n.length;o<s;++o)if((i=n[o]).type===t.type&&i.name===t.name)return this.removeEventListener(i.type,i.listener,i.options),this.addEventListener(i.type,i.listener=a,i.options=r),void(i.value=e);this.addEventListener(t.type,a,r),i={type:t.type,name:t.name,value:e,listener:a,options:r},n?n.push(i):this.__on=[i]}}function qe(t,e,r){var i,n,a=Re(t+""),o=a.length;if(!(arguments.length<2)){for(s=e?ze:Pe,i=0;i<o;++i)this.each(s(a[i],e,r));return this}var s=this.node().__on;if(s)for(var l,h=0,c=s.length;h<c;++h)for(i=0,l=s[h];i<o;++i)if((n=a[i]).type===l.type&&n.name===l.name)return l.value}function je(t,e,r){var i=Gt(t),n=i.CustomEvent;"function"==typeof n?n=new n(e,r):(n=i.document.createEvent("Event"),r?(n.initEvent(e,r.bubbles,r.cancelable),n.detail=r.detail):n.initEvent(e,!1,!1)),t.dispatchEvent(n)}function We(t,e){return function(){return je(this,t,e)}}function He(t,e){return function(){return je(this,t,e.apply(this,arguments))}}function Ue(t,e){return this.each(("function"==typeof e?He:We)(t,e))}function*Ye(){for(var t=this._groups,e=0,r=t.length;e<r;++e)for(var i,n=t[e],a=0,o=n.length;a<o;++a)(i=n[a])&&(yield i)}s(zt,"default"),s(qt,"attrRemove"),s(jt,"attrRemoveNS"),s(Wt,"attrConstant"),s(Ht,"attrConstantNS"),s(Ut,"attrFunction"),s(Yt,"attrFunctionNS"),s(Vt,"default"),s(Gt,"default"),s(Xt,"styleRemove"),s(Zt,"styleConstant"),s(Qt,"styleFunction"),s(Kt,"default"),s(Jt,"styleValue"),s(te,"propertyRemove"),s(ee,"propertyConstant"),s(re,"propertyFunction"),s(ie,"default"),s(ne,"classArray"),s(ae,"classList"),s(oe,"ClassList"),oe.prototype={add:s(function(t){this._names.indexOf(t)<0&&(this._names.push(t),this._node.setAttribute("class",this._names.join(" ")))},"add"),remove:s(function(t){var e=this._names.indexOf(t);e>=0&&(this._names.splice(e,1),this._node.setAttribute("class",this._names.join(" ")))},"remove"),contains:s(function(t){return this._names.indexOf(t)>=0},"contains")},s(se,"classedAdd"),s(le,"classedRemove"),s(he,"classedTrue"),s(ce,"classedFalse"),s(ue,"classedFunction"),s(de,"default"),s(pe,"textRemove"),s(fe,"textConstant"),s(ge,"textFunction"),s(ye,"default"),s(me,"htmlRemove"),s(xe,"htmlConstant"),s(be,"htmlFunction"),s(ke,"default"),s(Ce,"raise"),s(we,"default"),s(_e,"lower"),s(ve,"default"),s(Se,"creatorInherit"),s(Te,"creatorFixed"),s(Me,"default"),s(Be,"default"),s(Ae,"constantNull"),s(Le,"default"),s(Fe,"remove"),s($e,"default"),s(Ee,"selection_cloneShallow"),s(De,"selection_cloneDeep"),s(Oe,"default"),s(Ie,"default"),s(Ne,"contextListener"),s(Re,"parseTypenames"),s(Pe,"onRemove"),s(ze,"onAdd"),s(qe,"default"),s(je,"dispatchEvent"),s(We,"dispatchConstant"),s(He,"dispatchFunction"),s(Ue,"default"),s(Ye,"default");var Ve=[null];function Ge(t,e){this._groups=t,this._parents=e}function Xe(){return new Ge([[document.documentElement]],Ve)}function Ze(){return this}s(Ge,"Selection"),s(Xe,"selection"),s(Ze,"selection_selection"),Ge.prototype=Xe.prototype={constructor:Ge,select:tt,selectAll:at,selectChild:ut,selectChildren:gt,filter:yt,data:vt,enter:xt,exit:Tt,join:Mt,merge:Bt,selection:Ze,order:At,sort:Lt,call:$t,nodes:Et,node:Dt,size:Ot,empty:It,each:Nt,attr:Vt,style:Kt,property:ie,classed:de,text:ye,html:ke,raise:we,lower:ve,append:Be,insert:Le,remove:$e,clone:Oe,datum:Ie,on:qe,dispatch:Ue,[Symbol.iterator]:Ye};var Qe=Xe;function Ke(t){return"string"==typeof t?new Ge([[document.querySelector(t)]],[document.documentElement]):new Ge([[t]],Ve)}function Je(t,e,r){t.prototype=e.prototype=r,r.constructor=t}function tr(t,e){var r=Object.create(t.prototype);for(var i in e)r[i]=e[i];return r}function er(){}s(Ke,"default"),s(Je,"default"),s(tr,"extend"),s(er,"Color");var rr=.7,ir=1/rr,nr="\\s*([+-]?\\d+)\\s*",ar="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*",or="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*",sr=/^#([0-9a-f]{3,8})$/,lr=new RegExp(`^rgb\\(${nr},${nr},${nr}\\)$`),hr=new RegExp(`^rgb\\(${or},${or},${or}\\)$`),cr=new RegExp(`^rgba\\(${nr},${nr},${nr},${ar}\\)$`),ur=new RegExp(`^rgba\\(${or},${or},${or},${ar}\\)$`),dr=new RegExp(`^hsl\\(${ar},${or},${or}\\)$`),pr=new RegExp(`^hsla\\(${ar},${or},${or},${ar}\\)$`),fr={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};function gr(){return this.rgb().formatHex()}function yr(){return this.rgb().formatHex8()}function mr(){return $r(this).formatHsl()}function xr(){return this.rgb().formatRgb()}function br(t){var e,r;return t=(t+"").trim().toLowerCase(),(e=sr.exec(t))?(r=e[1].length,e=parseInt(e[1],16),6===r?kr(e):3===r?new vr(e>>8&15|e>>4&240,e>>4&15|240&e,(15&e)<<4|15&e,1):8===r?Cr(e>>24&255,e>>16&255,e>>8&255,(255&e)/255):4===r?Cr(e>>12&15|e>>8&240,e>>8&15|e>>4&240,e>>4&15|240&e,((15&e)<<4|15&e)/255):null):(e=lr.exec(t))?new vr(e[1],e[2],e[3],1):(e=hr.exec(t))?new vr(255*e[1]/100,255*e[2]/100,255*e[3]/100,1):(e=cr.exec(t))?Cr(e[1],e[2],e[3],e[4]):(e=ur.exec(t))?Cr(255*e[1]/100,255*e[2]/100,255*e[3]/100,e[4]):(e=dr.exec(t))?Fr(e[1],e[2]/100,e[3]/100,1):(e=pr.exec(t))?Fr(e[1],e[2]/100,e[3]/100,e[4]):fr.hasOwnProperty(t)?kr(fr[t]):"transparent"===t?new vr(NaN,NaN,NaN,0):null}function kr(t){return new vr(t>>16&255,t>>8&255,255&t,1)}function Cr(t,e,r,i){return i<=0&&(t=e=r=NaN),new vr(t,e,r,i)}function wr(t){return t instanceof er||(t=br(t)),t?new vr((t=t.rgb()).r,t.g,t.b,t.opacity):new vr}function _r(t,e,r,i){return 1===arguments.length?wr(t):new vr(t,e,r,i??1)}function vr(t,e,r,i){this.r=+t,this.g=+e,this.b=+r,this.opacity=+i}function Sr(){return`#${Lr(this.r)}${Lr(this.g)}${Lr(this.b)}`}function Tr(){return`#${Lr(this.r)}${Lr(this.g)}${Lr(this.b)}${Lr(255*(isNaN(this.opacity)?1:this.opacity))}`}function Mr(){let t=Br(this.opacity);return`${1===t?"rgb(":"rgba("}${Ar(this.r)}, ${Ar(this.g)}, ${Ar(this.b)}${1===t?")":`, ${t})`}`}function Br(t){return isNaN(t)?1:Math.max(0,Math.min(1,t))}function Ar(t){return Math.max(0,Math.min(255,Math.round(t)||0))}function Lr(t){return((t=Ar(t))<16?"0":"")+t.toString(16)}function Fr(t,e,r,i){return i<=0?t=e=r=NaN:r<=0||r>=1?t=e=NaN:e<=0&&(t=NaN),new Dr(t,e,r,i)}function $r(t){if(t instanceof Dr)return new Dr(t.h,t.s,t.l,t.opacity);if(t instanceof er||(t=br(t)),!t)return new Dr;if(t instanceof Dr)return t;var e=(t=t.rgb()).r/255,r=t.g/255,i=t.b/255,n=Math.min(e,r,i),a=Math.max(e,r,i),o=NaN,s=a-n,l=(a+n)/2;return s?(o=e===a?(r-i)/s+6*(r<i):r===a?(i-e)/s+2:(e-r)/s+4,s/=l<.5?a+n:2-a-n,o*=60):s=l>0&&l<1?0:o,new Dr(o,s,l,t.opacity)}function Er(t,e,r,i){return 1===arguments.length?$r(t):new Dr(t,e,r,i??1)}function Dr(t,e,r,i){this.h=+t,this.s=+e,this.l=+r,this.opacity=+i}function Or(t){return(t=(t||0)%360)<0?t+360:t}function Ir(t){return Math.max(0,Math.min(1,t||0))}function Nr(t,e,r){return 255*(t<60?e+(r-e)*t/60:t<180?r:t<240?e+(r-e)*(240-t)/60:e)}Je(er,br,{copy(t){return Object.assign(new this.constructor,this,t)},displayable(){return this.rgb().displayable()},hex:gr,formatHex:gr,formatHex8:yr,formatHsl:mr,formatRgb:xr,toString:xr}),s(gr,"color_formatHex"),s(yr,"color_formatHex8"),s(mr,"color_formatHsl"),s(xr,"color_formatRgb"),s(br,"color"),s(kr,"rgbn"),s(Cr,"rgba"),s(wr,"rgbConvert"),s(_r,"rgb"),s(vr,"Rgb"),Je(vr,_r,tr(er,{brighter(t){return t=null==t?ir:Math.pow(ir,t),new vr(this.r*t,this.g*t,this.b*t,this.opacity)},darker(t){return t=null==t?rr:Math.pow(rr,t),new vr(this.r*t,this.g*t,this.b*t,this.opacity)},rgb(){return this},clamp(){return new vr(Ar(this.r),Ar(this.g),Ar(this.b),Br(this.opacity))},displayable(){return-.5<=this.r&&this.r<255.5&&-.5<=this.g&&this.g<255.5&&-.5<=this.b&&this.b<255.5&&0<=this.opacity&&this.opacity<=1},hex:Sr,formatHex:Sr,formatHex8:Tr,formatRgb:Mr,toString:Mr})),s(Sr,"rgb_formatHex"),s(Tr,"rgb_formatHex8"),s(Mr,"rgb_formatRgb"),s(Br,"clampa"),s(Ar,"clampi"),s(Lr,"hex"),s(Fr,"hsla"),s($r,"hslConvert"),s(Er,"hsl"),s(Dr,"Hsl"),Je(Dr,Er,tr(er,{brighter(t){return t=null==t?ir:Math.pow(ir,t),new Dr(this.h,this.s,this.l*t,this.opacity)},darker(t){return t=null==t?rr:Math.pow(rr,t),new Dr(this.h,this.s,this.l*t,this.opacity)},rgb(){var t=this.h%360+360*(this.h<0),e=isNaN(t)||isNaN(this.s)?0:this.s,r=this.l,i=r+(r<.5?r:1-r)*e,n=2*r-i;return new vr(Nr(t>=240?t-240:t+120,n,i),Nr(t,n,i),Nr(t<120?t+240:t-120,n,i),this.opacity)},clamp(){return new Dr(Or(this.h),Ir(this.s),Ir(this.l),Br(this.opacity))},displayable(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&0<=this.l&&this.l<=1&&0<=this.opacity&&this.opacity<=1},formatHsl(){let t=Br(this.opacity);return`${1===t?"hsl(":"hsla("}${Or(this.h)}, ${100*Ir(this.s)}%, ${100*Ir(this.l)}%${1===t?")":`, ${t})`}`}})),s(Or,"clamph"),s(Ir,"clampt"),s(Nr,"hsl2rgb");var Rr=Math.PI/180,Pr=180/Math.PI,zr=.96422,qr=.82521,jr=4/29,Wr=6/29,Hr=3*Wr*Wr,Ur=Wr*Wr*Wr;function Yr(t){if(t instanceof Gr)return new Gr(t.l,t.a,t.b,t.opacity);if(t instanceof ei)return ri(t);t instanceof vr||(t=wr(t));var e,r,i=Kr(t.r),n=Kr(t.g),a=Kr(t.b),o=Xr((.2225045*i+.7168786*n+.0606169*a)/1);return i===n&&n===a?e=r=o:(e=Xr((.4360747*i+.3850649*n+.1430804*a)/zr),r=Xr((.0139322*i+.0971045*n+.7141733*a)/qr)),new Gr(116*o-16,500*(e-o),200*(o-r),t.opacity)}function Vr(t,e,r,i){return 1===arguments.length?Yr(t):new Gr(t,e,r,i??1)}function Gr(t,e,r,i){this.l=+t,this.a=+e,this.b=+r,this.opacity=+i}function Xr(t){return t>Ur?Math.pow(t,1/3):t/Hr+jr}function Zr(t){return t>Wr?t*t*t:Hr*(t-jr)}function Qr(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function Kr(t){return(t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function Jr(t){if(t instanceof ei)return new ei(t.h,t.c,t.l,t.opacity);if(t instanceof Gr||(t=Yr(t)),0===t.a&&0===t.b)return new ei(NaN,0<t.l&&t.l<100?0:NaN,t.l,t.opacity);var e=Math.atan2(t.b,t.a)*Pr;return new ei(e<0?e+360:e,Math.sqrt(t.a*t.a+t.b*t.b),t.l,t.opacity)}function ti(t,e,r,i){return 1===arguments.length?Jr(t):new ei(t,e,r,i??1)}function ei(t,e,r,i){this.h=+t,this.c=+e,this.l=+r,this.opacity=+i}function ri(t){if(isNaN(t.h))return new Gr(t.l,0,0,t.opacity);var e=t.h*Rr;return new Gr(t.l,Math.cos(e)*t.c,Math.sin(e)*t.c,t.opacity)}s(Yr,"labConvert"),s(Vr,"lab"),s(Gr,"Lab"),Je(Gr,Vr,tr(er,{brighter(t){return new Gr(this.l+18*(t??1),this.a,this.b,this.opacity)},darker(t){return new Gr(this.l-18*(t??1),this.a,this.b,this.opacity)},rgb(){var t=(this.l+16)/116,e=isNaN(this.a)?t:t+this.a/500,r=isNaN(this.b)?t:t-this.b/200;return new vr(Qr(3.1338561*(e=zr*Zr(e))-1.6168667*(t=1*Zr(t))-.4906146*(r=qr*Zr(r))),Qr(-.9787684*e+1.9161415*t+.033454*r),Qr(.0719453*e-.2289914*t+1.4052427*r),this.opacity)}})),s(Xr,"xyz2lab"),s(Zr,"lab2xyz"),s(Qr,"lrgb2rgb"),s(Kr,"rgb2lrgb"),s(Jr,"hclConvert"),s(ti,"hcl"),s(ei,"Hcl"),s(ri,"hcl2lab"),Je(ei,ti,tr(er,{brighter(t){return new ei(this.h,this.c,this.l+18*(t??1),this.opacity)},darker(t){return new ei(this.h,this.c,this.l-18*(t??1),this.opacity)},rgb(){return ri(this).rgb()}}));var ii=s(t=>()=>t,"default");function ni(t,e){return function(r){return t+r*e}}function ai(t,e,r){return t=Math.pow(t,r),e=Math.pow(e,r)-t,r=1/r,function(i){return Math.pow(t+i*e,r)}}function oi(t,e){var r=e-t;return r?ni(t,r>180||r<-180?r-360*Math.round(r/360):r):ii(isNaN(t)?e:t)}function si(t){return 1==(t=+t)?li:function(e,r){return r-e?ai(e,r,t):ii(isNaN(e)?r:e)}}function li(t,e){var r=e-t;return r?ni(t,r):ii(isNaN(t)?e:t)}function hi(t){return function(e,r){var i=t((e=ti(e)).h,(r=ti(r)).h),n=li(e.c,r.c),a=li(e.l,r.l),o=li(e.opacity,r.opacity);return function(t){return e.h=i(t),e.c=n(t),e.l=a(t),e.opacity=o(t),e+""}}}s(ni,"linear"),s(ai,"exponential"),s(oi,"hue"),s(si,"gamma"),s(li,"nogamma"),s(hi,"hcl");var ci=hi(oi);function ui(t,e,r,i,n){var a=t*t,o=a*t;return((1-3*t+3*a-o)*e+(4-6*a+3*o)*r+(1+3*t+3*a-3*o)*i+o*n)/6}s(ui,"basis"),s(function(t){var e=t.length-1;return function(r){var i=r<=0?r=0:r>=1?(r=1,e-1):Math.floor(r*e),n=t[i],a=t[i+1],o=i>0?t[i-1]:2*n-a,s=i<e-1?t[i+2]:2*a-n;return ui((r-i/e)*e,o,n,a,s)}},"default"),s(function(t){var e=t.length;return function(r){var i=Math.floor(((r%=1)<0?++r:r)*e),n=t[(i+e-1)%e],a=t[i%e],o=t[(i+1)%e],s=t[(i+2)%e];return ui((r-i/e)*e,n,a,o,s)}},"default");var di=s(function t(e){var r=si(e);function i(t,e){var i=r((t=_r(t)).r,(e=_r(e)).r),n=r(t.g,e.g),a=r(t.b,e.b),o=li(t.opacity,e.opacity);return function(e){return t.r=i(e),t.g=n(e),t.b=a(e),t.opacity=o(e),t+""}}return s(i,"rgb"),i.gamma=t,i},"rgbGamma")(1);function pi(t,e){e||(e=[]);var r,i=t?Math.min(e.length,t.length):0,n=e.slice();return function(a){for(r=0;r<i;++r)n[r]=t[r]*(1-a)+e[r]*a;return n}}function fi(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)}function gi(t,e){var r,i=e?e.length:0,n=t?Math.min(i,t.length):0,a=new Array(n),o=new Array(i);for(r=0;r<n;++r)a[r]=vi(t[r],e[r]);for(;r<i;++r)o[r]=e[r];return function(t){for(r=0;r<n;++r)o[r]=a[r](t);return o}}function yi(t,e){var r=new Date;return t=+t,e=+e,function(i){return r.setTime(t*(1-i)+e*i),r}}function mi(t,e){return t=+t,e=+e,function(r){return t*(1-r)+e*r}}function xi(t,e){var r,i={},n={};for(r in(null===t||"object"!=typeof t)&&(t={}),(null===e||"object"!=typeof e)&&(e={}),e)r in t?i[r]=vi(t[r],e[r]):n[r]=e[r];return function(t){for(r in i)n[r]=i[r](t);return n}}s(function(t){return function(e){var r,i,n=e.length,a=new Array(n),o=new Array(n),s=new Array(n);for(r=0;r<n;++r)i=_r(e[r]),a[r]=i.r||0,o[r]=i.g||0,s[r]=i.b||0;return a=t(a),o=t(o),s=t(s),i.opacity=1,function(t){return i.r=a(t),i.g=o(t),i.b=s(t),i+""}}},"rgbSpline"),s(pi,"default"),s(fi,"isNumberArray"),s(gi,"genericArray"),s(yi,"default"),s(mi,"default"),s(xi,"default");var bi=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,ki=new RegExp(bi.source,"g");function Ci(t){return function(){return t}}function wi(t){return function(e){return t(e)+""}}function _i(t,e){var r,i,n,a=bi.lastIndex=ki.lastIndex=0,o=-1,s=[],l=[];for(t+="",e+="";(r=bi.exec(t))&&(i=ki.exec(e));)(n=i.index)>a&&(n=e.slice(a,n),s[o]?s[o]+=n:s[++o]=n),(r=r[0])===(i=i[0])?s[o]?s[o]+=i:s[++o]=i:(s[++o]=null,l.push({i:o,x:mi(r,i)})),a=ki.lastIndex;return a<e.length&&(n=e.slice(a),s[o]?s[o]+=n:s[++o]=n),s.length<2?l[0]?wi(l[0].x):Ci(e):(e=l.length,function(t){for(var r,i=0;i<e;++i)s[(r=l[i]).i]=r.x(t);return s.join("")})}function vi(t,e){var r,i=typeof e;return null==e||"boolean"===i?ii(e):("number"===i?mi:"string"===i?(r=br(e))?(e=r,di):_i:e instanceof br?di:e instanceof Date?yi:fi(e)?pi:Array.isArray(e)?gi:"function"!=typeof e.valueOf&&"function"!=typeof e.toString||isNaN(e)?xi:mi)(t,e)}function Si(t,e){return t=+t,e=+e,function(r){return Math.round(t*(1-r)+e*r)}}s(Ci,"zero"),s(wi,"one"),s(_i,"default"),s(vi,"default"),s(Si,"default");var Ti,Mi=180/Math.PI,Bi={translateX:0,translateY:0,rotate:0,skewX:0,scaleX:1,scaleY:1};function Ai(t,e,r,i,n,a){var o,s,l;return(o=Math.sqrt(t*t+e*e))&&(t/=o,e/=o),(l=t*r+e*i)&&(r-=t*l,i-=e*l),(s=Math.sqrt(r*r+i*i))&&(r/=s,i/=s,l/=s),t*i<e*r&&(t=-t,e=-e,l=-l,o=-o),{translateX:n,translateY:a,rotate:Math.atan2(e,t)*Mi,skewX:Math.atan(l)*Mi,scaleX:o,scaleY:s}}function Li(t){let e=new("function"==typeof DOMMatrix?DOMMatrix:WebKitCSSMatrix)(t+"");return e.isIdentity?Bi:Ai(e.a,e.b,e.c,e.d,e.e,e.f)}function Fi(t){return null==t?Bi:(Ti||(Ti=document.createElementNS("http://www.w3.org/2000/svg","g")),Ti.setAttribute("transform",t),(t=Ti.transform.baseVal.consolidate())?Ai((t=t.matrix).a,t.b,t.c,t.d,t.e,t.f):Bi)}function $i(t,e,r,i){function n(t){return t.length?t.pop()+" ":""}function a(t,i,n,a,o,s){if(t!==n||i!==a){var l=o.push("translate(",null,e,null,r);s.push({i:l-4,x:mi(t,n)},{i:l-2,x:mi(i,a)})}else(n||a)&&o.push("translate("+n+e+a+r)}function o(t,e,r,a){t!==e?(t-e>180?e+=360:e-t>180&&(t+=360),a.push({i:r.push(n(r)+"rotate(",null,i)-2,x:mi(t,e)})):e&&r.push(n(r)+"rotate("+e+i)}function l(t,e,r,a){t!==e?a.push({i:r.push(n(r)+"skewX(",null,i)-2,x:mi(t,e)}):e&&r.push(n(r)+"skewX("+e+i)}function h(t,e,r,i,a,o){if(t!==r||e!==i){var s=a.push(n(a)+"scale(",null,",",null,")");o.push({i:s-4,x:mi(t,r)},{i:s-2,x:mi(e,i)})}else(1!==r||1!==i)&&a.push(n(a)+"scale("+r+","+i+")")}return s(n,"pop"),s(a,"translate"),s(o,"rotate"),s(l,"skewX"),s(h,"scale"),function(e,r){var i=[],n=[];return e=t(e),r=t(r),a(e.translateX,e.translateY,r.translateX,r.translateY,i,n),o(e.rotate,r.rotate,i,n),l(e.skewX,r.skewX,i,n),h(e.scaleX,e.scaleY,r.scaleX,r.scaleY,i,n),e=r=null,function(t){for(var e,r=-1,a=n.length;++r<a;)i[(e=n[r]).i]=e.x(t);return i.join("")}}}s(Ai,"default"),s(Li,"parseCss"),s(Fi,"parseSvg"),s($i,"interpolateTransform");var Ei=$i(Li,"px, ","px)","deg)"),Di=$i(Fi,", ",")",")");function Oi(t){return Math.abs(t=Math.round(t))>=1e21?t.toLocaleString("en").replace(/,/g,""):t.toString(10)}function Ii(t,e){if((r=(t=e?t.toExponential(e-1):t.toExponential()).indexOf("e"))<0)return null;var r,i=t.slice(0,r);return[i.length>1?i[0]+i.slice(2):i,+t.slice(r+1)]}function Ni(t){return(t=Ii(Math.abs(t)))?t[1]:NaN}function Ri(t,e){return function(r,i){for(var n=r.length,a=[],o=0,s=t[0],l=0;n>0&&s>0&&(l+s+1>i&&(s=Math.max(1,i-l)),a.push(r.substring(n-=s,n+s)),!((l+=s+1)>i));)s=t[o=(o+1)%t.length];return a.reverse().join(e)}}function Pi(t){return function(e){return e.replace(/[0-9]/g,function(e){return t[+e]})}}s(Oi,"default"),s(Ii,"formatDecimalParts"),s(Ni,"default"),s(Ri,"default"),s(Pi,"default");var zi,qi=/^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;function ji(t){if(!(e=qi.exec(t)))throw new Error("invalid format: "+t);var e;return new Wi({fill:e[1],align:e[2],sign:e[3],symbol:e[4],zero:e[5],width:e[6],comma:e[7],precision:e[8]&&e[8].slice(1),trim:e[9],type:e[10]})}function Wi(t){this.fill=void 0===t.fill?" ":t.fill+"",this.align=void 0===t.align?">":t.align+"",this.sign=void 0===t.sign?"-":t.sign+"",this.symbol=void 0===t.symbol?"":t.symbol+"",this.zero=!!t.zero,this.width=void 0===t.width?void 0:+t.width,this.comma=!!t.comma,this.precision=void 0===t.precision?void 0:+t.precision,this.trim=!!t.trim,this.type=void 0===t.type?"":t.type+""}function Hi(t){t:for(var e,r=t.length,i=1,n=-1;i<r;++i)switch(t[i]){case".":n=e=i;break;case"0":0===n&&(n=i),e=i;break;default:if(!+t[i])break t;n>0&&(n=0)}return n>0?t.slice(0,n)+t.slice(e+1):t}function Ui(t,e){var r=Ii(t,e);if(!r)return t+"";var i=r[0],n=r[1],a=n-(zi=3*Math.max(-8,Math.min(8,Math.floor(n/3))))+1,o=i.length;return a===o?i:a>o?i+new Array(a-o+1).join("0"):a>0?i.slice(0,a)+"."+i.slice(a):"0."+new Array(1-a).join("0")+Ii(t,Math.max(0,e+a-1))[0]}function Yi(t,e){var r=Ii(t,e);if(!r)return t+"";var i=r[0],n=r[1];return n<0?"0."+new Array(-n).join("0")+i:i.length>n+1?i.slice(0,n+1)+"."+i.slice(n+1):i+new Array(n-i.length+2).join("0")}s(ji,"formatSpecifier"),ji.prototype=Wi.prototype,s(Wi,"FormatSpecifier"),Wi.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(void 0===this.width?"":Math.max(1,0|this.width))+(this.comma?",":"")+(void 0===this.precision?"":"."+Math.max(0,0|this.precision))+(this.trim?"~":"")+this.type},s(Hi,"default"),s(Ui,"default"),s(Yi,"default");var Vi={"%":s((t,e)=>(100*t).toFixed(e),"%"),b:s(t=>Math.round(t).toString(2),"b"),c:s(t=>t+"","c"),d:Oi,e:s((t,e)=>t.toExponential(e),"e"),f:s((t,e)=>t.toFixed(e),"f"),g:s((t,e)=>t.toPrecision(e),"g"),o:s(t=>Math.round(t).toString(8),"o"),p:s((t,e)=>Yi(100*t,e),"p"),r:Yi,s:Ui,X:s(t=>Math.round(t).toString(16).toUpperCase(),"X"),x:s(t=>Math.round(t).toString(16),"x")};function Gi(t){return t}s(Gi,"default");var Xi,Zi,Qi,Ki=Array.prototype.map,Ji=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];function tn(t){var e=void 0===t.grouping||void 0===t.thousands?Gi:Ri(Ki.call(t.grouping,Number),t.thousands+""),r=void 0===t.currency?"":t.currency[0]+"",i=void 0===t.currency?"":t.currency[1]+"",n=void 0===t.decimal?".":t.decimal+"",a=void 0===t.numerals?Gi:Pi(Ki.call(t.numerals,String)),o=void 0===t.percent?"%":t.percent+"",l=void 0===t.minus?"−":t.minus+"",h=void 0===t.nan?"NaN":t.nan+"";function c(t){var c=(t=ji(t)).fill,u=t.align,d=t.sign,p=t.symbol,f=t.zero,g=t.width,y=t.comma,m=t.precision,x=t.trim,b=t.type;"n"===b?(y=!0,b="g"):Vi[b]||(void 0===m&&(m=12),x=!0,b="g"),(f||"0"===c&&"="===u)&&(f=!0,c="0",u="=");var k="$"===p?r:"#"===p&&/[boxX]/.test(b)?"0"+b.toLowerCase():"",C="$"===p?i:/[%p]/.test(b)?o:"",w=Vi[b],_=/[defgprs%]/.test(b);function v(t){var r,i,o,s=k,p=C;if("c"===b)p=w(t)+p,t="";else{var v=(t=+t)<0||1/t<0;if(t=isNaN(t)?h:w(Math.abs(t),m),x&&(t=Hi(t)),v&&0==+t&&"+"!==d&&(v=!1),s=(v?"("===d?d:l:"-"===d||"("===d?"":d)+s,p=("s"===b?Ji[8+zi/3]:"")+p+(v&&"("===d?")":""),_)for(r=-1,i=t.length;++r<i;)if(48>(o=t.charCodeAt(r))||o>57){p=(46===o?n+t.slice(r+1):t.slice(r))+p,t=t.slice(0,r);break}}y&&!f&&(t=e(t,1/0));var S=s.length+t.length+p.length,T=S<g?new Array(g-S+1).join(c):"";switch(y&&f&&(t=e(T+t,T.length?g-p.length:1/0),T=""),u){case"<":t=s+t+p+T;break;case"=":t=s+T+t+p;break;case"^":t=T.slice(0,S=T.length>>1)+s+t+p+T.slice(S);break;default:t=T+s+t+p}return a(t)}return m=void 0===m?6:/[gprs]/.test(b)?Math.max(1,Math.min(21,m)):Math.max(0,Math.min(20,m)),s(v,"format"),v.toString=function(){return t+""},v}function u(t,e){var r=c(((t=ji(t)).type="f",t)),i=3*Math.max(-8,Math.min(8,Math.floor(Ni(e)/3))),n=Math.pow(10,-i),a=Ji[8+i/3];return function(t){return r(n*t)+a}}return s(c,"newFormat"),s(u,"formatPrefix"),{format:c,formatPrefix:u}}function en(t){return Xi=tn(t),Zi=Xi.format,Qi=Xi.formatPrefix,Xi}function rn(t){return Math.max(0,-Ni(Math.abs(t)))}function nn(t,e){return Math.max(0,3*Math.max(-8,Math.min(8,Math.floor(Ni(e)/3)))-Ni(Math.abs(t)))}function an(t,e){return t=Math.abs(t),e=Math.abs(e)-t,Math.max(0,Ni(e)-Ni(t))+1}function on(t){var e=0,r=t.children,i=r&&r.length;if(i)for(;--i>=0;)e+=r[i].value;else e=1;t.value=e}function sn(){return this.eachAfter(on)}function ln(t,e){let r=-1;for(let i of this)t.call(e,i,++r,this);return this}function hn(t,e){for(var r,i,n=this,a=[n],o=-1;n=a.pop();)if(t.call(e,n,++o,this),r=n.children)for(i=r.length-1;i>=0;--i)a.push(r[i]);return this}function cn(t,e){for(var r,i,n,a=this,o=[a],s=[],l=-1;a=o.pop();)if(s.push(a),r=a.children)for(i=0,n=r.length;i<n;++i)o.push(r[i]);for(;a=s.pop();)t.call(e,a,++l,this);return this}function un(t,e){let r=-1;for(let i of this)if(t.call(e,i,++r,this))return i}function dn(t){return this.eachAfter(function(e){for(var r=+t(e.data)||0,i=e.children,n=i&&i.length;--n>=0;)r+=i[n].value;e.value=r})}function pn(t){return this.eachBefore(function(e){e.children&&e.children.sort(t)})}function fn(t){for(var e=this,r=gn(e,t),i=[e];e!==r;)e=e.parent,i.push(e);for(var n=i.length;t!==r;)i.splice(n,0,t),t=t.parent;return i}function gn(t,e){if(t===e)return t;var r=t.ancestors(),i=e.ancestors(),n=null;for(t=r.pop(),e=i.pop();t===e;)n=t,t=r.pop(),e=i.pop();return n}function yn(){for(var t=this,e=[t];t=t.parent;)e.push(t);return e}function mn(){return Array.from(this)}function xn(){var t=[];return this.eachBefore(function(e){e.children||t.push(e)}),t}function bn(){var t=this,e=[];return t.each(function(r){r!==t&&e.push({source:r.parent,target:r})}),e}function*kn(){var t,e,r,i,n=this,a=[n];do{for(t=a.reverse(),a=[];n=t.pop();)if(yield n,e=n.children)for(r=0,i=e.length;r<i;++r)a.push(e[r])}while(a.length)}function Cn(t,e){t instanceof Map?(t=[void 0,t],void 0===e&&(e=vn)):void 0===e&&(e=_n);for(var r,i,n,a,o,s=new Mn(t),l=[s];r=l.pop();)if((n=e(r.data))&&(o=(n=Array.from(n)).length))for(r.children=n,a=o-1;a>=0;--a)l.push(i=n[a]=new Mn(n[a])),i.parent=r,i.depth=r.depth+1;return s.eachBefore(Tn)}function wn(){return Cn(this).eachBefore(Sn)}function _n(t){return t.children}function vn(t){return Array.isArray(t)?t[1]:null}function Sn(t){void 0!==t.data.value&&(t.value=t.data.value),t.data=t.data.data}function Tn(t){var e=0;do{t.height=e}while((t=t.parent)&&t.height<++e)}function Mn(t){this.data=t,this.depth=this.height=0,this.parent=null}function Bn(t){t.x0=Math.round(t.x0),t.y0=Math.round(t.y0),t.x1=Math.round(t.x1),t.y1=Math.round(t.y1)}function An(t,e,r,i,n){for(var a,o=t.children,s=-1,l=o.length,h=t.value&&(i-e)/t.value;++s<l;)(a=o[s]).y0=r,a.y1=n,a.x0=e,a.x1=e+=a.value*h}function Ln(t,e,r,i,n){for(var a,o=t.children,s=-1,l=o.length,h=t.value&&(n-r)/t.value;++s<l;)(a=o[s]).x0=e,a.x1=i,a.y0=r,a.y1=r+=a.value*h}s(tn,"default"),en({thousands:",",grouping:[3],currency:["$",""]}),s(en,"defaultLocale"),s(rn,"default"),s(nn,"default"),s(an,"default"),s(on,"count"),s(sn,"default"),s(ln,"default"),s(hn,"default"),s(cn,"default"),s(un,"default"),s(dn,"default"),s(pn,"default"),s(fn,"default"),s(gn,"leastCommonAncestor"),s(yn,"default"),s(mn,"default"),s(xn,"default"),s(bn,"default"),s(kn,"default"),s(Cn,"hierarchy"),s(wn,"node_copy"),s(_n,"objectChildren"),s(vn,"mapChildren"),s(Sn,"copyData"),s(Tn,"computeHeight"),s(Mn,"Node"),Mn.prototype=Cn.prototype={constructor:Mn,count:sn,each:ln,eachAfter:cn,eachBefore:hn,find:un,sum:dn,sort:pn,path:fn,ancestors:yn,descendants:mn,leaves:xn,links:bn,copy:wn,[Symbol.iterator]:kn},s(Bn,"default"),s(An,"default"),s(Ln,"default");var Fn=(1+Math.sqrt(5))/2;function $n(t,e,r,i,n,a){for(var o,s,l,h,c,u,d,p,f,g,y,m=[],x=e.children,b=0,k=0,C=x.length,w=e.value;b<C;){l=n-r,h=a-i;do{c=x[k++].value}while(!c&&k<C);for(u=d=c,y=c*c*(g=Math.max(h/l,l/h)/(w*t)),f=Math.max(d/y,y/u);k<C;++k){if(c+=s=x[k].value,s<u&&(u=s),s>d&&(d=s),y=c*c*g,(p=Math.max(d/y,y/u))>f){c-=s;break}f=p}m.push(o={value:c,dice:l<h,children:x.slice(b,k)}),o.dice?An(o,r,i,n,w?i+=h*c/w:a):Ln(o,r,i,w?r+=l*c/w:n,a),w-=c,b=k}return m}s($n,"squarifyRatio");var En=s(function t(e){function r(t,r,i,n,a){$n(e,t,r,i,n,a)}return s(r,"squarify"),r.ratio=function(e){return t((e=+e)>1?e:1)},r},"custom")(Fn);function Dn(t){if("function"!=typeof t)throw new Error;return t}function On(){return 0}function In(t){return function(){return t}}function Nn(){var t=En,e=!1,r=1,i=1,n=[0],a=On,o=On,l=On,h=On,c=On;function u(t){return t.x0=t.y0=0,t.x1=r,t.y1=i,t.eachBefore(d),n=[0],e&&t.eachBefore(Bn),t}function d(e){var r=n[e.depth],i=e.x0+r,s=e.y0+r,u=e.x1-r,d=e.y1-r;u<i&&(i=u=(i+u)/2),d<s&&(s=d=(s+d)/2),e.x0=i,e.y0=s,e.x1=u,e.y1=d,e.children&&(r=n[e.depth+1]=a(e)/2,i+=c(e)-r,s+=o(e)-r,(u-=l(e)-r)<i&&(i=u=(i+u)/2),(d-=h(e)-r)<s&&(s=d=(s+d)/2),t(e,i,s,u,d))}return s(u,"treemap"),s(d,"positionNode"),u.round=function(t){return arguments.length?(e=!!t,u):e},u.size=function(t){return arguments.length?(r=+t[0],i=+t[1],u):[r,i]},u.tile=function(e){return arguments.length?(t=Dn(e),u):t},u.padding=function(t){return arguments.length?u.paddingInner(t).paddingOuter(t):u.paddingInner()},u.paddingInner=function(t){return arguments.length?(a="function"==typeof t?t:In(+t),u):a},u.paddingOuter=function(t){return arguments.length?u.paddingTop(t).paddingRight(t).paddingBottom(t).paddingLeft(t):u.paddingTop()},u.paddingTop=function(t){return arguments.length?(o="function"==typeof t?t:In(+t),u):o},u.paddingRight=function(t){return arguments.length?(l="function"==typeof t?t:In(+t),u):l},u.paddingBottom=function(t){return arguments.length?(h="function"==typeof t?t:In(+t),u):h},u.paddingLeft=function(t){return arguments.length?(c="function"==typeof t?t:In(+t),u):c},u}function Rn(t,e){switch(arguments.length){case 0:break;case 1:this.range(t);break;default:this.range(e).domain(t)}return this}s(Dn,"required"),s(On,"constantZero"),s(In,"default"),s(Nn,"default"),s(Rn,"initRange");var Pn=Symbol("implicit");function zn(){var t=new A,e=[],r=[],i=Pn;function n(n){let a=t.get(n);if(void 0===a){if(i!==Pn)return i;t.set(n,a=e.push(n)-1)}return r[a%r.length]}return s(n,"scale"),n.domain=function(r){if(!arguments.length)return e.slice();e=[],t=new A;for(let i of r)t.has(i)||t.set(i,e.push(i)-1);return n},n.range=function(t){return arguments.length?(r=Array.from(t),n):r.slice()},n.unknown=function(t){return arguments.length?(i=t,n):i},n.copy=function(){return zn(e,r).unknown(i)},Rn.apply(n,arguments),n}function qn(t){return function(){return t}}function jn(t){return+t}s(zn,"ordinal"),s(qn,"constants"),s(jn,"number");var Wn=[0,1];function Hn(t){return t}function Un(t,e){return(e-=t=+t)?function(r){return(r-t)/e}:qn(isNaN(e)?NaN:.5)}function Yn(t,e){var r;return t>e&&(r=t,t=e,e=r),function(r){return Math.max(t,Math.min(e,r))}}function Vn(t,e,r){var i=t[0],n=t[1],a=e[0],o=e[1];return n<i?(i=Un(n,i),a=r(o,a)):(i=Un(i,n),a=r(a,o)),function(t){return a(i(t))}}function Gn(t,e,r){var i=Math.min(t.length,e.length)-1,n=new Array(i),a=new Array(i),o=-1;for(t[i]<t[0]&&(t=t.slice().reverse(),e=e.slice().reverse());++o<i;)n[o]=Un(t[o],t[o+1]),a[o]=r(e[o],e[o+1]);return function(e){var r=B(t,e,1,i)-1;return a[r](n[r](e))}}function Xn(t,e){return e.domain(t.domain()).range(t.range()).interpolate(t.interpolate()).clamp(t.clamp()).unknown(t.unknown())}function Zn(){var t,e,r,i,n,a,o=Wn,l=Wn,h=vi,c=Hn;function u(){var t=Math.min(o.length,l.length);return c!==Hn&&(c=Yn(o[0],o[t-1])),i=t>2?Gn:Vn,n=a=null,d}function d(e){return null==e||isNaN(e=+e)?r:(n||(n=i(o.map(t),l,h)))(t(c(e)))}return s(u,"rescale"),s(d,"scale"),d.invert=function(r){return c(e((a||(a=i(l,o.map(t),mi)))(r)))},d.domain=function(t){return arguments.length?(o=Array.from(t,jn),u()):o.slice()},d.range=function(t){return arguments.length?(l=Array.from(t),u()):l.slice()},d.rangeRound=function(t){return l=Array.from(t),h=Si,u()},d.clamp=function(t){return arguments.length?(c=!!t||Hn,u()):c!==Hn},d.interpolate=function(t){return arguments.length?(h=t,u()):h},d.unknown=function(t){return arguments.length?(r=t,d):r},function(r,i){return t=r,e=i,u()}}function Qn(){return Zn()(Hn,Hn)}function Kn(t,e,r,i){var n,a=z(t,e,r);switch((i=ji(i??",f")).type){case"s":var o=Math.max(Math.abs(t),Math.abs(e));return null==i.precision&&!isNaN(n=nn(a,o))&&(i.precision=n),Qi(i,o);case"":case"e":case"g":case"p":case"r":null==i.precision&&!isNaN(n=an(a,Math.max(Math.abs(t),Math.abs(e))))&&(i.precision=n-("e"===i.type));break;case"f":case"%":null==i.precision&&!isNaN(n=rn(a))&&(i.precision=n-2*("%"===i.type))}return Zi(i)}function Jn(t){var e=t.domain;return t.ticks=function(t){var r=e();return R(r[0],r[r.length-1],t??10)},t.tickFormat=function(t,r){var i=e();return Kn(i[0],i[i.length-1],t??10,r)},t.nice=function(r){null==r&&(r=10);var i,n,a=e(),o=0,s=a.length-1,l=a[o],h=a[s],c=10;for(h<l&&(n=l,l=h,h=n,n=o,o=s,s=n);c-- >0;){if((n=P(l,h,r))===i)return a[o]=l,a[s]=h,e(a);if(n>0)l=Math.floor(l/n)*n,h=Math.ceil(h/n)*n;else{if(!(n<0))break;l=Math.ceil(l*n)/n,h=Math.floor(h*n)/n}i=n}return t},t}function ta(){var t=Qn();return t.copy=function(){return Xn(t,ta())},Rn.apply(t,arguments),Jn(t)}s(Hn,"identity"),s(Un,"normalize"),s(Yn,"clamper"),s(Vn,"bimap"),s(Gn,"polymap"),s(Xn,"copy"),s(Zn,"transformer"),s(Qn,"continuous"),s(Kn,"tickFormat"),s(Jn,"linearish"),s(ta,"linear");var ea=new Date,ra=new Date;function ia(t,e,r,i){function n(e){return t(e=0===arguments.length?new Date:new Date(+e)),e}return s(n,"interval"),n.floor=e=>(t(e=new Date(+e)),e),n.ceil=r=>(t(r=new Date(r-1)),e(r,1),t(r),r),n.round=t=>{let e=n(t),r=n.ceil(t);return t-e<r-t?e:r},n.offset=(t,r)=>(e(t=new Date(+t),null==r?1:Math.floor(r)),t),n.range=(r,i,a)=>{let o,s=[];if(r=n.ceil(r),a=null==a?1:Math.floor(a),!(r<i&&a>0))return s;do{s.push(o=new Date(+r)),e(r,a),t(r)}while(o<r&&r<i);return s},n.filter=r=>ia(e=>{if(e>=e)for(;t(e),!r(e);)e.setTime(e-1)},(t,i)=>{if(t>=t)if(i<0)for(;++i<=0;)for(;e(t,-1),!r(t););else for(;--i>=0;)for(;e(t,1),!r(t););}),r&&(n.count=(e,i)=>(ea.setTime(+e),ra.setTime(+i),t(ea),t(ra),Math.floor(r(ea,ra))),n.every=t=>(t=Math.floor(t),isFinite(t)&&t>0?t>1?n.filter(i?e=>i(e)%t===0:e=>n.count(0,e)%t===0):n:null)),n}s(ia,"timeInterval");var na=ia(()=>{},(t,e)=>{t.setTime(+t+e)},(t,e)=>e-t);na.every=t=>(t=Math.floor(t),isFinite(t)&&t>0?t>1?ia(e=>{e.setTime(Math.floor(e/t)*t)},(e,r)=>{e.setTime(+e+r*t)},(e,r)=>(r-e)/t):na:null),na.range;var aa=ia(t=>{t.setTime(t-t.getMilliseconds())},(t,e)=>{t.setTime(+t+1e3*e)},(t,e)=>(e-t)/1e3,t=>t.getUTCSeconds());aa.range;var oa=ia(t=>{t.setTime(t-t.getMilliseconds()-1e3*t.getSeconds())},(t,e)=>{t.setTime(+t+6e4*e)},(t,e)=>(e-t)/6e4,t=>t.getMinutes());oa.range;var sa=ia(t=>{t.setUTCSeconds(0,0)},(t,e)=>{t.setTime(+t+6e4*e)},(t,e)=>(e-t)/6e4,t=>t.getUTCMinutes());sa.range;var la=ia(t=>{t.setTime(t-t.getMilliseconds()-1e3*t.getSeconds()-6e4*t.getMinutes())},(t,e)=>{t.setTime(+t+36e5*e)},(t,e)=>(e-t)/36e5,t=>t.getHours());la.range;var ha=ia(t=>{t.setUTCMinutes(0,0,0)},(t,e)=>{t.setTime(+t+36e5*e)},(t,e)=>(e-t)/36e5,t=>t.getUTCHours());ha.range;var ca=ia(t=>t.setHours(0,0,0,0),(t,e)=>t.setDate(t.getDate()+e),(t,e)=>(e-t-6e4*(e.getTimezoneOffset()-t.getTimezoneOffset()))/864e5,t=>t.getDate()-1);ca.range;var ua=ia(t=>{t.setUTCHours(0,0,0,0)},(t,e)=>{t.setUTCDate(t.getUTCDate()+e)},(t,e)=>(e-t)/864e5,t=>t.getUTCDate()-1);ua.range;var da=ia(t=>{t.setUTCHours(0,0,0,0)},(t,e)=>{t.setUTCDate(t.getUTCDate()+e)},(t,e)=>(e-t)/864e5,t=>Math.floor(t/864e5));function pa(t){return ia(e=>{e.setDate(e.getDate()-(e.getDay()+7-t)%7),e.setHours(0,0,0,0)},(t,e)=>{t.setDate(t.getDate()+7*e)},(t,e)=>(e-t-6e4*(e.getTimezoneOffset()-t.getTimezoneOffset()))/6048e5)}da.range,s(pa,"timeWeekday");var fa=pa(0),ga=pa(1),ya=pa(2),ma=pa(3),xa=pa(4),ba=pa(5),ka=pa(6);function Ca(t){return ia(e=>{e.setUTCDate(e.getUTCDate()-(e.getUTCDay()+7-t)%7),e.setUTCHours(0,0,0,0)},(t,e)=>{t.setUTCDate(t.getUTCDate()+7*e)},(t,e)=>(e-t)/6048e5)}fa.range,ga.range,ya.range,ma.range,xa.range,ba.range,ka.range,s(Ca,"utcWeekday");var wa=Ca(0),_a=Ca(1),va=Ca(2),Sa=Ca(3),Ta=Ca(4),Ma=Ca(5),Ba=Ca(6);wa.range,_a.range,va.range,Sa.range,Ta.range,Ma.range,Ba.range;var Aa=ia(t=>{t.setDate(1),t.setHours(0,0,0,0)},(t,e)=>{t.setMonth(t.getMonth()+e)},(t,e)=>e.getMonth()-t.getMonth()+12*(e.getFullYear()-t.getFullYear()),t=>t.getMonth());Aa.range;var La=ia(t=>{t.setUTCDate(1),t.setUTCHours(0,0,0,0)},(t,e)=>{t.setUTCMonth(t.getUTCMonth()+e)},(t,e)=>e.getUTCMonth()-t.getUTCMonth()+12*(e.getUTCFullYear()-t.getUTCFullYear()),t=>t.getUTCMonth());La.range;var Fa=ia(t=>{t.setMonth(0,1),t.setHours(0,0,0,0)},(t,e)=>{t.setFullYear(t.getFullYear()+e)},(t,e)=>e.getFullYear()-t.getFullYear(),t=>t.getFullYear());Fa.every=t=>isFinite(t=Math.floor(t))&&t>0?ia(e=>{e.setFullYear(Math.floor(e.getFullYear()/t)*t),e.setMonth(0,1),e.setHours(0,0,0,0)},(e,r)=>{e.setFullYear(e.getFullYear()+r*t)}):null,Fa.range;var $a=ia(t=>{t.setUTCMonth(0,1),t.setUTCHours(0,0,0,0)},(t,e)=>{t.setUTCFullYear(t.getUTCFullYear()+e)},(t,e)=>e.getUTCFullYear()-t.getUTCFullYear(),t=>t.getUTCFullYear());function Ea(t,e,r,i,n,a){let o=[[aa,1,1e3],[aa,5,5e3],[aa,15,15e3],[aa,30,3e4],[a,1,6e4],[a,5,3e5],[a,15,9e5],[a,30,18e5],[n,1,36e5],[n,3,108e5],[n,6,216e5],[n,12,432e5],[i,1,864e5],[i,2,1728e5],[r,1,6048e5],[e,1,2592e6],[e,3,7776e6],[t,1,31536e6]];function l(t,e,r){let i=e<t;i&&([t,e]=[e,t]);let n=r&&"function"==typeof r.range?r:h(t,e,r),a=n?n.range(t,+e+1):[];return i?a.reverse():a}function h(e,r,i){let n=Math.abs(r-e)/i,a=_(([,,t])=>t).right(o,n);if(a===o.length)return t.every(z(e/31536e6,r/31536e6,i));if(0===a)return na.every(Math.max(z(e,r,i),1));let[s,l]=o[n/o[a-1][2]<o[a][2]/n?a-1:a];return s.every(l)}return s(l,"ticks"),s(h,"tickInterval"),[l,h]}$a.every=t=>isFinite(t=Math.floor(t))&&t>0?ia(e=>{e.setUTCFullYear(Math.floor(e.getUTCFullYear()/t)*t),e.setUTCMonth(0,1),e.setUTCHours(0,0,0,0)},(e,r)=>{e.setUTCFullYear(e.getUTCFullYear()+r*t)}):null,$a.range,s(Ea,"ticker");var[Da,Oa]=Ea($a,La,wa,da,ha,sa),[Ia,Na]=Ea(Fa,Aa,fa,ca,la,oa);function Ra(t){if(0<=t.y&&t.y<100){var e=new Date(-1,t.m,t.d,t.H,t.M,t.S,t.L);return e.setFullYear(t.y),e}return new Date(t.y,t.m,t.d,t.H,t.M,t.S,t.L)}function Pa(t){if(0<=t.y&&t.y<100){var e=new Date(Date.UTC(-1,t.m,t.d,t.H,t.M,t.S,t.L));return e.setUTCFullYear(t.y),e}return new Date(Date.UTC(t.y,t.m,t.d,t.H,t.M,t.S,t.L))}function za(t,e,r){return{y:t,m:e,d:r,H:0,M:0,S:0,L:0}}function qa(t){var e=t.dateTime,r=t.date,i=t.time,n=t.periods,a=t.days,o=t.shortDays,l=t.months,h=t.shortMonths,c=Za(n),u=Qa(n),d=Za(a),p=Qa(a),f=Za(o),g=Qa(o),y=Za(l),m=Qa(l),x=Za(h),b=Qa(h),k={a:D,A:O,b:I,B:N,c:null,d:bo,e:bo,f:vo,g:Oo,G:No,H:ko,I:Co,j:wo,L:_o,m:So,M:To,p:R,q:P,Q:os,s:ss,S:Mo,u:Bo,U:Ao,V:Fo,w:$o,W:Eo,x:null,X:null,y:Do,Y:Io,Z:Ro,"%":as},C={a:z,A:q,b:j,B:W,c:null,d:Po,e:Po,f:Ho,g:es,G:is,H:zo,I:qo,j:jo,L:Wo,m:Uo,M:Yo,p:H,q:U,Q:os,s:ss,S:Vo,u:Go,U:Xo,V:Qo,w:Ko,W:Jo,x:null,X:null,y:ts,Y:rs,Z:ns,"%":as},w={a:M,A:B,b:A,B:L,c:F,d:lo,e:lo,f:go,g:no,G:io,H:co,I:co,j:ho,L:fo,m:so,M:uo,p:T,q:oo,Q:mo,s:xo,S:po,u:Ja,U:to,V:eo,w:Ka,W:ro,x:$,X:E,y:no,Y:io,Z:ao,"%":yo};function _(t,e){return function(r){var i,n,a,o=[],s=-1,l=0,h=t.length;for(r instanceof Date||(r=new Date(+r));++s<h;)37===t.charCodeAt(s)&&(o.push(t.slice(l,s)),null!=(n=Ha[i=t.charAt(++s)])?i=t.charAt(++s):n="e"===i?" ":"0",(a=e[i])&&(i=a(r,n)),o.push(i),l=s+1);return o.push(t.slice(l,s)),o.join("")}}function v(t,e){return function(r){var i,n,a=za(1900,void 0,1);if(S(a,t,r+="",0)!=r.length)return null;if("Q"in a)return new Date(a.Q);if("s"in a)return new Date(1e3*a.s+("L"in a?a.L:0));if(e&&!("Z"in a)&&(a.Z=0),"p"in a&&(a.H=a.H%12+12*a.p),void 0===a.m&&(a.m="q"in a?a.q:0),"V"in a){if(a.V<1||a.V>53)return null;"w"in a||(a.w=1),"Z"in a?(n=(i=Pa(za(a.y,0,1))).getUTCDay(),i=n>4||0===n?_a.ceil(i):_a(i),i=ua.offset(i,7*(a.V-1)),a.y=i.getUTCFullYear(),a.m=i.getUTCMonth(),a.d=i.getUTCDate()+(a.w+6)%7):(n=(i=Ra(za(a.y,0,1))).getDay(),i=n>4||0===n?ga.ceil(i):ga(i),i=ca.offset(i,7*(a.V-1)),a.y=i.getFullYear(),a.m=i.getMonth(),a.d=i.getDate()+(a.w+6)%7)}else("W"in a||"U"in a)&&("w"in a||(a.w="u"in a?a.u%7:"W"in a?1:0),n="Z"in a?Pa(za(a.y,0,1)).getUTCDay():Ra(za(a.y,0,1)).getDay(),a.m=0,a.d="W"in a?(a.w+6)%7+7*a.W-(n+5)%7:a.w+7*a.U-(n+6)%7);return"Z"in a?(a.H+=a.Z/100|0,a.M+=a.Z%100,Pa(a)):Ra(a)}}function S(t,e,r,i){for(var n,a,o=0,s=e.length,l=r.length;o<s;){if(i>=l)return-1;if(37===(n=e.charCodeAt(o++))){if(n=e.charAt(o++),!(a=w[n in Ha?e.charAt(o++):n])||(i=a(t,r,i))<0)return-1}else if(n!=r.charCodeAt(i++))return-1}return i}function T(t,e,r){var i=c.exec(e.slice(r));return i?(t.p=u.get(i[0].toLowerCase()),r+i[0].length):-1}function M(t,e,r){var i=f.exec(e.slice(r));return i?(t.w=g.get(i[0].toLowerCase()),r+i[0].length):-1}function B(t,e,r){var i=d.exec(e.slice(r));return i?(t.w=p.get(i[0].toLowerCase()),r+i[0].length):-1}function A(t,e,r){var i=x.exec(e.slice(r));return i?(t.m=b.get(i[0].toLowerCase()),r+i[0].length):-1}function L(t,e,r){var i=y.exec(e.slice(r));return i?(t.m=m.get(i[0].toLowerCase()),r+i[0].length):-1}function F(t,r,i){return S(t,e,r,i)}function $(t,e,i){return S(t,r,e,i)}function E(t,e,r){return S(t,i,e,r)}function D(t){return o[t.getDay()]}function O(t){return a[t.getDay()]}function I(t){return h[t.getMonth()]}function N(t){return l[t.getMonth()]}function R(t){return n[+(t.getHours()>=12)]}function P(t){return 1+~~(t.getMonth()/3)}function z(t){return o[t.getUTCDay()]}function q(t){return a[t.getUTCDay()]}function j(t){return h[t.getUTCMonth()]}function W(t){return l[t.getUTCMonth()]}function H(t){return n[+(t.getUTCHours()>=12)]}function U(t){return 1+~~(t.getUTCMonth()/3)}return k.x=_(r,k),k.X=_(i,k),k.c=_(e,k),C.x=_(r,C),C.X=_(i,C),C.c=_(e,C),s(_,"newFormat"),s(v,"newParse"),s(S,"parseSpecifier"),s(T,"parsePeriod"),s(M,"parseShortWeekday"),s(B,"parseWeekday"),s(A,"parseShortMonth"),s(L,"parseMonth"),s(F,"parseLocaleDateTime"),s($,"parseLocaleDate"),s(E,"parseLocaleTime"),s(D,"formatShortWeekday"),s(O,"formatWeekday"),s(I,"formatShortMonth"),s(N,"formatMonth"),s(R,"formatPeriod"),s(P,"formatQuarter"),s(z,"formatUTCShortWeekday"),s(q,"formatUTCWeekday"),s(j,"formatUTCShortMonth"),s(W,"formatUTCMonth"),s(H,"formatUTCPeriod"),s(U,"formatUTCQuarter"),{format:s(function(t){var e=_(t+="",k);return e.toString=function(){return t},e},"format"),parse:s(function(t){var e=v(t+="",!1);return e.toString=function(){return t},e},"parse"),utcFormat:s(function(t){var e=_(t+="",C);return e.toString=function(){return t},e},"utcFormat"),utcParse:s(function(t){var e=v(t+="",!0);return e.toString=function(){return t},e},"utcParse")}}s(Ra,"localDate"),s(Pa,"utcDate"),s(za,"newDate"),s(qa,"formatLocale");var ja,Wa,Ha={"-":"",_:" ",0:"0"},Ua=/^\s*\d+/,Ya=/^%/,Va=/[\\^$*+?|[\]().{}]/g;function Ga(t,e,r){var i=t<0?"-":"",n=(i?-t:t)+"",a=n.length;return i+(a<r?new Array(r-a+1).join(e)+n:n)}function Xa(t){return t.replace(Va,"\\$&")}function Za(t){return new RegExp("^(?:"+t.map(Xa).join("|")+")","i")}function Qa(t){return new Map(t.map((t,e)=>[t.toLowerCase(),e]))}function Ka(t,e,r){var i=Ua.exec(e.slice(r,r+1));return i?(t.w=+i[0],r+i[0].length):-1}function Ja(t,e,r){var i=Ua.exec(e.slice(r,r+1));return i?(t.u=+i[0],r+i[0].length):-1}function to(t,e,r){var i=Ua.exec(e.slice(r,r+2));return i?(t.U=+i[0],r+i[0].length):-1}function eo(t,e,r){var i=Ua.exec(e.slice(r,r+2));return i?(t.V=+i[0],r+i[0].length):-1}function ro(t,e,r){var i=Ua.exec(e.slice(r,r+2));return i?(t.W=+i[0],r+i[0].length):-1}function io(t,e,r){var i=Ua.exec(e.slice(r,r+4));return i?(t.y=+i[0],r+i[0].length):-1}function no(t,e,r){var i=Ua.exec(e.slice(r,r+2));return i?(t.y=+i[0]+(+i[0]>68?1900:2e3),r+i[0].length):-1}function ao(t,e,r){var i=/^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(e.slice(r,r+6));return i?(t.Z=i[1]?0:-(i[2]+(i[3]||"00")),r+i[0].length):-1}function oo(t,e,r){var i=Ua.exec(e.slice(r,r+1));return i?(t.q=3*i[0]-3,r+i[0].length):-1}function so(t,e,r){var i=Ua.exec(e.slice(r,r+2));return i?(t.m=i[0]-1,r+i[0].length):-1}function lo(t,e,r){var i=Ua.exec(e.slice(r,r+2));return i?(t.d=+i[0],r+i[0].length):-1}function ho(t,e,r){var i=Ua.exec(e.slice(r,r+3));return i?(t.m=0,t.d=+i[0],r+i[0].length):-1}function co(t,e,r){var i=Ua.exec(e.slice(r,r+2));return i?(t.H=+i[0],r+i[0].length):-1}function uo(t,e,r){var i=Ua.exec(e.slice(r,r+2));return i?(t.M=+i[0],r+i[0].length):-1}function po(t,e,r){var i=Ua.exec(e.slice(r,r+2));return i?(t.S=+i[0],r+i[0].length):-1}function fo(t,e,r){var i=Ua.exec(e.slice(r,r+3));return i?(t.L=+i[0],r+i[0].length):-1}function go(t,e,r){var i=Ua.exec(e.slice(r,r+6));return i?(t.L=Math.floor(i[0]/1e3),r+i[0].length):-1}function yo(t,e,r){var i=Ya.exec(e.slice(r,r+1));return i?r+i[0].length:-1}function mo(t,e,r){var i=Ua.exec(e.slice(r));return i?(t.Q=+i[0],r+i[0].length):-1}function xo(t,e,r){var i=Ua.exec(e.slice(r));return i?(t.s=+i[0],r+i[0].length):-1}function bo(t,e){return Ga(t.getDate(),e,2)}function ko(t,e){return Ga(t.getHours(),e,2)}function Co(t,e){return Ga(t.getHours()%12||12,e,2)}function wo(t,e){return Ga(1+ca.count(Fa(t),t),e,3)}function _o(t,e){return Ga(t.getMilliseconds(),e,3)}function vo(t,e){return _o(t,e)+"000"}function So(t,e){return Ga(t.getMonth()+1,e,2)}function To(t,e){return Ga(t.getMinutes(),e,2)}function Mo(t,e){return Ga(t.getSeconds(),e,2)}function Bo(t){var e=t.getDay();return 0===e?7:e}function Ao(t,e){return Ga(fa.count(Fa(t)-1,t),e,2)}function Lo(t){var e=t.getDay();return e>=4||0===e?xa(t):xa.ceil(t)}function Fo(t,e){return t=Lo(t),Ga(xa.count(Fa(t),t)+(4===Fa(t).getDay()),e,2)}function $o(t){return t.getDay()}function Eo(t,e){return Ga(ga.count(Fa(t)-1,t),e,2)}function Do(t,e){return Ga(t.getFullYear()%100,e,2)}function Oo(t,e){return Ga((t=Lo(t)).getFullYear()%100,e,2)}function Io(t,e){return Ga(t.getFullYear()%1e4,e,4)}function No(t,e){var r=t.getDay();return Ga((t=r>=4||0===r?xa(t):xa.ceil(t)).getFullYear()%1e4,e,4)}function Ro(t){var e=t.getTimezoneOffset();return(e>0?"-":(e*=-1,"+"))+Ga(e/60|0,"0",2)+Ga(e%60,"0",2)}function Po(t,e){return Ga(t.getUTCDate(),e,2)}function zo(t,e){return Ga(t.getUTCHours(),e,2)}function qo(t,e){return Ga(t.getUTCHours()%12||12,e,2)}function jo(t,e){return Ga(1+ua.count($a(t),t),e,3)}function Wo(t,e){return Ga(t.getUTCMilliseconds(),e,3)}function Ho(t,e){return Wo(t,e)+"000"}function Uo(t,e){return Ga(t.getUTCMonth()+1,e,2)}function Yo(t,e){return Ga(t.getUTCMinutes(),e,2)}function Vo(t,e){return Ga(t.getUTCSeconds(),e,2)}function Go(t){var e=t.getUTCDay();return 0===e?7:e}function Xo(t,e){return Ga(wa.count($a(t)-1,t),e,2)}function Zo(t){var e=t.getUTCDay();return e>=4||0===e?Ta(t):Ta.ceil(t)}function Qo(t,e){return t=Zo(t),Ga(Ta.count($a(t),t)+(4===$a(t).getUTCDay()),e,2)}function Ko(t){return t.getUTCDay()}function Jo(t,e){return Ga(_a.count($a(t)-1,t),e,2)}function ts(t,e){return Ga(t.getUTCFullYear()%100,e,2)}function es(t,e){return Ga((t=Zo(t)).getUTCFullYear()%100,e,2)}function rs(t,e){return Ga(t.getUTCFullYear()%1e4,e,4)}function is(t,e){var r=t.getUTCDay();return Ga((t=r>=4||0===r?Ta(t):Ta.ceil(t)).getUTCFullYear()%1e4,e,4)}function ns(){return"+0000"}function as(){return"%"}function os(t){return+t}function ss(t){return Math.floor(+t/1e3)}function ls(t){return ja=qa(t),Wa=ja.format,ja.parse,ja.utcFormat,ja.utcParse,ja}function hs(t,e){var r,i=0,n=(t=t.slice()).length-1,a=t[i],o=t[n];return o<a&&(r=i,i=n,n=r,r=a,a=o,o=r),t[i]=e.floor(a),t[n]=e.ceil(o),t}function cs(t){return new Date(t)}function us(t){return t instanceof Date?+t:+new Date(+t)}function ds(t,e,r,i,n,a,o,l,h,c){var u=Qn(),d=u.invert,p=u.domain,f=c(".%L"),g=c(":%S"),y=c("%I:%M"),m=c("%I %p"),x=c("%a %d"),b=c("%b %d"),k=c("%B"),C=c("%Y");function w(t){return(h(t)<t?f:l(t)<t?g:o(t)<t?y:a(t)<t?m:i(t)<t?n(t)<t?x:b:r(t)<t?k:C)(t)}return s(w,"tickFormat"),u.invert=function(t){return new Date(d(t))},u.domain=function(t){return arguments.length?p(Array.from(t,us)):p().map(cs)},u.ticks=function(e){var r=p();return t(r[0],r[r.length-1],e??10)},u.tickFormat=function(t,e){return null==e?w:c(e)},u.nice=function(t){var r=p();return(!t||"function"!=typeof t.range)&&(t=e(r[0],r[r.length-1],t??10)),t?p(hs(r,t)):u},u.copy=function(){return Xn(u,ds(t,e,r,i,n,a,o,l,h,c))},u}function ps(){return Rn.apply(ds(Ia,Na,Fa,Aa,fa,ca,la,oa,aa,Wa).domain([new Date(2e3,0,1),new Date(2e3,0,2)]),arguments)}function fs(){var t,e,r=zn().unknown(void 0),i=r.domain,n=r.range,a=0,o=1,l=!1,h=0,c=0,u=.5;function d(){var r=i().length,s=o<a,d=s?o:a,p=s?a:o;t=(p-d)/Math.max(1,r-h+2*c),l&&(t=Math.floor(t)),d+=(p-d-t*(r-h))*u,e=t*(1-h),l&&(d=Math.round(d),e=Math.round(e));var f=q(r).map(function(e){return d+t*e});return n(s?f.reverse():f)}return delete r.unknown,s(d,"rescale"),r.domain=function(t){return arguments.length?(i(t),d()):i()},r.range=function(t){return arguments.length?([a,o]=t,a=+a,o=+o,d()):[a,o]},r.rangeRound=function(t){return[a,o]=t,a=+a,o=+o,l=!0,d()},r.bandwidth=function(){return e},r.step=function(){return t},r.round=function(t){return arguments.length?(l=!!t,d()):l},r.padding=function(t){return arguments.length?(h=Math.min(1,c=+t),d()):h},r.paddingInner=function(t){return arguments.length?(h=Math.min(1,t),d()):h},r.paddingOuter=function(t){return arguments.length?(c=+t,d()):c},r.align=function(t){return arguments.length?(u=Math.max(0,Math.min(1,t)),d()):u},r.copy=function(){return fs(i(),[a,o]).round(l).paddingInner(h).paddingOuter(c).align(u)},Rn.apply(d(),arguments)}function gs(t){for(var e=t.length/6|0,r=new Array(e),i=0;i<e;)r[i]="#"+t.slice(6*i,6*++i);return r}s(Ga,"pad"),s(Xa,"requote"),s(Za,"formatRe"),s(Qa,"formatLookup"),s(Ka,"parseWeekdayNumberSunday"),s(Ja,"parseWeekdayNumberMonday"),s(to,"parseWeekNumberSunday"),s(eo,"parseWeekNumberISO"),s(ro,"parseWeekNumberMonday"),s(io,"parseFullYear"),s(no,"parseYear"),s(ao,"parseZone"),s(oo,"parseQuarter"),s(so,"parseMonthNumber"),s(lo,"parseDayOfMonth"),s(ho,"parseDayOfYear"),s(co,"parseHour24"),s(uo,"parseMinutes"),s(po,"parseSeconds"),s(fo,"parseMilliseconds"),s(go,"parseMicroseconds"),s(yo,"parseLiteralPercent"),s(mo,"parseUnixTimestamp"),s(xo,"parseUnixTimestampSeconds"),s(bo,"formatDayOfMonth"),s(ko,"formatHour24"),s(Co,"formatHour12"),s(wo,"formatDayOfYear"),s(_o,"formatMilliseconds"),s(vo,"formatMicroseconds"),s(So,"formatMonthNumber"),s(To,"formatMinutes"),s(Mo,"formatSeconds"),s(Bo,"formatWeekdayNumberMonday"),s(Ao,"formatWeekNumberSunday"),s(Lo,"dISO"),s(Fo,"formatWeekNumberISO"),s($o,"formatWeekdayNumberSunday"),s(Eo,"formatWeekNumberMonday"),s(Do,"formatYear"),s(Oo,"formatYearISO"),s(Io,"formatFullYear"),s(No,"formatFullYearISO"),s(Ro,"formatZone"),s(Po,"formatUTCDayOfMonth"),s(zo,"formatUTCHour24"),s(qo,"formatUTCHour12"),s(jo,"formatUTCDayOfYear"),s(Wo,"formatUTCMilliseconds"),s(Ho,"formatUTCMicroseconds"),s(Uo,"formatUTCMonthNumber"),s(Yo,"formatUTCMinutes"),s(Vo,"formatUTCSeconds"),s(Go,"formatUTCWeekdayNumberMonday"),s(Xo,"formatUTCWeekNumberSunday"),s(Zo,"UTCdISO"),s(Qo,"formatUTCWeekNumberISO"),s(Ko,"formatUTCWeekdayNumberSunday"),s(Jo,"formatUTCWeekNumberMonday"),s(ts,"formatUTCYear"),s(es,"formatUTCYearISO"),s(rs,"formatUTCFullYear"),s(is,"formatUTCFullYearISO"),s(ns,"formatUTCZone"),s(as,"formatLiteralPercent"),s(os,"formatUnixTimestamp"),s(ss,"formatUnixTimestampSeconds"),ls({dateTime:"%x, %X",date:"%-m/%-d/%Y",time:"%-I:%M:%S %p",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]}),s(ls,"defaultLocale"),s(hs,"nice"),s(cs,"date"),s(us,"number"),s(ds,"calendar"),s(ps,"time"),s(fs,"band"),s(gs,"default");var ys=gs("4e79a7f28e2ce1575976b7b259a14fedc949af7aa1ff9da79c755fbab0ab");function ms(t){return s(function(){return t},"constant")}s(ms,"default");var xs=Math.abs,bs=Math.atan2,ks=Math.cos,Cs=Math.max,ws=Math.min,_s=Math.sin,vs=Math.sqrt,Ss=1e-12,Ts=Math.PI,Ms=Ts/2,Bs=2*Ts;function As(t){return t>1?0:t<-1?Ts:Math.acos(t)}function Ls(t){return t>=1?Ms:t<=-1?-Ms:Math.asin(t)}s(As,"acos"),s(Ls,"asin");var Fs=Math.PI,$s=2*Fs,Es=1e-6,Ds=$s-Es;function Os(t){this._+=t[0];for(let e=1,r=t.length;e<r;++e)this._+=arguments[e]+t[e]}function Is(t){let e=Math.floor(t);if(!(e>=0))throw new Error(`invalid digits: ${t}`);if(e>15)return Os;let r=10**e;return function(t){this._+=t[0];for(let e=1,i=t.length;e<i;++e)this._+=Math.round(arguments[e]*r)/r+t[e]}}s(Os,"append"),s(Is,"appendRound");var Ns=class{static{s(this,"Path")}constructor(t){this._x0=this._y0=this._x1=this._y1=null,this._="",this._append=null==t?Os:Is(t)}moveTo(t,e){this._append`M${this._x0=this._x1=+t},${this._y0=this._y1=+e}`}closePath(){null!==this._x1&&(this._x1=this._x0,this._y1=this._y0,this._append`Z`)}lineTo(t,e){this._append`L${this._x1=+t},${this._y1=+e}`}quadraticCurveTo(t,e,r,i){this._append`Q${+t},${+e},${this._x1=+r},${this._y1=+i}`}bezierCurveTo(t,e,r,i,n,a){this._append`C${+t},${+e},${+r},${+i},${this._x1=+n},${this._y1=+a}`}arcTo(t,e,r,i,n){if(t=+t,e=+e,r=+r,i=+i,(n=+n)<0)throw new Error(`negative radius: ${n}`);let a=this._x1,o=this._y1,s=r-t,l=i-e,h=a-t,c=o-e,u=h*h+c*c;if(null===this._x1)this._append`M${this._x1=t},${this._y1=e}`;else if(u>Es)if(Math.abs(c*s-l*h)>Es&&n){let d=r-a,p=i-o,f=s*s+l*l,g=d*d+p*p,y=Math.sqrt(f),m=Math.sqrt(u),x=n*Math.tan((Fs-Math.acos((f+u-g)/(2*y*m)))/2),b=x/m,k=x/y;Math.abs(b-1)>Es&&this._append`L${t+b*h},${e+b*c}`,this._append`A${n},${n},0,0,${+(c*d>h*p)},${this._x1=t+k*s},${this._y1=e+k*l}`}else this._append`L${this._x1=t},${this._y1=e}`}arc(t,e,r,i,n,a){if(t=+t,e=+e,a=!!a,(r=+r)<0)throw new Error(`negative radius: ${r}`);let o=r*Math.cos(i),s=r*Math.sin(i),l=t+o,h=e+s,c=1^a,u=a?i-n:n-i;null===this._x1?this._append`M${l},${h}`:(Math.abs(this._x1-l)>Es||Math.abs(this._y1-h)>Es)&&this._append`L${l},${h}`,r&&(u<0&&(u=u%$s+$s),u>Ds?this._append`A${r},${r},0,1,${c},${t-o},${e-s}A${r},${r},0,1,${c},${this._x1=l},${this._y1=h}`:u>Es&&this._append`A${r},${r},0,${+(u>=Fs)},${c},${this._x1=t+r*Math.cos(n)},${this._y1=e+r*Math.sin(n)}`)}rect(t,e,r,i){this._append`M${this._x0=this._x1=+t},${this._y0=this._y1=+e}h${r=+r}v${+i}h${-r}Z`}toString(){return this._}};function Rs(){return new Ns}function Ps(t){let e=3;return t.digits=function(r){if(!arguments.length)return e;if(null==r)e=null;else{let t=Math.floor(r);if(!(t>=0))throw new RangeError(`invalid digits: ${r}`);e=t}return t},()=>new Ns(e)}function zs(t){return t.innerRadius}function qs(t){return t.outerRadius}function js(t){return t.startAngle}function Ws(t){return t.endAngle}function Hs(t){return t&&t.padAngle}function Us(t,e,r,i,n,a,o,s){var l=r-t,h=i-e,c=o-n,u=s-a,d=u*l-c*h;if(!(d*d<Ss))return[t+(d=(c*(e-a)-u*(t-n))/d)*l,e+d*h]}function Ys(t,e,r,i,n,a,o){var s=t-r,l=e-i,h=(o?a:-a)/vs(s*s+l*l),c=h*l,u=-h*s,d=t+c,p=e+u,f=r+c,g=i+u,y=(d+f)/2,m=(p+g)/2,x=f-d,b=g-p,k=x*x+b*b,C=n-a,w=d*g-f*p,_=(b<0?-1:1)*vs(Cs(0,C*C*k-w*w)),v=(w*b-x*_)/k,S=(-w*x-b*_)/k,T=(w*b+x*_)/k,M=(-w*x+b*_)/k,B=v-y,A=S-m,L=T-y,F=M-m;return B*B+A*A>L*L+F*F&&(v=T,S=M),{cx:v,cy:S,x01:-c,y01:-u,x11:v*(n/C-1),y11:S*(n/C-1)}}function Vs(){var t=zs,e=qs,r=ms(0),i=null,n=js,a=Ws,o=Hs,l=null,h=Ps(c);function c(){var s,c,u=+t.apply(this,arguments),d=+e.apply(this,arguments),p=n.apply(this,arguments)-Ms,f=a.apply(this,arguments)-Ms,g=xs(f-p),y=f>p;if(l||(l=s=h()),d<u&&(c=d,d=u,u=c),d>Ss)if(g>Bs-Ss)l.moveTo(d*ks(p),d*_s(p)),l.arc(0,0,d,p,f,!y),u>Ss&&(l.moveTo(u*ks(f),u*_s(f)),l.arc(0,0,u,f,p,y));else{var m,x,b=p,k=f,C=p,w=f,_=g,v=g,S=o.apply(this,arguments)/2,T=S>Ss&&(i?+i.apply(this,arguments):vs(u*u+d*d)),M=ws(xs(d-u)/2,+r.apply(this,arguments)),B=M,A=M;if(T>Ss){var L=Ls(T/u*_s(S)),F=Ls(T/d*_s(S));(_-=2*L)>Ss?(C+=L*=y?1:-1,w-=L):(_=0,C=w=(p+f)/2),(v-=2*F)>Ss?(b+=F*=y?1:-1,k-=F):(v=0,b=k=(p+f)/2)}var $=d*ks(b),E=d*_s(b),D=u*ks(w),O=u*_s(w);if(M>Ss){var I,N=d*ks(k),R=d*_s(k),P=u*ks(C),z=u*_s(C);if(g<Ts)if(I=Us($,E,P,z,N,R,D,O)){var q=$-I[0],j=E-I[1],W=N-I[0],H=R-I[1],U=1/_s(As((q*W+j*H)/(vs(q*q+j*j)*vs(W*W+H*H)))/2),Y=vs(I[0]*I[0]+I[1]*I[1]);B=ws(M,(u-Y)/(U-1)),A=ws(M,(d-Y)/(U+1))}else B=A=0}v>Ss?A>Ss?(m=Ys(P,z,$,E,d,A,y),x=Ys(N,R,D,O,d,A,y),l.moveTo(m.cx+m.x01,m.cy+m.y01),A<M?l.arc(m.cx,m.cy,A,bs(m.y01,m.x01),bs(x.y01,x.x01),!y):(l.arc(m.cx,m.cy,A,bs(m.y01,m.x01),bs(m.y11,m.x11),!y),l.arc(0,0,d,bs(m.cy+m.y11,m.cx+m.x11),bs(x.cy+x.y11,x.cx+x.x11),!y),l.arc(x.cx,x.cy,A,bs(x.y11,x.x11),bs(x.y01,x.x01),!y))):(l.moveTo($,E),l.arc(0,0,d,b,k,!y)):l.moveTo($,E),u>Ss&&_>Ss?B>Ss?(m=Ys(D,O,N,R,u,-B,y),x=Ys($,E,P,z,u,-B,y),l.lineTo(m.cx+m.x01,m.cy+m.y01),B<M?l.arc(m.cx,m.cy,B,bs(m.y01,m.x01),bs(x.y01,x.x01),!y):(l.arc(m.cx,m.cy,B,bs(m.y01,m.x01),bs(m.y11,m.x11),!y),l.arc(0,0,u,bs(m.cy+m.y11,m.cx+m.x11),bs(x.cy+x.y11,x.cx+x.x11),y),l.arc(x.cx,x.cy,B,bs(x.y11,x.x11),bs(x.y01,x.x01),!y))):l.arc(0,0,u,w,C,y):l.lineTo(D,O)}else l.moveTo(0,0);if(l.closePath(),s)return l=null,s+""||null}return s(c,"arc"),c.centroid=function(){var r=(+t.apply(this,arguments)+ +e.apply(this,arguments))/2,i=(+n.apply(this,arguments)+ +a.apply(this,arguments))/2-Ts/2;return[ks(i)*r,_s(i)*r]},c.innerRadius=function(e){return arguments.length?(t="function"==typeof e?e:ms(+e),c):t},c.outerRadius=function(t){return arguments.length?(e="function"==typeof t?t:ms(+t),c):e},c.cornerRadius=function(t){return arguments.length?(r="function"==typeof t?t:ms(+t),c):r},c.padRadius=function(t){return arguments.length?(i=null==t?null:"function"==typeof t?t:ms(+t),c):i},c.startAngle=function(t){return arguments.length?(n="function"==typeof t?t:ms(+t),c):n},c.endAngle=function(t){return arguments.length?(a="function"==typeof t?t:ms(+t),c):a},c.padAngle=function(t){return arguments.length?(o="function"==typeof t?t:ms(+t),c):o},c.context=function(t){return arguments.length?(l=t??null,c):l},c}function Gs(t){this._context=t}function Xs(t){return new Gs(t)}function Zs(t){return"object"==typeof t&&"length"in t?t:Array.from(t)}function Qs(t){return t[0]}function Ks(t){return t[1]}function Js(t,e){var r=ms(!0),i=null,n=Xs,a=null,o=Ps(l);function l(s){var l,h,c,u=(s=Zs(s)).length,d=!1;for(null==i&&(a=n(c=o())),l=0;l<=u;++l)!(l<u&&r(h=s[l],l,s))===d&&((d=!d)?a.lineStart():a.lineEnd()),d&&a.point(+t(h,l,s),+e(h,l,s));if(c)return a=null,c+""||null}return t="function"==typeof t?t:void 0===t?Qs:ms(t),e="function"==typeof e?e:void 0===e?Ks:ms(e),s(l,"line"),l.x=function(e){return arguments.length?(t="function"==typeof e?e:ms(+e),l):t},l.y=function(t){return arguments.length?(e="function"==typeof t?t:ms(+t),l):e},l.defined=function(t){return arguments.length?(r="function"==typeof t?t:ms(!!t),l):r},l.curve=function(t){return arguments.length?(n=t,null!=i&&(a=n(i)),l):n},l.context=function(t){return arguments.length?(null==t?i=a=null:a=n(i=t),l):i},l}function tl(t,e){return e<t?-1:e>t?1:e>=t?0:NaN}function el(t){return t}function rl(){var t=el,e=tl,r=null,i=ms(0),n=ms(Bs),a=ms(0);function o(o){var s,l,h,c,u,d=(o=Zs(o)).length,p=0,f=new Array(d),g=new Array(d),y=+i.apply(this,arguments),m=Math.min(Bs,Math.max(-Bs,n.apply(this,arguments)-y)),x=Math.min(Math.abs(m)/d,a.apply(this,arguments)),b=x*(m<0?-1:1);for(s=0;s<d;++s)(u=g[f[s]=s]=+t(o[s],s,o))>0&&(p+=u);for(null!=e?f.sort(function(t,r){return e(g[t],g[r])}):null!=r&&f.sort(function(t,e){return r(o[t],o[e])}),s=0,h=p?(m-d*b)/p:0;s<d;++s,y=c)l=f[s],c=y+((u=g[l])>0?u*h:0)+b,g[l]={data:o[l],index:s,value:u,startAngle:y,endAngle:c,padAngle:x};return g}return s(o,"pie"),o.value=function(e){return arguments.length?(t="function"==typeof e?e:ms(+e),o):t},o.sortValues=function(t){return arguments.length?(e=t,r=null,o):e},o.sort=function(t){return arguments.length?(r=t,e=null,o):r},o.startAngle=function(t){return arguments.length?(i="function"==typeof t?t:ms(+t),o):i},o.endAngle=function(t){return arguments.length?(n="function"==typeof t?t:ms(+t),o):n},o.padAngle=function(t){return arguments.length?(a="function"==typeof t?t:ms(+t),o):a},o}s(Rs,"path"),Rs.prototype=Ns.prototype,s(Ps,"withPath"),s(zs,"arcInnerRadius"),s(qs,"arcOuterRadius"),s(js,"arcStartAngle"),s(Ws,"arcEndAngle"),s(Hs,"arcPadAngle"),s(Us,"intersect"),s(Ys,"cornerTangents"),s(Vs,"default"),s(Gs,"Linear"),Gs.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._point=0},"lineStart"),lineEnd:s(function(){(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;default:this._context.lineTo(t,e)}},"point")},s(Xs,"default"),s(Zs,"default"),s(Qs,"x"),s(Ks,"y"),s(Js,"default"),s(tl,"default"),s(el,"default"),s(rl,"default");var il=class{static{s(this,"Bump")}constructor(t,e){this._context=t,this._x=e}areaStart(){this._line=0}areaEnd(){this._line=NaN}lineStart(){this._point=0}lineEnd(){(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line}point(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;default:this._x?this._context.bezierCurveTo(this._x0=(this._x0+t)/2,this._y0,this._x0,e,t,e):this._context.bezierCurveTo(this._x0,this._y0=(this._y0+e)/2,t,this._y0,t,e)}this._x0=t,this._y0=e}};function nl(t){return new il(t,!0)}function al(t){return new il(t,!1)}function ol(t,e,r){t._context.bezierCurveTo((2*t._x0+t._x1)/3,(2*t._y0+t._y1)/3,(t._x0+2*t._x1)/3,(t._y0+2*t._y1)/3,(t._x0+4*t._x1+e)/6,(t._y0+4*t._y1+r)/6)}function sl(t){this._context=t}function ll(t){return new sl(t)}function hl(){}function cl(t){this._context=t}function ul(t){return new cl(t)}function dl(t){this._context=t}function pl(t){return new dl(t)}function fl(t,e){this._basis=new sl(t),this._beta=e}s(nl,"bumpX"),s(al,"bumpY"),s(ol,"point"),s(sl,"Basis"),sl.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._y0=this._y1=NaN,this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 3:ol(this,this._x1,this._y1);case 2:this._context.lineTo(this._x1,this._y1)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;break;case 2:this._point=3,this._context.lineTo((5*this._x0+this._x1)/6,(5*this._y0+this._y1)/6);default:ol(this,t,e)}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e},"point")},s(ll,"default"),s(hl,"default"),s(cl,"BasisClosed"),cl.prototype={areaStart:hl,areaEnd:hl,lineStart:s(function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._y0=this._y1=this._y2=this._y3=this._y4=NaN,this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 1:this._context.moveTo(this._x2,this._y2),this._context.closePath();break;case 2:this._context.moveTo((this._x2+2*this._x3)/3,(this._y2+2*this._y3)/3),this._context.lineTo((this._x3+2*this._x2)/3,(this._y3+2*this._y2)/3),this._context.closePath();break;case 3:this.point(this._x2,this._y2),this.point(this._x3,this._y3),this.point(this._x4,this._y4)}},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._x2=t,this._y2=e;break;case 1:this._point=2,this._x3=t,this._y3=e;break;case 2:this._point=3,this._x4=t,this._y4=e,this._context.moveTo((this._x0+4*this._x1+t)/6,(this._y0+4*this._y1+e)/6);break;default:ol(this,t,e)}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e},"point")},s(ul,"default"),s(dl,"BasisOpen"),dl.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._y0=this._y1=NaN,this._point=0},"lineStart"),lineEnd:s(function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;var r=(this._x0+4*this._x1+t)/6,i=(this._y0+4*this._y1+e)/6;this._line?this._context.lineTo(r,i):this._context.moveTo(r,i);break;case 3:this._point=4;default:ol(this,t,e)}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e},"point")},s(pl,"default"),s(fl,"Bundle"),fl.prototype={lineStart:s(function(){this._x=[],this._y=[],this._basis.lineStart()},"lineStart"),lineEnd:s(function(){var t=this._x,e=this._y,r=t.length-1;if(r>0)for(var i,n=t[0],a=e[0],o=t[r]-n,s=e[r]-a,l=-1;++l<=r;)i=l/r,this._basis.point(this._beta*t[l]+(1-this._beta)*(n+i*o),this._beta*e[l]+(1-this._beta)*(a+i*s));this._x=this._y=null,this._basis.lineEnd()},"lineEnd"),point:s(function(t,e){this._x.push(+t),this._y.push(+e)},"point")};var gl=s(function t(e){function r(t){return 1===e?new sl(t):new fl(t,e)}return s(r,"bundle"),r.beta=function(e){return t(+e)},r},"custom")(.85);function yl(t,e,r){t._context.bezierCurveTo(t._x1+t._k*(t._x2-t._x0),t._y1+t._k*(t._y2-t._y0),t._x2+t._k*(t._x1-e),t._y2+t._k*(t._y1-r),t._x2,t._y2)}function ml(t,e){this._context=t,this._k=(1-e)/6}s(yl,"point"),s(ml,"Cardinal"),ml.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:yl(this,this._x1,this._y1)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2,this._x1=t,this._y1=e;break;case 2:this._point=3;default:yl(this,t,e)}this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var xl=s(function t(e){function r(t){return new ml(t,e)}return s(r,"cardinal"),r.tension=function(e){return t(+e)},r},"custom")(0);function bl(t,e){this._context=t,this._k=(1-e)/6}s(bl,"CardinalClosed"),bl.prototype={areaStart:hl,areaEnd:hl,lineStart:s(function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN,this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 1:this._context.moveTo(this._x3,this._y3),this._context.closePath();break;case 2:this._context.lineTo(this._x3,this._y3),this._context.closePath();break;case 3:this.point(this._x3,this._y3),this.point(this._x4,this._y4),this.point(this._x5,this._y5)}},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._x3=t,this._y3=e;break;case 1:this._point=2,this._context.moveTo(this._x4=t,this._y4=e);break;case 2:this._point=3,this._x5=t,this._y5=e;break;default:yl(this,t,e)}this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var kl=s(function t(e){function r(t){return new bl(t,e)}return s(r,"cardinal"),r.tension=function(e){return t(+e)},r},"custom")(0);function Cl(t,e){this._context=t,this._k=(1-e)/6}s(Cl,"CardinalOpen"),Cl.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._point=0},"lineStart"),lineEnd:s(function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3,this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:yl(this,t,e)}this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var wl=s(function t(e){function r(t){return new Cl(t,e)}return s(r,"cardinal"),r.tension=function(e){return t(+e)},r},"custom")(0);function _l(t,e,r){var i=t._x1,n=t._y1,a=t._x2,o=t._y2;if(t._l01_a>Ss){var s=2*t._l01_2a+3*t._l01_a*t._l12_a+t._l12_2a,l=3*t._l01_a*(t._l01_a+t._l12_a);i=(i*s-t._x0*t._l12_2a+t._x2*t._l01_2a)/l,n=(n*s-t._y0*t._l12_2a+t._y2*t._l01_2a)/l}if(t._l23_a>Ss){var h=2*t._l23_2a+3*t._l23_a*t._l12_a+t._l12_2a,c=3*t._l23_a*(t._l23_a+t._l12_a);a=(a*h+t._x1*t._l23_2a-e*t._l12_2a)/c,o=(o*h+t._y1*t._l23_2a-r*t._l12_2a)/c}t._context.bezierCurveTo(i,n,a,o,t._x2,t._y2)}function vl(t,e){this._context=t,this._alpha=e}s(_l,"point"),s(vl,"CatmullRom"),vl.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:this.point(this._x2,this._y2)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){if(t=+t,e=+e,this._point){var r=this._x2-t,i=this._y2-e;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(r*r+i*i,this._alpha))}switch(this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;break;case 2:this._point=3;default:_l(this,t,e)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var Sl=s(function t(e){function r(t){return e?new vl(t,e):new ml(t,0)}return s(r,"catmullRom"),r.alpha=function(e){return t(+e)},r},"custom")(.5);function Tl(t,e){this._context=t,this._alpha=e}s(Tl,"CatmullRomClosed"),Tl.prototype={areaStart:hl,areaEnd:hl,lineStart:s(function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 1:this._context.moveTo(this._x3,this._y3),this._context.closePath();break;case 2:this._context.lineTo(this._x3,this._y3),this._context.closePath();break;case 3:this.point(this._x3,this._y3),this.point(this._x4,this._y4),this.point(this._x5,this._y5)}},"lineEnd"),point:s(function(t,e){if(t=+t,e=+e,this._point){var r=this._x2-t,i=this._y2-e;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(r*r+i*i,this._alpha))}switch(this._point){case 0:this._point=1,this._x3=t,this._y3=e;break;case 1:this._point=2,this._context.moveTo(this._x4=t,this._y4=e);break;case 2:this._point=3,this._x5=t,this._y5=e;break;default:_l(this,t,e)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var Ml=s(function t(e){function r(t){return e?new Tl(t,e):new bl(t,0)}return s(r,"catmullRom"),r.alpha=function(e){return t(+e)},r},"custom")(.5);function Bl(t,e){this._context=t,this._alpha=e}s(Bl,"CatmullRomOpen"),Bl.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},"lineStart"),lineEnd:s(function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){if(t=+t,e=+e,this._point){var r=this._x2-t,i=this._y2-e;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(r*r+i*i,this._alpha))}switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3,this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:_l(this,t,e)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var Al=s(function t(e){function r(t){return e?new Bl(t,e):new Cl(t,0)}return s(r,"catmullRom"),r.alpha=function(e){return t(+e)},r},"custom")(.5);function Ll(t){this._context=t}function Fl(t){return new Ll(t)}function $l(t){return t<0?-1:1}function El(t,e,r){var i=t._x1-t._x0,n=e-t._x1,a=(t._y1-t._y0)/(i||n<0&&-0),o=(r-t._y1)/(n||i<0&&-0),s=(a*n+o*i)/(i+n);return($l(a)+$l(o))*Math.min(Math.abs(a),Math.abs(o),.5*Math.abs(s))||0}function Dl(t,e){var r=t._x1-t._x0;return r?(3*(t._y1-t._y0)/r-e)/2:e}function Ol(t,e,r){var i=t._x0,n=t._y0,a=t._x1,o=t._y1,s=(a-i)/3;t._context.bezierCurveTo(i+s,n+s*e,a-s,o-s*r,a,o)}function Il(t){this._context=t}function Nl(t){this._context=new Rl(t)}function Rl(t){this._context=t}function Pl(t){return new Il(t)}function zl(t){return new Nl(t)}function ql(t){this._context=t}function jl(t){var e,r,i=t.length-1,n=new Array(i),a=new Array(i),o=new Array(i);for(n[0]=0,a[0]=2,o[0]=t[0]+2*t[1],e=1;e<i-1;++e)n[e]=1,a[e]=4,o[e]=4*t[e]+2*t[e+1];for(n[i-1]=2,a[i-1]=7,o[i-1]=8*t[i-1]+t[i],e=1;e<i;++e)r=n[e]/a[e-1],a[e]-=r,o[e]-=r*o[e-1];for(n[i-1]=o[i-1]/a[i-1],e=i-2;e>=0;--e)n[e]=(o[e]-n[e+1])/a[e];for(a[i-1]=(t[i]+n[i-1])/2,e=0;e<i-1;++e)a[e]=2*t[e+1]-n[e+1];return[n,a]}function Wl(t){return new ql(t)}function Hl(t,e){this._context=t,this._t=e}function Ul(t){return new Hl(t,.5)}function Yl(t){return new Hl(t,0)}function Vl(t){return new Hl(t,1)}s(Ll,"LinearClosed"),Ll.prototype={areaStart:hl,areaEnd:hl,lineStart:s(function(){this._point=0},"lineStart"),lineEnd:s(function(){this._point&&this._context.closePath()},"lineEnd"),point:s(function(t,e){t=+t,e=+e,this._point?this._context.lineTo(t,e):(this._point=1,this._context.moveTo(t,e))},"point")},s(Fl,"default"),s($l,"sign"),s(El,"slope3"),s(Dl,"slope2"),s(Ol,"point"),s(Il,"MonotoneX"),Il.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._y0=this._y1=this._t0=NaN,this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 2:this._context.lineTo(this._x1,this._y1);break;case 3:Ol(this,this._t0,Dl(this,this._t0))}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){var r=NaN;if(e=+e,(t=+t)!==this._x1||e!==this._y1){switch(this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;break;case 2:this._point=3,Ol(this,Dl(this,r=El(this,t,e)),r);break;default:Ol(this,this._t0,r=El(this,t,e))}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e,this._t0=r}},"point")},s(Nl,"MonotoneY"),(Nl.prototype=Object.create(Il.prototype)).point=function(t,e){Il.prototype.point.call(this,e,t)},s(Rl,"ReflectContext"),Rl.prototype={moveTo:s(function(t,e){this._context.moveTo(e,t)},"moveTo"),closePath:s(function(){this._context.closePath()},"closePath"),lineTo:s(function(t,e){this._context.lineTo(e,t)},"lineTo"),bezierCurveTo:s(function(t,e,r,i,n,a){this._context.bezierCurveTo(e,t,i,r,a,n)},"bezierCurveTo")},s(Pl,"monotoneX"),s(zl,"monotoneY"),s(ql,"Natural"),ql.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x=[],this._y=[]},"lineStart"),lineEnd:s(function(){var t=this._x,e=this._y,r=t.length;if(r)if(this._line?this._context.lineTo(t[0],e[0]):this._context.moveTo(t[0],e[0]),2===r)this._context.lineTo(t[1],e[1]);else for(var i=jl(t),n=jl(e),a=0,o=1;o<r;++a,++o)this._context.bezierCurveTo(i[0][a],n[0][a],i[1][a],n[1][a],t[o],e[o]);(this._line||0!==this._line&&1===r)&&this._context.closePath(),this._line=1-this._line,this._x=this._y=null},"lineEnd"),point:s(function(t,e){this._x.push(+t),this._y.push(+e)},"point")},s(jl,"controlPoints"),s(Wl,"default"),s(Hl,"Step"),Hl.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x=this._y=NaN,this._point=0},"lineStart"),lineEnd:s(function(){0<this._t&&this._t<1&&2===this._point&&this._context.lineTo(this._x,this._y),(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line>=0&&(this._t=1-this._t,this._line=1-this._line)},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;default:if(this._t<=0)this._context.lineTo(this._x,e),this._context.lineTo(t,e);else{var r=this._x*(1-this._t)+t*this._t;this._context.lineTo(r,this._y),this._context.lineTo(r,e)}}this._x=t,this._y=e},"point")},s(Ul,"default"),s(Yl,"stepBefore"),s(Vl,"stepAfter");var Gl={value:s(()=>{},"value")};function Xl(){for(var t,e=0,r=arguments.length,i={};e<r;++e){if(!(t=arguments[e]+"")||t in i||/[\s.]/.test(t))throw new Error("illegal type: "+t);i[t]=[]}return new Zl(i)}function Zl(t){this._=t}function Ql(t,e){return t.trim().split(/^|\s+/).map(function(t){var r="",i=t.indexOf(".");if(i>=0&&(r=t.slice(i+1),t=t.slice(0,i)),t&&!e.hasOwnProperty(t))throw new Error("unknown type: "+t);return{type:t,name:r}})}function Kl(t,e){for(var r,i=0,n=t.length;i<n;++i)if((r=t[i]).name===e)return r.value}function Jl(t,e,r){for(var i=0,n=t.length;i<n;++i)if(t[i].name===e){t[i]=Gl,t=t.slice(0,i).concat(t.slice(i+1));break}return null!=r&&t.push({name:e,value:r}),t}s(Xl,"dispatch"),s(Zl,"Dispatch"),s(Ql,"parseTypenames"),Zl.prototype=Xl.prototype={constructor:Zl,on:s(function(t,e){var r,i=this._,n=Ql(t+"",i),a=-1,o=n.length;if(!(arguments.length<2)){if(null!=e&&"function"!=typeof e)throw new Error("invalid callback: "+e);for(;++a<o;)if(r=(t=n[a]).type)i[r]=Jl(i[r],t.name,e);else if(null==e)for(r in i)i[r]=Jl(i[r],t.name,null);return this}for(;++a<o;)if((r=(t=n[a]).type)&&(r=Kl(i[r],t.name)))return r},"on"),copy:s(function(){var t={},e=this._;for(var r in e)t[r]=e[r].slice();return new Zl(t)},"copy"),call:s(function(t,e){if((r=arguments.length-2)>0)for(var r,i,n=new Array(r),a=0;a<r;++a)n[a]=arguments[a+2];if(!this._.hasOwnProperty(t))throw new Error("unknown type: "+t);for(a=0,r=(i=this._[t]).length;a<r;++a)i[a].value.apply(e,n)},"call"),apply:s(function(t,e,r){if(!this._.hasOwnProperty(t))throw new Error("unknown type: "+t);for(var i=this._[t],n=0,a=i.length;n<a;++n)i[n].value.apply(e,r)},"apply")},s(Kl,"get"),s(Jl,"set");var th,eh,rh=Xl,ih=0,nh=0,ah=0,oh=0,sh=0,lh=0,hh="object"==typeof performance&&performance.now?performance:Date,ch="object"==typeof window&&window.requestAnimationFrame?window.requestAnimationFrame.bind(window):function(t){setTimeout(t,17)};function uh(){return sh||(ch(dh),sh=hh.now()+lh)}function dh(){sh=0}function ph(){this._call=this._time=this._next=null}function fh(t,e,r){var i=new ph;return i.restart(t,e,r),i}function gh(){uh(),++ih;for(var t,e=th;e;)(t=sh-e._time)>=0&&e._call.call(void 0,t),e=e._next;--ih}function yh(){sh=(oh=hh.now())+lh,ih=nh=0;try{gh()}finally{ih=0,xh(),sh=0}}function mh(){var t=hh.now(),e=t-oh;e>1e3&&(lh-=e,oh=t)}function xh(){for(var t,e,r=th,i=1/0;r;)r._call?(i>r._time&&(i=r._time),t=r,r=r._next):(e=r._next,r._next=null,r=t?t._next=e:th=e);eh=t,bh(i)}function bh(t){ih||(nh&&(nh=clearTimeout(nh)),t-sh>24?(t<1/0&&(nh=setTimeout(yh,t-hh.now()-lh)),ah&&(ah=clearInterval(ah))):(ah||(oh=hh.now(),ah=setInterval(mh,1e3)),ih=1,ch(yh)))}function kh(t,e,r){var i=new ph;return e=null==e?0:+e,i.restart(r=>{i.stop(),t(r+e)},e,r),i}s(uh,"now"),s(dh,"clearNow"),s(ph,"Timer"),ph.prototype=fh.prototype={constructor:ph,restart:s(function(t,e,r){if("function"!=typeof t)throw new TypeError("callback is not a function");r=(null==r?uh():+r)+(null==e?0:+e),!this._next&&eh!==this&&(eh?eh._next=this:th=this,eh=this),this._call=t,this._time=r,bh()},"restart"),stop:s(function(){this._call&&(this._call=null,this._time=1/0,bh())},"stop")},s(fh,"timer"),s(gh,"timerFlush"),s(yh,"wake"),s(mh,"poke"),s(xh,"nap"),s(bh,"sleep"),s(kh,"default");var Ch=rh("start","end","cancel","interrupt"),wh=[];function _h(t,e,r,i,n,a){var o=t.__transition;if(o){if(r in o)return}else t.__transition={};Mh(t,r,{name:e,index:i,group:n,on:Ch,tween:wh,time:a.time,delay:a.delay,duration:a.duration,ease:a.ease,timer:null,state:0})}function vh(t,e){var r=Th(t,e);if(r.state>0)throw new Error("too late; already scheduled");return r}function Sh(t,e){var r=Th(t,e);if(r.state>3)throw new Error("too late; already running");return r}function Th(t,e){var r=t.__transition;if(!r||!(r=r[e]))throw new Error("transition not found");return r}function Mh(t,e,r){var i,n=t.__transition;function a(t){r.state=1,r.timer.restart(o,r.delay,r.time),r.delay<=t&&o(t-r.delay)}function o(a){var s,c,u,d;if(1!==r.state)return h();for(s in n)if((d=n[s]).name===r.name){if(3===d.state)return kh(o);4===d.state?(d.state=6,d.timer.stop(),d.on.call("interrupt",t,t.__data__,d.index,d.group),delete n[s]):+s<e&&(d.state=6,d.timer.stop(),d.on.call("cancel",t,t.__data__,d.index,d.group),delete n[s])}if(kh(function(){3===r.state&&(r.state=4,r.timer.restart(l,r.delay,r.time),l(a))}),r.state=2,r.on.call("start",t,t.__data__,r.index,r.group),2===r.state){for(r.state=3,i=new Array(u=r.tween.length),s=0,c=-1;s<u;++s)(d=r.tween[s].value.call(t,t.__data__,r.index,r.group))&&(i[++c]=d);i.length=c+1}}function l(e){for(var n=e<r.duration?r.ease.call(null,e/r.duration):(r.timer.restart(h),r.state=5,1),a=-1,o=i.length;++a<o;)i[a].call(t,n);5===r.state&&(r.on.call("end",t,t.__data__,r.index,r.group),h())}function h(){for(var i in r.state=6,r.timer.stop(),delete n[e],n)return;delete t.__transition}n[e]=r,r.timer=fh(a,0,r.time),s(a,"schedule"),s(o,"start"),s(l,"tick"),s(h,"stop")}function Bh(t,e){var r,i,n,a=t.__transition,o=!0;if(a){for(n in e=null==e?null:e+"",a)(r=a[n]).name===e?(i=r.state>2&&r.state<5,r.state=6,r.timer.stop(),r.on.call(i?"interrupt":"cancel",t,t.__data__,r.index,r.group),delete a[n]):o=!1;o&&delete t.__transition}}function Ah(t){return this.each(function(){Bh(this,t)})}function Lh(t,e){var r,i;return function(){var n=Sh(this,t),a=n.tween;if(a!==r)for(var o=0,s=(i=r=a).length;o<s;++o)if(i[o].name===e){(i=i.slice()).splice(o,1);break}n.tween=i}}function Fh(t,e,r){var i,n;if("function"!=typeof r)throw new Error;return function(){var a=Sh(this,t),o=a.tween;if(o!==i){n=(i=o).slice();for(var s={name:e,value:r},l=0,h=n.length;l<h;++l)if(n[l].name===e){n[l]=s;break}l===h&&n.push(s)}a.tween=n}}function $h(t,e){var r=this._id;if(t+="",arguments.length<2){for(var i,n=Th(this.node(),r).tween,a=0,o=n.length;a<o;++a)if((i=n[a]).name===t)return i.value;return null}return this.each((null==e?Lh:Fh)(r,t,e))}function Eh(t,e,r){var i=t._id;return t.each(function(){var t=Sh(this,i);(t.value||(t.value={}))[e]=r.apply(this,arguments)}),function(t){return Th(t,i).value[e]}}function Dh(t,e){var r;return("number"==typeof e?mi:e instanceof br?di:(r=br(e))?(e=r,di):_i)(t,e)}function Oh(t){return function(){this.removeAttribute(t)}}function Ih(t){return function(){this.removeAttributeNS(t.space,t.local)}}function Nh(t,e,r){var i,n,a=r+"";return function(){var o=this.getAttribute(t);return o===a?null:o===i?n:n=e(i=o,r)}}function Rh(t,e,r){var i,n,a=r+"";return function(){var o=this.getAttributeNS(t.space,t.local);return o===a?null:o===i?n:n=e(i=o,r)}}function Ph(t,e,r){var i,n,a;return function(){var o,s,l=r(this);return null==l?void this.removeAttribute(t):(o=this.getAttribute(t))===(s=l+"")?null:o===i&&s===n?a:(n=s,a=e(i=o,l))}}function zh(t,e,r){var i,n,a;return function(){var o,s,l=r(this);return null==l?void this.removeAttributeNS(t.space,t.local):(o=this.getAttributeNS(t.space,t.local))===(s=l+"")?null:o===i&&s===n?a:(n=s,a=e(i=o,l))}}function qh(t,e){var r=zt(t),i="transform"===r?Di:Dh;return this.attrTween(t,"function"==typeof e?(r.local?zh:Ph)(r,i,Eh(this,"attr."+t,e)):null==e?(r.local?Ih:Oh)(r):(r.local?Rh:Nh)(r,i,e))}function jh(t,e){return function(r){this.setAttribute(t,e.call(this,r))}}function Wh(t,e){return function(r){this.setAttributeNS(t.space,t.local,e.call(this,r))}}function Hh(t,e){var r,i;function n(){var n=e.apply(this,arguments);return n!==i&&(r=(i=n)&&Wh(t,n)),r}return s(n,"tween"),n._value=e,n}function Uh(t,e){var r,i;function n(){var n=e.apply(this,arguments);return n!==i&&(r=(i=n)&&jh(t,n)),r}return s(n,"tween"),n._value=e,n}function Yh(t,e){var r="attr."+t;if(arguments.length<2)return(r=this.tween(r))&&r._value;if(null==e)return this.tween(r,null);if("function"!=typeof e)throw new Error;var i=zt(t);return this.tween(r,(i.local?Hh:Uh)(i,e))}function Vh(t,e){return function(){vh(this,t).delay=+e.apply(this,arguments)}}function Gh(t,e){return e=+e,function(){vh(this,t).delay=e}}function Xh(t){var e=this._id;return arguments.length?this.each(("function"==typeof t?Vh:Gh)(e,t)):Th(this.node(),e).delay}function Zh(t,e){return function(){Sh(this,t).duration=+e.apply(this,arguments)}}function Qh(t,e){return e=+e,function(){Sh(this,t).duration=e}}function Kh(t){var e=this._id;return arguments.length?this.each(("function"==typeof t?Zh:Qh)(e,t)):Th(this.node(),e).duration}function Jh(t,e){if("function"!=typeof e)throw new Error;return function(){Sh(this,t).ease=e}}function tc(t){var e=this._id;return arguments.length?this.each(Jh(e,t)):Th(this.node(),e).ease}function ec(t,e){return function(){var r=e.apply(this,arguments);if("function"!=typeof r)throw new Error;Sh(this,t).ease=r}}function rc(t){if("function"!=typeof t)throw new Error;return this.each(ec(this._id,t))}function ic(t){"function"!=typeof t&&(t=ot(t));for(var e=this._groups,r=e.length,i=new Array(r),n=0;n<r;++n)for(var a,o=e[n],s=o.length,l=i[n]=[],h=0;h<s;++h)(a=o[h])&&t.call(a,a.__data__,h,o)&&l.push(a);return new $c(i,this._parents,this._name,this._id)}function nc(t){if(t._id!==this._id)throw new Error;for(var e=this._groups,r=t._groups,i=e.length,n=r.length,a=Math.min(i,n),o=new Array(i),s=0;s<a;++s)for(var l,h=e[s],c=r[s],u=h.length,d=o[s]=new Array(u),p=0;p<u;++p)(l=h[p]||c[p])&&(d[p]=l);for(;s<i;++s)o[s]=e[s];return new $c(o,this._parents,this._name,this._id)}function ac(t){return(t+"").trim().split(/^|\s+/).every(function(t){var e=t.indexOf(".");return e>=0&&(t=t.slice(0,e)),!t||"start"===t})}function oc(t,e,r){var i,n,a=ac(e)?vh:Sh;return function(){var o=a(this,t),s=o.on;s!==i&&(n=(i=s).copy()).on(e,r),o.on=n}}function sc(t,e){var r=this._id;return arguments.length<2?Th(this.node(),r).on.on(t):this.each(oc(r,t,e))}function lc(t){return function(){var e=this.parentNode;for(var r in this.__transition)if(+r!==t)return;e&&e.removeChild(this)}}function hc(){return this.on("end.remove",lc(this._id))}function cc(t){var e=this._name,r=this._id;"function"!=typeof t&&(t=J(t));for(var i=this._groups,n=i.length,a=new Array(n),o=0;o<n;++o)for(var s,l,h=i[o],c=h.length,u=a[o]=new Array(c),d=0;d<c;++d)(s=h[d])&&(l=t.call(s,s.__data__,d,h))&&("__data__"in s&&(l.__data__=s.__data__),u[d]=l,_h(u[d],e,r,d,u,Th(s,r)));return new $c(a,this._parents,e,r)}function uc(t){var e=this._name,r=this._id;"function"!=typeof t&&(t=it(t));for(var i=this._groups,n=i.length,a=[],o=[],s=0;s<n;++s)for(var l,h=i[s],c=h.length,u=0;u<c;++u)if(l=h[u]){for(var d,p=t.call(l,l.__data__,u,h),f=Th(l,r),g=0,y=p.length;g<y;++g)(d=p[g])&&_h(d,e,r,g,p,f);a.push(p),o.push(l)}return new $c(a,o,e,r)}s(_h,"default"),s(vh,"init"),s(Sh,"set"),s(Th,"get"),s(Mh,"create"),s(Bh,"default"),s(Ah,"default"),s(Lh,"tweenRemove"),s(Fh,"tweenFunction"),s($h,"default"),s(Eh,"tweenValue"),s(Dh,"default"),s(Oh,"attrRemove"),s(Ih,"attrRemoveNS"),s(Nh,"attrConstant"),s(Rh,"attrConstantNS"),s(Ph,"attrFunction"),s(zh,"attrFunctionNS"),s(qh,"default"),s(jh,"attrInterpolate"),s(Wh,"attrInterpolateNS"),s(Hh,"attrTweenNS"),s(Uh,"attrTween"),s(Yh,"default"),s(Vh,"delayFunction"),s(Gh,"delayConstant"),s(Xh,"default"),s(Zh,"durationFunction"),s(Qh,"durationConstant"),s(Kh,"default"),s(Jh,"easeConstant"),s(tc,"default"),s(ec,"easeVarying"),s(rc,"default"),s(ic,"default"),s(nc,"default"),s(ac,"start"),s(oc,"onFunction"),s(sc,"default"),s(lc,"removeFunction"),s(hc,"default"),s(cc,"default"),s(uc,"default");var dc=Qe.prototype.constructor;function pc(){return new dc(this._groups,this._parents)}function fc(t,e){var r,i,n;return function(){var a=Jt(this,t),o=(this.style.removeProperty(t),Jt(this,t));return a===o?null:a===r&&o===i?n:n=e(r=a,i=o)}}function gc(t){return function(){this.style.removeProperty(t)}}function yc(t,e,r){var i,n,a=r+"";return function(){var o=Jt(this,t);return o===a?null:o===i?n:n=e(i=o,r)}}function mc(t,e,r){var i,n,a;return function(){var o=Jt(this,t),s=r(this),l=s+"";return null==s&&(this.style.removeProperty(t),l=s=Jt(this,t)),o===l?null:o===i&&l===n?a:(n=l,a=e(i=o,s))}}function xc(t,e){var r,i,n,a,o="style."+e,s="end."+o;return function(){var l=Sh(this,t),h=l.on,c=null==l.value[o]?a||(a=gc(e)):void 0;(h!==r||n!==c)&&(i=(r=h).copy()).on(s,n=c),l.on=i}}function bc(t,e,r){var i="transform"==(t+="")?Ei:Dh;return null==e?this.styleTween(t,fc(t,i)).on("end.style."+t,gc(t)):"function"==typeof e?this.styleTween(t,mc(t,i,Eh(this,"style."+t,e))).each(xc(this._id,t)):this.styleTween(t,yc(t,i,e),r).on("end.style."+t,null)}function kc(t,e,r){return function(i){this.style.setProperty(t,e.call(this,i),r)}}function Cc(t,e,r){var i,n;function a(){var a=e.apply(this,arguments);return a!==n&&(i=(n=a)&&kc(t,a,r)),i}return s(a,"tween"),a._value=e,a}function wc(t,e,r){var i="style."+(t+="");if(arguments.length<2)return(i=this.tween(i))&&i._value;if(null==e)return this.tween(i,null);if("function"!=typeof e)throw new Error;return this.tween(i,Cc(t,e,r??""))}function _c(t){return function(){this.textContent=t}}function vc(t){return function(){var e=t(this);this.textContent=e??""}}function Sc(t){return this.tween("text","function"==typeof t?vc(Eh(this,"text",t)):_c(null==t?"":t+""))}function Tc(t){return function(e){this.textContent=t.call(this,e)}}function Mc(t){var e,r;function i(){var i=t.apply(this,arguments);return i!==r&&(e=(r=i)&&Tc(i)),e}return s(i,"tween"),i._value=t,i}function Bc(t){var e="text";if(arguments.length<1)return(e=this.tween(e))&&e._value;if(null==t)return this.tween(e,null);if("function"!=typeof t)throw new Error;return this.tween(e,Mc(t))}function Ac(){for(var t=this._name,e=this._id,r=Dc(),i=this._groups,n=i.length,a=0;a<n;++a)for(var o,s=i[a],l=s.length,h=0;h<l;++h)if(o=s[h]){var c=Th(o,e);_h(o,t,r,h,s,{time:c.time+c.delay+c.duration,delay:0,duration:c.duration,ease:c.ease})}return new $c(i,this._parents,t,r)}function Lc(){var t,e,r=this,i=r._id,n=r.size();return new Promise(function(a,o){var l={value:o},h={value:s(function(){0===--n&&a()},"value")};r.each(function(){var r=Sh(this,i),n=r.on;n!==t&&((e=(t=n).copy())._.cancel.push(l),e._.interrupt.push(l),e._.end.push(h)),r.on=e}),0===n&&a()})}s(pc,"default"),s(fc,"styleNull"),s(gc,"styleRemove"),s(yc,"styleConstant"),s(mc,"styleFunction"),s(xc,"styleMaybeRemove"),s(bc,"default"),s(kc,"styleInterpolate"),s(Cc,"styleTween"),s(wc,"default"),s(_c,"textConstant"),s(vc,"textFunction"),s(Sc,"default"),s(Tc,"textInterpolate"),s(Mc,"textTween"),s(Bc,"default"),s(Ac,"default"),s(Lc,"default");var Fc=0;function $c(t,e,r,i){this._groups=t,this._parents=e,this._name=r,this._id=i}function Ec(t){return Qe().transition(t)}function Dc(){return++Fc}s($c,"Transition"),s(Ec,"transition"),s(Dc,"newId");var Oc=Qe.prototype;function Ic(t){return((t*=2)<=1?t*t*t:(t-=2)*t*t+2)/2}$c.prototype=Ec.prototype={constructor:$c,select:cc,selectAll:uc,selectChild:Oc.selectChild,selectChildren:Oc.selectChildren,filter:ic,merge:nc,selection:pc,transition:Ac,call:Oc.call,nodes:Oc.nodes,node:Oc.node,size:Oc.size,empty:Oc.empty,each:Oc.each,on:sc,attr:qh,attrTween:Yh,style:bc,styleTween:wc,text:Sc,textTween:Bc,remove:hc,tween:$h,delay:Xh,duration:Kh,ease:tc,easeVarying:rc,end:Lc,[Symbol.iterator]:Oc[Symbol.iterator]},s(Ic,"cubicInOut");var Nc={time:null,delay:0,duration:250,ease:Ic};function Rc(t,e){for(var r;!(r=t.__transition)||!(r=r[e]);)if(!(t=t.parentNode))throw new Error(`transition ${e} not found`);return r}function Pc(t){var e,r;t instanceof $c?(e=t._id,t=t._name):(e=Dc(),(r=Nc).time=uh(),t=null==t?null:t+"");for(var i=this._groups,n=i.length,a=0;a<n;++a)for(var o,s=i[a],l=s.length,h=0;h<l;++h)(o=s[h])&&_h(o,t,e,h,s,r||Rc(o,e));return new $c(i,this._parents,t,e)}function zc(t){return[+t[0],+t[1]]}function qc(t){return[zc(t[0]),zc(t[1])]}function jc(t,e,r){this.k=t,this.x=e,this.y=r}s(Rc,"inherit"),s(Pc,"default"),Qe.prototype.interrupt=Ah,Qe.prototype.transition=Pc,s(zc,"number1"),s(qc,"number2"),s(function(t,e){return null==t?null:[[+t[0],e[0][1]],[+t[1],e[1][1]]]},"input"),s(function(t){return t&&[t[0][0],t[1][0]]},"output"),s(function(t,e){return null==t?null:[[e[0][0],+t[0]],[e[1][0],+t[1]]]},"input"),s(function(t){return t&&[t[0][1],t[1][1]]},"output"),s(function(t){return null==t?null:qc(t)},"input"),s(function(t){return t},"output"),s(function(t){return{type:t}},"type"),s(jc,"Transform"),jc.prototype={constructor:jc,scale:s(function(t){return 1===t?this:new jc(this.k*t,this.x,this.y)},"scale"),translate:s(function(t,e){return 0===t&0===e?this:new jc(this.k,this.x+this.k*t,this.y+this.k*e)},"translate"),apply:s(function(t){return[t[0]*this.k+this.x,t[1]*this.k+this.y]},"apply"),applyX:s(function(t){return t*this.k+this.x},"applyX"),applyY:s(function(t){return t*this.k+this.y},"applyY"),invert:s(function(t){return[(t[0]-this.x)/this.k,(t[1]-this.y)/this.k]},"invert"),invertX:s(function(t){return(t-this.x)/this.k},"invertX"),invertY:s(function(t){return(t-this.y)/this.k},"invertY"),rescaleX:s(function(t){return t.copy().domain(t.range().map(this.invertX,this).map(t.invert,t))},"rescaleX"),rescaleY:s(function(t){return t.copy().domain(t.range().map(this.invertY,this).map(t.invert,t))},"rescaleY"),toString:s(function(){return"translate("+this.x+","+this.y+") scale("+this.k+")"},"toString")};var Wc=new jc(1,0,0);function Hc(t){for(;!t.__zoom;)if(!(t=t.parentNode))return Wc;return t.__zoom}Hc.prototype=jc.prototype,s(Hc,"transform");var Uc=/^-{3}\s*[\n\r](.*?)[\n\r]-{3}\s*[\n\r]+/s,Yc=/%{2}{\s*(?:(\w+)\s*:|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi,Vc=/\s*%%.*\n/gm,Gc=class extends Error{static{s(this,"UnknownDiagramError")}constructor(t){super(t),this.name="UnknownDiagramError"}},Xc={},Zc=s(function(t,e){t=t.replace(Uc,"").replace(Yc,"").replace(Vc,"\n");for(let[r,{detector:i}]of Object.entries(Xc))if(i(t,e))return r;throw new Gc(`No diagram type detected matching given configuration for text: ${t}`)},"detectType"),Qc=s((...t)=>{for(let{id:e,detector:r,loader:i}of t)Kc(e,r,i)},"registerLazyLoadedDiagrams"),Kc=s((t,e,r)=>{Xc[t]&&y.warn(`Detector with key ${t} already exists. Overwriting.`),Xc[t]={detector:e,loader:r},y.debug(`Detector with key ${t} added${r?" with loader":""}`)},"addDetector"),Jc=s(t=>Xc[t].loader,"getDiagramLoader"),tu=s((t,e,{depth:r=2,clobber:i=!1}={})=>{let n={depth:r,clobber:i};return Array.isArray(e)&&!Array.isArray(t)?(e.forEach(e=>tu(t,e,n)),t):Array.isArray(e)&&Array.isArray(t)?(e.forEach(e=>{t.includes(e)||t.push(e)}),t):void 0===t||r<=0?null!=t&&"object"==typeof t&&"object"==typeof e?Object.assign(t,e):e:(void 0!==e&&"object"==typeof t&&"object"==typeof e&&Object.keys(e).forEach(n=>{"object"!=typeof e[n]||void 0!==t[n]&&"object"!=typeof t[n]?(i||"object"!=typeof t[n]&&"object"!=typeof e[n])&&(t[n]=e[n]):(void 0===t[n]&&(t[n]=Array.isArray(e[n])?[]:{}),t[n]=tu(t[n],e[n],{depth:r-1,clobber:i}))}),t)},"assignWithDepth"),eu=tu,ru={min:{r:0,g:0,b:0,s:0,l:0,a:0},max:{r:255,g:255,b:255,h:360,s:100,l:100,a:1},clamp:{r:s(t=>t>=255?255:t<0?0:t,"r"),g:s(t=>t>=255?255:t<0?0:t,"g"),b:s(t=>t>=255?255:t<0?0:t,"b"),h:s(t=>t%360,"h"),s:s(t=>t>=100?100:t<0?0:t,"s"),l:s(t=>t>=100?100:t<0?0:t,"l"),a:s(t=>t>=1?1:t<0?0:t,"a")},toLinear:s(t=>{let e=t/255;return t>.03928?Math.pow((e+.055)/1.055,2.4):e/12.92},"toLinear"),hue2rgb:s((t,e,r)=>(r<0&&(r+=1),r>1&&(r-=1),r<.16666666666666666?t+6*(e-t)*r:r<.5?e:r<.6666666666666666?t+(e-t)*(.6666666666666666-r)*6:t),"hue2rgb"),hsl2rgb:s(({h:t,s:e,l:r},i)=>{if(!e)return 2.55*r;t/=360,e/=100;let n=(r/=100)<.5?r*(1+e):r+e-r*e,a=2*r-n;switch(i){case"r":return 255*ru.hue2rgb(a,n,t+.3333333333333333);case"g":return 255*ru.hue2rgb(a,n,t);case"b":return 255*ru.hue2rgb(a,n,t-.3333333333333333)}},"hsl2rgb"),rgb2hsl:s(({r:t,g:e,b:r},i)=>{t/=255,e/=255,r/=255;let n=Math.max(t,e,r),a=Math.min(t,e,r),o=(n+a)/2;if("l"===i)return 100*o;if(n===a)return 0;let s=n-a;if("s"===i)return 100*(o>.5?s/(2-n-a):s/(n+a));switch(n){case t:return 60*((e-r)/s+(e<r?6:0));case e:return 60*((r-t)/s+2);case r:return 60*((t-e)/s+4);default:return-1}},"rgb2hsl")},iu=ru,nu={clamp:s((t,e,r)=>e>r?Math.min(e,Math.max(r,t)):Math.min(r,Math.max(e,t)),"clamp"),round:s(t=>Math.round(1e10*t)/1e10,"round")},au=nu,ou={dec2hex:s(t=>{let e=Math.round(t).toString(16);return e.length>1?e:`0${e}`},"dec2hex")},su={channel:iu,lang:au,unit:ou},lu={};for(let t=0;t<=255;t++)lu[t]=su.unit.dec2hex(t);var hu,cu=0,uu=1,du=2,pu=class{static{s(this,"Type")}constructor(){this.type=cu}get(){return this.type}set(t){if(this.type&&this.type!==t)throw new Error("Cannot change both RGB and HSL channels at the same time");this.type=t}reset(){this.type=cu}is(t){return this.type===t}},fu=pu,gu=class{static{s(this,"Channels")}constructor(t,e){this.color=e,this.changed=!1,this.data=t,this.type=new fu}set(t,e){return this.color=e,this.changed=!1,this.data=t,this.type.type=cu,this}_ensureHSL(){let t=this.data,{h:e,s:r,l:i}=t;void 0===e&&(t.h=su.channel.rgb2hsl(t,"h")),void 0===r&&(t.s=su.channel.rgb2hsl(t,"s")),void 0===i&&(t.l=su.channel.rgb2hsl(t,"l"))}_ensureRGB(){let t=this.data,{r:e,g:r,b:i}=t;void 0===e&&(t.r=su.channel.hsl2rgb(t,"r")),void 0===r&&(t.g=su.channel.hsl2rgb(t,"g")),void 0===i&&(t.b=su.channel.hsl2rgb(t,"b"))}get r(){let t=this.data,e=t.r;return this.type.is(du)||void 0===e?(this._ensureHSL(),su.channel.hsl2rgb(t,"r")):e}get g(){let t=this.data,e=t.g;return this.type.is(du)||void 0===e?(this._ensureHSL(),su.channel.hsl2rgb(t,"g")):e}get b(){let t=this.data,e=t.b;return this.type.is(du)||void 0===e?(this._ensureHSL(),su.channel.hsl2rgb(t,"b")):e}get h(){let t=this.data,e=t.h;return this.type.is(uu)||void 0===e?(this._ensureRGB(),su.channel.rgb2hsl(t,"h")):e}get s(){let t=this.data,e=t.s;return this.type.is(uu)||void 0===e?(this._ensureRGB(),su.channel.rgb2hsl(t,"s")):e}get l(){let t=this.data,e=t.l;return this.type.is(uu)||void 0===e?(this._ensureRGB(),su.channel.rgb2hsl(t,"l")):e}get a(){return this.data.a}set r(t){this.type.set(uu),this.changed=!0,this.data.r=t}set g(t){this.type.set(uu),this.changed=!0,this.data.g=t}set b(t){this.type.set(uu),this.changed=!0,this.data.b=t}set h(t){this.type.set(du),this.changed=!0,this.data.h=t}set s(t){this.type.set(du),this.changed=!0,this.data.s=t}set l(t){this.type.set(du),this.changed=!0,this.data.l=t}set a(t){this.changed=!0,this.data.a=t}},yu=new gu({r:0,g:0,b:0,a:0},"transparent"),mu={re:/^#((?:[a-f0-9]{2}){2,4}|[a-f0-9]{3})$/i,parse:s(t=>{if(35!==t.charCodeAt(0))return;let e=t.match(mu.re);if(!e)return;let r=e[1],i=parseInt(r,16),n=r.length,a=n%4==0,o=n>4,s=o?1:17,l=o?8:4,h=a?0:-1,c=o?255:15;return yu.set({r:(i>>l*(h+3)&c)*s,g:(i>>l*(h+2)&c)*s,b:(i>>l*(h+1)&c)*s,a:a?(i&c)*s/255:1},t)},"parse"),stringify:s(t=>{let{r:e,g:r,b:i,a:n}=t;return n<1?`#${lu[Math.round(e)]}${lu[Math.round(r)]}${lu[Math.round(i)]}${lu[Math.round(255*n)]}`:`#${lu[Math.round(e)]}${lu[Math.round(r)]}${lu[Math.round(i)]}`},"stringify")},xu=mu,bu={re:/^hsla?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(?:deg|grad|rad|turn)?)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(%)?))?\s*?\)$/i,hueRe:/^(.+?)(deg|grad|rad|turn)$/i,_hue2deg:s(t=>{let e=t.match(bu.hueRe);if(e){let[,t,r]=e;switch(r){case"grad":return su.channel.clamp.h(.9*parseFloat(t));case"rad":return su.channel.clamp.h(180*parseFloat(t)/Math.PI);case"turn":return su.channel.clamp.h(360*parseFloat(t))}}return su.channel.clamp.h(parseFloat(t))},"_hue2deg"),parse:s(t=>{let e=t.charCodeAt(0);if(104!==e&&72!==e)return;let r=t.match(bu.re);if(!r)return;let[,i,n,a,o,s]=r;return yu.set({h:bu._hue2deg(i),s:su.channel.clamp.s(parseFloat(n)),l:su.channel.clamp.l(parseFloat(a)),a:o?su.channel.clamp.a(s?parseFloat(o)/100:parseFloat(o)):1},t)},"parse"),stringify:s(t=>{let{h:e,s:r,l:i,a:n}=t;return n<1?`hsla(${su.lang.round(e)}, ${su.lang.round(r)}%, ${su.lang.round(i)}%, ${n})`:`hsl(${su.lang.round(e)}, ${su.lang.round(r)}%, ${su.lang.round(i)}%)`},"stringify")},ku=bu,Cu={colors:{aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyanaqua:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",transparent:"#00000000",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},parse:s(t=>{t=t.toLowerCase();let e=Cu.colors[t];if(e)return xu.parse(e)},"parse"),stringify:s(t=>{let e=xu.stringify(t);for(let t in Cu.colors)if(Cu.colors[t]===e)return t},"stringify")},wu=Cu,_u={re:/^rgba?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?)))?\s*?\)$/i,parse:s(t=>{let e=t.charCodeAt(0);if(114!==e&&82!==e)return;let r=t.match(_u.re);if(!r)return;let[,i,n,a,o,s,l,h,c]=r;return yu.set({r:su.channel.clamp.r(n?2.55*parseFloat(i):parseFloat(i)),g:su.channel.clamp.g(o?2.55*parseFloat(a):parseFloat(a)),b:su.channel.clamp.b(l?2.55*parseFloat(s):parseFloat(s)),a:h?su.channel.clamp.a(c?parseFloat(h)/100:parseFloat(h)):1},t)},"parse"),stringify:s(t=>{let{r:e,g:r,b:i,a:n}=t;return n<1?`rgba(${su.lang.round(e)}, ${su.lang.round(r)}, ${su.lang.round(i)}, ${su.lang.round(n)})`:`rgb(${su.lang.round(e)}, ${su.lang.round(r)}, ${su.lang.round(i)})`},"stringify")},vu=_u,Su={format:{keyword:wu,hex:xu,rgb:vu,rgba:vu,hsl:ku,hsla:ku},parse:s(t=>{if("string"!=typeof t)return t;let e=xu.parse(t)||vu.parse(t)||ku.parse(t)||wu.parse(t);if(e)return e;throw new Error(`Unsupported color format: "${t}"`)},"parse"),stringify:s(t=>!t.changed&&t.color?t.color:t.type.is(du)||void 0===t.data.r?ku.stringify(t):t.a<1||!Number.isInteger(t.r)||!Number.isInteger(t.g)||!Number.isInteger(t.b)?vu.stringify(t):xu.stringify(t),"stringify")},Tu=Su,Mu=s((t,e)=>{let r=Tu.parse(t);for(let t in e)r[t]=su.channel.clamp[t](e[t]);return Tu.stringify(r)},"change"),Bu=Mu,Au=s((t,e,r=0,i=1)=>{if("number"!=typeof t)return Bu(t,{a:e});let n=yu.set({r:su.channel.clamp.r(t),g:su.channel.clamp.g(e),b:su.channel.clamp.b(r),a:su.channel.clamp.a(i)});return Tu.stringify(n)},"rgba"),Lu=Au,Fu=s((t,e)=>su.lang.round(Tu.parse(t)[e]),"channel"),$u=Fu,Eu=s(t=>{let{r:e,g:r,b:i}=Tu.parse(t),n=.2126*su.channel.toLinear(e)+.7152*su.channel.toLinear(r)+.0722*su.channel.toLinear(i);return su.lang.round(n)},"luminance"),Du=Eu,Ou=s(t=>Du(t)>=.5,"isLight"),Iu=Ou,Nu=s(t=>!Iu(t),"isDark"),Ru=Nu,Pu=s((t,e,r)=>{let i=Tu.parse(t),n=i[e],a=su.channel.clamp[e](n+r);return n!==a&&(i[e]=a),Tu.stringify(i)},"adjustChannel"),zu=Pu,qu=s((t,e)=>zu(t,"l",e),"lighten"),ju=qu,Wu=s((t,e)=>zu(t,"l",-e),"darken"),Hu=Wu,Uu=s((t,e)=>{let r=Tu.parse(t),i={};for(let t in e)e[t]&&(i[t]=r[t]+e[t]);return Bu(t,i)},"adjust"),Yu=Uu,Vu=s((t,e,r=50)=>{let{r:i,g:n,b:a,a:o}=Tu.parse(t),{r:s,g:l,b:h,a:c}=Tu.parse(e),u=r/100,d=2*u-1,p=o-c,f=((d*p===-1?d:(d+p)/(1+d*p))+1)/2,g=1-f;return Lu(i*f+s*g,n*f+l*g,a*f+h*g,o*u+c*(1-u))},"mix"),Gu=Vu,Xu=s((t,e=100)=>{let r=Tu.parse(t);return r.r=255-r.r,r.g=255-r.g,r.b=255-r.b,Gu(r,t,e)},"invert"),Zu=Xu,Qu="#ffffff",Ku="#f2f2f2",Ju=s((t,e)=>Yu(t,e?{s:-40,l:10}:{s:-40,l:-10}),"mkBorder"),td=class{static{s(this,"Theme")}constructor(){this.background="#f4f4f4",this.primaryColor="#fff4dd",this.noteBkgColor="#fff5ad",this.noteTextColor="#333",this.THEME_COLOR_LIMIT=12,this.fontFamily='"trebuchet ms", verdana, arial, sans-serif',this.fontSize="16px"}updateColors(){if(this.primaryTextColor=this.primaryTextColor||(this.darkMode?"#eee":"#333"),this.secondaryColor=this.secondaryColor||Yu(this.primaryColor,{h:-120}),this.tertiaryColor=this.tertiaryColor||Yu(this.primaryColor,{h:180,l:5}),this.primaryBorderColor=this.primaryBorderColor||Ju(this.primaryColor,this.darkMode),this.secondaryBorderColor=this.secondaryBorderColor||Ju(this.secondaryColor,this.darkMode),this.tertiaryBorderColor=this.tertiaryBorderColor||Ju(this.tertiaryColor,this.darkMode),this.noteBorderColor=this.noteBorderColor||Ju(this.noteBkgColor,this.darkMode),this.noteBkgColor=this.noteBkgColor||"#fff5ad",this.noteTextColor=this.noteTextColor||"#333",this.secondaryTextColor=this.secondaryTextColor||Zu(this.secondaryColor),this.tertiaryTextColor=this.tertiaryTextColor||Zu(this.tertiaryColor),this.lineColor=this.lineColor||Zu(this.background),this.arrowheadColor=this.arrowheadColor||Zu(this.background),this.textColor=this.textColor||this.primaryTextColor,this.border2=this.border2||this.tertiaryBorderColor,this.nodeBkg=this.nodeBkg||this.primaryColor,this.mainBkg=this.mainBkg||this.primaryColor,this.nodeBorder=this.nodeBorder||this.primaryBorderColor,this.clusterBkg=this.clusterBkg||this.tertiaryColor,this.clusterBorder=this.clusterBorder||this.tertiaryBorderColor,this.defaultLinkColor=this.defaultLinkColor||this.lineColor,this.titleColor=this.titleColor||this.tertiaryTextColor,this.edgeLabelBackground=this.edgeLabelBackground||(this.darkMode?Hu(this.secondaryColor,30):this.secondaryColor),this.nodeTextColor=this.nodeTextColor||this.primaryTextColor,this.actorBorder=this.actorBorder||this.primaryBorderColor,this.actorBkg=this.actorBkg||this.mainBkg,this.actorTextColor=this.actorTextColor||this.primaryTextColor,this.actorLineColor=this.actorLineColor||this.actorBorder,this.labelBoxBkgColor=this.labelBoxBkgColor||this.actorBkg,this.signalColor=this.signalColor||this.textColor,this.signalTextColor=this.signalTextColor||this.textColor,this.labelBoxBorderColor=this.labelBoxBorderColor||this.actorBorder,this.labelTextColor=this.labelTextColor||this.actorTextColor,this.loopTextColor=this.loopTextColor||this.actorTextColor,this.activationBorderColor=this.activationBorderColor||Hu(this.secondaryColor,10),this.activationBkgColor=this.activationBkgColor||this.secondaryColor,this.sequenceNumberColor=this.sequenceNumberColor||Zu(this.lineColor),this.sectionBkgColor=this.sectionBkgColor||this.tertiaryColor,this.altSectionBkgColor=this.altSectionBkgColor||"white",this.sectionBkgColor=this.sectionBkgColor||this.secondaryColor,this.sectionBkgColor2=this.sectionBkgColor2||this.primaryColor,this.excludeBkgColor=this.excludeBkgColor||"#eeeeee",this.taskBorderColor=this.taskBorderColor||this.primaryBorderColor,this.taskBkgColor=this.taskBkgColor||this.primaryColor,this.activeTaskBorderColor=this.activeTaskBorderColor||this.primaryColor,this.activeTaskBkgColor=this.activeTaskBkgColor||ju(this.primaryColor,23),this.gridColor=this.gridColor||"lightgrey",this.doneTaskBkgColor=this.doneTaskBkgColor||"lightgrey",this.doneTaskBorderColor=this.doneTaskBorderColor||"grey",this.critBorderColor=this.critBorderColor||"#ff8888",this.critBkgColor=this.critBkgColor||"red",this.todayLineColor=this.todayLineColor||"red",this.vertLineColor=this.vertLineColor||"navy",this.taskTextColor=this.taskTextColor||this.textColor,this.taskTextOutsideColor=this.taskTextOutsideColor||this.textColor,this.taskTextLightColor=this.taskTextLightColor||this.textColor,this.taskTextColor=this.taskTextColor||this.primaryTextColor,this.taskTextDarkColor=this.taskTextDarkColor||this.textColor,this.taskTextClickableColor=this.taskTextClickableColor||"#003163",this.personBorder=this.personBorder||this.primaryBorderColor,this.personBkg=this.personBkg||this.mainBkg,this.darkMode?(this.rowOdd=this.rowOdd||Hu(this.mainBkg,5)||"#ffffff",this.rowEven=this.rowEven||Hu(this.mainBkg,10)):(this.rowOdd=this.rowOdd||ju(this.mainBkg,75)||"#ffffff",this.rowEven=this.rowEven||ju(this.mainBkg,5)),this.transitionColor=this.transitionColor||this.lineColor,this.transitionLabelColor=this.transitionLabelColor||this.textColor,this.stateLabelColor=this.stateLabelColor||this.stateBkg||this.primaryTextColor,this.stateBkg=this.stateBkg||this.mainBkg,this.labelBackgroundColor=this.labelBackgroundColor||this.stateBkg,this.compositeBackground=this.compositeBackground||this.background||this.tertiaryColor,this.altBackground=this.altBackground||this.tertiaryColor,this.compositeTitleBackground=this.compositeTitleBackground||this.mainBkg,this.compositeBorder=this.compositeBorder||this.nodeBorder,this.innerEndBackground=this.nodeBorder,this.errorBkgColor=this.errorBkgColor||this.tertiaryColor,this.errorTextColor=this.errorTextColor||this.tertiaryTextColor,this.transitionColor=this.transitionColor||this.lineColor,this.specialStateColor=this.lineColor,this.cScale0=this.cScale0||this.primaryColor,this.cScale1=this.cScale1||this.secondaryColor,this.cScale2=this.cScale2||this.tertiaryColor,this.cScale3=this.cScale3||Yu(this.primaryColor,{h:30}),this.cScale4=this.cScale4||Yu(this.primaryColor,{h:60}),this.cScale5=this.cScale5||Yu(this.primaryColor,{h:90}),this.cScale6=this.cScale6||Yu(this.primaryColor,{h:120}),this.cScale7=this.cScale7||Yu(this.primaryColor,{h:150}),this.cScale8=this.cScale8||Yu(this.primaryColor,{h:210,l:150}),this.cScale9=this.cScale9||Yu(this.primaryColor,{h:270}),this.cScale10=this.cScale10||Yu(this.primaryColor,{h:300}),this.cScale11=this.cScale11||Yu(this.primaryColor,{h:330}),this.darkMode)for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScale"+t]=Hu(this["cScale"+t],75);else for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScale"+t]=Hu(this["cScale"+t],25);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleInv"+t]=this["cScaleInv"+t]||Zu(this["cScale"+t]);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this.darkMode?this["cScalePeer"+t]=this["cScalePeer"+t]||ju(this["cScale"+t],10):this["cScalePeer"+t]=this["cScalePeer"+t]||Hu(this["cScale"+t],10);this.scaleLabelColor=this.scaleLabelColor||this.labelTextColor;for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleLabel"+t]=this["cScaleLabel"+t]||this.scaleLabelColor;let t=this.darkMode?-4:-1;for(let e=0;e<5;e++)this["surface"+e]=this["surface"+e]||Yu(this.mainBkg,{h:180,s:-15,l:t*(5+3*e)}),this["surfacePeer"+e]=this["surfacePeer"+e]||Yu(this.mainBkg,{h:180,s:-15,l:t*(8+3*e)});this.classText=this.classText||this.textColor,this.fillType0=this.fillType0||this.primaryColor,this.fillType1=this.fillType1||this.secondaryColor,this.fillType2=this.fillType2||Yu(this.primaryColor,{h:64}),this.fillType3=this.fillType3||Yu(this.secondaryColor,{h:64}),this.fillType4=this.fillType4||Yu(this.primaryColor,{h:-64}),this.fillType5=this.fillType5||Yu(this.secondaryColor,{h:-64}),this.fillType6=this.fillType6||Yu(this.primaryColor,{h:128}),this.fillType7=this.fillType7||Yu(this.secondaryColor,{h:128}),this.pie1=this.pie1||this.primaryColor,this.pie2=this.pie2||this.secondaryColor,this.pie3=this.pie3||this.tertiaryColor,this.pie4=this.pie4||Yu(this.primaryColor,{l:-10}),this.pie5=this.pie5||Yu(this.secondaryColor,{l:-10}),this.pie6=this.pie6||Yu(this.tertiaryColor,{l:-10}),this.pie7=this.pie7||Yu(this.primaryColor,{h:60,l:-10}),this.pie8=this.pie8||Yu(this.primaryColor,{h:-60,l:-10}),this.pie9=this.pie9||Yu(this.primaryColor,{h:120,l:0}),this.pie10=this.pie10||Yu(this.primaryColor,{h:60,l:-20}),this.pie11=this.pie11||Yu(this.primaryColor,{h:-60,l:-20}),this.pie12=this.pie12||Yu(this.primaryColor,{h:120,l:-10}),this.pieTitleTextSize=this.pieTitleTextSize||"25px",this.pieTitleTextColor=this.pieTitleTextColor||this.taskTextDarkColor,this.pieSectionTextSize=this.pieSectionTextSize||"17px",this.pieSectionTextColor=this.pieSectionTextColor||this.textColor,this.pieLegendTextSize=this.pieLegendTextSize||"17px",this.pieLegendTextColor=this.pieLegendTextColor||this.taskTextDarkColor,this.pieStrokeColor=this.pieStrokeColor||"black",this.pieStrokeWidth=this.pieStrokeWidth||"2px",this.pieOuterStrokeWidth=this.pieOuterStrokeWidth||"2px",this.pieOuterStrokeColor=this.pieOuterStrokeColor||"black",this.pieOpacity=this.pieOpacity||"0.7",this.radar={axisColor:this.radar?.axisColor||this.lineColor,axisStrokeWidth:this.radar?.axisStrokeWidth||2,axisLabelFontSize:this.radar?.axisLabelFontSize||12,curveOpacity:this.radar?.curveOpacity||.5,curveStrokeWidth:this.radar?.curveStrokeWidth||2,graticuleColor:this.radar?.graticuleColor||"#DEDEDE",graticuleStrokeWidth:this.radar?.graticuleStrokeWidth||1,graticuleOpacity:this.radar?.graticuleOpacity||.3,legendBoxSize:this.radar?.legendBoxSize||12,legendFontSize:this.radar?.legendFontSize||12},this.archEdgeColor=this.archEdgeColor||"#777",this.archEdgeArrowColor=this.archEdgeArrowColor||"#777",this.archEdgeWidth=this.archEdgeWidth||"3",this.archGroupBorderColor=this.archGroupBorderColor||"#000",this.archGroupBorderWidth=this.archGroupBorderWidth||"2px",this.quadrant1Fill=this.quadrant1Fill||this.primaryColor,this.quadrant2Fill=this.quadrant2Fill||Yu(this.primaryColor,{r:5,g:5,b:5}),this.quadrant3Fill=this.quadrant3Fill||Yu(this.primaryColor,{r:10,g:10,b:10}),this.quadrant4Fill=this.quadrant4Fill||Yu(this.primaryColor,{r:15,g:15,b:15}),this.quadrant1TextFill=this.quadrant1TextFill||this.primaryTextColor,this.quadrant2TextFill=this.quadrant2TextFill||Yu(this.primaryTextColor,{r:-5,g:-5,b:-5}),this.quadrant3TextFill=this.quadrant3TextFill||Yu(this.primaryTextColor,{r:-10,g:-10,b:-10}),this.quadrant4TextFill=this.quadrant4TextFill||Yu(this.primaryTextColor,{r:-15,g:-15,b:-15}),this.quadrantPointFill=this.quadrantPointFill||Ru(this.quadrant1Fill)?ju(this.quadrant1Fill):Hu(this.quadrant1Fill),this.quadrantPointTextFill=this.quadrantPointTextFill||this.primaryTextColor,this.quadrantXAxisTextFill=this.quadrantXAxisTextFill||this.primaryTextColor,this.quadrantYAxisTextFill=this.quadrantYAxisTextFill||this.primaryTextColor,this.quadrantInternalBorderStrokeFill=this.quadrantInternalBorderStrokeFill||this.primaryBorderColor,this.quadrantExternalBorderStrokeFill=this.quadrantExternalBorderStrokeFill||this.primaryBorderColor,this.quadrantTitleFill=this.quadrantTitleFill||this.primaryTextColor,this.xyChart={backgroundColor:this.xyChart?.backgroundColor||this.background,titleColor:this.xyChart?.titleColor||this.primaryTextColor,xAxisTitleColor:this.xyChart?.xAxisTitleColor||this.primaryTextColor,xAxisLabelColor:this.xyChart?.xAxisLabelColor||this.primaryTextColor,xAxisTickColor:this.xyChart?.xAxisTickColor||this.primaryTextColor,xAxisLineColor:this.xyChart?.xAxisLineColor||this.primaryTextColor,yAxisTitleColor:this.xyChart?.yAxisTitleColor||this.primaryTextColor,yAxisLabelColor:this.xyChart?.yAxisLabelColor||this.primaryTextColor,yAxisTickColor:this.xyChart?.yAxisTickColor||this.primaryTextColor,yAxisLineColor:this.xyChart?.yAxisLineColor||this.primaryTextColor,plotColorPalette:this.xyChart?.plotColorPalette||"#FFF4DD,#FFD8B1,#FFA07A,#ECEFF1,#D6DBDF,#C3E0A8,#FFB6A4,#FFD74D,#738FA7,#FFFFF0"},this.requirementBackground=this.requirementBackground||this.primaryColor,this.requirementBorderColor=this.requirementBorderColor||this.primaryBorderColor,this.requirementBorderSize=this.requirementBorderSize||"1",this.requirementTextColor=this.requirementTextColor||this.primaryTextColor,this.relationColor=this.relationColor||this.lineColor,this.relationLabelBackground=this.relationLabelBackground||(this.darkMode?Hu(this.secondaryColor,30):this.secondaryColor),this.relationLabelColor=this.relationLabelColor||this.actorTextColor,this.git0=this.git0||this.primaryColor,this.git1=this.git1||this.secondaryColor,this.git2=this.git2||this.tertiaryColor,this.git3=this.git3||Yu(this.primaryColor,{h:-30}),this.git4=this.git4||Yu(this.primaryColor,{h:-60}),this.git5=this.git5||Yu(this.primaryColor,{h:-90}),this.git6=this.git6||Yu(this.primaryColor,{h:60}),this.git7=this.git7||Yu(this.primaryColor,{h:120}),this.darkMode?(this.git0=ju(this.git0,25),this.git1=ju(this.git1,25),this.git2=ju(this.git2,25),this.git3=ju(this.git3,25),this.git4=ju(this.git4,25),this.git5=ju(this.git5,25),this.git6=ju(this.git6,25),this.git7=ju(this.git7,25)):(this.git0=Hu(this.git0,25),this.git1=Hu(this.git1,25),this.git2=Hu(this.git2,25),this.git3=Hu(this.git3,25),this.git4=Hu(this.git4,25),this.git5=Hu(this.git5,25),this.git6=Hu(this.git6,25),this.git7=Hu(this.git7,25)),this.gitInv0=this.gitInv0||Zu(this.git0),this.gitInv1=this.gitInv1||Zu(this.git1),this.gitInv2=this.gitInv2||Zu(this.git2),this.gitInv3=this.gitInv3||Zu(this.git3),this.gitInv4=this.gitInv4||Zu(this.git4),this.gitInv5=this.gitInv5||Zu(this.git5),this.gitInv6=this.gitInv6||Zu(this.git6),this.gitInv7=this.gitInv7||Zu(this.git7),this.branchLabelColor=this.branchLabelColor||(this.darkMode?"black":this.labelTextColor),this.gitBranchLabel0=this.gitBranchLabel0||this.branchLabelColor,this.gitBranchLabel1=this.gitBranchLabel1||this.branchLabelColor,this.gitBranchLabel2=this.gitBranchLabel2||this.branchLabelColor,this.gitBranchLabel3=this.gitBranchLabel3||this.branchLabelColor,this.gitBranchLabel4=this.gitBranchLabel4||this.branchLabelColor,this.gitBranchLabel5=this.gitBranchLabel5||this.branchLabelColor,this.gitBranchLabel6=this.gitBranchLabel6||this.branchLabelColor,this.gitBranchLabel7=this.gitBranchLabel7||this.branchLabelColor,this.tagLabelColor=this.tagLabelColor||this.primaryTextColor,this.tagLabelBackground=this.tagLabelBackground||this.primaryColor,this.tagLabelBorder=this.tagBorder||this.primaryBorderColor,this.tagLabelFontSize=this.tagLabelFontSize||"10px",this.commitLabelColor=this.commitLabelColor||this.secondaryTextColor,this.commitLabelBackground=this.commitLabelBackground||this.secondaryColor,this.commitLabelFontSize=this.commitLabelFontSize||"10px",this.attributeBackgroundColorOdd=this.attributeBackgroundColorOdd||Qu,this.attributeBackgroundColorEven=this.attributeBackgroundColorEven||Ku}calculate(t){if("object"!=typeof t)return void this.updateColors();let e=Object.keys(t);e.forEach(e=>{this[e]=t[e]}),this.updateColors(),e.forEach(e=>{this[e]=t[e]})}},ed=s(t=>{let e=new td;return e.calculate(t),e},"getThemeVariables"),rd=class{static{s(this,"Theme")}constructor(){this.background="#333",this.primaryColor="#1f2020",this.secondaryColor=ju(this.primaryColor,16),this.tertiaryColor=Yu(this.primaryColor,{h:-160}),this.primaryBorderColor=Zu(this.background),this.secondaryBorderColor=Ju(this.secondaryColor,this.darkMode),this.tertiaryBorderColor=Ju(this.tertiaryColor,this.darkMode),this.primaryTextColor=Zu(this.primaryColor),this.secondaryTextColor=Zu(this.secondaryColor),this.tertiaryTextColor=Zu(this.tertiaryColor),this.lineColor=Zu(this.background),this.textColor=Zu(this.background),this.mainBkg="#1f2020",this.secondBkg="calculated",this.mainContrastColor="lightgrey",this.darkTextColor=ju(Zu("#323D47"),10),this.lineColor="calculated",this.border1="#ccc",this.border2=Lu(255,255,255,.25),this.arrowheadColor="calculated",this.fontFamily='"trebuchet ms", verdana, arial, sans-serif',this.fontSize="16px",this.labelBackground="#181818",this.textColor="#ccc",this.THEME_COLOR_LIMIT=12,this.nodeBkg="calculated",this.nodeBorder="calculated",this.clusterBkg="calculated",this.clusterBorder="calculated",this.defaultLinkColor="calculated",this.titleColor="#F9FFFE",this.edgeLabelBackground="calculated",this.actorBorder="calculated",this.actorBkg="calculated",this.actorTextColor="calculated",this.actorLineColor="calculated",this.signalColor="calculated",this.signalTextColor="calculated",this.labelBoxBkgColor="calculated",this.labelBoxBorderColor="calculated",this.labelTextColor="calculated",this.loopTextColor="calculated",this.noteBorderColor="calculated",this.noteBkgColor="#fff5ad",this.noteTextColor="calculated",this.activationBorderColor="calculated",this.activationBkgColor="calculated",this.sequenceNumberColor="black",this.sectionBkgColor=Hu("#EAE8D9",30),this.altSectionBkgColor="calculated",this.sectionBkgColor2="#EAE8D9",this.excludeBkgColor=Hu(this.sectionBkgColor,10),this.taskBorderColor=Lu(255,255,255,70),this.taskBkgColor="calculated",this.taskTextColor="calculated",this.taskTextLightColor="calculated",this.taskTextOutsideColor="calculated",this.taskTextClickableColor="#003163",this.activeTaskBorderColor=Lu(255,255,255,50),this.activeTaskBkgColor="#81B1DB",this.gridColor="calculated",this.doneTaskBkgColor="calculated",this.doneTaskBorderColor="grey",this.critBorderColor="#E83737",this.critBkgColor="#E83737",this.taskTextDarkColor="calculated",this.todayLineColor="#DB5757",this.vertLineColor="#00BFFF",this.personBorder=this.primaryBorderColor,this.personBkg=this.mainBkg,this.archEdgeColor="calculated",this.archEdgeArrowColor="calculated",this.archEdgeWidth="3",this.archGroupBorderColor=this.primaryBorderColor,this.archGroupBorderWidth="2px",this.rowOdd=this.rowOdd||ju(this.mainBkg,5)||"#ffffff",this.rowEven=this.rowEven||Hu(this.mainBkg,10),this.labelColor="calculated",this.errorBkgColor="#a44141",this.errorTextColor="#ddd"}updateColors(){this.secondBkg=ju(this.mainBkg,16),this.lineColor=this.mainContrastColor,this.arrowheadColor=this.mainContrastColor,this.nodeBkg=this.mainBkg,this.nodeBorder=this.border1,this.clusterBkg=this.secondBkg,this.clusterBorder=this.border2,this.defaultLinkColor=this.lineColor,this.edgeLabelBackground=ju(this.labelBackground,25),this.actorBorder=this.border1,this.actorBkg=this.mainBkg,this.actorTextColor=this.mainContrastColor,this.actorLineColor=this.actorBorder,this.signalColor=this.mainContrastColor,this.signalTextColor=this.mainContrastColor,this.labelBoxBkgColor=this.actorBkg,this.labelBoxBorderColor=this.actorBorder,this.labelTextColor=this.mainContrastColor,this.loopTextColor=this.mainContrastColor,this.noteBorderColor=this.secondaryBorderColor,this.noteBkgColor=this.secondBkg,this.noteTextColor=this.secondaryTextColor,this.activationBorderColor=this.border1,this.activationBkgColor=this.secondBkg,this.altSectionBkgColor=this.background,this.taskBkgColor=ju(this.mainBkg,23),this.taskTextColor=this.darkTextColor,this.taskTextLightColor=this.mainContrastColor,this.taskTextOutsideColor=this.taskTextLightColor,this.gridColor=this.mainContrastColor,this.doneTaskBkgColor=this.mainContrastColor,this.taskTextDarkColor=this.darkTextColor,this.archEdgeColor=this.lineColor,this.archEdgeArrowColor=this.lineColor,this.transitionColor=this.transitionColor||this.lineColor,this.transitionLabelColor=this.transitionLabelColor||this.textColor,this.stateLabelColor=this.stateLabelColor||this.stateBkg||this.primaryTextColor,this.stateBkg=this.stateBkg||this.mainBkg,this.labelBackgroundColor=this.labelBackgroundColor||this.stateBkg,this.compositeBackground=this.compositeBackground||this.background||this.tertiaryColor,this.altBackground=this.altBackground||"#555",this.compositeTitleBackground=this.compositeTitleBackground||this.mainBkg,this.compositeBorder=this.compositeBorder||this.nodeBorder,this.innerEndBackground=this.primaryBorderColor,this.specialStateColor="#f4f4f4",this.errorBkgColor=this.errorBkgColor||this.tertiaryColor,this.errorTextColor=this.errorTextColor||this.tertiaryTextColor,this.fillType0=this.primaryColor,this.fillType1=this.secondaryColor,this.fillType2=Yu(this.primaryColor,{h:64}),this.fillType3=Yu(this.secondaryColor,{h:64}),this.fillType4=Yu(this.primaryColor,{h:-64}),this.fillType5=Yu(this.secondaryColor,{h:-64}),this.fillType6=Yu(this.primaryColor,{h:128}),this.fillType7=Yu(this.secondaryColor,{h:128}),this.cScale1=this.cScale1||"#0b0000",this.cScale2=this.cScale2||"#4d1037",this.cScale3=this.cScale3||"#3f5258",this.cScale4=this.cScale4||"#4f2f1b",this.cScale5=this.cScale5||"#6e0a0a",this.cScale6=this.cScale6||"#3b0048",this.cScale7=this.cScale7||"#995a01",this.cScale8=this.cScale8||"#154706",this.cScale9=this.cScale9||"#161722",this.cScale10=this.cScale10||"#00296f",this.cScale11=this.cScale11||"#01629c",this.cScale12=this.cScale12||"#010029",this.cScale0=this.cScale0||this.primaryColor,this.cScale1=this.cScale1||this.secondaryColor,this.cScale2=this.cScale2||this.tertiaryColor,this.cScale3=this.cScale3||Yu(this.primaryColor,{h:30}),this.cScale4=this.cScale4||Yu(this.primaryColor,{h:60}),this.cScale5=this.cScale5||Yu(this.primaryColor,{h:90}),this.cScale6=this.cScale6||Yu(this.primaryColor,{h:120}),this.cScale7=this.cScale7||Yu(this.primaryColor,{h:150}),this.cScale8=this.cScale8||Yu(this.primaryColor,{h:210}),this.cScale9=this.cScale9||Yu(this.primaryColor,{h:270}),this.cScale10=this.cScale10||Yu(this.primaryColor,{h:300}),this.cScale11=this.cScale11||Yu(this.primaryColor,{h:330});for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleInv"+t]=this["cScaleInv"+t]||Zu(this["cScale"+t]);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScalePeer"+t]=this["cScalePeer"+t]||ju(this["cScale"+t],10);for(let t=0;t<5;t++)this["surface"+t]=this["surface"+t]||Yu(this.mainBkg,{h:30,s:-30,l:-(4*t-10)}),this["surfacePeer"+t]=this["surfacePeer"+t]||Yu(this.mainBkg,{h:30,s:-30,l:-(4*t-7)});this.scaleLabelColor=this.scaleLabelColor||(this.darkMode?"black":this.labelTextColor);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleLabel"+t]=this["cScaleLabel"+t]||this.scaleLabelColor;for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["pie"+t]=this["cScale"+t];this.pieTitleTextSize=this.pieTitleTextSize||"25px",this.pieTitleTextColor=this.pieTitleTextColor||this.taskTextDarkColor,this.pieSectionTextSize=this.pieSectionTextSize||"17px",this.pieSectionTextColor=this.pieSectionTextColor||this.textColor,this.pieLegendTextSize=this.pieLegendTextSize||"17px",this.pieLegendTextColor=this.pieLegendTextColor||this.taskTextDarkColor,this.pieStrokeColor=this.pieStrokeColor||"black",this.pieStrokeWidth=this.pieStrokeWidth||"2px",this.pieOuterStrokeWidth=this.pieOuterStrokeWidth||"2px",this.pieOuterStrokeColor=this.pieOuterStrokeColor||"black",this.pieOpacity=this.pieOpacity||"0.7",this.quadrant1Fill=this.quadrant1Fill||this.primaryColor,this.quadrant2Fill=this.quadrant2Fill||Yu(this.primaryColor,{r:5,g:5,b:5}),this.quadrant3Fill=this.quadrant3Fill||Yu(this.primaryColor,{r:10,g:10,b:10}),this.quadrant4Fill=this.quadrant4Fill||Yu(this.primaryColor,{r:15,g:15,b:15}),this.quadrant1TextFill=this.quadrant1TextFill||this.primaryTextColor,this.quadrant2TextFill=this.quadrant2TextFill||Yu(this.primaryTextColor,{r:-5,g:-5,b:-5}),this.quadrant3TextFill=this.quadrant3TextFill||Yu(this.primaryTextColor,{r:-10,g:-10,b:-10}),this.quadrant4TextFill=this.quadrant4TextFill||Yu(this.primaryTextColor,{r:-15,g:-15,b:-15}),this.quadrantPointFill=this.quadrantPointFill||Ru(this.quadrant1Fill)?ju(this.quadrant1Fill):Hu(this.quadrant1Fill),this.quadrantPointTextFill=this.quadrantPointTextFill||this.primaryTextColor,this.quadrantXAxisTextFill=this.quadrantXAxisTextFill||this.primaryTextColor,this.quadrantYAxisTextFill=this.quadrantYAxisTextFill||this.primaryTextColor,this.quadrantInternalBorderStrokeFill=this.quadrantInternalBorderStrokeFill||this.primaryBorderColor,this.quadrantExternalBorderStrokeFill=this.quadrantExternalBorderStrokeFill||this.primaryBorderColor,this.quadrantTitleFill=this.quadrantTitleFill||this.primaryTextColor,this.xyChart={backgroundColor:this.xyChart?.backgroundColor||this.background,titleColor:this.xyChart?.titleColor||this.primaryTextColor,xAxisTitleColor:this.xyChart?.xAxisTitleColor||this.primaryTextColor,xAxisLabelColor:this.xyChart?.xAxisLabelColor||this.primaryTextColor,xAxisTickColor:this.xyChart?.xAxisTickColor||this.primaryTextColor,xAxisLineColor:this.xyChart?.xAxisLineColor||this.primaryTextColor,yAxisTitleColor:this.xyChart?.yAxisTitleColor||this.primaryTextColor,yAxisLabelColor:this.xyChart?.yAxisLabelColor||this.primaryTextColor,yAxisTickColor:this.xyChart?.yAxisTickColor||this.primaryTextColor,yAxisLineColor:this.xyChart?.yAxisLineColor||this.primaryTextColor,plotColorPalette:this.xyChart?.plotColorPalette||"#3498db,#2ecc71,#e74c3c,#f1c40f,#bdc3c7,#ffffff,#34495e,#9b59b6,#1abc9c,#e67e22"},this.packet={startByteColor:this.primaryTextColor,endByteColor:this.primaryTextColor,labelColor:this.primaryTextColor,titleColor:this.primaryTextColor,blockStrokeColor:this.primaryTextColor,blockFillColor:this.background},this.radar={axisColor:this.radar?.axisColor||this.lineColor,axisStrokeWidth:this.radar?.axisStrokeWidth||2,axisLabelFontSize:this.radar?.axisLabelFontSize||12,curveOpacity:this.radar?.curveOpacity||.5,curveStrokeWidth:this.radar?.curveStrokeWidth||2,graticuleColor:this.radar?.graticuleColor||"#DEDEDE",graticuleStrokeWidth:this.radar?.graticuleStrokeWidth||1,graticuleOpacity:this.radar?.graticuleOpacity||.3,legendBoxSize:this.radar?.legendBoxSize||12,legendFontSize:this.radar?.legendFontSize||12},this.classText=this.primaryTextColor,this.requirementBackground=this.requirementBackground||this.primaryColor,this.requirementBorderColor=this.requirementBorderColor||this.primaryBorderColor,this.requirementBorderSize=this.requirementBorderSize||"1",this.requirementTextColor=this.requirementTextColor||this.primaryTextColor,this.relationColor=this.relationColor||this.lineColor,this.relationLabelBackground=this.relationLabelBackground||(this.darkMode?Hu(this.secondaryColor,30):this.secondaryColor),this.relationLabelColor=this.relationLabelColor||this.actorTextColor,this.git0=ju(this.secondaryColor,20),this.git1=ju(this.pie2||this.secondaryColor,20),this.git2=ju(this.pie3||this.tertiaryColor,20),this.git3=ju(this.pie4||Yu(this.primaryColor,{h:-30}),20),this.git4=ju(this.pie5||Yu(this.primaryColor,{h:-60}),20),this.git5=ju(this.pie6||Yu(this.primaryColor,{h:-90}),10),this.git6=ju(this.pie7||Yu(this.primaryColor,{h:60}),10),this.git7=ju(this.pie8||Yu(this.primaryColor,{h:120}),20),this.gitInv0=this.gitInv0||Zu(this.git0),this.gitInv1=this.gitInv1||Zu(this.git1),this.gitInv2=this.gitInv2||Zu(this.git2),this.gitInv3=this.gitInv3||Zu(this.git3),this.gitInv4=this.gitInv4||Zu(this.git4),this.gitInv5=this.gitInv5||Zu(this.git5),this.gitInv6=this.gitInv6||Zu(this.git6),this.gitInv7=this.gitInv7||Zu(this.git7),this.gitBranchLabel0=this.gitBranchLabel0||Zu(this.labelTextColor),this.gitBranchLabel1=this.gitBranchLabel1||this.labelTextColor,this.gitBranchLabel2=this.gitBranchLabel2||this.labelTextColor,this.gitBranchLabel3=this.gitBranchLabel3||Zu(this.labelTextColor),this.gitBranchLabel4=this.gitBranchLabel4||this.labelTextColor,this.gitBranchLabel5=this.gitBranchLabel5||this.labelTextColor,this.gitBranchLabel6=this.gitBranchLabel6||this.labelTextColor,this.gitBranchLabel7=this.gitBranchLabel7||this.labelTextColor,this.tagLabelColor=this.tagLabelColor||this.primaryTextColor,this.tagLabelBackground=this.tagLabelBackground||this.primaryColor,this.tagLabelBorder=this.tagBorder||this.primaryBorderColor,this.tagLabelFontSize=this.tagLabelFontSize||"10px",this.commitLabelColor=this.commitLabelColor||this.secondaryTextColor,this.commitLabelBackground=this.commitLabelBackground||this.secondaryColor,this.commitLabelFontSize=this.commitLabelFontSize||"10px",this.attributeBackgroundColorOdd=this.attributeBackgroundColorOdd||ju(this.background,12),this.attributeBackgroundColorEven=this.attributeBackgroundColorEven||ju(this.background,2),this.nodeBorder=this.nodeBorder||"#999"}calculate(t){if("object"!=typeof t)return void this.updateColors();let e=Object.keys(t);e.forEach(e=>{this[e]=t[e]}),this.updateColors(),e.forEach(e=>{this[e]=t[e]})}},id=s(t=>{let e=new rd;return e.calculate(t),e},"getThemeVariables"),nd=class{static{s(this,"Theme")}constructor(){this.background="#f4f4f4",this.primaryColor="#ECECFF",this.secondaryColor=Yu(this.primaryColor,{h:120}),this.secondaryColor="#ffffde",this.tertiaryColor=Yu(this.primaryColor,{h:-160}),this.primaryBorderColor=Ju(this.primaryColor,this.darkMode),this.secondaryBorderColor=Ju(this.secondaryColor,this.darkMode),this.tertiaryBorderColor=Ju(this.tertiaryColor,this.darkMode),this.primaryTextColor=Zu(this.primaryColor),this.secondaryTextColor=Zu(this.secondaryColor),this.tertiaryTextColor=Zu(this.tertiaryColor),this.lineColor=Zu(this.background),this.textColor=Zu(this.background),this.background="white",this.mainBkg="#ECECFF",this.secondBkg="#ffffde",this.lineColor="#333333",this.border1="#9370DB",this.border2="#aaaa33",this.arrowheadColor="#333333",this.fontFamily='"trebuchet ms", verdana, arial, sans-serif',this.fontSize="16px",this.labelBackground="rgba(232,232,232, 0.8)",this.textColor="#333",this.THEME_COLOR_LIMIT=12,this.nodeBkg="calculated",this.nodeBorder="calculated",this.clusterBkg="calculated",this.clusterBorder="calculated",this.defaultLinkColor="calculated",this.titleColor="calculated",this.edgeLabelBackground="calculated",this.actorBorder="calculated",this.actorBkg="calculated",this.actorTextColor="black",this.actorLineColor="calculated",this.signalColor="calculated",this.signalTextColor="calculated",this.labelBoxBkgColor="calculated",this.labelBoxBorderColor="calculated",this.labelTextColor="calculated",this.loopTextColor="calculated",this.noteBorderColor="calculated",this.noteBkgColor="#fff5ad",this.noteTextColor="calculated",this.activationBorderColor="#666",this.activationBkgColor="#f4f4f4",this.sequenceNumberColor="white",this.sectionBkgColor="calculated",this.altSectionBkgColor="calculated",this.sectionBkgColor2="calculated",this.excludeBkgColor="#eeeeee",this.taskBorderColor="calculated",this.taskBkgColor="calculated",this.taskTextLightColor="calculated",this.taskTextColor=this.taskTextLightColor,this.taskTextDarkColor="calculated",this.taskTextOutsideColor=this.taskTextDarkColor,this.taskTextClickableColor="calculated",this.activeTaskBorderColor="calculated",this.activeTaskBkgColor="calculated",this.gridColor="calculated",this.doneTaskBkgColor="calculated",this.doneTaskBorderColor="calculated",this.critBorderColor="calculated",this.critBkgColor="calculated",this.todayLineColor="calculated",this.vertLineColor="calculated",this.sectionBkgColor=Lu(102,102,255,.49),this.altSectionBkgColor="white",this.sectionBkgColor2="#fff400",this.taskBorderColor="#534fbc",this.taskBkgColor="#8a90dd",this.taskTextLightColor="white",this.taskTextColor="calculated",this.taskTextDarkColor="black",this.taskTextOutsideColor="calculated",this.taskTextClickableColor="#003163",this.activeTaskBorderColor="#534fbc",this.activeTaskBkgColor="#bfc7ff",this.gridColor="lightgrey",this.doneTaskBkgColor="lightgrey",this.doneTaskBorderColor="grey",this.critBorderColor="#ff8888",this.critBkgColor="red",this.todayLineColor="red",this.vertLineColor="navy",this.personBorder=this.primaryBorderColor,this.personBkg=this.mainBkg,this.archEdgeColor="calculated",this.archEdgeArrowColor="calculated",this.archEdgeWidth="3",this.archGroupBorderColor=this.primaryBorderColor,this.archGroupBorderWidth="2px",this.rowOdd="calculated",this.rowEven="calculated",this.labelColor="black",this.errorBkgColor="#552222",this.errorTextColor="#552222",this.updateColors()}updateColors(){this.cScale0=this.cScale0||this.primaryColor,this.cScale1=this.cScale1||this.secondaryColor,this.cScale2=this.cScale2||this.tertiaryColor,this.cScale3=this.cScale3||Yu(this.primaryColor,{h:30}),this.cScale4=this.cScale4||Yu(this.primaryColor,{h:60}),this.cScale5=this.cScale5||Yu(this.primaryColor,{h:90}),this.cScale6=this.cScale6||Yu(this.primaryColor,{h:120}),this.cScale7=this.cScale7||Yu(this.primaryColor,{h:150}),this.cScale8=this.cScale8||Yu(this.primaryColor,{h:210}),this.cScale9=this.cScale9||Yu(this.primaryColor,{h:270}),this.cScale10=this.cScale10||Yu(this.primaryColor,{h:300}),this.cScale11=this.cScale11||Yu(this.primaryColor,{h:330}),this.cScalePeer1=this.cScalePeer1||Hu(this.secondaryColor,45),this.cScalePeer2=this.cScalePeer2||Hu(this.tertiaryColor,40);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScale"+t]=Hu(this["cScale"+t],10),this["cScalePeer"+t]=this["cScalePeer"+t]||Hu(this["cScale"+t],25);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleInv"+t]=this["cScaleInv"+t]||Yu(this["cScale"+t],{h:180});for(let t=0;t<5;t++)this["surface"+t]=this["surface"+t]||Yu(this.mainBkg,{h:30,l:-(5+5*t)}),this["surfacePeer"+t]=this["surfacePeer"+t]||Yu(this.mainBkg,{h:30,l:-(7+5*t)});if(this.scaleLabelColor="calculated"!==this.scaleLabelColor&&this.scaleLabelColor?this.scaleLabelColor:this.labelTextColor,"calculated"!==this.labelTextColor){this.cScaleLabel0=this.cScaleLabel0||Zu(this.labelTextColor),this.cScaleLabel3=this.cScaleLabel3||Zu(this.labelTextColor);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleLabel"+t]=this["cScaleLabel"+t]||this.labelTextColor}this.nodeBkg=this.mainBkg,this.nodeBorder=this.border1,this.clusterBkg=this.secondBkg,this.clusterBorder=this.border2,this.defaultLinkColor=this.lineColor,this.titleColor=this.textColor,this.edgeLabelBackground=this.labelBackground,this.actorBorder=ju(this.border1,23),this.actorBkg=this.mainBkg,this.labelBoxBkgColor=this.actorBkg,this.signalColor=this.textColor,this.signalTextColor=this.textColor,this.labelBoxBorderColor=this.actorBorder,this.labelTextColor=this.actorTextColor,this.loopTextColor=this.actorTextColor,this.noteBorderColor=this.border2,this.noteTextColor=this.actorTextColor,this.actorLineColor=this.actorBorder,this.taskTextColor=this.taskTextLightColor,this.taskTextOutsideColor=this.taskTextDarkColor,this.archEdgeColor=this.lineColor,this.archEdgeArrowColor=this.lineColor,this.rowOdd=this.rowOdd||ju(this.primaryColor,75)||"#ffffff",this.rowEven=this.rowEven||ju(this.primaryColor,1),this.transitionColor=this.transitionColor||this.lineColor,this.transitionLabelColor=this.transitionLabelColor||this.textColor,this.stateLabelColor=this.stateLabelColor||this.stateBkg||this.primaryTextColor,this.stateBkg=this.stateBkg||this.mainBkg,this.labelBackgroundColor=this.labelBackgroundColor||this.stateBkg,this.compositeBackground=this.compositeBackground||this.background||this.tertiaryColor,this.altBackground=this.altBackground||"#f0f0f0",this.compositeTitleBackground=this.compositeTitleBackground||this.mainBkg,this.compositeBorder=this.compositeBorder||this.nodeBorder,this.innerEndBackground=this.nodeBorder,this.specialStateColor=this.lineColor,this.errorBkgColor=this.errorBkgColor||this.tertiaryColor,this.errorTextColor=this.errorTextColor||this.tertiaryTextColor,this.transitionColor=this.transitionColor||this.lineColor,this.classText=this.primaryTextColor,this.fillType0=this.primaryColor,this.fillType1=this.secondaryColor,this.fillType2=Yu(this.primaryColor,{h:64}),this.fillType3=Yu(this.secondaryColor,{h:64}),this.fillType4=Yu(this.primaryColor,{h:-64}),this.fillType5=Yu(this.secondaryColor,{h:-64}),this.fillType6=Yu(this.primaryColor,{h:128}),this.fillType7=Yu(this.secondaryColor,{h:128}),this.pie1=this.pie1||this.primaryColor,this.pie2=this.pie2||this.secondaryColor,this.pie3=this.pie3||Yu(this.tertiaryColor,{l:-40}),this.pie4=this.pie4||Yu(this.primaryColor,{l:-10}),this.pie5=this.pie5||Yu(this.secondaryColor,{l:-30}),this.pie6=this.pie6||Yu(this.tertiaryColor,{l:-20}),this.pie7=this.pie7||Yu(this.primaryColor,{h:60,l:-20}),this.pie8=this.pie8||Yu(this.primaryColor,{h:-60,l:-40}),this.pie9=this.pie9||Yu(this.primaryColor,{h:120,l:-40}),this.pie10=this.pie10||Yu(this.primaryColor,{h:60,l:-40}),this.pie11=this.pie11||Yu(this.primaryColor,{h:-90,l:-40}),this.pie12=this.pie12||Yu(this.primaryColor,{h:120,l:-30}),this.pieTitleTextSize=this.pieTitleTextSize||"25px",this.pieTitleTextColor=this.pieTitleTextColor||this.taskTextDarkColor,this.pieSectionTextSize=this.pieSectionTextSize||"17px",this.pieSectionTextColor=this.pieSectionTextColor||this.textColor,this.pieLegendTextSize=this.pieLegendTextSize||"17px",this.pieLegendTextColor=this.pieLegendTextColor||this.taskTextDarkColor,this.pieStrokeColor=this.pieStrokeColor||"black",this.pieStrokeWidth=this.pieStrokeWidth||"2px",this.pieOuterStrokeWidth=this.pieOuterStrokeWidth||"2px",this.pieOuterStrokeColor=this.pieOuterStrokeColor||"black",this.pieOpacity=this.pieOpacity||"0.7",this.quadrant1Fill=this.quadrant1Fill||this.primaryColor,this.quadrant2Fill=this.quadrant2Fill||Yu(this.primaryColor,{r:5,g:5,b:5}),this.quadrant3Fill=this.quadrant3Fill||Yu(this.primaryColor,{r:10,g:10,b:10}),this.quadrant4Fill=this.quadrant4Fill||Yu(this.primaryColor,{r:15,g:15,b:15}),this.quadrant1TextFill=this.quadrant1TextFill||this.primaryTextColor,this.quadrant2TextFill=this.quadrant2TextFill||Yu(this.primaryTextColor,{r:-5,g:-5,b:-5}),this.quadrant3TextFill=this.quadrant3TextFill||Yu(this.primaryTextColor,{r:-10,g:-10,b:-10}),this.quadrant4TextFill=this.quadrant4TextFill||Yu(this.primaryTextColor,{r:-15,g:-15,b:-15}),this.quadrantPointFill=this.quadrantPointFill||Ru(this.quadrant1Fill)?ju(this.quadrant1Fill):Hu(this.quadrant1Fill),this.quadrantPointTextFill=this.quadrantPointTextFill||this.primaryTextColor,this.quadrantXAxisTextFill=this.quadrantXAxisTextFill||this.primaryTextColor,this.quadrantYAxisTextFill=this.quadrantYAxisTextFill||this.primaryTextColor,this.quadrantInternalBorderStrokeFill=this.quadrantInternalBorderStrokeFill||this.primaryBorderColor,this.quadrantExternalBorderStrokeFill=this.quadrantExternalBorderStrokeFill||this.primaryBorderColor,this.quadrantTitleFill=this.quadrantTitleFill||this.primaryTextColor,this.radar={axisColor:this.radar?.axisColor||this.lineColor,axisStrokeWidth:this.radar?.axisStrokeWidth||2,axisLabelFontSize:this.radar?.axisLabelFontSize||12,curveOpacity:this.radar?.curveOpacity||.5,curveStrokeWidth:this.radar?.curveStrokeWidth||2,graticuleColor:this.radar?.graticuleColor||"#DEDEDE",graticuleStrokeWidth:this.radar?.graticuleStrokeWidth||1,graticuleOpacity:this.radar?.graticuleOpacity||.3,legendBoxSize:this.radar?.legendBoxSize||12,legendFontSize:this.radar?.legendFontSize||12},this.xyChart={backgroundColor:this.xyChart?.backgroundColor||this.background,titleColor:this.xyChart?.titleColor||this.primaryTextColor,xAxisTitleColor:this.xyChart?.xAxisTitleColor||this.primaryTextColor,xAxisLabelColor:this.xyChart?.xAxisLabelColor||this.primaryTextColor,xAxisTickColor:this.xyChart?.xAxisTickColor||this.primaryTextColor,xAxisLineColor:this.xyChart?.xAxisLineColor||this.primaryTextColor,yAxisTitleColor:this.xyChart?.yAxisTitleColor||this.primaryTextColor,yAxisLabelColor:this.xyChart?.yAxisLabelColor||this.primaryTextColor,yAxisTickColor:this.xyChart?.yAxisTickColor||this.primaryTextColor,yAxisLineColor:this.xyChart?.yAxisLineColor||this.primaryTextColor,plotColorPalette:this.xyChart?.plotColorPalette||"#ECECFF,#8493A6,#FFC3A0,#DCDDE1,#B8E994,#D1A36F,#C3CDE6,#FFB6C1,#496078,#F8F3E3"},this.requirementBackground=this.requirementBackground||this.primaryColor,this.requirementBorderColor=this.requirementBorderColor||this.primaryBorderColor,this.requirementBorderSize=this.requirementBorderSize||"1",this.requirementTextColor=this.requirementTextColor||this.primaryTextColor,this.relationColor=this.relationColor||this.lineColor,this.relationLabelBackground=this.relationLabelBackground||this.labelBackground,this.relationLabelColor=this.relationLabelColor||this.actorTextColor,this.git0=this.git0||this.primaryColor,this.git1=this.git1||this.secondaryColor,this.git2=this.git2||this.tertiaryColor,this.git3=this.git3||Yu(this.primaryColor,{h:-30}),this.git4=this.git4||Yu(this.primaryColor,{h:-60}),this.git5=this.git5||Yu(this.primaryColor,{h:-90}),this.git6=this.git6||Yu(this.primaryColor,{h:60}),this.git7=this.git7||Yu(this.primaryColor,{h:120}),this.darkMode?(this.git0=ju(this.git0,25),this.git1=ju(this.git1,25),this.git2=ju(this.git2,25),this.git3=ju(this.git3,25),this.git4=ju(this.git4,25),this.git5=ju(this.git5,25),this.git6=ju(this.git6,25),this.git7=ju(this.git7,25)):(this.git0=Hu(this.git0,25),this.git1=Hu(this.git1,25),this.git2=Hu(this.git2,25),this.git3=Hu(this.git3,25),this.git4=Hu(this.git4,25),this.git5=Hu(this.git5,25),this.git6=Hu(this.git6,25),this.git7=Hu(this.git7,25)),this.gitInv0=this.gitInv0||Hu(Zu(this.git0),25),this.gitInv1=this.gitInv1||Zu(this.git1),this.gitInv2=this.gitInv2||Zu(this.git2),this.gitInv3=this.gitInv3||Zu(this.git3),this.gitInv4=this.gitInv4||Zu(this.git4),this.gitInv5=this.gitInv5||Zu(this.git5),this.gitInv6=this.gitInv6||Zu(this.git6),this.gitInv7=this.gitInv7||Zu(this.git7),this.gitBranchLabel0=this.gitBranchLabel0||Zu(this.labelTextColor),this.gitBranchLabel1=this.gitBranchLabel1||this.labelTextColor,this.gitBranchLabel2=this.gitBranchLabel2||this.labelTextColor,this.gitBranchLabel3=this.gitBranchLabel3||Zu(this.labelTextColor),this.gitBranchLabel4=this.gitBranchLabel4||this.labelTextColor,this.gitBranchLabel5=this.gitBranchLabel5||this.labelTextColor,this.gitBranchLabel6=this.gitBranchLabel6||this.labelTextColor,this.gitBranchLabel7=this.gitBranchLabel7||this.labelTextColor,this.tagLabelColor=this.tagLabelColor||this.primaryTextColor,this.tagLabelBackground=this.tagLabelBackground||this.primaryColor,this.tagLabelBorder=this.tagBorder||this.primaryBorderColor,this.tagLabelFontSize=this.tagLabelFontSize||"10px",this.commitLabelColor=this.commitLabelColor||this.secondaryTextColor,this.commitLabelBackground=this.commitLabelBackground||this.secondaryColor,this.commitLabelFontSize=this.commitLabelFontSize||"10px",this.attributeBackgroundColorOdd=this.attributeBackgroundColorOdd||Qu,this.attributeBackgroundColorEven=this.attributeBackgroundColorEven||Ku}calculate(t){if(Object.keys(this).forEach(t=>{"calculated"===this[t]&&(this[t]=void 0)}),"object"!=typeof t)return void this.updateColors();let e=Object.keys(t);e.forEach(e=>{this[e]=t[e]}),this.updateColors(),e.forEach(e=>{this[e]=t[e]})}},ad=s(t=>{let e=new nd;return e.calculate(t),e},"getThemeVariables"),od=class{static{s(this,"Theme")}constructor(){this.background="#f4f4f4",this.primaryColor="#cde498",this.secondaryColor="#cdffb2",this.background="white",this.mainBkg="#cde498",this.secondBkg="#cdffb2",this.lineColor="green",this.border1="#13540c",this.border2="#6eaa49",this.arrowheadColor="green",this.fontFamily='"trebuchet ms", verdana, arial, sans-serif',this.fontSize="16px",this.tertiaryColor=ju("#cde498",10),this.primaryBorderColor=Ju(this.primaryColor,this.darkMode),this.secondaryBorderColor=Ju(this.secondaryColor,this.darkMode),this.tertiaryBorderColor=Ju(this.tertiaryColor,this.darkMode),this.primaryTextColor=Zu(this.primaryColor),this.secondaryTextColor=Zu(this.secondaryColor),this.tertiaryTextColor=Zu(this.primaryColor),this.lineColor=Zu(this.background),this.textColor=Zu(this.background),this.THEME_COLOR_LIMIT=12,this.nodeBkg="calculated",this.nodeBorder="calculated",this.clusterBkg="calculated",this.clusterBorder="calculated",this.defaultLinkColor="calculated",this.titleColor="#333",this.edgeLabelBackground="#e8e8e8",this.actorBorder="calculated",this.actorBkg="calculated",this.actorTextColor="black",this.actorLineColor="calculated",this.signalColor="#333",this.signalTextColor="#333",this.labelBoxBkgColor="calculated",this.labelBoxBorderColor="#326932",this.labelTextColor="calculated",this.loopTextColor="calculated",this.noteBorderColor="calculated",this.noteBkgColor="#fff5ad",this.noteTextColor="calculated",this.activationBorderColor="#666",this.activationBkgColor="#f4f4f4",this.sequenceNumberColor="white",this.sectionBkgColor="#6eaa49",this.altSectionBkgColor="white",this.sectionBkgColor2="#6eaa49",this.excludeBkgColor="#eeeeee",this.taskBorderColor="calculated",this.taskBkgColor="#487e3a",this.taskTextLightColor="white",this.taskTextColor="calculated",this.taskTextDarkColor="black",this.taskTextOutsideColor="calculated",this.taskTextClickableColor="#003163",this.activeTaskBorderColor="calculated",this.activeTaskBkgColor="calculated",this.gridColor="lightgrey",this.doneTaskBkgColor="lightgrey",this.doneTaskBorderColor="grey",this.critBorderColor="#ff8888",this.critBkgColor="red",this.todayLineColor="red",this.vertLineColor="#00BFFF",this.personBorder=this.primaryBorderColor,this.personBkg=this.mainBkg,this.archEdgeColor="calculated",this.archEdgeArrowColor="calculated",this.archEdgeWidth="3",this.archGroupBorderColor=this.primaryBorderColor,this.archGroupBorderWidth="2px",this.labelColor="black",this.errorBkgColor="#552222",this.errorTextColor="#552222"}updateColors(){this.actorBorder=Hu(this.mainBkg,20),this.actorBkg=this.mainBkg,this.labelBoxBkgColor=this.actorBkg,this.labelTextColor=this.actorTextColor,this.loopTextColor=this.actorTextColor,this.noteBorderColor=this.border2,this.noteTextColor=this.actorTextColor,this.actorLineColor=this.actorBorder,this.cScale0=this.cScale0||this.primaryColor,this.cScale1=this.cScale1||this.secondaryColor,this.cScale2=this.cScale2||this.tertiaryColor,this.cScale3=this.cScale3||Yu(this.primaryColor,{h:30}),this.cScale4=this.cScale4||Yu(this.primaryColor,{h:60}),this.cScale5=this.cScale5||Yu(this.primaryColor,{h:90}),this.cScale6=this.cScale6||Yu(this.primaryColor,{h:120}),this.cScale7=this.cScale7||Yu(this.primaryColor,{h:150}),this.cScale8=this.cScale8||Yu(this.primaryColor,{h:210}),this.cScale9=this.cScale9||Yu(this.primaryColor,{h:270}),this.cScale10=this.cScale10||Yu(this.primaryColor,{h:300}),this.cScale11=this.cScale11||Yu(this.primaryColor,{h:330}),this.cScalePeer1=this.cScalePeer1||Hu(this.secondaryColor,45),this.cScalePeer2=this.cScalePeer2||Hu(this.tertiaryColor,40);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScale"+t]=Hu(this["cScale"+t],10),this["cScalePeer"+t]=this["cScalePeer"+t]||Hu(this["cScale"+t],25);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleInv"+t]=this["cScaleInv"+t]||Yu(this["cScale"+t],{h:180});this.scaleLabelColor="calculated"!==this.scaleLabelColor&&this.scaleLabelColor?this.scaleLabelColor:this.labelTextColor;for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleLabel"+t]=this["cScaleLabel"+t]||this.scaleLabelColor;for(let t=0;t<5;t++)this["surface"+t]=this["surface"+t]||Yu(this.mainBkg,{h:30,s:-30,l:-(5+5*t)}),this["surfacePeer"+t]=this["surfacePeer"+t]||Yu(this.mainBkg,{h:30,s:-30,l:-(8+5*t)});this.nodeBkg=this.mainBkg,this.nodeBorder=this.border1,this.clusterBkg=this.secondBkg,this.clusterBorder=this.border2,this.defaultLinkColor=this.lineColor,this.taskBorderColor=this.border1,this.taskTextColor=this.taskTextLightColor,this.taskTextOutsideColor=this.taskTextDarkColor,this.activeTaskBorderColor=this.taskBorderColor,this.activeTaskBkgColor=this.mainBkg,this.archEdgeColor=this.lineColor,this.archEdgeArrowColor=this.lineColor,this.rowOdd=this.rowOdd||ju(this.mainBkg,75)||"#ffffff",this.rowEven=this.rowEven||ju(this.mainBkg,20),this.transitionColor=this.transitionColor||this.lineColor,this.transitionLabelColor=this.transitionLabelColor||this.textColor,this.stateLabelColor=this.stateLabelColor||this.stateBkg||this.primaryTextColor,this.stateBkg=this.stateBkg||this.mainBkg,this.labelBackgroundColor=this.labelBackgroundColor||this.stateBkg,this.compositeBackground=this.compositeBackground||this.background||this.tertiaryColor,this.altBackground=this.altBackground||"#f0f0f0",this.compositeTitleBackground=this.compositeTitleBackground||this.mainBkg,this.compositeBorder=this.compositeBorder||this.nodeBorder,this.innerEndBackground=this.primaryBorderColor,this.specialStateColor=this.lineColor,this.errorBkgColor=this.errorBkgColor||this.tertiaryColor,this.errorTextColor=this.errorTextColor||this.tertiaryTextColor,this.transitionColor=this.transitionColor||this.lineColor,this.classText=this.primaryTextColor,this.fillType0=this.primaryColor,this.fillType1=this.secondaryColor,this.fillType2=Yu(this.primaryColor,{h:64}),this.fillType3=Yu(this.secondaryColor,{h:64}),this.fillType4=Yu(this.primaryColor,{h:-64}),this.fillType5=Yu(this.secondaryColor,{h:-64}),this.fillType6=Yu(this.primaryColor,{h:128}),this.fillType7=Yu(this.secondaryColor,{h:128}),this.pie1=this.pie1||this.primaryColor,this.pie2=this.pie2||this.secondaryColor,this.pie3=this.pie3||this.tertiaryColor,this.pie4=this.pie4||Yu(this.primaryColor,{l:-30}),this.pie5=this.pie5||Yu(this.secondaryColor,{l:-30}),this.pie6=this.pie6||Yu(this.tertiaryColor,{h:40,l:-40}),this.pie7=this.pie7||Yu(this.primaryColor,{h:60,l:-10}),this.pie8=this.pie8||Yu(this.primaryColor,{h:-60,l:-10}),this.pie9=this.pie9||Yu(this.primaryColor,{h:120,l:0}),this.pie10=this.pie10||Yu(this.primaryColor,{h:60,l:-50}),this.pie11=this.pie11||Yu(this.primaryColor,{h:-60,l:-50}),this.pie12=this.pie12||Yu(this.primaryColor,{h:120,l:-50}),this.pieTitleTextSize=this.pieTitleTextSize||"25px",this.pieTitleTextColor=this.pieTitleTextColor||this.taskTextDarkColor,this.pieSectionTextSize=this.pieSectionTextSize||"17px",this.pieSectionTextColor=this.pieSectionTextColor||this.textColor,this.pieLegendTextSize=this.pieLegendTextSize||"17px",this.pieLegendTextColor=this.pieLegendTextColor||this.taskTextDarkColor,this.pieStrokeColor=this.pieStrokeColor||"black",this.pieStrokeWidth=this.pieStrokeWidth||"2px",this.pieOuterStrokeWidth=this.pieOuterStrokeWidth||"2px",this.pieOuterStrokeColor=this.pieOuterStrokeColor||"black",this.pieOpacity=this.pieOpacity||"0.7",this.quadrant1Fill=this.quadrant1Fill||this.primaryColor,this.quadrant2Fill=this.quadrant2Fill||Yu(this.primaryColor,{r:5,g:5,b:5}),this.quadrant3Fill=this.quadrant3Fill||Yu(this.primaryColor,{r:10,g:10,b:10}),this.quadrant4Fill=this.quadrant4Fill||Yu(this.primaryColor,{r:15,g:15,b:15}),this.quadrant1TextFill=this.quadrant1TextFill||this.primaryTextColor,this.quadrant2TextFill=this.quadrant2TextFill||Yu(this.primaryTextColor,{r:-5,g:-5,b:-5}),this.quadrant3TextFill=this.quadrant3TextFill||Yu(this.primaryTextColor,{r:-10,g:-10,b:-10}),this.quadrant4TextFill=this.quadrant4TextFill||Yu(this.primaryTextColor,{r:-15,g:-15,b:-15}),this.quadrantPointFill=this.quadrantPointFill||Ru(this.quadrant1Fill)?ju(this.quadrant1Fill):Hu(this.quadrant1Fill),this.quadrantPointTextFill=this.quadrantPointTextFill||this.primaryTextColor,this.quadrantXAxisTextFill=this.quadrantXAxisTextFill||this.primaryTextColor,this.quadrantYAxisTextFill=this.quadrantYAxisTextFill||this.primaryTextColor,this.quadrantInternalBorderStrokeFill=this.quadrantInternalBorderStrokeFill||this.primaryBorderColor,this.quadrantExternalBorderStrokeFill=this.quadrantExternalBorderStrokeFill||this.primaryBorderColor,this.quadrantTitleFill=this.quadrantTitleFill||this.primaryTextColor,this.packet={startByteColor:this.primaryTextColor,endByteColor:this.primaryTextColor,labelColor:this.primaryTextColor,titleColor:this.primaryTextColor,blockStrokeColor:this.primaryTextColor,blockFillColor:this.mainBkg},this.radar={axisColor:this.radar?.axisColor||this.lineColor,axisStrokeWidth:this.radar?.axisStrokeWidth||2,axisLabelFontSize:this.radar?.axisLabelFontSize||12,curveOpacity:this.radar?.curveOpacity||.5,curveStrokeWidth:this.radar?.curveStrokeWidth||2,graticuleColor:this.radar?.graticuleColor||"#DEDEDE",graticuleStrokeWidth:this.radar?.graticuleStrokeWidth||1,graticuleOpacity:this.radar?.graticuleOpacity||.3,legendBoxSize:this.radar?.legendBoxSize||12,legendFontSize:this.radar?.legendFontSize||12},this.xyChart={backgroundColor:this.xyChart?.backgroundColor||this.background,titleColor:this.xyChart?.titleColor||this.primaryTextColor,xAxisTitleColor:this.xyChart?.xAxisTitleColor||this.primaryTextColor,xAxisLabelColor:this.xyChart?.xAxisLabelColor||this.primaryTextColor,xAxisTickColor:this.xyChart?.xAxisTickColor||this.primaryTextColor,xAxisLineColor:this.xyChart?.xAxisLineColor||this.primaryTextColor,yAxisTitleColor:this.xyChart?.yAxisTitleColor||this.primaryTextColor,yAxisLabelColor:this.xyChart?.yAxisLabelColor||this.primaryTextColor,yAxisTickColor:this.xyChart?.yAxisTickColor||this.primaryTextColor,yAxisLineColor:this.xyChart?.yAxisLineColor||this.primaryTextColor,plotColorPalette:this.xyChart?.plotColorPalette||"#CDE498,#FF6B6B,#A0D2DB,#D7BDE2,#F0F0F0,#FFC3A0,#7FD8BE,#FF9A8B,#FAF3E0,#FFF176"},this.requirementBackground=this.requirementBackground||this.primaryColor,this.requirementBorderColor=this.requirementBorderColor||this.primaryBorderColor,this.requirementBorderSize=this.requirementBorderSize||"1",this.requirementTextColor=this.requirementTextColor||this.primaryTextColor,this.relationColor=this.relationColor||this.lineColor,this.relationLabelBackground=this.relationLabelBackground||this.edgeLabelBackground,this.relationLabelColor=this.relationLabelColor||this.actorTextColor,this.git0=this.git0||this.primaryColor,this.git1=this.git1||this.secondaryColor,this.git2=this.git2||this.tertiaryColor,this.git3=this.git3||Yu(this.primaryColor,{h:-30}),this.git4=this.git4||Yu(this.primaryColor,{h:-60}),this.git5=this.git5||Yu(this.primaryColor,{h:-90}),this.git6=this.git6||Yu(this.primaryColor,{h:60}),this.git7=this.git7||Yu(this.primaryColor,{h:120}),this.darkMode?(this.git0=ju(this.git0,25),this.git1=ju(this.git1,25),this.git2=ju(this.git2,25),this.git3=ju(this.git3,25),this.git4=ju(this.git4,25),this.git5=ju(this.git5,25),this.git6=ju(this.git6,25),this.git7=ju(this.git7,25)):(this.git0=Hu(this.git0,25),this.git1=Hu(this.git1,25),this.git2=Hu(this.git2,25),this.git3=Hu(this.git3,25),this.git4=Hu(this.git4,25),this.git5=Hu(this.git5,25),this.git6=Hu(this.git6,25),this.git7=Hu(this.git7,25)),this.gitInv0=this.gitInv0||Zu(this.git0),this.gitInv1=this.gitInv1||Zu(this.git1),this.gitInv2=this.gitInv2||Zu(this.git2),this.gitInv3=this.gitInv3||Zu(this.git3),this.gitInv4=this.gitInv4||Zu(this.git4),this.gitInv5=this.gitInv5||Zu(this.git5),this.gitInv6=this.gitInv6||Zu(this.git6),this.gitInv7=this.gitInv7||Zu(this.git7),this.gitBranchLabel0=this.gitBranchLabel0||Zu(this.labelTextColor),this.gitBranchLabel1=this.gitBranchLabel1||this.labelTextColor,this.gitBranchLabel2=this.gitBranchLabel2||this.labelTextColor,this.gitBranchLabel3=this.gitBranchLabel3||Zu(this.labelTextColor),this.gitBranchLabel4=this.gitBranchLabel4||this.labelTextColor,this.gitBranchLabel5=this.gitBranchLabel5||this.labelTextColor,this.gitBranchLabel6=this.gitBranchLabel6||this.labelTextColor,this.gitBranchLabel7=this.gitBranchLabel7||this.labelTextColor,this.tagLabelColor=this.tagLabelColor||this.primaryTextColor,this.tagLabelBackground=this.tagLabelBackground||this.primaryColor,this.tagLabelBorder=this.tagBorder||this.primaryBorderColor,this.tagLabelFontSize=this.tagLabelFontSize||"10px",this.commitLabelColor=this.commitLabelColor||this.secondaryTextColor,this.commitLabelBackground=this.commitLabelBackground||this.secondaryColor,this.commitLabelFontSize=this.commitLabelFontSize||"10px",this.attributeBackgroundColorOdd=this.attributeBackgroundColorOdd||Qu,this.attributeBackgroundColorEven=this.attributeBackgroundColorEven||Ku}calculate(t){if("object"!=typeof t)return void this.updateColors();let e=Object.keys(t);e.forEach(e=>{this[e]=t[e]}),this.updateColors(),e.forEach(e=>{this[e]=t[e]})}},sd=s(t=>{let e=new od;return e.calculate(t),e},"getThemeVariables"),ld=class{static{s(this,"Theme")}constructor(){this.primaryColor="#eee",this.contrast="#707070",this.secondaryColor=ju(this.contrast,55),this.background="#ffffff",this.tertiaryColor=Yu(this.primaryColor,{h:-160}),this.primaryBorderColor=Ju(this.primaryColor,this.darkMode),this.secondaryBorderColor=Ju(this.secondaryColor,this.darkMode),this.tertiaryBorderColor=Ju(this.tertiaryColor,this.darkMode),this.primaryTextColor=Zu(this.primaryColor),this.secondaryTextColor=Zu(this.secondaryColor),this.tertiaryTextColor=Zu(this.tertiaryColor),this.lineColor=Zu(this.background),this.textColor=Zu(this.background),this.mainBkg="#eee",this.secondBkg="calculated",this.lineColor="#666",this.border1="#999",this.border2="calculated",this.note="#ffa",this.text="#333",this.critical="#d42",this.done="#bbb",this.arrowheadColor="#333333",this.fontFamily='"trebuchet ms", verdana, arial, sans-serif',this.fontSize="16px",this.THEME_COLOR_LIMIT=12,this.nodeBkg="calculated",this.nodeBorder="calculated",this.clusterBkg="calculated",this.clusterBorder="calculated",this.defaultLinkColor="calculated",this.titleColor="calculated",this.edgeLabelBackground="white",this.actorBorder="calculated",this.actorBkg="calculated",this.actorTextColor="calculated",this.actorLineColor=this.actorBorder,this.signalColor="calculated",this.signalTextColor="calculated",this.labelBoxBkgColor="calculated",this.labelBoxBorderColor="calculated",this.labelTextColor="calculated",this.loopTextColor="calculated",this.noteBorderColor="calculated",this.noteBkgColor="calculated",this.noteTextColor="calculated",this.activationBorderColor="#666",this.activationBkgColor="#f4f4f4",this.sequenceNumberColor="white",this.sectionBkgColor="calculated",this.altSectionBkgColor="white",this.sectionBkgColor2="calculated",this.excludeBkgColor="#eeeeee",this.taskBorderColor="calculated",this.taskBkgColor="calculated",this.taskTextLightColor="white",this.taskTextColor="calculated",this.taskTextDarkColor="calculated",this.taskTextOutsideColor="calculated",this.taskTextClickableColor="#003163",this.activeTaskBorderColor="calculated",this.activeTaskBkgColor="calculated",this.gridColor="calculated",this.doneTaskBkgColor="calculated",this.doneTaskBorderColor="calculated",this.critBkgColor="calculated",this.critBorderColor="calculated",this.todayLineColor="calculated",this.vertLineColor="calculated",this.personBorder=this.primaryBorderColor,this.personBkg=this.mainBkg,this.archEdgeColor="calculated",this.archEdgeArrowColor="calculated",this.archEdgeWidth="3",this.archGroupBorderColor=this.primaryBorderColor,this.archGroupBorderWidth="2px",this.rowOdd=this.rowOdd||ju(this.mainBkg,75)||"#ffffff",this.rowEven=this.rowEven||"#f4f4f4",this.labelColor="black",this.errorBkgColor="#552222",this.errorTextColor="#552222"}updateColors(){this.secondBkg=ju(this.contrast,55),this.border2=this.contrast,this.actorBorder=ju(this.border1,23),this.actorBkg=this.mainBkg,this.actorTextColor=this.text,this.actorLineColor=this.actorBorder,this.signalColor=this.text,this.signalTextColor=this.text,this.labelBoxBkgColor=this.actorBkg,this.labelBoxBorderColor=this.actorBorder,this.labelTextColor=this.text,this.loopTextColor=this.text,this.noteBorderColor="#999",this.noteBkgColor="#666",this.noteTextColor="#fff",this.cScale0=this.cScale0||"#555",this.cScale1=this.cScale1||"#F4F4F4",this.cScale2=this.cScale2||"#555",this.cScale3=this.cScale3||"#BBB",this.cScale4=this.cScale4||"#777",this.cScale5=this.cScale5||"#999",this.cScale6=this.cScale6||"#DDD",this.cScale7=this.cScale7||"#FFF",this.cScale8=this.cScale8||"#DDD",this.cScale9=this.cScale9||"#BBB",this.cScale10=this.cScale10||"#999",this.cScale11=this.cScale11||"#777";for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleInv"+t]=this["cScaleInv"+t]||Zu(this["cScale"+t]);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this.darkMode?this["cScalePeer"+t]=this["cScalePeer"+t]||ju(this["cScale"+t],10):this["cScalePeer"+t]=this["cScalePeer"+t]||Hu(this["cScale"+t],10);this.scaleLabelColor=this.scaleLabelColor||(this.darkMode?"black":this.labelTextColor),this.cScaleLabel0=this.cScaleLabel0||this.cScale1,this.cScaleLabel2=this.cScaleLabel2||this.cScale1;for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleLabel"+t]=this["cScaleLabel"+t]||this.scaleLabelColor;for(let t=0;t<5;t++)this["surface"+t]=this["surface"+t]||Yu(this.mainBkg,{l:-(5+5*t)}),this["surfacePeer"+t]=this["surfacePeer"+t]||Yu(this.mainBkg,{l:-(8+5*t)});this.nodeBkg=this.mainBkg,this.nodeBorder=this.border1,this.clusterBkg=this.secondBkg,this.clusterBorder=this.border2,this.defaultLinkColor=this.lineColor,this.titleColor=this.text,this.sectionBkgColor=ju(this.contrast,30),this.sectionBkgColor2=ju(this.contrast,30),this.taskBorderColor=Hu(this.contrast,10),this.taskBkgColor=this.contrast,this.taskTextColor=this.taskTextLightColor,this.taskTextDarkColor=this.text,this.taskTextOutsideColor=this.taskTextDarkColor,this.activeTaskBorderColor=this.taskBorderColor,this.activeTaskBkgColor=this.mainBkg,this.gridColor=ju(this.border1,30),this.doneTaskBkgColor=this.done,this.doneTaskBorderColor=this.lineColor,this.critBkgColor=this.critical,this.critBorderColor=Hu(this.critBkgColor,10),this.todayLineColor=this.critBkgColor,this.vertLineColor=this.critBkgColor,this.archEdgeColor=this.lineColor,this.archEdgeArrowColor=this.lineColor,this.transitionColor=this.transitionColor||"#000",this.transitionLabelColor=this.transitionLabelColor||this.textColor,this.stateLabelColor=this.stateLabelColor||this.stateBkg||this.primaryTextColor,this.stateBkg=this.stateBkg||this.mainBkg,this.labelBackgroundColor=this.labelBackgroundColor||this.stateBkg,this.compositeBackground=this.compositeBackground||this.background||this.tertiaryColor,this.altBackground=this.altBackground||"#f4f4f4",this.compositeTitleBackground=this.compositeTitleBackground||this.mainBkg,this.stateBorder=this.stateBorder||"#000",this.innerEndBackground=this.primaryBorderColor,this.specialStateColor="#222",this.errorBkgColor=this.errorBkgColor||this.tertiaryColor,this.errorTextColor=this.errorTextColor||this.tertiaryTextColor,this.classText=this.primaryTextColor,this.fillType0=this.primaryColor,this.fillType1=this.secondaryColor,this.fillType2=Yu(this.primaryColor,{h:64}),this.fillType3=Yu(this.secondaryColor,{h:64}),this.fillType4=Yu(this.primaryColor,{h:-64}),this.fillType5=Yu(this.secondaryColor,{h:-64}),this.fillType6=Yu(this.primaryColor,{h:128}),this.fillType7=Yu(this.secondaryColor,{h:128});for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["pie"+t]=this["cScale"+t];this.pie12=this.pie0,this.pieTitleTextSize=this.pieTitleTextSize||"25px",this.pieTitleTextColor=this.pieTitleTextColor||this.taskTextDarkColor,this.pieSectionTextSize=this.pieSectionTextSize||"17px",this.pieSectionTextColor=this.pieSectionTextColor||this.textColor,this.pieLegendTextSize=this.pieLegendTextSize||"17px",this.pieLegendTextColor=this.pieLegendTextColor||this.taskTextDarkColor,this.pieStrokeColor=this.pieStrokeColor||"black",this.pieStrokeWidth=this.pieStrokeWidth||"2px",this.pieOuterStrokeWidth=this.pieOuterStrokeWidth||"2px",this.pieOuterStrokeColor=this.pieOuterStrokeColor||"black",this.pieOpacity=this.pieOpacity||"0.7",this.quadrant1Fill=this.quadrant1Fill||this.primaryColor,this.quadrant2Fill=this.quadrant2Fill||Yu(this.primaryColor,{r:5,g:5,b:5}),this.quadrant3Fill=this.quadrant3Fill||Yu(this.primaryColor,{r:10,g:10,b:10}),this.quadrant4Fill=this.quadrant4Fill||Yu(this.primaryColor,{r:15,g:15,b:15}),this.quadrant1TextFill=this.quadrant1TextFill||this.primaryTextColor,this.quadrant2TextFill=this.quadrant2TextFill||Yu(this.primaryTextColor,{r:-5,g:-5,b:-5}),this.quadrant3TextFill=this.quadrant3TextFill||Yu(this.primaryTextColor,{r:-10,g:-10,b:-10}),this.quadrant4TextFill=this.quadrant4TextFill||Yu(this.primaryTextColor,{r:-15,g:-15,b:-15}),this.quadrantPointFill=this.quadrantPointFill||Ru(this.quadrant1Fill)?ju(this.quadrant1Fill):Hu(this.quadrant1Fill),this.quadrantPointTextFill=this.quadrantPointTextFill||this.primaryTextColor,this.quadrantXAxisTextFill=this.quadrantXAxisTextFill||this.primaryTextColor,this.quadrantYAxisTextFill=this.quadrantYAxisTextFill||this.primaryTextColor,this.quadrantInternalBorderStrokeFill=this.quadrantInternalBorderStrokeFill||this.primaryBorderColor,this.quadrantExternalBorderStrokeFill=this.quadrantExternalBorderStrokeFill||this.primaryBorderColor,this.quadrantTitleFill=this.quadrantTitleFill||this.primaryTextColor,this.xyChart={backgroundColor:this.xyChart?.backgroundColor||this.background,titleColor:this.xyChart?.titleColor||this.primaryTextColor,xAxisTitleColor:this.xyChart?.xAxisTitleColor||this.primaryTextColor,xAxisLabelColor:this.xyChart?.xAxisLabelColor||this.primaryTextColor,xAxisTickColor:this.xyChart?.xAxisTickColor||this.primaryTextColor,xAxisLineColor:this.xyChart?.xAxisLineColor||this.primaryTextColor,yAxisTitleColor:this.xyChart?.yAxisTitleColor||this.primaryTextColor,yAxisLabelColor:this.xyChart?.yAxisLabelColor||this.primaryTextColor,yAxisTickColor:this.xyChart?.yAxisTickColor||this.primaryTextColor,yAxisLineColor:this.xyChart?.yAxisLineColor||this.primaryTextColor,plotColorPalette:this.xyChart?.plotColorPalette||"#EEE,#6BB8E4,#8ACB88,#C7ACD6,#E8DCC2,#FFB2A8,#FFF380,#7E8D91,#FFD8B1,#FAF3E0"},this.radar={axisColor:this.radar?.axisColor||this.lineColor,axisStrokeWidth:this.radar?.axisStrokeWidth||2,axisLabelFontSize:this.radar?.axisLabelFontSize||12,curveOpacity:this.radar?.curveOpacity||.5,curveStrokeWidth:this.radar?.curveStrokeWidth||2,graticuleColor:this.radar?.graticuleColor||"#DEDEDE",graticuleStrokeWidth:this.radar?.graticuleStrokeWidth||1,graticuleOpacity:this.radar?.graticuleOpacity||.3,legendBoxSize:this.radar?.legendBoxSize||12,legendFontSize:this.radar?.legendFontSize||12},this.requirementBackground=this.requirementBackground||this.primaryColor,this.requirementBorderColor=this.requirementBorderColor||this.primaryBorderColor,this.requirementBorderSize=this.requirementBorderSize||"1",this.requirementTextColor=this.requirementTextColor||this.primaryTextColor,this.relationColor=this.relationColor||this.lineColor,this.relationLabelBackground=this.relationLabelBackground||this.edgeLabelBackground,this.relationLabelColor=this.relationLabelColor||this.actorTextColor,this.git0=Hu(this.pie1,25)||this.primaryColor,this.git1=this.pie2||this.secondaryColor,this.git2=this.pie3||this.tertiaryColor,this.git3=this.pie4||Yu(this.primaryColor,{h:-30}),this.git4=this.pie5||Yu(this.primaryColor,{h:-60}),this.git5=this.pie6||Yu(this.primaryColor,{h:-90}),this.git6=this.pie7||Yu(this.primaryColor,{h:60}),this.git7=this.pie8||Yu(this.primaryColor,{h:120}),this.gitInv0=this.gitInv0||Zu(this.git0),this.gitInv1=this.gitInv1||Zu(this.git1),this.gitInv2=this.gitInv2||Zu(this.git2),this.gitInv3=this.gitInv3||Zu(this.git3),this.gitInv4=this.gitInv4||Zu(this.git4),this.gitInv5=this.gitInv5||Zu(this.git5),this.gitInv6=this.gitInv6||Zu(this.git6),this.gitInv7=this.gitInv7||Zu(this.git7),this.branchLabelColor=this.branchLabelColor||this.labelTextColor,this.gitBranchLabel0=this.branchLabelColor,this.gitBranchLabel1="white",this.gitBranchLabel2=this.branchLabelColor,this.gitBranchLabel3="white",this.gitBranchLabel4=this.branchLabelColor,this.gitBranchLabel5=this.branchLabelColor,this.gitBranchLabel6=this.branchLabelColor,this.gitBranchLabel7=this.branchLabelColor,this.tagLabelColor=this.tagLabelColor||this.primaryTextColor,this.tagLabelBackground=this.tagLabelBackground||this.primaryColor,this.tagLabelBorder=this.tagBorder||this.primaryBorderColor,this.tagLabelFontSize=this.tagLabelFontSize||"10px",this.commitLabelColor=this.commitLabelColor||this.secondaryTextColor,this.commitLabelBackground=this.commitLabelBackground||this.secondaryColor,this.commitLabelFontSize=this.commitLabelFontSize||"10px",this.attributeBackgroundColorOdd=this.attributeBackgroundColorOdd||Qu,this.attributeBackgroundColorEven=this.attributeBackgroundColorEven||Ku}calculate(t){if("object"!=typeof t)return void this.updateColors();let e=Object.keys(t);e.forEach(e=>{this[e]=t[e]}),this.updateColors(),e.forEach(e=>{this[e]=t[e]})}},hd=s(t=>{let e=new ld;return e.calculate(t),e},"getThemeVariables"),cd={base:{getThemeVariables:ed},dark:{getThemeVariables:id},default:{getThemeVariables:ad},forest:{getThemeVariables:sd},neutral:{getThemeVariables:hd}},ud={flowchart:{useMaxWidth:!0,titleTopMargin:25,subGraphTitleMargin:{top:0,bottom:0},diagramPadding:8,htmlLabels:!0,nodeSpacing:50,rankSpacing:50,curve:"basis",padding:15,defaultRenderer:"dagre-wrapper",wrappingWidth:200,inheritDir:!1},sequence:{useMaxWidth:!0,hideUnusedParticipants:!1,activationWidth:10,diagramMarginX:50,diagramMarginY:10,actorMargin:50,width:150,height:65,boxMargin:10,boxTextMargin:5,noteMargin:10,messageMargin:35,messageAlign:"center",mirrorActors:!0,forceMenus:!1,bottomMarginAdj:1,rightAngles:!1,showSequenceNumbers:!1,actorFontSize:14,actorFontFamily:'"Open Sans", sans-serif',actorFontWeight:400,noteFontSize:14,noteFontFamily:'"trebuchet ms", verdana, arial, sans-serif',noteFontWeight:400,noteAlign:"center",messageFontSize:16,messageFontFamily:'"trebuchet ms", verdana, arial, sans-serif',messageFontWeight:400,wrap:!1,wrapPadding:10,labelBoxWidth:50,labelBoxHeight:20},gantt:{useMaxWidth:!0,titleTopMargin:25,barHeight:20,barGap:4,topPadding:50,rightPadding:75,leftPadding:75,gridLineStartPadding:35,fontSize:11,sectionFontSize:11,numberSectionStyles:4,axisFormat:"%Y-%m-%d",topAxis:!1,displayMode:"",weekday:"sunday"},journey:{useMaxWidth:!0,diagramMarginX:50,diagramMarginY:10,leftMargin:150,maxLabelWidth:360,width:150,height:50,boxMargin:10,boxTextMargin:5,noteMargin:10,messageMargin:35,messageAlign:"center",bottomMarginAdj:1,rightAngles:!1,taskFontSize:14,taskFontFamily:'"Open Sans", sans-serif',taskMargin:50,activationWidth:10,textPlacement:"fo",actorColours:["#8FBC8F","#7CFC00","#00FFFF","#20B2AA","#B0E0E6","#FFFFE0"],sectionFills:["#191970","#8B008B","#4B0082","#2F4F4F","#800000","#8B4513","#00008B"],sectionColours:["#fff"],titleColor:"",titleFontFamily:'"trebuchet ms", verdana, arial, sans-serif',titleFontSize:"4ex"},class:{useMaxWidth:!0,titleTopMargin:25,arrowMarkerAbsolute:!1,dividerMargin:10,padding:5,textHeight:10,defaultRenderer:"dagre-wrapper",htmlLabels:!1,hideEmptyMembersBox:!1},state:{useMaxWidth:!0,titleTopMargin:25,dividerMargin:10,sizeUnit:5,padding:8,textHeight:10,titleShift:-15,noteMargin:10,forkWidth:70,forkHeight:7,miniPadding:2,fontSizeFactor:5.02,fontSize:24,labelHeight:16,edgeLengthFactor:"20",compositTitleSize:35,radius:5,defaultRenderer:"dagre-wrapper"},er:{useMaxWidth:!0,titleTopMargin:25,diagramPadding:20,layoutDirection:"TB",minEntityWidth:100,minEntityHeight:75,entityPadding:15,nodeSpacing:140,rankSpacing:80,stroke:"gray",fill:"honeydew",fontSize:12},pie:{useMaxWidth:!0,textPosition:.75},quadrantChart:{useMaxWidth:!0,chartWidth:500,chartHeight:500,titleFontSize:20,titlePadding:10,quadrantPadding:5,xAxisLabelPadding:5,yAxisLabelPadding:5,xAxisLabelFontSize:16,yAxisLabelFontSize:16,quadrantLabelFontSize:16,quadrantTextTopPadding:5,pointTextPadding:5,pointLabelFontSize:12,pointRadius:5,xAxisPosition:"top",yAxisPosition:"left",quadrantInternalBorderStrokeWidth:1,quadrantExternalBorderStrokeWidth:2},xyChart:{useMaxWidth:!0,width:700,height:500,titleFontSize:20,titlePadding:10,showDataLabel:!1,showTitle:!0,xAxis:{$ref:"#/$defs/XYChartAxisConfig",showLabel:!0,labelFontSize:14,labelPadding:5,showTitle:!0,titleFontSize:16,titlePadding:5,showTick:!0,tickLength:5,tickWidth:2,showAxisLine:!0,axisLineWidth:2},yAxis:{$ref:"#/$defs/XYChartAxisConfig",showLabel:!0,labelFontSize:14,labelPadding:5,showTitle:!0,titleFontSize:16,titlePadding:5,showTick:!0,tickLength:5,tickWidth:2,showAxisLine:!0,axisLineWidth:2},chartOrientation:"vertical",plotReservedSpacePercent:50},requirement:{useMaxWidth:!0,rect_fill:"#f9f9f9",text_color:"#333",rect_border_size:"0.5px",rect_border_color:"#bbb",rect_min_width:200,rect_min_height:200,fontSize:14,rect_padding:10,line_height:20},mindmap:{useMaxWidth:!0,padding:10,maxNodeWidth:200,layoutAlgorithm:"cose-bilkent"},kanban:{useMaxWidth:!0,padding:8,sectionWidth:200,ticketBaseUrl:""},timeline:{useMaxWidth:!0,diagramMarginX:50,diagramMarginY:10,leftMargin:150,width:150,height:50,boxMargin:10,boxTextMargin:5,noteMargin:10,messageMargin:35,messageAlign:"center",bottomMarginAdj:1,rightAngles:!1,taskFontSize:14,taskFontFamily:'"Open Sans", sans-serif',taskMargin:50,activationWidth:10,textPlacement:"fo",actorColours:["#8FBC8F","#7CFC00","#00FFFF","#20B2AA","#B0E0E6","#FFFFE0"],sectionFills:["#191970","#8B008B","#4B0082","#2F4F4F","#800000","#8B4513","#00008B"],sectionColours:["#fff"],disableMulticolor:!1},gitGraph:{useMaxWidth:!0,titleTopMargin:25,diagramPadding:8,nodeLabel:{width:75,height:100,x:-25,y:0},mainBranchName:"main",mainBranchOrder:0,showCommitLabel:!0,showBranches:!0,rotateCommitLabel:!0,parallelCommits:!1,arrowMarkerAbsolute:!1},c4:{useMaxWidth:!0,diagramMarginX:50,diagramMarginY:10,c4ShapeMargin:50,c4ShapePadding:20,width:216,height:60,boxMargin:10,c4ShapeInRow:4,nextLinePaddingX:0,c4BoundaryInRow:2,personFontSize:14,personFontFamily:'"Open Sans", sans-serif',personFontWeight:"normal",external_personFontSize:14,external_personFontFamily:'"Open Sans", sans-serif',external_personFontWeight:"normal",systemFontSize:14,systemFontFamily:'"Open Sans", sans-serif',systemFontWeight:"normal",external_systemFontSize:14,external_systemFontFamily:'"Open Sans", sans-serif',external_systemFontWeight:"normal",system_dbFontSize:14,system_dbFontFamily:'"Open Sans", sans-serif',system_dbFontWeight:"normal",external_system_dbFontSize:14,external_system_dbFontFamily:'"Open Sans", sans-serif',external_system_dbFontWeight:"normal",system_queueFontSize:14,system_queueFontFamily:'"Open Sans", sans-serif',system_queueFontWeight:"normal",external_system_queueFontSize:14,external_system_queueFontFamily:'"Open Sans", sans-serif',external_system_queueFontWeight:"normal",boundaryFontSize:14,boundaryFontFamily:'"Open Sans", sans-serif',boundaryFontWeight:"normal",messageFontSize:12,messageFontFamily:'"Open Sans", sans-serif',messageFontWeight:"normal",containerFontSize:14,containerFontFamily:'"Open Sans", sans-serif',containerFontWeight:"normal",external_containerFontSize:14,external_containerFontFamily:'"Open Sans", sans-serif',external_containerFontWeight:"normal",container_dbFontSize:14,container_dbFontFamily:'"Open Sans", sans-serif',container_dbFontWeight:"normal",external_container_dbFontSize:14,external_container_dbFontFamily:'"Open Sans", sans-serif',external_container_dbFontWeight:"normal",container_queueFontSize:14,container_queueFontFamily:'"Open Sans", sans-serif',container_queueFontWeight:"normal",external_container_queueFontSize:14,external_container_queueFontFamily:'"Open Sans", sans-serif',external_container_queueFontWeight:"normal",componentFontSize:14,componentFontFamily:'"Open Sans", sans-serif',componentFontWeight:"normal",external_componentFontSize:14,external_componentFontFamily:'"Open Sans", sans-serif',external_componentFontWeight:"normal",component_dbFontSize:14,component_dbFontFamily:'"Open Sans", sans-serif',component_dbFontWeight:"normal",external_component_dbFontSize:14,external_component_dbFontFamily:'"Open Sans", sans-serif',external_component_dbFontWeight:"normal",component_queueFontSize:14,component_queueFontFamily:'"Open Sans", sans-serif',component_queueFontWeight:"normal",external_component_queueFontSize:14,external_component_queueFontFamily:'"Open Sans", sans-serif',external_component_queueFontWeight:"normal",wrap:!0,wrapPadding:10,person_bg_color:"#08427B",person_border_color:"#073B6F",external_person_bg_color:"#686868",external_person_border_color:"#8A8A8A",system_bg_color:"#1168BD",system_border_color:"#3C7FC0",system_db_bg_color:"#1168BD",system_db_border_color:"#3C7FC0",system_queue_bg_color:"#1168BD",system_queue_border_color:"#3C7FC0",external_system_bg_color:"#999999",external_system_border_color:"#8A8A8A",external_system_db_bg_color:"#999999",external_system_db_border_color:"#8A8A8A",external_system_queue_bg_color:"#999999",external_system_queue_border_color:"#8A8A8A",container_bg_color:"#438DD5",container_border_color:"#3C7FC0",container_db_bg_color:"#438DD5",container_db_border_color:"#3C7FC0",container_queue_bg_color:"#438DD5",container_queue_border_color:"#3C7FC0",external_container_bg_color:"#B3B3B3",external_container_border_color:"#A6A6A6",external_container_db_bg_color:"#B3B3B3",external_container_db_border_color:"#A6A6A6",external_container_queue_bg_color:"#B3B3B3",external_container_queue_border_color:"#A6A6A6",component_bg_color:"#85BBF0",component_border_color:"#78A8D8",component_db_bg_color:"#85BBF0",component_db_border_color:"#78A8D8",component_queue_bg_color:"#85BBF0",component_queue_border_color:"#78A8D8",external_component_bg_color:"#CCCCCC",external_component_border_color:"#BFBFBF",external_component_db_bg_color:"#CCCCCC",external_component_db_border_color:"#BFBFBF",external_component_queue_bg_color:"#CCCCCC",external_component_queue_border_color:"#BFBFBF"},sankey:{useMaxWidth:!0,width:600,height:400,linkColor:"gradient",nodeAlignment:"justify",showValues:!0,prefix:"",suffix:""},block:{useMaxWidth:!0,padding:8},packet:{useMaxWidth:!0,rowHeight:32,bitWidth:32,bitsPerRow:32,showBits:!0,paddingX:5,paddingY:5},architecture:{useMaxWidth:!0,padding:40,iconSize:80,fontSize:16},radar:{useMaxWidth:!0,width:600,height:600,marginTop:50,marginRight:50,marginBottom:50,marginLeft:50,axisScaleFactor:1,axisLabelFactor:1.05,curveTension:.17},theme:"default",look:"classic",handDrawnSeed:0,layout:"dagre",maxTextSize:5e4,maxEdges:500,darkMode:!1,fontFamily:'"trebuchet ms", verdana, arial, sans-serif;',logLevel:5,securityLevel:"strict",startOnLoad:!0,arrowMarkerAbsolute:!1,secure:["secure","securityLevel","startOnLoad","maxTextSize","suppressErrorRendering","maxEdges"],legacyMathML:!1,forceLegacyMathML:!1,deterministicIds:!1,fontSize:16,markdownAutoWrap:!0,suppressErrorRendering:!1},dd={...ud,deterministicIDSeed:void 0,elk:{mergeEdges:!1,nodePlacementStrategy:"BRANDES_KOEPF",forceNodeModelOrder:!1,considerModelOrder:"NODES_AND_EDGES"},themeCSS:void 0,themeVariables:cd.default.getThemeVariables(),sequence:{...ud.sequence,messageFont:s(function(){return{fontFamily:this.messageFontFamily,fontSize:this.messageFontSize,fontWeight:this.messageFontWeight}},"messageFont"),noteFont:s(function(){return{fontFamily:this.noteFontFamily,fontSize:this.noteFontSize,fontWeight:this.noteFontWeight}},"noteFont"),actorFont:s(function(){return{fontFamily:this.actorFontFamily,fontSize:this.actorFontSize,fontWeight:this.actorFontWeight}},"actorFont")},class:{hideEmptyMembersBox:!1},gantt:{...ud.gantt,tickInterval:void 0,useWidth:void 0},c4:{...ud.c4,useWidth:void 0,personFont:s(function(){return{fontFamily:this.personFontFamily,fontSize:this.personFontSize,fontWeight:this.personFontWeight}},"personFont"),flowchart:{...ud.flowchart,inheritDir:!1},external_personFont:s(function(){return{fontFamily:this.external_personFontFamily,fontSize:this.external_personFontSize,fontWeight:this.external_personFontWeight}},"external_personFont"),systemFont:s(function(){return{fontFamily:this.systemFontFamily,fontSize:this.systemFontSize,fontWeight:this.systemFontWeight}},"systemFont"),external_systemFont:s(function(){return{fontFamily:this.external_systemFontFamily,fontSize:this.external_systemFontSize,fontWeight:this.external_systemFontWeight}},"external_systemFont"),system_dbFont:s(function(){return{fontFamily:this.system_dbFontFamily,fontSize:this.system_dbFontSize,fontWeight:this.system_dbFontWeight}},"system_dbFont"),external_system_dbFont:s(function(){return{fontFamily:this.external_system_dbFontFamily,fontSize:this.external_system_dbFontSize,fontWeight:this.external_system_dbFontWeight}},"external_system_dbFont"),system_queueFont:s(function(){return{fontFamily:this.system_queueFontFamily,fontSize:this.system_queueFontSize,fontWeight:this.system_queueFontWeight}},"system_queueFont"),external_system_queueFont:s(function(){return{fontFamily:this.external_system_queueFontFamily,fontSize:this.external_system_queueFontSize,fontWeight:this.external_system_queueFontWeight}},"external_system_queueFont"),containerFont:s(function(){return{fontFamily:this.containerFontFamily,fontSize:this.containerFontSize,fontWeight:this.containerFontWeight}},"containerFont"),external_containerFont:s(function(){return{fontFamily:this.external_containerFontFamily,fontSize:this.external_containerFontSize,fontWeight:this.external_containerFontWeight}},"external_containerFont"),container_dbFont:s(function(){return{fontFamily:this.container_dbFontFamily,fontSize:this.container_dbFontSize,fontWeight:this.container_dbFontWeight}},"container_dbFont"),external_container_dbFont:s(function(){return{fontFamily:this.external_container_dbFontFamily,fontSize:this.external_container_dbFontSize,fontWeight:this.external_container_dbFontWeight}},"external_container_dbFont"),container_queueFont:s(function(){return{fontFamily:this.container_queueFontFamily,fontSize:this.container_queueFontSize,fontWeight:this.container_queueFontWeight}},"container_queueFont"),external_container_queueFont:s(function(){return{fontFamily:this.external_container_queueFontFamily,fontSize:this.external_container_queueFontSize,fontWeight:this.external_container_queueFontWeight}},"external_container_queueFont"),componentFont:s(function(){return{fontFamily:this.componentFontFamily,fontSize:this.componentFontSize,fontWeight:this.componentFontWeight}},"componentFont"),external_componentFont:s(function(){return{fontFamily:this.external_componentFontFamily,fontSize:this.external_componentFontSize,fontWeight:this.external_componentFontWeight}},"external_componentFont"),component_dbFont:s(function(){return{fontFamily:this.component_dbFontFamily,fontSize:this.component_dbFontSize,fontWeight:this.component_dbFontWeight}},"component_dbFont"),external_component_dbFont:s(function(){return{fontFamily:this.external_component_dbFontFamily,fontSize:this.external_component_dbFontSize,fontWeight:this.external_component_dbFontWeight}},"external_component_dbFont"),component_queueFont:s(function(){return{fontFamily:this.component_queueFontFamily,fontSize:this.component_queueFontSize,fontWeight:this.component_queueFontWeight}},"component_queueFont"),external_component_queueFont:s(function(){return{fontFamily:this.external_component_queueFontFamily,fontSize:this.external_component_queueFontSize,fontWeight:this.external_component_queueFontWeight}},"external_component_queueFont"),boundaryFont:s(function(){return{fontFamily:this.boundaryFontFamily,fontSize:this.boundaryFontSize,fontWeight:this.boundaryFontWeight}},"boundaryFont"),messageFont:s(function(){return{fontFamily:this.messageFontFamily,fontSize:this.messageFontSize,fontWeight:this.messageFontWeight}},"messageFont")},pie:{...ud.pie,useWidth:984},xyChart:{...ud.xyChart,useWidth:void 0},requirement:{...ud.requirement,useWidth:void 0},packet:{...ud.packet},radar:{...ud.radar},treemap:{useMaxWidth:!0,padding:10,diagramPadding:8,showValues:!0,nodeWidth:100,nodeHeight:40,borderWidth:1,valueFontSize:12,labelFontSize:14,valueFormat:","}},pd=s((t,e="")=>Object.keys(t).reduce((r,i)=>Array.isArray(t[i])?r:"object"==typeof t[i]&&null!==t[i]?[...r,e+i,...pd(t[i],"")]:[...r,e+i],[]),"keyify"),fd=new Set(pd(dd,"")),gd=dd,yd=s(t=>{if(y.debug("sanitizeDirective called with",t),"object"==typeof t&&null!=t){if(Array.isArray(t))return void t.forEach(t=>yd(t));for(let e of Object.keys(t)){if(y.debug("Checking key",e),e.startsWith("__")||e.includes("proto")||e.includes("constr")||!fd.has(e)||null==t[e]){y.debug("sanitize deleting key: ",e),delete t[e];continue}if("object"==typeof t[e]){y.debug("sanitizing object",e),yd(t[e]);continue}let r=["themeCSS","fontFamily","altFontFamily"];for(let i of r)e.includes(i)&&(y.debug("sanitizing css option",e),t[e]=md(t[e]))}if(t.themeVariables)for(let e of Object.keys(t.themeVariables)){let r=t.themeVariables[e];r?.match&&!r.match(/^[\d "#%(),.;A-Za-z]+$/)&&(t.themeVariables[e]="")}y.debug("After sanitization",t)}},"sanitizeDirective"),md=s(t=>{let e=0,r=0;for(let i of t){if(e<r)return"{ /* ERROR: Unbalanced CSS */ }";"{"===i?e++:"}"===i&&r++}return e!==r?"{ /* ERROR: Unbalanced CSS */ }":t},"sanitizeCss"),xd=Object.freeze(gd),bd=eu({},xd),kd=[],Cd=eu({},xd),wd=s((t,e)=>{let r=eu({},t),i={};for(let t of e)Ad(t),i=eu(i,t);if(r=eu(r,i),i.theme&&i.theme in cd){let t=eu({},hu),e=eu(t.themeVariables||{},i.themeVariables);r.theme&&r.theme in cd&&(r.themeVariables=cd[r.theme].getThemeVariables(e))}return Od(Cd=r),Cd},"updateCurrentConfig"),_d=s(t=>(bd=eu({},xd),bd=eu(bd,t),t.theme&&cd[t.theme]&&(bd.themeVariables=cd[t.theme].getThemeVariables(t.themeVariables)),wd(bd,kd),bd),"setSiteConfig"),vd=s(t=>{hu=eu({},t)},"saveConfigFromInitialize"),Sd=s(t=>(bd=eu(bd,t),wd(bd,kd),bd),"updateSiteConfig"),Td=s(()=>eu({},bd),"getSiteConfig"),Md=s(t=>(Od(t),eu(Cd,t),Bd()),"setConfig"),Bd=s(()=>eu({},Cd),"getConfig"),Ad=s(t=>{t&&(["secure",...bd.secure??[]].forEach(e=>{Object.hasOwn(t,e)&&(y.debug(`Denied attempt to modify a secure key ${e}`,t[e]),delete t[e])}),Object.keys(t).forEach(e=>{e.startsWith("__")&&delete t[e]}),Object.keys(t).forEach(e=>{"string"==typeof t[e]&&(t[e].includes("<")||t[e].includes(">")||t[e].includes("url(data:"))&&delete t[e],"object"==typeof t[e]&&Ad(t[e])}))},"sanitize"),Ld=s(t=>{yd(t),t.fontFamily&&!t.themeVariables?.fontFamily&&(t.themeVariables={...t.themeVariables,fontFamily:t.fontFamily}),kd.push(t),wd(bd,kd)},"addDirective"),Fd=s((t=bd)=>{wd(t,kd=[])},"reset"),$d={LAZY_LOAD_DEPRECATED:"The configuration options lazyLoadedDiagrams and loadExternalDiagramsAtStartup are deprecated. Please use registerExternalDiagrams instead."},Ed={},Dd=s(t=>{Ed[t]||(y.warn($d[t]),Ed[t]=!0)},"issueWarning"),Od=s(t=>{t&&(t.lazyLoadedDiagrams||t.loadExternalDiagramsAtStartup)&&Dd("LAZY_LOAD_DEPRECATED")},"checkConfig"),Id=s(()=>{let t={};hu&&(t=eu(t,hu));for(let e of kd)t=eu(t,e);return t},"getUserDefinedConfig"),{entries:Nd,setPrototypeOf:Rd,isFrozen:Pd,getPrototypeOf:zd,getOwnPropertyDescriptor:qd}=Object,{freeze:jd,seal:Wd,create:Hd}=Object,{apply:Ud,construct:Yd}=typeof Reflect<"u"&&Reflect;jd||(jd=s(function(t){return t},"freeze")),Wd||(Wd=s(function(t){return t},"seal")),Ud||(Ud=s(function(t,e,r){return t.apply(e,r)},"apply")),Yd||(Yd=s(function(t,e){return new t(...e)},"construct"));var Vd=sp(Array.prototype.forEach),Gd=sp(Array.prototype.lastIndexOf),Xd=sp(Array.prototype.pop),Zd=sp(Array.prototype.push),Qd=sp(Array.prototype.splice),Kd=sp(String.prototype.toLowerCase),Jd=sp(String.prototype.toString),tp=sp(String.prototype.match),ep=sp(String.prototype.replace),rp=sp(String.prototype.indexOf),ip=sp(String.prototype.trim),np=sp(Object.prototype.hasOwnProperty),ap=sp(RegExp.prototype.test),op=lp(TypeError);function sp(t){return function(e){e instanceof RegExp&&(e.lastIndex=0);for(var r=arguments.length,i=new Array(r>1?r-1:0),n=1;n<r;n++)i[n-1]=arguments[n];return Ud(t,e,i)}}function lp(t){return function(){for(var e=arguments.length,r=new Array(e),i=0;i<e;i++)r[i]=arguments[i];return Yd(t,r)}}function hp(t,e){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:Kd;Rd&&Rd(t,null);let i=e.length;for(;i--;){let n=e[i];if("string"==typeof n){let t=r(n);t!==n&&(Pd(e)||(e[i]=t),n=t)}t[n]=!0}return t}function cp(t){for(let e=0;e<t.length;e++)np(t,e)||(t[e]=null);return t}function up(t){let e=Hd(null);for(let[r,i]of Nd(t))np(t,r)&&(Array.isArray(i)?e[r]=cp(i):i&&"object"==typeof i&&i.constructor===Object?e[r]=up(i):e[r]=i);return e}function dp(t,e){for(;null!==t;){let r=qd(t,e);if(r){if(r.get)return sp(r.get);if("function"==typeof r.value)return sp(r.value)}t=zd(t)}function r(){return null}return s(r,"fallbackValue"),r}s(sp,"unapply"),s(lp,"unconstruct"),s(hp,"addToSet"),s(cp,"cleanArray"),s(up,"clone"),s(dp,"lookupGetter");var pp=jd(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),fp=jd(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),gp=jd(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),yp=jd(["animate","color-profile","cursor","discard","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),mp=jd(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover","mprescripts"]),xp=jd(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),bp=jd(["#text"]),kp=jd(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","nonce","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","popover","popovertarget","popovertargetaction","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","wrap","xmlns","slot"]),Cp=jd(["accent-height","accumulate","additive","alignment-baseline","amplitude","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","exponent","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","intercept","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","slope","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","tablevalues","targetx","targety","transform","transform-origin","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),wp=jd(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),_p=jd(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),vp=Wd(/\{\{[\w\W]*|[\w\W]*\}\}/gm),Sp=Wd(/<%[\w\W]*|[\w\W]*%>/gm),Tp=Wd(/\$\{[\w\W]*/gm),Mp=Wd(/^data-[\-\w.\u00B7-\uFFFF]+$/),Bp=Wd(/^aria-[\-\w]+$/),Ap=Wd(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp|matrix):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),Lp=Wd(/^(?:\w+script|data):/i),Fp=Wd(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),$p=Wd(/^html$/i),Ep=Wd(/^[a-z][.\w]*(-[.\w]+)+$/i),Dp=Object.freeze({__proto__:null,ARIA_ATTR:Bp,ATTR_WHITESPACE:Fp,CUSTOM_ELEMENT:Ep,DATA_ATTR:Mp,DOCTYPE_NAME:$p,ERB_EXPR:Sp,IS_ALLOWED_URI:Ap,IS_SCRIPT_OR_DATA:Lp,MUSTACHE_EXPR:vp,TMPLIT_EXPR:Tp}),Op=1,Ip=3,Np=7,Rp=8,Pp=9,zp=s(function(){return typeof window>"u"?null:window},"getGlobal"),qp=s(function(t,e){if("object"!=typeof t||"function"!=typeof t.createPolicy)return null;let r=null,i="data-tt-policy-suffix";e&&e.hasAttribute(i)&&(r=e.getAttribute(i));let n="dompurify"+(r?"#"+r:"");try{return t.createPolicy(n,{createHTML:t=>t,createScriptURL:t=>t})}catch{return console.warn("TrustedTypes policy "+n+" could not be created."),null}},"_createTrustedTypesPolicy"),jp=s(function(){return{afterSanitizeAttributes:[],afterSanitizeElements:[],afterSanitizeShadowDOM:[],beforeSanitizeAttributes:[],beforeSanitizeElements:[],beforeSanitizeShadowDOM:[],uponSanitizeAttribute:[],uponSanitizeElement:[],uponSanitizeShadowNode:[]}},"_createHooksMap");function Wp(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:zp(),e=s(t=>Wp(t),"DOMPurify");if(e.version="3.2.6",e.removed=[],!t||!t.document||t.document.nodeType!==Pp||!t.Element)return e.isSupported=!1,e;let{document:r}=t,i=r,n=i.currentScript,{DocumentFragment:a,HTMLTemplateElement:o,Node:l,Element:h,NodeFilter:c,NamedNodeMap:u=t.NamedNodeMap||t.MozNamedAttrMap,HTMLFormElement:d,DOMParser:p,trustedTypes:f}=t,g=h.prototype,y=dp(g,"cloneNode"),m=dp(g,"remove"),x=dp(g,"nextSibling"),b=dp(g,"childNodes"),k=dp(g,"parentNode");if("function"==typeof o){let t=r.createElement("template");t.content&&t.content.ownerDocument&&(r=t.content.ownerDocument)}let C,w="",{implementation:_,createNodeIterator:v,createDocumentFragment:S,getElementsByTagName:T}=r,{importNode:M}=i,B=jp();e.isSupported="function"==typeof Nd&&"function"==typeof k&&_&&void 0!==_.createHTMLDocument;let{MUSTACHE_EXPR:A,ERB_EXPR:L,TMPLIT_EXPR:F,DATA_ATTR:$,ARIA_ATTR:E,IS_SCRIPT_OR_DATA:D,ATTR_WHITESPACE:O,CUSTOM_ELEMENT:I}=Dp,{IS_ALLOWED_URI:N}=Dp,R=null,P=hp({},[...pp,...fp,...gp,...mp,...bp]),z=null,q=hp({},[...kp,...Cp,...wp,..._p]),j=Object.seal(Hd(null,{tagNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},attributeNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},allowCustomizedBuiltInElements:{writable:!0,configurable:!1,enumerable:!0,value:!1}})),W=null,H=null,U=!0,Y=!0,V=!1,G=!0,X=!1,Z=!0,Q=!1,K=!1,J=!1,tt=!1,et=!1,rt=!1,it=!0,nt=!1,at=!0,ot=!1,st={},lt=null,ht=hp({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]),ct=null,ut=hp({},["audio","video","img","source","image","track"]),dt=null,pt=hp({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),ft="http://www.w3.org/1998/Math/MathML",gt="http://www.w3.org/2000/svg",yt="http://www.w3.org/1999/xhtml",mt=yt,xt=!1,bt=null,kt=hp({},[ft,gt,yt],Jd),Ct=hp({},["mi","mo","mn","ms","mtext"]),wt=hp({},["annotation-xml"]),_t=hp({},["title","style","font","a","script"]),vt=null,St=["application/xhtml+xml","text/html"],Tt=null,Mt=null,Bt=r.createElement("form"),At=s(function(t){return t instanceof RegExp||t instanceof Function},"isRegexOrFunction"),Lt=s(function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if(!Mt||Mt!==t){if((!t||"object"!=typeof t)&&(t={}),t=up(t),vt=-1===St.indexOf(t.PARSER_MEDIA_TYPE)?"text/html":t.PARSER_MEDIA_TYPE,Tt="application/xhtml+xml"===vt?Jd:Kd,R=np(t,"ALLOWED_TAGS")?hp({},t.ALLOWED_TAGS,Tt):P,z=np(t,"ALLOWED_ATTR")?hp({},t.ALLOWED_ATTR,Tt):q,bt=np(t,"ALLOWED_NAMESPACES")?hp({},t.ALLOWED_NAMESPACES,Jd):kt,dt=np(t,"ADD_URI_SAFE_ATTR")?hp(up(pt),t.ADD_URI_SAFE_ATTR,Tt):pt,ct=np(t,"ADD_DATA_URI_TAGS")?hp(up(ut),t.ADD_DATA_URI_TAGS,Tt):ut,lt=np(t,"FORBID_CONTENTS")?hp({},t.FORBID_CONTENTS,Tt):ht,W=np(t,"FORBID_TAGS")?hp({},t.FORBID_TAGS,Tt):up({}),H=np(t,"FORBID_ATTR")?hp({},t.FORBID_ATTR,Tt):up({}),st=!!np(t,"USE_PROFILES")&&t.USE_PROFILES,U=!1!==t.ALLOW_ARIA_ATTR,Y=!1!==t.ALLOW_DATA_ATTR,V=t.ALLOW_UNKNOWN_PROTOCOLS||!1,G=!1!==t.ALLOW_SELF_CLOSE_IN_ATTR,X=t.SAFE_FOR_TEMPLATES||!1,Z=!1!==t.SAFE_FOR_XML,Q=t.WHOLE_DOCUMENT||!1,tt=t.RETURN_DOM||!1,et=t.RETURN_DOM_FRAGMENT||!1,rt=t.RETURN_TRUSTED_TYPE||!1,J=t.FORCE_BODY||!1,it=!1!==t.SANITIZE_DOM,nt=t.SANITIZE_NAMED_PROPS||!1,at=!1!==t.KEEP_CONTENT,ot=t.IN_PLACE||!1,N=t.ALLOWED_URI_REGEXP||Ap,mt=t.NAMESPACE||yt,Ct=t.MATHML_TEXT_INTEGRATION_POINTS||Ct,wt=t.HTML_INTEGRATION_POINTS||wt,j=t.CUSTOM_ELEMENT_HANDLING||{},t.CUSTOM_ELEMENT_HANDLING&&At(t.CUSTOM_ELEMENT_HANDLING.tagNameCheck)&&(j.tagNameCheck=t.CUSTOM_ELEMENT_HANDLING.tagNameCheck),t.CUSTOM_ELEMENT_HANDLING&&At(t.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)&&(j.attributeNameCheck=t.CUSTOM_ELEMENT_HANDLING.attributeNameCheck),t.CUSTOM_ELEMENT_HANDLING&&"boolean"==typeof t.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements&&(j.allowCustomizedBuiltInElements=t.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements),X&&(Y=!1),et&&(tt=!0),st&&(R=hp({},bp),z=[],!0===st.html&&(hp(R,pp),hp(z,kp)),!0===st.svg&&(hp(R,fp),hp(z,Cp),hp(z,_p)),!0===st.svgFilters&&(hp(R,gp),hp(z,Cp),hp(z,_p)),!0===st.mathMl&&(hp(R,mp),hp(z,wp),hp(z,_p))),t.ADD_TAGS&&(R===P&&(R=up(R)),hp(R,t.ADD_TAGS,Tt)),t.ADD_ATTR&&(z===q&&(z=up(z)),hp(z,t.ADD_ATTR,Tt)),t.ADD_URI_SAFE_ATTR&&hp(dt,t.ADD_URI_SAFE_ATTR,Tt),t.FORBID_CONTENTS&&(lt===ht&&(lt=up(lt)),hp(lt,t.FORBID_CONTENTS,Tt)),at&&(R["#text"]=!0),Q&&hp(R,["html","head","body"]),R.table&&(hp(R,["tbody"]),delete W.tbody),t.TRUSTED_TYPES_POLICY){if("function"!=typeof t.TRUSTED_TYPES_POLICY.createHTML)throw op('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');if("function"!=typeof t.TRUSTED_TYPES_POLICY.createScriptURL)throw op('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');C=t.TRUSTED_TYPES_POLICY,w=C.createHTML("")}else void 0===C&&(C=qp(f,n)),null!==C&&"string"==typeof w&&(w=C.createHTML(""));jd&&jd(t),Mt=t}},"_parseConfig"),Ft=hp({},[...fp,...gp,...yp]),$t=hp({},[...mp,...xp]),Et=s(function(t){let e=k(t);(!e||!e.tagName)&&(e={namespaceURI:mt,tagName:"template"});let r=Kd(t.tagName),i=Kd(e.tagName);return!!bt[t.namespaceURI]&&(t.namespaceURI===gt?e.namespaceURI===yt?"svg"===r:e.namespaceURI===ft?"svg"===r&&("annotation-xml"===i||Ct[i]):!!Ft[r]:t.namespaceURI===ft?e.namespaceURI===yt?"math"===r:e.namespaceURI===gt?"math"===r&&wt[i]:!!$t[r]:t.namespaceURI===yt?!(e.namespaceURI===gt&&!wt[i]||e.namespaceURI===ft&&!Ct[i])&&(!$t[r]&&(_t[r]||!Ft[r])):!("application/xhtml+xml"!==vt||!bt[t.namespaceURI]))},"_checkValidNamespace"),Dt=s(function(t){Zd(e.removed,{element:t});try{k(t).removeChild(t)}catch{m(t)}},"_forceRemove"),Ot=s(function(t,r){try{Zd(e.removed,{attribute:r.getAttributeNode(t),from:r})}catch{Zd(e.removed,{attribute:null,from:r})}if(r.removeAttribute(t),"is"===t)if(tt||et)try{Dt(r)}catch{}else try{r.setAttribute(t,"")}catch{}},"_removeAttribute"),It=s(function(t){let e=null,i=null;if(J)t="<remove></remove>"+t;else{let e=tp(t,/^[\r\n\t ]+/);i=e&&e[0]}"application/xhtml+xml"===vt&&mt===yt&&(t='<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>'+t+"</body></html>");let n=C?C.createHTML(t):t;if(mt===yt)try{e=(new p).parseFromString(n,vt)}catch{}if(!e||!e.documentElement){e=_.createDocument(mt,"template",null);try{e.documentElement.innerHTML=xt?w:n}catch{}}let a=e.body||e.documentElement;return t&&i&&a.insertBefore(r.createTextNode(i),a.childNodes[0]||null),mt===yt?T.call(e,Q?"html":"body")[0]:Q?e.documentElement:a},"_initDocument"),Nt=s(function(t){return v.call(t.ownerDocument||t,t,c.SHOW_ELEMENT|c.SHOW_COMMENT|c.SHOW_TEXT|c.SHOW_PROCESSING_INSTRUCTION|c.SHOW_CDATA_SECTION,null)},"_createNodeIterator"),Rt=s(function(t){return t instanceof d&&("string"!=typeof t.nodeName||"string"!=typeof t.textContent||"function"!=typeof t.removeChild||!(t.attributes instanceof u)||"function"!=typeof t.removeAttribute||"function"!=typeof t.setAttribute||"string"!=typeof t.namespaceURI||"function"!=typeof t.insertBefore||"function"!=typeof t.hasChildNodes)},"_isClobbered"),Pt=s(function(t){return"function"==typeof l&&t instanceof l},"_isNode");function zt(t,r,i){Vd(t,t=>{t.call(e,r,i,Mt)})}s(zt,"_executeHooks");let qt=s(function(t){let r=null;if(zt(B.beforeSanitizeElements,t,null),Rt(t))return Dt(t),!0;let i=Tt(t.nodeName);if(zt(B.uponSanitizeElement,t,{tagName:i,allowedTags:R}),Z&&t.hasChildNodes()&&!Pt(t.firstElementChild)&&ap(/<[/\w!]/g,t.innerHTML)&&ap(/<[/\w!]/g,t.textContent)||t.nodeType===Np||Z&&t.nodeType===Rp&&ap(/<[/\w]/g,t.data))return Dt(t),!0;if(!R[i]||W[i]){if(!W[i]&&Wt(i)&&(j.tagNameCheck instanceof RegExp&&ap(j.tagNameCheck,i)||j.tagNameCheck instanceof Function&&j.tagNameCheck(i)))return!1;if(at&&!lt[i]){let e=k(t)||t.parentNode,r=b(t)||t.childNodes;if(r&&e){for(let i=r.length-1;i>=0;--i){let n=y(r[i],!0);n.__removalCount=(t.__removalCount||0)+1,e.insertBefore(n,x(t))}}}return Dt(t),!0}return t instanceof h&&!Et(t)||("noscript"===i||"noembed"===i||"noframes"===i)&&ap(/<\/no(script|embed|frames)/i,t.innerHTML)?(Dt(t),!0):(X&&t.nodeType===Ip&&(r=t.textContent,Vd([A,L,F],t=>{r=ep(r,t," ")}),t.textContent!==r&&(Zd(e.removed,{element:t.cloneNode()}),t.textContent=r)),zt(B.afterSanitizeElements,t,null),!1)},"_sanitizeElements"),jt=s(function(t,e,i){if(it&&("id"===e||"name"===e)&&(i in r||i in Bt))return!1;if((!Y||H[e]||!ap($,e))&&(!U||!ap(E,e)))if(!z[e]||H[e]){if(!(Wt(t)&&(j.tagNameCheck instanceof RegExp&&ap(j.tagNameCheck,t)||j.tagNameCheck instanceof Function&&j.tagNameCheck(t))&&(j.attributeNameCheck instanceof RegExp&&ap(j.attributeNameCheck,e)||j.attributeNameCheck instanceof Function&&j.attributeNameCheck(e))||"is"===e&&j.allowCustomizedBuiltInElements&&(j.tagNameCheck instanceof RegExp&&ap(j.tagNameCheck,i)||j.tagNameCheck instanceof Function&&j.tagNameCheck(i))))return!1}else if(!dt[e]&&!ap(N,ep(i,O,""))&&("src"!==e&&"xlink:href"!==e&&"href"!==e||"script"===t||0!==rp(i,"data:")||!ct[t])&&(!V||ap(D,ep(i,O,"")))&&i)return!1;return!0},"_isValidAttribute"),Wt=s(function(t){return"annotation-xml"!==t&&tp(t,I)},"_isBasicCustomElement"),Ht=s(function(t){zt(B.beforeSanitizeAttributes,t,null);let{attributes:r}=t;if(!r||Rt(t))return;let i={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:z,forceKeepAttr:void 0},n=r.length;for(;n--;){let a=r[n],{name:o,namespaceURI:s,value:l}=a,h=Tt(o),c=l,u="value"===o?c:ip(c);if(i.attrName=h,i.attrValue=u,i.keepAttr=!0,i.forceKeepAttr=void 0,zt(B.uponSanitizeAttribute,t,i),u=i.attrValue,nt&&("id"===h||"name"===h)&&(Ot(o,t),u="user-content-"+u),Z&&ap(/((--!?|])>)|<\/(style|title)/i,u)){Ot(o,t);continue}if(i.forceKeepAttr)continue;if(!i.keepAttr){Ot(o,t);continue}if(!G&&ap(/\/>/i,u)){Ot(o,t);continue}X&&Vd([A,L,F],t=>{u=ep(u,t," ")});let d=Tt(t.nodeName);if(jt(d,h,u)){if(C&&"object"==typeof f&&"function"==typeof f.getAttributeType&&!s)switch(f.getAttributeType(d,h)){case"TrustedHTML":u=C.createHTML(u);break;case"TrustedScriptURL":u=C.createScriptURL(u)}if(u!==c)try{s?t.setAttributeNS(s,o,u):t.setAttribute(o,u),Rt(t)?Dt(t):Xd(e.removed)}catch{Ot(o,t)}}else Ot(o,t)}zt(B.afterSanitizeAttributes,t,null)},"_sanitizeAttributes"),Ut=s(function t(e){let r=null,i=Nt(e);for(zt(B.beforeSanitizeShadowDOM,e,null);r=i.nextNode();)zt(B.uponSanitizeShadowNode,r,null),qt(r),Ht(r),r.content instanceof a&&t(r.content);zt(B.afterSanitizeShadowDOM,e,null)},"_sanitizeShadowDOM");return e.sanitize=function(t){let r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=null,o=null,s=null,h=null;if(xt=!t,xt&&(t="\x3c!--\x3e"),"string"!=typeof t&&!Pt(t)){if("function"!=typeof t.toString)throw op("toString is not a function");if("string"!=typeof(t=t.toString()))throw op("dirty is not a string, aborting")}if(!e.isSupported)return t;if(K||Lt(r),e.removed=[],"string"==typeof t&&(ot=!1),ot){if(t.nodeName){let e=Tt(t.nodeName);if(!R[e]||W[e])throw op("root node is forbidden and cannot be sanitized in-place")}}else if(t instanceof l)n=It("\x3c!----\x3e"),o=n.ownerDocument.importNode(t,!0),o.nodeType===Op&&"BODY"===o.nodeName||"HTML"===o.nodeName?n=o:n.appendChild(o);else{if(!tt&&!X&&!Q&&-1===t.indexOf("<"))return C&&rt?C.createHTML(t):t;if(n=It(t),!n)return tt?null:rt?w:""}n&&J&&Dt(n.firstChild);let c=Nt(ot?t:n);for(;s=c.nextNode();)qt(s),Ht(s),s.content instanceof a&&Ut(s.content);if(ot)return t;if(tt){if(et)for(h=S.call(n.ownerDocument);n.firstChild;)h.appendChild(n.firstChild);else h=n;return(z.shadowroot||z.shadowrootmode)&&(h=M.call(i,h,!0)),h}let u=Q?n.outerHTML:n.innerHTML;return Q&&R["!doctype"]&&n.ownerDocument&&n.ownerDocument.doctype&&n.ownerDocument.doctype.name&&ap($p,n.ownerDocument.doctype.name)&&(u="<!DOCTYPE "+n.ownerDocument.doctype.name+">\n"+u),X&&Vd([A,L,F],t=>{u=ep(u,t," ")}),C&&rt?C.createHTML(u):u},e.setConfig=function(){Lt(arguments.length>0&&void 0!==arguments[0]?arguments[0]:{}),K=!0},e.clearConfig=function(){Mt=null,K=!1},e.isValidAttribute=function(t,e,r){Mt||Lt({});let i=Tt(t),n=Tt(e);return jt(i,n,r)},e.addHook=function(t,e){"function"==typeof e&&Zd(B[t],e)},e.removeHook=function(t,e){if(void 0!==e){let r=Gd(B[t],e);return-1===r?void 0:Qd(B[t],r,1)[0]}return Xd(B[t])},e.removeHooks=function(t){B[t]=[]},e.removeAllHooks=function(){B=jp()},e}s(Wp,"createDOMPurify");var Hp=Wp(),Up=/<br\s*\/?>/gi,Yp=s(t=>t?rf(t).replace(/\\n/g,"#br#").split("#br#"):[""],"getRows"),Vp=(()=>{let t=!1;return()=>{t||(Gp(),t=!0)}})();function Gp(){let t="data-temp-href-target";Hp.addHook("beforeSanitizeAttributes",e=>{"A"===e.tagName&&e.hasAttribute("target")&&e.setAttribute(t,e.getAttribute("target")??"")}),Hp.addHook("afterSanitizeAttributes",e=>{"A"===e.tagName&&e.hasAttribute(t)&&(e.setAttribute("target",e.getAttribute(t)??""),e.removeAttribute(t),"_blank"===e.getAttribute("target")&&e.setAttribute("rel","noopener"))})}s(Gp,"setupDompurifyHooks");var Xp=s(t=>(Vp(),Hp.sanitize(t)),"removeScript"),Zp=s((t,e)=>{if(!1!==e.flowchart?.htmlLabels){let r=e.securityLevel;"antiscript"===r||"strict"===r?t=Xp(t):"loose"!==r&&(t=(t=(t=rf(t)).replace(/</g,"&lt;").replace(/>/g,"&gt;")).replace(/=/g,"&equals;"),t=ef(t))}return t},"sanitizeMore"),Qp=s((t,e)=>t&&(t=e.dompurifyConfig?Hp.sanitize(Zp(t,e),e.dompurifyConfig).toString():Hp.sanitize(Zp(t,e),{FORBID_TAGS:["style"]}).toString()),"sanitizeText"),Kp=s((t,e)=>"string"==typeof t?Qp(t,e):t.flat().map(t=>Qp(t,e)),"sanitizeTextOrArray"),Jp=s(t=>Up.test(t),"hasBreaks"),tf=s(t=>t.split(Up),"splitBreaks"),ef=s(t=>t.replace(/#br#/g,"<br/>"),"placeholderToBreak"),rf=s(t=>t.replace(Up,"#br#"),"breakToPlaceholder"),nf=s(t=>{let e="";return t&&(e=window.location.protocol+"//"+window.location.host+window.location.pathname+window.location.search,e=CSS.escape(e)),e},"getUrl"),af=s(t=>!(!1===t||["false","null","0"].includes(String(t).trim().toLowerCase())),"evaluate"),of=s(function(...t){let e=t.filter(t=>!isNaN(t));return Math.max(...e)},"getMax"),sf=s(function(...t){let e=t.filter(t=>!isNaN(t));return Math.min(...e)},"getMin"),lf=s(function(t){let e=t.split(/(,)/),r=[];for(let t=0;t<e.length;t++){let i=e[t];if(","===i&&t>0&&t+1<e.length){let n=e[t-1],a=e[t+1];cf(n,a)&&(i=n+","+a,t++,r.pop())}r.push(uf(i))}return r.join("")},"parseGenericTypes"),hf=s((t,e)=>Math.max(0,t.split(e).length-1),"countOccurrence"),cf=s((t,e)=>{let r=hf(t,"~"),i=hf(e,"~");return 1===r&&1===i},"shouldCombineSets"),uf=s(t=>{let e=hf(t,"~"),r=!1;if(e<=1)return t;e%2!=0&&t.startsWith("~")&&(t=t.substring(1),r=!0);let i=[...t],n=i.indexOf("~"),a=i.lastIndexOf("~");for(;-1!==n&&-1!==a&&n!==a;)i[n]="<",i[a]=">",n=i.indexOf("~"),a=i.lastIndexOf("~");return r&&i.unshift("~"),i.join("")},"processSet"),df=s(()=>void 0!==window.MathMLElement,"isMathMLSupported"),pf=/\$\$(.*)\$\$/g,ff=s(t=>(t.match(pf)?.length??0)>0,"hasKatex"),gf=s(async(t,e)=>{let r=document.createElement("div");r.innerHTML=await mf(t,e),r.id="katex-temp",r.style.visibility="hidden",r.style.position="absolute",r.style.top="0",document.querySelector("body")?.insertAdjacentElement("beforeend",r);let i={width:r.clientWidth,height:r.clientHeight};return r.remove(),i},"calculateMathMLDimensions"),yf=s(async(t,e)=>{if(!ff(t))return t;if(!(df()||e.legacyMathML||e.forceLegacyMathML))return t.replace(pf,"MathML is unsupported in this environment.");{let{default:r}=await import("./katex-RV2QPRKB-CFGzmZZE.js"),i=e.forceLegacyMathML||!df()&&e.legacyMathML?"htmlAndMathml":"mathml";return t.split(Up).map(t=>ff(t)?`<div style="display: flex; align-items: center; justify-content: center; white-space: nowrap;">${t}</div>`:`<div>${t}</div>`).join("").replace(pf,(t,e)=>r.renderToString(e,{throwOnError:!0,displayMode:!0,output:i}).replace(/\n/g," ").replace(/<annotation.*<\/annotation>/g,""))}},"renderKatexUnsanitized"),mf=s(async(t,e)=>Qp(await yf(t,e),e),"renderKatexSanitized"),xf={getRows:Yp,sanitizeText:Qp,sanitizeTextOrArray:Kp,hasBreaks:Jp,splitBreaks:tf,lineBreakRegex:Up,removeScript:Xp,getUrl:nf,evaluate:af,getMax:of,getMin:sf},bf=s(function(t,e){for(let r of e)t.attr(r[0],r[1])},"d3Attrs"),kf=s(function(t,e,r){let i=new Map;return r?(i.set("width","100%"),i.set("style",`max-width: ${e}px;`)):(i.set("height",t),i.set("width",e)),i},"calculateSvgSizeAttrs"),Cf=s(function(t,e,r,i){let n=kf(e,r,i);bf(t,n)},"configureSvgSize"),wf=s(function(t,e,r,i){let n=e.node().getBBox(),a=n.width,o=n.height;y.info(`SVG bounds: ${a}x${o}`,n);let s=0,l=0;y.info(`Graph bounds: ${s}x${l}`,t),s=a+2*r,l=o+2*r,y.info(`Calculated bounds: ${s}x${l}`),Cf(e,l,s,i);let h=`${n.x-r} ${n.y-r} ${n.width+2*r} ${n.height+2*r}`;e.attr("viewBox",h)},"setupGraphViewbox"),_f={},vf=s((t,e,r)=>{let i="";return t in _f&&_f[t]?i=_f[t](r):y.warn(`No theme found for ${t}`),` & {\n    font-family: ${r.fontFamily};\n    font-size: ${r.fontSize};\n    fill: ${r.textColor}\n  }\n  @keyframes edge-animation-frame {\n    from {\n      stroke-dashoffset: 0;\n    }\n  }\n  @keyframes dash {\n    to {\n      stroke-dashoffset: 0;\n    }\n  }\n  & .edge-animation-slow {\n    stroke-dasharray: 9,5 !important;\n    stroke-dashoffset: 900;\n    animation: dash 50s linear infinite;\n    stroke-linecap: round;\n  }\n  & .edge-animation-fast {\n    stroke-dasharray: 9,5 !important;\n    stroke-dashoffset: 900;\n    animation: dash 20s linear infinite;\n    stroke-linecap: round;\n  }\n  /* Classes common for multiple diagrams */\n\n  & .error-icon {\n    fill: ${r.errorBkgColor};\n  }\n  & .error-text {\n    fill: ${r.errorTextColor};\n    stroke: ${r.errorTextColor};\n  }\n\n  & .edge-thickness-normal {\n    stroke-width: 1px;\n  }\n  & .edge-thickness-thick {\n    stroke-width: 3.5px\n  }\n  & .edge-pattern-solid {\n    stroke-dasharray: 0;\n  }\n  & .edge-thickness-invisible {\n    stroke-width: 0;\n    fill: none;\n  }\n  & .edge-pattern-dashed{\n    stroke-dasharray: 3;\n  }\n  .edge-pattern-dotted {\n    stroke-dasharray: 2;\n  }\n\n  & .marker {\n    fill: ${r.lineColor};\n    stroke: ${r.lineColor};\n  }\n  & .marker.cross {\n    stroke: ${r.lineColor};\n  }\n\n  & svg {\n    font-family: ${r.fontFamily};\n    font-size: ${r.fontSize};\n  }\n   & p {\n    margin: 0\n   }\n\n  ${i}\n\n  ${e}\n`},"getStyles"),Sf=s((t,e)=>{void 0!==e&&(_f[t]=e)},"addStylesForDiagram"),Tf=vf,Mf={};h(Mf,{clear:()=>$f,getAccDescription:()=>If,getAccTitle:()=>Df,getDiagramTitle:()=>Rf,setAccDescription:()=>Of,setAccTitle:()=>Ef,setDiagramTitle:()=>Nf});var Bf="",Af="",Lf="",Ff=s(t=>Qp(t,Bd()),"sanitizeText"),$f=s(()=>{Bf="",Lf="",Af=""},"clear"),Ef=s(t=>{Bf=Ff(t).replace(/^\s+/g,"")},"setAccTitle"),Df=s(()=>Bf,"getAccTitle"),Of=s(t=>{Lf=Ff(t).replace(/\n\s+/g,"\n")},"setAccDescription"),If=s(()=>Lf,"getAccDescription"),Nf=s(t=>{Af=Ff(t)},"setDiagramTitle"),Rf=s(()=>Af,"getDiagramTitle"),Pf=y,zf=m,qf=Bd,jf=Md,Wf=xd,Hf=s(t=>Qp(t,qf()),"sanitizeText"),Uf=wf,Yf=s(()=>Mf,"getCommonDb"),Vf={},Gf=s((t,e,r)=>{Vf[t]&&Pf.warn(`Diagram with id ${t} already registered. Overwriting.`),Vf[t]=e,r&&Kc(t,r),Sf(t,e.styles),e.injectUtils?.(Pf,zf,qf,Hf,Uf,Yf(),()=>{})},"registerDiagram"),Xf=s(t=>{if(t in Vf)return Vf[t];throw new Zf(t)},"getDiagram"),Zf=class extends Error{static{s(this,"DiagramNotFoundError")}constructor(t){super(`Diagram ${t} not found.`)}},Qf=s(t=>{let{securityLevel:e}=qf(),r=Ke("body");if("sandbox"===e){let e=Ke(`#i${t}`).node()?.contentDocument??document;r=Ke(e.body)}return r.select(`#${t}`)},"selectSvgElement");function Kf(t){return typeof t>"u"||null===t}function Jf(t){return"object"==typeof t&&null!==t}function tg(t){return Array.isArray(t)?t:Kf(t)?[]:[t]}function eg(t,e){var r,i,n,a;if(e)for(r=0,i=(a=Object.keys(e)).length;r<i;r+=1)t[n=a[r]]=e[n];return t}function rg(t,e){var r,i="";for(r=0;r<e;r+=1)i+=t;return i}function ig(t){return 0===t&&Number.NEGATIVE_INFINITY===1/t}s(Kf,"isNothing"),s(Jf,"isObject"),s(tg,"toArray"),s(eg,"extend"),s(rg,"repeat"),s(ig,"isNegativeZero");var ng={isNothing:Kf,isObject:Jf,toArray:tg,repeat:rg,isNegativeZero:ig,extend:eg};function ag(t,e){var r="",i=t.reason||"(unknown reason)";return t.mark?(t.mark.name&&(r+='in "'+t.mark.name+'" '),r+="("+(t.mark.line+1)+":"+(t.mark.column+1)+")",!e&&t.mark.snippet&&(r+="\n\n"+t.mark.snippet),i+" "+r):i}function og(t,e){Error.call(this),this.name="YAMLException",this.reason=t,this.mark=e,this.message=ag(this,!1),Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=(new Error).stack||""}s(ag,"formatError"),s(og,"YAMLException$1"),og.prototype=Object.create(Error.prototype),og.prototype.constructor=og,og.prototype.toString=s(function(t){return this.name+": "+ag(this,t)},"toString");var sg=og;function lg(t,e,r,i,n){var a="",o="",s=Math.floor(n/2)-1;return i-e>s&&(e=i-s+(a=" ... ").length),r-i>s&&(r=i+s-(o=" ...").length),{str:a+t.slice(e,r).replace(/\t/g,"→")+o,pos:i-e+a.length}}function hg(t,e){return ng.repeat(" ",e-t.length)+t}function cg(t,e){if(e=Object.create(e||null),!t.buffer)return null;e.maxLength||(e.maxLength=79),"number"!=typeof e.indent&&(e.indent=1),"number"!=typeof e.linesBefore&&(e.linesBefore=3),"number"!=typeof e.linesAfter&&(e.linesAfter=2);for(var r,i=/\r?\n|\r|\0/g,n=[0],a=[],o=-1;r=i.exec(t.buffer);)a.push(r.index),n.push(r.index+r[0].length),t.position<=r.index&&o<0&&(o=n.length-2);o<0&&(o=n.length-1);var s,l,h="",c=Math.min(t.line+e.linesAfter,a.length).toString().length,u=e.maxLength-(e.indent+c+3);for(s=1;s<=e.linesBefore&&!(o-s<0);s++)l=lg(t.buffer,n[o-s],a[o-s],t.position-(n[o]-n[o-s]),u),h=ng.repeat(" ",e.indent)+hg((t.line-s+1).toString(),c)+" | "+l.str+"\n"+h;for(l=lg(t.buffer,n[o],a[o],t.position,u),h+=ng.repeat(" ",e.indent)+hg((t.line+1).toString(),c)+" | "+l.str+"\n",h+=ng.repeat("-",e.indent+c+3+l.pos)+"^\n",s=1;s<=e.linesAfter&&!(o+s>=a.length);s++)l=lg(t.buffer,n[o+s],a[o+s],t.position-(n[o]-n[o+s]),u),h+=ng.repeat(" ",e.indent)+hg((t.line+s+1).toString(),c)+" | "+l.str+"\n";return h.replace(/\n$/,"")}s(lg,"getLine"),s(hg,"padStart"),s(cg,"makeSnippet");var ug=cg,dg=["kind","multi","resolve","construct","instanceOf","predicate","represent","representName","defaultStyle","styleAliases"],pg=["scalar","sequence","mapping"];function fg(t){var e={};return null!==t&&Object.keys(t).forEach(function(r){t[r].forEach(function(t){e[String(t)]=r})}),e}function gg(t,e){if(e=e||{},Object.keys(e).forEach(function(e){if(-1===dg.indexOf(e))throw new sg('Unknown option "'+e+'" is met in definition of "'+t+'" YAML type.')}),this.options=e,this.tag=t,this.kind=e.kind||null,this.resolve=e.resolve||function(){return!0},this.construct=e.construct||function(t){return t},this.instanceOf=e.instanceOf||null,this.predicate=e.predicate||null,this.represent=e.represent||null,this.representName=e.representName||null,this.defaultStyle=e.defaultStyle||null,this.multi=e.multi||!1,this.styleAliases=fg(e.styleAliases||null),-1===pg.indexOf(this.kind))throw new sg('Unknown kind "'+this.kind+'" is specified for "'+t+'" YAML type.')}s(fg,"compileStyleAliases"),s(gg,"Type$1");var yg=gg;function mg(t,e){var r=[];return t[e].forEach(function(t){var e=r.length;r.forEach(function(r,i){r.tag===t.tag&&r.kind===t.kind&&r.multi===t.multi&&(e=i)}),r[e]=t}),r}function xg(){var t,e,r={scalar:{},sequence:{},mapping:{},fallback:{},multi:{scalar:[],sequence:[],mapping:[],fallback:[]}};function i(t){t.multi?(r.multi[t.kind].push(t),r.multi.fallback.push(t)):r[t.kind][t.tag]=r.fallback[t.tag]=t}for(s(i,"collectType"),t=0,e=arguments.length;t<e;t+=1)arguments[t].forEach(i);return r}function bg(t){return this.extend(t)}s(mg,"compileList"),s(xg,"compileMap"),s(bg,"Schema$1"),bg.prototype.extend=s(function(t){var e=[],r=[];if(t instanceof yg)r.push(t);else if(Array.isArray(t))r=r.concat(t);else{if(!t||!Array.isArray(t.implicit)&&!Array.isArray(t.explicit))throw new sg("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");t.implicit&&(e=e.concat(t.implicit)),t.explicit&&(r=r.concat(t.explicit))}e.forEach(function(t){if(!(t instanceof yg))throw new sg("Specified list of YAML types (or a single Type object) contains a non-Type object.");if(t.loadKind&&"scalar"!==t.loadKind)throw new sg("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");if(t.multi)throw new sg("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.")}),r.forEach(function(t){if(!(t instanceof yg))throw new sg("Specified list of YAML types (or a single Type object) contains a non-Type object.")});var i=Object.create(bg.prototype);return i.implicit=(this.implicit||[]).concat(e),i.explicit=(this.explicit||[]).concat(r),i.compiledImplicit=mg(i,"implicit"),i.compiledExplicit=mg(i,"explicit"),i.compiledTypeMap=xg(i.compiledImplicit,i.compiledExplicit),i},"extend");var kg=bg,Cg=new yg("tag:yaml.org,2002:str",{kind:"scalar",construct:s(function(t){return null!==t?t:""},"construct")}),wg=new yg("tag:yaml.org,2002:seq",{kind:"sequence",construct:s(function(t){return null!==t?t:[]},"construct")}),_g=new yg("tag:yaml.org,2002:map",{kind:"mapping",construct:s(function(t){return null!==t?t:{}},"construct")}),vg=new kg({explicit:[Cg,wg,_g]});function Sg(t){if(null===t)return!0;var e=t.length;return 1===e&&"~"===t||4===e&&("null"===t||"Null"===t||"NULL"===t)}function Tg(){return null}function Mg(t){return null===t}s(Sg,"resolveYamlNull"),s(Tg,"constructYamlNull"),s(Mg,"isNull");var Bg=new yg("tag:yaml.org,2002:null",{kind:"scalar",resolve:Sg,construct:Tg,predicate:Mg,represent:{canonical:s(function(){return"~"},"canonical"),lowercase:s(function(){return"null"},"lowercase"),uppercase:s(function(){return"NULL"},"uppercase"),camelcase:s(function(){return"Null"},"camelcase"),empty:s(function(){return""},"empty")},defaultStyle:"lowercase"});function Ag(t){if(null===t)return!1;var e=t.length;return 4===e&&("true"===t||"True"===t||"TRUE"===t)||5===e&&("false"===t||"False"===t||"FALSE"===t)}function Lg(t){return"true"===t||"True"===t||"TRUE"===t}function Fg(t){return"[object Boolean]"===Object.prototype.toString.call(t)}s(Ag,"resolveYamlBoolean"),s(Lg,"constructYamlBoolean"),s(Fg,"isBoolean");var $g=new yg("tag:yaml.org,2002:bool",{kind:"scalar",resolve:Ag,construct:Lg,predicate:Fg,represent:{lowercase:s(function(t){return t?"true":"false"},"lowercase"),uppercase:s(function(t){return t?"TRUE":"FALSE"},"uppercase"),camelcase:s(function(t){return t?"True":"False"},"camelcase")},defaultStyle:"lowercase"});function Eg(t){return 48<=t&&t<=57||65<=t&&t<=70||97<=t&&t<=102}function Dg(t){return 48<=t&&t<=55}function Og(t){return 48<=t&&t<=57}function Ig(t){if(null===t)return!1;var e,r=t.length,i=0,n=!1;if(!r)return!1;if(("-"===(e=t[i])||"+"===e)&&(e=t[++i]),"0"===e){if(i+1===r)return!0;if("b"===(e=t[++i])){for(i++;i<r;i++)if("_"!==(e=t[i])){if("0"!==e&&"1"!==e)return!1;n=!0}return n&&"_"!==e}if("x"===e){for(i++;i<r;i++)if("_"!==(e=t[i])){if(!Eg(t.charCodeAt(i)))return!1;n=!0}return n&&"_"!==e}if("o"===e){for(i++;i<r;i++)if("_"!==(e=t[i])){if(!Dg(t.charCodeAt(i)))return!1;n=!0}return n&&"_"!==e}}if("_"===e)return!1;for(;i<r;i++)if("_"!==(e=t[i])){if(!Og(t.charCodeAt(i)))return!1;n=!0}return!(!n||"_"===e)}function Ng(t){var e,r=t,i=1;if(-1!==r.indexOf("_")&&(r=r.replace(/_/g,"")),("-"===(e=r[0])||"+"===e)&&("-"===e&&(i=-1),e=(r=r.slice(1))[0]),"0"===r)return 0;if("0"===e){if("b"===r[1])return i*parseInt(r.slice(2),2);if("x"===r[1])return i*parseInt(r.slice(2),16);if("o"===r[1])return i*parseInt(r.slice(2),8)}return i*parseInt(r,10)}function Rg(t){return"[object Number]"===Object.prototype.toString.call(t)&&t%1==0&&!ng.isNegativeZero(t)}s(Eg,"isHexCode"),s(Dg,"isOctCode"),s(Og,"isDecCode"),s(Ig,"resolveYamlInteger"),s(Ng,"constructYamlInteger"),s(Rg,"isInteger");var Pg=new yg("tag:yaml.org,2002:int",{kind:"scalar",resolve:Ig,construct:Ng,predicate:Rg,represent:{binary:s(function(t){return t>=0?"0b"+t.toString(2):"-0b"+t.toString(2).slice(1)},"binary"),octal:s(function(t){return t>=0?"0o"+t.toString(8):"-0o"+t.toString(8).slice(1)},"octal"),decimal:s(function(t){return t.toString(10)},"decimal"),hexadecimal:s(function(t){return t>=0?"0x"+t.toString(16).toUpperCase():"-0x"+t.toString(16).toUpperCase().slice(1)},"hexadecimal")},defaultStyle:"decimal",styleAliases:{binary:[2,"bin"],octal:[8,"oct"],decimal:[10,"dec"],hexadecimal:[16,"hex"]}}),zg=new RegExp("^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");function qg(t){return!(null===t||!zg.test(t)||"_"===t[t.length-1])}function jg(t){var e,r;return r="-"===(e=t.replace(/_/g,"").toLowerCase())[0]?-1:1,"+-".indexOf(e[0])>=0&&(e=e.slice(1)),".inf"===e?1===r?Number.POSITIVE_INFINITY:Number.NEGATIVE_INFINITY:".nan"===e?NaN:r*parseFloat(e,10)}s(qg,"resolveYamlFloat"),s(jg,"constructYamlFloat");var Wg=/^[-+]?[0-9]+e/;function Hg(t,e){var r;if(isNaN(t))switch(e){case"lowercase":return".nan";case"uppercase":return".NAN";case"camelcase":return".NaN"}else if(Number.POSITIVE_INFINITY===t)switch(e){case"lowercase":return".inf";case"uppercase":return".INF";case"camelcase":return".Inf"}else if(Number.NEGATIVE_INFINITY===t)switch(e){case"lowercase":return"-.inf";case"uppercase":return"-.INF";case"camelcase":return"-.Inf"}else if(ng.isNegativeZero(t))return"-0.0";return r=t.toString(10),Wg.test(r)?r.replace("e",".e"):r}function Ug(t){return"[object Number]"===Object.prototype.toString.call(t)&&(t%1!=0||ng.isNegativeZero(t))}s(Hg,"representYamlFloat"),s(Ug,"isFloat");var Yg=new yg("tag:yaml.org,2002:float",{kind:"scalar",resolve:qg,construct:jg,predicate:Ug,represent:Hg,defaultStyle:"lowercase"}),Vg=vg.extend({implicit:[Bg,$g,Pg,Yg]}),Gg=Vg,Xg=new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$"),Zg=new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$");function Qg(t){return null!==t&&(null!==Xg.exec(t)||null!==Zg.exec(t))}function Kg(t){var e,r,i,n,a,o,s,l,h=0,c=null;if(null===(e=Xg.exec(t))&&(e=Zg.exec(t)),null===e)throw new Error("Date resolve error");if(r=+e[1],i=+e[2]-1,n=+e[3],!e[4])return new Date(Date.UTC(r,i,n));if(a=+e[4],o=+e[5],s=+e[6],e[7]){for(h=e[7].slice(0,3);h.length<3;)h+="0";h=+h}return e[9]&&(c=6e4*(60*+e[10]+ +(e[11]||0)),"-"===e[9]&&(c=-c)),l=new Date(Date.UTC(r,i,n,a,o,s,h)),c&&l.setTime(l.getTime()-c),l}function Jg(t){return t.toISOString()}s(Qg,"resolveYamlTimestamp"),s(Kg,"constructYamlTimestamp"),s(Jg,"representYamlTimestamp");var ty=new yg("tag:yaml.org,2002:timestamp",{kind:"scalar",resolve:Qg,construct:Kg,instanceOf:Date,represent:Jg});function ey(t){return"<<"===t||null===t}s(ey,"resolveYamlMerge");var ry=new yg("tag:yaml.org,2002:merge",{kind:"scalar",resolve:ey}),iy="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";function ny(t){if(null===t)return!1;var e,r,i=0,n=t.length,a=iy;for(r=0;r<n;r++)if(!((e=a.indexOf(t.charAt(r)))>64)){if(e<0)return!1;i+=6}return i%8==0}function ay(t){var e,r,i=t.replace(/[\r\n=]/g,""),n=i.length,a=iy,o=0,s=[];for(e=0;e<n;e++)e%4==0&&e&&(s.push(o>>16&255),s.push(o>>8&255),s.push(255&o)),o=o<<6|a.indexOf(i.charAt(e));return 0===(r=n%4*6)?(s.push(o>>16&255),s.push(o>>8&255),s.push(255&o)):18===r?(s.push(o>>10&255),s.push(o>>2&255)):12===r&&s.push(o>>4&255),new Uint8Array(s)}function oy(t){var e,r,i="",n=0,a=t.length,o=iy;for(e=0;e<a;e++)e%3==0&&e&&(i+=o[n>>18&63],i+=o[n>>12&63],i+=o[n>>6&63],i+=o[63&n]),n=(n<<8)+t[e];return 0===(r=a%3)?(i+=o[n>>18&63],i+=o[n>>12&63],i+=o[n>>6&63],i+=o[63&n]):2===r?(i+=o[n>>10&63],i+=o[n>>4&63],i+=o[n<<2&63],i+=o[64]):1===r&&(i+=o[n>>2&63],i+=o[n<<4&63],i+=o[64],i+=o[64]),i}function sy(t){return"[object Uint8Array]"===Object.prototype.toString.call(t)}s(ny,"resolveYamlBinary"),s(ay,"constructYamlBinary"),s(oy,"representYamlBinary"),s(sy,"isBinary");var ly=new yg("tag:yaml.org,2002:binary",{kind:"scalar",resolve:ny,construct:ay,predicate:sy,represent:oy}),hy=Object.prototype.hasOwnProperty,cy=Object.prototype.toString;function uy(t){if(null===t)return!0;var e,r,i,n,a,o=[],s=t;for(e=0,r=s.length;e<r;e+=1){if(i=s[e],a=!1,"[object Object]"!==cy.call(i))return!1;for(n in i)if(hy.call(i,n)){if(a)return!1;a=!0}if(!a)return!1;if(-1!==o.indexOf(n))return!1;o.push(n)}return!0}function dy(t){return null!==t?t:[]}s(uy,"resolveYamlOmap"),s(dy,"constructYamlOmap");var py=new yg("tag:yaml.org,2002:omap",{kind:"sequence",resolve:uy,construct:dy}),fy=Object.prototype.toString;function gy(t){if(null===t)return!0;var e,r,i,n,a,o=t;for(a=new Array(o.length),e=0,r=o.length;e<r;e+=1){if(i=o[e],"[object Object]"!==fy.call(i)||1!==(n=Object.keys(i)).length)return!1;a[e]=[n[0],i[n[0]]]}return!0}function yy(t){if(null===t)return[];var e,r,i,n,a,o=t;for(a=new Array(o.length),e=0,r=o.length;e<r;e+=1)i=o[e],n=Object.keys(i),a[e]=[n[0],i[n[0]]];return a}s(gy,"resolveYamlPairs"),s(yy,"constructYamlPairs");var my=new yg("tag:yaml.org,2002:pairs",{kind:"sequence",resolve:gy,construct:yy}),xy=Object.prototype.hasOwnProperty;function by(t){if(null===t)return!0;var e,r=t;for(e in r)if(xy.call(r,e)&&null!==r[e])return!1;return!0}function ky(t){return null!==t?t:{}}s(by,"resolveYamlSet"),s(ky,"constructYamlSet");var Cy=new yg("tag:yaml.org,2002:set",{kind:"mapping",resolve:by,construct:ky}),wy=Gg.extend({implicit:[ty,ry],explicit:[ly,py,my,Cy]}),_y=Object.prototype.hasOwnProperty,vy=/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/,Sy=/[\x85\u2028\u2029]/,Ty=/[,\[\]\{\}]/,My=/^(?:!|!!|![a-z\-]+!)$/i,By=/^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;function Ay(t){return Object.prototype.toString.call(t)}function Ly(t){return 10===t||13===t}function Fy(t){return 9===t||32===t}function $y(t){return 9===t||32===t||10===t||13===t}function Ey(t){return 44===t||91===t||93===t||123===t||125===t}function Dy(t){var e;return 48<=t&&t<=57?t-48:97<=(e=32|t)&&e<=102?e-97+10:-1}function Oy(t){return 120===t?2:117===t?4:85===t?8:0}function Iy(t){return 48<=t&&t<=57?t-48:-1}function Ny(t){return 48===t?"\0":97===t?"":98===t?"\b":116===t||9===t?"\t":110===t?"\n":118===t?"\v":102===t?"\f":114===t?"\r":101===t?"":32===t?" ":34===t?'"':47===t?"/":92===t?"\\":78===t?"":95===t?" ":76===t?"\u2028":80===t?"\u2029":""}function Ry(t){return t<=65535?String.fromCharCode(t):String.fromCharCode(55296+(t-65536>>10),56320+(t-65536&1023))}s(Ay,"_class"),s(Ly,"is_EOL"),s(Fy,"is_WHITE_SPACE"),s($y,"is_WS_OR_EOL"),s(Ey,"is_FLOW_INDICATOR"),s(Dy,"fromHexCode"),s(Oy,"escapedHexLen"),s(Iy,"fromDecimalCode"),s(Ny,"simpleEscapeSequence"),s(Ry,"charFromCodepoint");var Py,zy=new Array(256),qy=new Array(256);for(Py=0;Py<256;Py++)zy[Py]=Ny(Py)?1:0,qy[Py]=Ny(Py);function jy(t,e){this.input=t,this.filename=e.filename||null,this.schema=e.schema||wy,this.onWarning=e.onWarning||null,this.legacy=e.legacy||!1,this.json=e.json||!1,this.listener=e.listener||null,this.implicitTypes=this.schema.compiledImplicit,this.typeMap=this.schema.compiledTypeMap,this.length=t.length,this.position=0,this.line=0,this.lineStart=0,this.lineIndent=0,this.firstTabInLine=-1,this.documents=[]}function Wy(t,e){var r={name:t.filename,buffer:t.input.slice(0,-1),position:t.position,line:t.line,column:t.position-t.lineStart};return r.snippet=ug(r),new sg(e,r)}function Hy(t,e){throw Wy(t,e)}function Uy(t,e){t.onWarning&&t.onWarning.call(null,Wy(t,e))}s(jy,"State$1"),s(Wy,"generateError"),s(Hy,"throwError"),s(Uy,"throwWarning");var Yy={YAML:s(function(t,e,r){var i,n,a;null!==t.version&&Hy(t,"duplication of %YAML directive"),1!==r.length&&Hy(t,"YAML directive accepts exactly one argument"),null===(i=/^([0-9]+)\.([0-9]+)$/.exec(r[0]))&&Hy(t,"ill-formed argument of the YAML directive"),n=parseInt(i[1],10),a=parseInt(i[2],10),1!==n&&Hy(t,"unacceptable YAML version of the document"),t.version=r[0],t.checkLineBreaks=a<2,1!==a&&2!==a&&Uy(t,"unsupported YAML version of the document")},"handleYamlDirective"),TAG:s(function(t,e,r){var i,n;2!==r.length&&Hy(t,"TAG directive accepts exactly two arguments"),i=r[0],n=r[1],My.test(i)||Hy(t,"ill-formed tag handle (first argument) of the TAG directive"),_y.call(t.tagMap,i)&&Hy(t,'there is a previously declared suffix for "'+i+'" tag handle'),By.test(n)||Hy(t,"ill-formed tag prefix (second argument) of the TAG directive");try{n=decodeURIComponent(n)}catch{Hy(t,"tag prefix is malformed: "+n)}t.tagMap[i]=n},"handleTagDirective")};function Vy(t,e,r,i){var n,a,o,s;if(e<r){if(s=t.input.slice(e,r),i)for(n=0,a=s.length;n<a;n+=1)9===(o=s.charCodeAt(n))||32<=o&&o<=1114111||Hy(t,"expected valid JSON character");else vy.test(s)&&Hy(t,"the stream contains non-printable characters");t.result+=s}}function Gy(t,e,r,i){var n,a,o,s;for(ng.isObject(r)||Hy(t,"cannot merge mappings; the provided source object is unacceptable"),o=0,s=(n=Object.keys(r)).length;o<s;o+=1)a=n[o],_y.call(e,a)||(e[a]=r[a],i[a]=!0)}function Xy(t,e,r,i,n,a,o,s,l){var h,c;if(Array.isArray(n))for(h=0,c=(n=Array.prototype.slice.call(n)).length;h<c;h+=1)Array.isArray(n[h])&&Hy(t,"nested arrays are not supported inside keys"),"object"==typeof n&&"[object Object]"===Ay(n[h])&&(n[h]="[object Object]");if("object"==typeof n&&"[object Object]"===Ay(n)&&(n="[object Object]"),n=String(n),null===e&&(e={}),"tag:yaml.org,2002:merge"===i)if(Array.isArray(a))for(h=0,c=a.length;h<c;h+=1)Gy(t,e,a[h],r);else Gy(t,e,a,r);else!t.json&&!_y.call(r,n)&&_y.call(e,n)&&(t.line=o||t.line,t.lineStart=s||t.lineStart,t.position=l||t.position,Hy(t,"duplicated mapping key")),"__proto__"===n?Object.defineProperty(e,n,{configurable:!0,enumerable:!0,writable:!0,value:a}):e[n]=a,delete r[n];return e}function Zy(t){var e;10===(e=t.input.charCodeAt(t.position))?t.position++:13===e?(t.position++,10===t.input.charCodeAt(t.position)&&t.position++):Hy(t,"a line break is expected"),t.line+=1,t.lineStart=t.position,t.firstTabInLine=-1}function Qy(t,e,r){for(var i=0,n=t.input.charCodeAt(t.position);0!==n;){for(;Fy(n);)9===n&&-1===t.firstTabInLine&&(t.firstTabInLine=t.position),n=t.input.charCodeAt(++t.position);if(e&&35===n)do{n=t.input.charCodeAt(++t.position)}while(10!==n&&13!==n&&0!==n);if(!Ly(n))break;for(Zy(t),n=t.input.charCodeAt(t.position),i++,t.lineIndent=0;32===n;)t.lineIndent++,n=t.input.charCodeAt(++t.position)}return-1!==r&&0!==i&&t.lineIndent<r&&Uy(t,"deficient indentation"),i}function Ky(t){var e,r=t.position;return!(45!==(e=t.input.charCodeAt(r))&&46!==e||e!==t.input.charCodeAt(r+1)||e!==t.input.charCodeAt(r+2)||(r+=3,e=t.input.charCodeAt(r),0!==e&&!$y(e)))}function Jy(t,e){1===e?t.result+=" ":e>1&&(t.result+=ng.repeat("\n",e-1))}function tm(t,e,r){var i,n,a,o,s,l,h,c,u=t.kind,d=t.result;if($y(c=t.input.charCodeAt(t.position))||Ey(c)||35===c||38===c||42===c||33===c||124===c||62===c||39===c||34===c||37===c||64===c||96===c||(63===c||45===c)&&($y(i=t.input.charCodeAt(t.position+1))||r&&Ey(i)))return!1;for(t.kind="scalar",t.result="",n=a=t.position,o=!1;0!==c;){if(58===c){if($y(i=t.input.charCodeAt(t.position+1))||r&&Ey(i))break}else if(35===c){if($y(t.input.charCodeAt(t.position-1)))break}else{if(t.position===t.lineStart&&Ky(t)||r&&Ey(c))break;if(Ly(c)){if(s=t.line,l=t.lineStart,h=t.lineIndent,Qy(t,!1,-1),t.lineIndent>=e){o=!0,c=t.input.charCodeAt(t.position);continue}t.position=a,t.line=s,t.lineStart=l,t.lineIndent=h;break}}o&&(Vy(t,n,a,!1),Jy(t,t.line-s),n=a=t.position,o=!1),Fy(c)||(a=t.position+1),c=t.input.charCodeAt(++t.position)}return Vy(t,n,a,!1),!!t.result||(t.kind=u,t.result=d,!1)}function em(t,e){var r,i,n;if(39!==(r=t.input.charCodeAt(t.position)))return!1;for(t.kind="scalar",t.result="",t.position++,i=n=t.position;0!==(r=t.input.charCodeAt(t.position));)if(39===r){if(Vy(t,i,t.position,!0),39!==(r=t.input.charCodeAt(++t.position)))return!0;i=t.position,t.position++,n=t.position}else Ly(r)?(Vy(t,i,n,!0),Jy(t,Qy(t,!1,e)),i=n=t.position):t.position===t.lineStart&&Ky(t)?Hy(t,"unexpected end of the document within a single quoted scalar"):(t.position++,n=t.position);Hy(t,"unexpected end of the stream within a single quoted scalar")}function rm(t,e){var r,i,n,a,o,s;if(34!==(s=t.input.charCodeAt(t.position)))return!1;for(t.kind="scalar",t.result="",t.position++,r=i=t.position;0!==(s=t.input.charCodeAt(t.position));){if(34===s)return Vy(t,r,t.position,!0),t.position++,!0;if(92===s){if(Vy(t,r,t.position,!0),Ly(s=t.input.charCodeAt(++t.position)))Qy(t,!1,e);else if(s<256&&zy[s])t.result+=qy[s],t.position++;else if((o=Oy(s))>0){for(n=o,a=0;n>0;n--)(o=Dy(s=t.input.charCodeAt(++t.position)))>=0?a=(a<<4)+o:Hy(t,"expected hexadecimal character");t.result+=Ry(a),t.position++}else Hy(t,"unknown escape sequence");r=i=t.position}else Ly(s)?(Vy(t,r,i,!0),Jy(t,Qy(t,!1,e)),r=i=t.position):t.position===t.lineStart&&Ky(t)?Hy(t,"unexpected end of the document within a double quoted scalar"):(t.position++,i=t.position)}Hy(t,"unexpected end of the stream within a double quoted scalar")}function im(t,e){var r,i,n,a,o,s,l,h,c,u,d,p,f=!0,g=t.tag,y=t.anchor,m=Object.create(null);if(91===(p=t.input.charCodeAt(t.position)))o=93,h=!1,a=[];else{if(123!==p)return!1;o=125,h=!0,a={}}for(null!==t.anchor&&(t.anchorMap[t.anchor]=a),p=t.input.charCodeAt(++t.position);0!==p;){if(Qy(t,!0,e),(p=t.input.charCodeAt(t.position))===o)return t.position++,t.tag=g,t.anchor=y,t.kind=h?"mapping":"sequence",t.result=a,!0;f?44===p&&Hy(t,"expected the node content, but found ','"):Hy(t,"missed comma between flow collection entries"),d=null,s=l=!1,63===p&&($y(t.input.charCodeAt(t.position+1))&&(s=l=!0,t.position++,Qy(t,!0,e))),r=t.line,i=t.lineStart,n=t.position,cm(t,e,1,!1,!0),u=t.tag,c=t.result,Qy(t,!0,e),p=t.input.charCodeAt(t.position),(l||t.line===r)&&58===p&&(s=!0,p=t.input.charCodeAt(++t.position),Qy(t,!0,e),cm(t,e,1,!1,!0),d=t.result),h?Xy(t,a,m,u,c,d,r,i,n):s?a.push(Xy(t,null,m,u,c,d,r,i,n)):a.push(c),Qy(t,!0,e),44===(p=t.input.charCodeAt(t.position))?(f=!0,p=t.input.charCodeAt(++t.position)):f=!1}Hy(t,"unexpected end of the stream within a flow collection")}function nm(t,e){var r,i,n,a,o=1,s=!1,l=!1,h=e,c=0,u=!1;if(124===(a=t.input.charCodeAt(t.position)))i=!1;else{if(62!==a)return!1;i=!0}for(t.kind="scalar",t.result="";0!==a;)if(43===(a=t.input.charCodeAt(++t.position))||45===a)1===o?o=43===a?3:2:Hy(t,"repeat of a chomping mode identifier");else{if(!((n=Iy(a))>=0))break;0===n?Hy(t,"bad explicit indentation width of a block scalar; it cannot be less than one"):l?Hy(t,"repeat of an indentation width identifier"):(h=e+n-1,l=!0)}if(Fy(a)){do{a=t.input.charCodeAt(++t.position)}while(Fy(a));if(35===a)do{a=t.input.charCodeAt(++t.position)}while(!Ly(a)&&0!==a)}for(;0!==a;){for(Zy(t),t.lineIndent=0,a=t.input.charCodeAt(t.position);(!l||t.lineIndent<h)&&32===a;)t.lineIndent++,a=t.input.charCodeAt(++t.position);if(!l&&t.lineIndent>h&&(h=t.lineIndent),Ly(a))c++;else{if(t.lineIndent<h){3===o?t.result+=ng.repeat("\n",s?1+c:c):1===o&&s&&(t.result+="\n");break}for(i?Fy(a)?(u=!0,t.result+=ng.repeat("\n",s?1+c:c)):u?(u=!1,t.result+=ng.repeat("\n",c+1)):0===c?s&&(t.result+=" "):t.result+=ng.repeat("\n",c):t.result+=ng.repeat("\n",s?1+c:c),s=!0,l=!0,c=0,r=t.position;!Ly(a)&&0!==a;)a=t.input.charCodeAt(++t.position);Vy(t,r,t.position,!1)}}return!0}function am(t,e){var r,i,n=t.tag,a=t.anchor,o=[],s=!1;if(-1!==t.firstTabInLine)return!1;for(null!==t.anchor&&(t.anchorMap[t.anchor]=o),i=t.input.charCodeAt(t.position);0!==i&&(-1!==t.firstTabInLine&&(t.position=t.firstTabInLine,Hy(t,"tab characters must not be used in indentation")),45===i&&$y(t.input.charCodeAt(t.position+1)));)if(s=!0,t.position++,Qy(t,!0,-1)&&t.lineIndent<=e)o.push(null),i=t.input.charCodeAt(t.position);else if(r=t.line,cm(t,e,3,!1,!0),o.push(t.result),Qy(t,!0,-1),i=t.input.charCodeAt(t.position),(t.line===r||t.lineIndent>e)&&0!==i)Hy(t,"bad indentation of a sequence entry");else if(t.lineIndent<e)break;return!!s&&(t.tag=n,t.anchor=a,t.kind="sequence",t.result=o,!0)}function om(t,e,r){var i,n,a,o,s,l,h,c=t.tag,u=t.anchor,d={},p=Object.create(null),f=null,g=null,y=null,m=!1,x=!1;if(-1!==t.firstTabInLine)return!1;for(null!==t.anchor&&(t.anchorMap[t.anchor]=d),h=t.input.charCodeAt(t.position);0!==h;){if(!m&&-1!==t.firstTabInLine&&(t.position=t.firstTabInLine,Hy(t,"tab characters must not be used in indentation")),i=t.input.charCodeAt(t.position+1),a=t.line,63!==h&&58!==h||!$y(i)){if(o=t.line,s=t.lineStart,l=t.position,!cm(t,r,2,!1,!0))break;if(t.line===a){for(h=t.input.charCodeAt(t.position);Fy(h);)h=t.input.charCodeAt(++t.position);if(58===h)$y(h=t.input.charCodeAt(++t.position))||Hy(t,"a whitespace character is expected after the key-value separator within a block mapping"),m&&(Xy(t,d,p,f,g,null,o,s,l),f=g=y=null),x=!0,m=!1,n=!1,f=t.tag,g=t.result;else{if(!x)return t.tag=c,t.anchor=u,!0;Hy(t,"can not read an implicit mapping pair; a colon is missed")}}else{if(!x)return t.tag=c,t.anchor=u,!0;Hy(t,"can not read a block mapping entry; a multiline key may not be an implicit key")}}else 63===h?(m&&(Xy(t,d,p,f,g,null,o,s,l),f=g=y=null),x=!0,m=!0,n=!0):m?(m=!1,n=!0):Hy(t,"incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line"),t.position+=1,h=i;if((t.line===a||t.lineIndent>e)&&(m&&(o=t.line,s=t.lineStart,l=t.position),cm(t,e,4,!0,n)&&(m?g=t.result:y=t.result),m||(Xy(t,d,p,f,g,y,o,s,l),f=g=y=null),Qy(t,!0,-1),h=t.input.charCodeAt(t.position)),(t.line===a||t.lineIndent>e)&&0!==h)Hy(t,"bad indentation of a mapping entry");else if(t.lineIndent<e)break}return m&&Xy(t,d,p,f,g,null,o,s,l),x&&(t.tag=c,t.anchor=u,t.kind="mapping",t.result=d),x}function sm(t){var e,r,i,n,a=!1,o=!1;if(33!==(n=t.input.charCodeAt(t.position)))return!1;if(null!==t.tag&&Hy(t,"duplication of a tag property"),60===(n=t.input.charCodeAt(++t.position))?(a=!0,n=t.input.charCodeAt(++t.position)):33===n?(o=!0,r="!!",n=t.input.charCodeAt(++t.position)):r="!",e=t.position,a){do{n=t.input.charCodeAt(++t.position)}while(0!==n&&62!==n);t.position<t.length?(i=t.input.slice(e,t.position),n=t.input.charCodeAt(++t.position)):Hy(t,"unexpected end of the stream within a verbatim tag")}else{for(;0!==n&&!$y(n);)33===n&&(o?Hy(t,"tag suffix cannot contain exclamation marks"):(r=t.input.slice(e-1,t.position+1),My.test(r)||Hy(t,"named tag handle cannot contain such characters"),o=!0,e=t.position+1)),n=t.input.charCodeAt(++t.position);i=t.input.slice(e,t.position),Ty.test(i)&&Hy(t,"tag suffix cannot contain flow indicator characters")}i&&!By.test(i)&&Hy(t,"tag name cannot contain such characters: "+i);try{i=decodeURIComponent(i)}catch{Hy(t,"tag name is malformed: "+i)}return a?t.tag=i:_y.call(t.tagMap,r)?t.tag=t.tagMap[r]+i:"!"===r?t.tag="!"+i:"!!"===r?t.tag="tag:yaml.org,2002:"+i:Hy(t,'undeclared tag handle "'+r+'"'),!0}function lm(t){var e,r;if(38!==(r=t.input.charCodeAt(t.position)))return!1;for(null!==t.anchor&&Hy(t,"duplication of an anchor property"),r=t.input.charCodeAt(++t.position),e=t.position;0!==r&&!$y(r)&&!Ey(r);)r=t.input.charCodeAt(++t.position);return t.position===e&&Hy(t,"name of an anchor node must contain at least one character"),t.anchor=t.input.slice(e,t.position),!0}function hm(t){var e,r,i;if(42!==(i=t.input.charCodeAt(t.position)))return!1;for(i=t.input.charCodeAt(++t.position),e=t.position;0!==i&&!$y(i)&&!Ey(i);)i=t.input.charCodeAt(++t.position);return t.position===e&&Hy(t,"name of an alias node must contain at least one character"),r=t.input.slice(e,t.position),_y.call(t.anchorMap,r)||Hy(t,'unidentified alias "'+r+'"'),t.result=t.anchorMap[r],Qy(t,!0,-1),!0}function cm(t,e,r,i,n){var a,o,s,l,h,c,u,d,p,f=1,g=!1,y=!1;if(null!==t.listener&&t.listener("open",t),t.tag=null,t.anchor=null,t.kind=null,t.result=null,a=o=s=4===r||3===r,i&&Qy(t,!0,-1)&&(g=!0,t.lineIndent>e?f=1:t.lineIndent===e?f=0:t.lineIndent<e&&(f=-1)),1===f)for(;sm(t)||lm(t);)Qy(t,!0,-1)?(g=!0,s=a,t.lineIndent>e?f=1:t.lineIndent===e?f=0:t.lineIndent<e&&(f=-1)):s=!1;if(s&&(s=g||n),(1===f||4===r)&&(d=1===r||2===r?e:e+1,p=t.position-t.lineStart,1===f?s&&(am(t,p)||om(t,p,d))||im(t,d)?y=!0:(o&&nm(t,d)||em(t,d)||rm(t,d)?y=!0:hm(t)?(y=!0,(null!==t.tag||null!==t.anchor)&&Hy(t,"alias node should not have any properties")):tm(t,d,1===r)&&(y=!0,null===t.tag&&(t.tag="?")),null!==t.anchor&&(t.anchorMap[t.anchor]=t.result)):0===f&&(y=s&&am(t,p))),null===t.tag)null!==t.anchor&&(t.anchorMap[t.anchor]=t.result);else if("?"===t.tag){for(null!==t.result&&"scalar"!==t.kind&&Hy(t,'unacceptable node kind for !<?> tag; it should be "scalar", not "'+t.kind+'"'),l=0,h=t.implicitTypes.length;l<h;l+=1)if((u=t.implicitTypes[l]).resolve(t.result)){t.result=u.construct(t.result),t.tag=u.tag,null!==t.anchor&&(t.anchorMap[t.anchor]=t.result);break}}else if("!"!==t.tag){if(_y.call(t.typeMap[t.kind||"fallback"],t.tag))u=t.typeMap[t.kind||"fallback"][t.tag];else for(u=null,l=0,h=(c=t.typeMap.multi[t.kind||"fallback"]).length;l<h;l+=1)if(t.tag.slice(0,c[l].tag.length)===c[l].tag){u=c[l];break}u||Hy(t,"unknown tag !<"+t.tag+">"),null!==t.result&&u.kind!==t.kind&&Hy(t,"unacceptable node kind for !<"+t.tag+'> tag; it should be "'+u.kind+'", not "'+t.kind+'"'),u.resolve(t.result,t.tag)?(t.result=u.construct(t.result,t.tag),null!==t.anchor&&(t.anchorMap[t.anchor]=t.result)):Hy(t,"cannot resolve a node with !<"+t.tag+"> explicit tag")}return null!==t.listener&&t.listener("close",t),null!==t.tag||null!==t.anchor||y}function um(t){var e,r,i,n,a=t.position,o=!1;for(t.version=null,t.checkLineBreaks=t.legacy,t.tagMap=Object.create(null),t.anchorMap=Object.create(null);0!==(n=t.input.charCodeAt(t.position))&&(Qy(t,!0,-1),n=t.input.charCodeAt(t.position),!(t.lineIndent>0||37!==n));){for(o=!0,n=t.input.charCodeAt(++t.position),e=t.position;0!==n&&!$y(n);)n=t.input.charCodeAt(++t.position);for(i=[],(r=t.input.slice(e,t.position)).length<1&&Hy(t,"directive name must not be less than one character in length");0!==n;){for(;Fy(n);)n=t.input.charCodeAt(++t.position);if(35===n){do{n=t.input.charCodeAt(++t.position)}while(0!==n&&!Ly(n));break}if(Ly(n))break;for(e=t.position;0!==n&&!$y(n);)n=t.input.charCodeAt(++t.position);i.push(t.input.slice(e,t.position))}0!==n&&Zy(t),_y.call(Yy,r)?Yy[r](t,r,i):Uy(t,'unknown document directive "'+r+'"')}Qy(t,!0,-1),0===t.lineIndent&&45===t.input.charCodeAt(t.position)&&45===t.input.charCodeAt(t.position+1)&&45===t.input.charCodeAt(t.position+2)?(t.position+=3,Qy(t,!0,-1)):o&&Hy(t,"directives end mark is expected"),cm(t,t.lineIndent-1,4,!1,!0),Qy(t,!0,-1),t.checkLineBreaks&&Sy.test(t.input.slice(a,t.position))&&Uy(t,"non-ASCII line breaks are interpreted as content"),t.documents.push(t.result),t.position===t.lineStart&&Ky(t)?46===t.input.charCodeAt(t.position)&&(t.position+=3,Qy(t,!0,-1)):t.position<t.length-1&&Hy(t,"end of the stream or a document separator is expected")}function dm(t,e){e=e||{},0!==(t=String(t)).length&&(10!==t.charCodeAt(t.length-1)&&13!==t.charCodeAt(t.length-1)&&(t+="\n"),65279===t.charCodeAt(0)&&(t=t.slice(1)));var r=new jy(t,e),i=t.indexOf("\0");for(-1!==i&&(r.position=i,Hy(r,"null byte is not allowed in input")),r.input+="\0";32===r.input.charCodeAt(r.position);)r.lineIndent+=1,r.position+=1;for(;r.position<r.length-1;)um(r);return r.documents}function pm(t,e){var r=dm(t,e);if(0!==r.length){if(1===r.length)return r[0];throw new sg("expected a single document in the stream, but found more")}}s(Vy,"captureSegment"),s(Gy,"mergeMappings"),s(Xy,"storeMappingPair"),s(Zy,"readLineBreak"),s(Qy,"skipSeparationSpace"),s(Ky,"testDocumentSeparator"),s(Jy,"writeFoldedLines"),s(tm,"readPlainScalar"),s(em,"readSingleQuotedScalar"),s(rm,"readDoubleQuotedScalar"),s(im,"readFlowCollection"),s(nm,"readBlockScalar"),s(am,"readBlockSequence"),s(om,"readBlockMapping"),s(sm,"readTagProperty"),s(lm,"readAnchorProperty"),s(hm,"readAlias"),s(cm,"composeNode"),s(um,"readDocument"),s(dm,"loadDocuments"),s(function(t,e,r){null!==e&&"object"==typeof e&&typeof r>"u"&&(r=e,e=null);var i=dm(t,r);if("function"!=typeof e)return i;for(var n=0,a=i.length;n<a;n+=1)e(i[n])},"loadAll$1"),s(pm,"load$1");var fm={load:pm},gm=Object.prototype.toString,ym=Object.prototype.hasOwnProperty,mm=65279,xm={0:"\\0",7:"\\a",8:"\\b",9:"\\t",10:"\\n",11:"\\v",12:"\\f",13:"\\r",27:"\\e",34:'\\"',92:"\\\\",133:"\\N",160:"\\_",8232:"\\L",8233:"\\P"},bm=["y","Y","yes","Yes","YES","on","On","ON","n","N","no","No","NO","off","Off","OFF"],km=/^[-+]?[0-9_]+(?::[0-9_]+)+(?:\.[0-9_]*)?$/;function Cm(t,e){var r,i,n,a,o,s,l;if(null===e)return{};for(r={},n=0,a=(i=Object.keys(e)).length;n<a;n+=1)o=i[n],s=String(e[o]),"!!"===o.slice(0,2)&&(o="tag:yaml.org,2002:"+o.slice(2)),(l=t.compiledTypeMap.fallback[o])&&ym.call(l.styleAliases,s)&&(s=l.styleAliases[s]),r[o]=s;return r}function wm(t){var e,r,i;if(e=t.toString(16).toUpperCase(),t<=255)r="x",i=2;else if(t<=65535)r="u",i=4;else{if(!(t<=4294967295))throw new sg("code point within a string may not be greater than 0xFFFFFFFF");r="U",i=8}return"\\"+r+ng.repeat("0",i-e.length)+e}s(Cm,"compileStyleMap"),s(wm,"encodeHex");function _m(t){this.schema=t.schema||wy,this.indent=Math.max(1,t.indent||2),this.noArrayIndent=t.noArrayIndent||!1,this.skipInvalid=t.skipInvalid||!1,this.flowLevel=ng.isNothing(t.flowLevel)?-1:t.flowLevel,this.styleMap=Cm(this.schema,t.styles||null),this.sortKeys=t.sortKeys||!1,this.lineWidth=t.lineWidth||80,this.noRefs=t.noRefs||!1,this.noCompatMode=t.noCompatMode||!1,this.condenseFlow=t.condenseFlow||!1,this.quotingType='"'===t.quotingType?2:1,this.forceQuotes=t.forceQuotes||!1,this.replacer="function"==typeof t.replacer?t.replacer:null,this.implicitTypes=this.schema.compiledImplicit,this.explicitTypes=this.schema.compiledExplicit,this.tag=null,this.result="",this.duplicates=[],this.usedDuplicates=null}function vm(t,e){for(var r,i=ng.repeat(" ",e),n=0,a=-1,o="",s=t.length;n<s;)-1===(a=t.indexOf("\n",n))?(r=t.slice(n),n=s):(r=t.slice(n,a+1),n=a+1),r.length&&"\n"!==r&&(o+=i),o+=r;return o}function Sm(t,e){return"\n"+ng.repeat(" ",t.indent*e)}function Tm(t,e){var r,i;for(r=0,i=t.implicitTypes.length;r<i;r+=1)if(t.implicitTypes[r].resolve(e))return!0;return!1}function Mm(t){return 32===t||9===t}function Bm(t){return 32<=t&&t<=126||161<=t&&t<=55295&&8232!==t&&8233!==t||57344<=t&&t<=65533&&t!==mm||65536<=t&&t<=1114111}function Am(t){return Bm(t)&&t!==mm&&13!==t&&10!==t}function Lm(t,e,r){var i=Am(t),n=i&&!Mm(t);return(r?i:i&&44!==t&&91!==t&&93!==t&&123!==t&&125!==t)&&35!==t&&!(58===e&&!n)||Am(e)&&!Mm(e)&&35===t||58===e&&n}function Fm(t){return Bm(t)&&t!==mm&&!Mm(t)&&45!==t&&63!==t&&58!==t&&44!==t&&91!==t&&93!==t&&123!==t&&125!==t&&35!==t&&38!==t&&42!==t&&33!==t&&124!==t&&61!==t&&62!==t&&39!==t&&34!==t&&37!==t&&64!==t&&96!==t}function $m(t){return!Mm(t)&&58!==t}function Em(t,e){var r,i=t.charCodeAt(e);return i>=55296&&i<=56319&&e+1<t.length&&((r=t.charCodeAt(e+1))>=56320&&r<=57343)?1024*(i-55296)+r-56320+65536:i}function Dm(t){return/^\n* /.test(t)}s(_m,"State"),s(vm,"indentString"),s(Sm,"generateNextLine"),s(Tm,"testImplicitResolving"),s(Mm,"isWhitespace"),s(Bm,"isPrintable"),s(Am,"isNsCharOrWhitespace"),s(Lm,"isPlainSafe"),s(Fm,"isPlainSafeFirst"),s($m,"isPlainSafeLast"),s(Em,"codePointAt"),s(Dm,"needIndentIndicator");function Om(t,e,r,i,n,a,o,s){var l,h=0,c=null,u=!1,d=!1,p=-1!==i,f=-1,g=Fm(Em(t,0))&&$m(Em(t,t.length-1));if(e||o)for(l=0;l<t.length;h>=65536?l+=2:l++){if(!Bm(h=Em(t,l)))return 5;g=g&&Lm(h,c,s),c=h}else{for(l=0;l<t.length;h>=65536?l+=2:l++){if(10===(h=Em(t,l)))u=!0,p&&(d=d||l-f-1>i&&" "!==t[f+1],f=l);else if(!Bm(h))return 5;g=g&&Lm(h,c,s),c=h}d=d||p&&l-f-1>i&&" "!==t[f+1]}return u||d?r>9&&Dm(t)?5:o?2===a?5:2:d?4:3:!g||o||n(t)?2===a?5:2:1}function Im(t,e,r,i,n){t.dump=function(){if(0===e.length)return 2===t.quotingType?'""':"''";if(!t.noCompatMode&&(-1!==bm.indexOf(e)||km.test(e)))return 2===t.quotingType?'"'+e+'"':"'"+e+"'";var a=t.indent*Math.max(1,r),o=-1===t.lineWidth?-1:Math.max(Math.min(t.lineWidth,40),t.lineWidth-a),l=i||t.flowLevel>-1&&r>=t.flowLevel;function h(e){return Tm(t,e)}switch(s(h,"testAmbiguity"),Om(e,l,t.indent,o,h,t.quotingType,t.forceQuotes&&!i,n)){case 1:return e;case 2:return"'"+e.replace(/'/g,"''")+"'";case 3:return"|"+Nm(e,t.indent)+Rm(vm(e,a));case 4:return">"+Nm(e,t.indent)+Rm(vm(Pm(e,o),a));case 5:return'"'+qm(e)+'"';default:throw new sg("impossible error: invalid scalar style")}}()}function Nm(t,e){var r=Dm(t)?String(e):"",i="\n"===t[t.length-1];return r+(i&&("\n"===t[t.length-2]||"\n"===t)?"+":i?"":"-")+"\n"}function Rm(t){return"\n"===t[t.length-1]?t.slice(0,-1):t}function Pm(t,e){for(var r,i,n=/(\n+)([^\n]*)/g,a=function(){var r=t.indexOf("\n");return r=-1!==r?r:t.length,n.lastIndex=r,zm(t.slice(0,r),e)}(),o="\n"===t[0]||" "===t[0];i=n.exec(t);){var s=i[1],l=i[2];r=" "===l[0],a+=s+(o||r||""===l?"":"\n")+zm(l,e),o=r}return a}function zm(t,e){if(""===t||" "===t[0])return t;for(var r,i,n=/ [^ ]/g,a=0,o=0,s=0,l="";r=n.exec(t);)(s=r.index)-a>e&&(i=o>a?o:s,l+="\n"+t.slice(a,i),a=i+1),o=s;return l+="\n",t.length-a>e&&o>a?l+=t.slice(a,o)+"\n"+t.slice(o+1):l+=t.slice(a),l.slice(1)}function qm(t){for(var e,r="",i=0,n=0;n<t.length;i>=65536?n+=2:n++)i=Em(t,n),!(e=xm[i])&&Bm(i)?(r+=t[n],i>=65536&&(r+=t[n+1])):r+=e||wm(i);return r}function jm(t,e,r){var i,n,a,o="",s=t.tag;for(i=0,n=r.length;i<n;i+=1)a=r[i],t.replacer&&(a=t.replacer.call(r,String(i),a)),(Vm(t,e,a,!1,!1)||typeof a>"u"&&Vm(t,e,null,!1,!1))&&(""!==o&&(o+=","+(t.condenseFlow?"":" ")),o+=t.dump);t.tag=s,t.dump="["+o+"]"}function Wm(t,e,r,i){var n,a,o,s="",l=t.tag;for(n=0,a=r.length;n<a;n+=1)o=r[n],t.replacer&&(o=t.replacer.call(r,String(n),o)),(Vm(t,e+1,o,!0,!0,!1,!0)||typeof o>"u"&&Vm(t,e+1,null,!0,!0,!1,!0))&&((!i||""!==s)&&(s+=Sm(t,e)),t.dump&&10===t.dump.charCodeAt(0)?s+="-":s+="- ",s+=t.dump);t.tag=l,t.dump=s||"[]"}function Hm(t,e,r){var i,n,a,o,s,l="",h=t.tag,c=Object.keys(r);for(i=0,n=c.length;i<n;i+=1)s="",""!==l&&(s+=", "),t.condenseFlow&&(s+='"'),o=r[a=c[i]],t.replacer&&(o=t.replacer.call(r,a,o)),Vm(t,e,a,!1,!1)&&(t.dump.length>1024&&(s+="? "),s+=t.dump+(t.condenseFlow?'"':"")+":"+(t.condenseFlow?"":" "),Vm(t,e,o,!1,!1)&&(l+=s+=t.dump));t.tag=h,t.dump="{"+l+"}"}function Um(t,e,r,i){var n,a,o,s,l,h,c="",u=t.tag,d=Object.keys(r);if(!0===t.sortKeys)d.sort();else if("function"==typeof t.sortKeys)d.sort(t.sortKeys);else if(t.sortKeys)throw new sg("sortKeys must be a boolean or a function");for(n=0,a=d.length;n<a;n+=1)h="",(!i||""!==c)&&(h+=Sm(t,e)),s=r[o=d[n]],t.replacer&&(s=t.replacer.call(r,o,s)),Vm(t,e+1,o,!0,!0,!0)&&((l=null!==t.tag&&"?"!==t.tag||t.dump&&t.dump.length>1024)&&(t.dump&&10===t.dump.charCodeAt(0)?h+="?":h+="? "),h+=t.dump,l&&(h+=Sm(t,e)),Vm(t,e+1,s,!0,l)&&(t.dump&&10===t.dump.charCodeAt(0)?h+=":":h+=": ",c+=h+=t.dump));t.tag=u,t.dump=c||"{}"}function Ym(t,e,r){var i,n,a,o,s,l;for(a=0,o=(n=r?t.explicitTypes:t.implicitTypes).length;a<o;a+=1)if(((s=n[a]).instanceOf||s.predicate)&&(!s.instanceOf||"object"==typeof e&&e instanceof s.instanceOf)&&(!s.predicate||s.predicate(e))){if(r?s.multi&&s.representName?t.tag=s.representName(e):t.tag=s.tag:t.tag="?",s.represent){if(l=t.styleMap[s.tag]||s.defaultStyle,"[object Function]"===gm.call(s.represent))i=s.represent(e,l);else{if(!ym.call(s.represent,l))throw new sg("!<"+s.tag+'> tag resolver accepts not "'+l+'" style');i=s.represent[l](e,l)}t.dump=i}return!0}return!1}function Vm(t,e,r,i,n,a,o){t.tag=null,t.dump=r,Ym(t,r,!1)||Ym(t,r,!0);var s,l=gm.call(t.dump),h=i;i&&(i=t.flowLevel<0||t.flowLevel>e);var c,u,d="[object Object]"===l||"[object Array]"===l;if(d&&(u=-1!==(c=t.duplicates.indexOf(r))),(null!==t.tag&&"?"!==t.tag||u||2!==t.indent&&e>0)&&(n=!1),u&&t.usedDuplicates[c])t.dump="*ref_"+c;else{if(d&&u&&!t.usedDuplicates[c]&&(t.usedDuplicates[c]=!0),"[object Object]"===l)i&&0!==Object.keys(t.dump).length?(Um(t,e,t.dump,n),u&&(t.dump="&ref_"+c+t.dump)):(Hm(t,e,t.dump),u&&(t.dump="&ref_"+c+" "+t.dump));else if("[object Array]"===l)i&&0!==t.dump.length?(t.noArrayIndent&&!o&&e>0?Wm(t,e-1,t.dump,n):Wm(t,e,t.dump,n),u&&(t.dump="&ref_"+c+t.dump)):(jm(t,e,t.dump),u&&(t.dump="&ref_"+c+" "+t.dump));else{if("[object String]"!==l){if("[object Undefined]"===l)return!1;if(t.skipInvalid)return!1;throw new sg("unacceptable kind of an object to dump "+l)}"?"!==t.tag&&Im(t,t.dump,e,a,h)}null!==t.tag&&"?"!==t.tag&&(s=encodeURI("!"===t.tag[0]?t.tag.slice(1):t.tag).replace(/!/g,"%21"),s="!"===t.tag[0]?"!"+s:"tag:yaml.org,2002:"===s.slice(0,18)?"!!"+s.slice(18):"!<"+s+">",t.dump=s+" "+t.dump)}return!0}function Gm(t,e){var r,i,n=[],a=[];for(Xm(t,n,a),r=0,i=a.length;r<i;r+=1)e.duplicates.push(n[a[r]]);e.usedDuplicates=new Array(i)}function Xm(t,e,r){var i,n,a;if(null!==t&&"object"==typeof t)if(-1!==(n=e.indexOf(t)))-1===r.indexOf(n)&&r.push(n);else if(e.push(t),Array.isArray(t))for(n=0,a=t.length;n<a;n+=1)Xm(t[n],e,r);else for(n=0,a=(i=Object.keys(t)).length;n<a;n+=1)Xm(t[i[n]],e,r)}s(Om,"chooseScalarStyle"),s(Im,"writeScalar"),s(Nm,"blockHeader"),s(Rm,"dropEndingNewline"),s(Pm,"foldString"),s(zm,"foldLine"),s(qm,"escapeString"),s(jm,"writeFlowSequence"),s(Wm,"writeBlockSequence"),s(Hm,"writeFlowMapping"),s(Um,"writeBlockMapping"),s(Ym,"detectType"),s(Vm,"writeNode"),s(Gm,"getDuplicateReferences"),s(Xm,"inspectNode"),s(function(t,e){var r=new _m(e=e||{});r.noRefs||Gm(t,r);var i=t;return r.replacer&&(i=r.replacer.call({"":i},"",i)),Vm(r,0,i,!0,!0)?r.dump+"\n":""},"dump$1"),s(function(t,e){return function(){throw new Error("Function yaml."+t+" is removed in js-yaml 4. Use yaml."+e+" instead, which is now safe by default.")}},"renamed");var Zm=Vg,Qm=fm.load,Km={aggregation:17.25,extension:17.25,composition:17.25,dependency:6,lollipop:13.5,arrow_point:4},Jm={arrow_point:9,arrow_cross:12.5,arrow_circle:12.5};function tx(t,e){if(void 0===t||void 0===e)return{angle:0,deltaX:0,deltaY:0};t=ex(t),e=ex(e);let[r,i]=[t.x,t.y],[n,a]=[e.x,e.y],o=n-r,s=a-i;return{angle:Math.atan(s/o),deltaX:o,deltaY:s}}s(tx,"calculateDeltaAndAngle");var ex=s(t=>Array.isArray(t)?{x:t[0],y:t[1]}:t,"pointTransformer"),rx=s(t=>({x:s(function(e,r,i){let n=0,a=ex(i[0]).x<ex(i[i.length-1]).x?"left":"right";if(0===r&&Object.hasOwn(Km,t.arrowTypeStart)){let{angle:e,deltaX:r}=tx(i[0],i[1]);n=Km[t.arrowTypeStart]*Math.cos(e)*(r>=0?1:-1)}else if(r===i.length-1&&Object.hasOwn(Km,t.arrowTypeEnd)){let{angle:e,deltaX:r}=tx(i[i.length-1],i[i.length-2]);n=Km[t.arrowTypeEnd]*Math.cos(e)*(r>=0?1:-1)}let o=Math.abs(ex(e).x-ex(i[i.length-1]).x),s=Math.abs(ex(e).y-ex(i[i.length-1]).y),l=Math.abs(ex(e).x-ex(i[0]).x),h=Math.abs(ex(e).y-ex(i[0]).y),c=Km[t.arrowTypeStart],u=Km[t.arrowTypeEnd];if(o<u&&o>0&&s<u){let t=u+1-o;t*="right"===a?-1:1,n-=t}if(l<c&&l>0&&h<c){let t=c+1-l;t*="right"===a?-1:1,n+=t}return ex(e).x+n},"x"),y:s(function(e,r,i){let n=0,a=ex(i[0]).y<ex(i[i.length-1]).y?"down":"up";if(0===r&&Object.hasOwn(Km,t.arrowTypeStart)){let{angle:e,deltaY:r}=tx(i[0],i[1]);n=Km[t.arrowTypeStart]*Math.abs(Math.sin(e))*(r>=0?1:-1)}else if(r===i.length-1&&Object.hasOwn(Km,t.arrowTypeEnd)){let{angle:e,deltaY:r}=tx(i[i.length-1],i[i.length-2]);n=Km[t.arrowTypeEnd]*Math.abs(Math.sin(e))*(r>=0?1:-1)}let o=Math.abs(ex(e).y-ex(i[i.length-1]).y),s=Math.abs(ex(e).x-ex(i[i.length-1]).x),l=Math.abs(ex(e).y-ex(i[0]).y),h=Math.abs(ex(e).x-ex(i[0]).x),c=Km[t.arrowTypeStart],u=Km[t.arrowTypeEnd];if(o<u&&o>0&&s<u){let t=u+1-o;t*="up"===a?-1:1,n-=t}if(l<c&&l>0&&h<c){let t=c+1-l;t*="up"===a?-1:1,n+=t}return ex(e).y+n},"y")}),"getLineFunctionsWithOffset"),ix=s(({flowchart:t})=>{let e=t?.subGraphTitleMargin?.top??0,r=t?.subGraphTitleMargin?.bottom??0;return{subGraphTitleTopMargin:e,subGraphTitleBottomMargin:r,subGraphTitleTotalMargin:e+r}},"getSubGraphTitleMargins"),nx=s(t=>{let{handDrawnSeed:e}=qf();return{fill:t,hachureAngle:120,hachureGap:4,fillWeight:2,roughness:.7,stroke:t,seed:e}},"solidStateFill"),ax=s(t=>{let e=ox([...t.cssCompiledStyles||[],...t.cssStyles||[],...t.labelStyle||[]]);return{stylesMap:e,stylesArray:[...e]}},"compileStyles"),ox=s(t=>{let e=new Map;return t.forEach(t=>{let[r,i]=t.split(":");e.set(r.trim(),i?.trim())}),e},"styles2Map"),sx=s(t=>"color"===t||"font-size"===t||"font-family"===t||"font-weight"===t||"font-style"===t||"text-decoration"===t||"text-align"===t||"text-transform"===t||"line-height"===t||"letter-spacing"===t||"word-spacing"===t||"text-shadow"===t||"text-overflow"===t||"white-space"===t||"word-wrap"===t||"word-break"===t||"overflow-wrap"===t||"hyphens"===t,"isLabelStyle"),lx=s(t=>{let{stylesArray:e}=ax(t),r=[],i=[],n=[],a=[];return e.forEach(t=>{let e=t[0];sx(e)?r.push(t.join(":")+" !important"):(i.push(t.join(":")+" !important"),e.includes("stroke")&&n.push(t.join(":")+" !important"),"fill"===e&&a.push(t.join(":")+" !important"))}),{labelStyles:r.join(";"),nodeStyles:i.join(";"),stylesArray:e,borderStyles:n,backgroundStyles:a}},"styles2String"),hx=s((t,e)=>{let{themeVariables:r,handDrawnSeed:i}=qf(),{nodeBorder:n,mainBkg:a}=r,{stylesMap:o}=ax(t);return Object.assign({roughness:.7,fill:o.get("fill")||a,fillStyle:"hachure",fillWeight:4,hachureGap:5.2,stroke:o.get("stroke")||n,seed:i,strokeWidth:o.get("stroke-width")?.replace("px","")||1.3,fillLineDash:[0,0],strokeLineDash:cx(o.get("stroke-dasharray"))},e)},"userNodeOverrides"),cx=s(t=>{if(!t)return[0,0];let e=t.trim().split(/\s+/).map(Number);if(1===e.length){let t=isNaN(e[0])?0:e[0];return[t,t]}return[isNaN(e[0])?0:e[0],isNaN(e[1])?0:e[1]]},"getStrokeDashArray"),ux=l(t=>{Object.defineProperty(t,"__esModule",{value:!0}),t.BLANK_URL=t.relativeFirstCharacters=t.whitespaceEscapeCharsRegex=t.urlSchemeRegex=t.ctrlCharactersRegex=t.htmlCtrlEntityRegex=t.htmlEntitiesRegex=t.invalidProtocolRegex=void 0,t.invalidProtocolRegex=/^([^\w]*)(javascript|data|vbscript)/im,t.htmlEntitiesRegex=/&#(\w+)(^\w|;)?/g,t.htmlCtrlEntityRegex=/&(newline|tab);/gi,t.ctrlCharactersRegex=/[\u0000-\u001F\u007F-\u009F\u2000-\u200D\uFEFF]/gim,t.urlSchemeRegex=/^.+(:|&colon;)/gim,t.whitespaceEscapeCharsRegex=/(\\|%5[cC])((%(6[eE]|72|74))|[nrt])/g,t.relativeFirstCharacters=[".","/"],t.BLANK_URL="about:blank"}),dx=l(t=>{Object.defineProperty(t,"__esModule",{value:!0}),t.sanitizeUrl=void 0;var e=ux();function r(t){return e.relativeFirstCharacters.indexOf(t[0])>-1}function i(t){return t.replace(e.ctrlCharactersRegex,"").replace(e.htmlEntitiesRegex,function(t,e){return String.fromCharCode(e)})}function n(t){return URL.canParse(t)}function a(t){try{return decodeURIComponent(t)}catch{return t}}function o(t){if(!t)return e.BLANK_URL;var o,s=a(t.trim());do{o=(s=a(s=i(s).replace(e.htmlCtrlEntityRegex,"").replace(e.ctrlCharactersRegex,"").replace(e.whitespaceEscapeCharsRegex,"").trim())).match(e.ctrlCharactersRegex)||s.match(e.htmlEntitiesRegex)||s.match(e.htmlCtrlEntityRegex)||s.match(e.whitespaceEscapeCharsRegex)}while(o&&o.length>0);var l=s;if(!l)return e.BLANK_URL;if(r(l))return l;var h=l.trimStart(),c=h.match(e.urlSchemeRegex);if(!c)return l;var u=c[0].toLowerCase().trim();if(e.invalidProtocolRegex.test(u))return e.BLANK_URL;var d=h.replace(/\\/g,"/");if("mailto:"===u||u.includes("://"))return d;if("http:"===u||"https:"===u){if(!n(d))return e.BLANK_URL;var p=new URL(d);return p.protocol=p.protocol.toLowerCase(),p.hostname=p.hostname.toLowerCase(),p.toString()}return d}s(r,"isRelativeUrlWithoutProtocol"),s(i,"decodeHtmlCharacters"),s(n,"isValidUrl"),s(a,"decodeURI"),s(o,"sanitizeUrl"),t.sanitizeUrl=o}),px="object"==typeof global&&global&&global.Object===Object&&global,fx="object"==typeof self&&self&&self.Object===Object&&self,gx=px||fx||Function("return this")(),yx=gx.Symbol,mx=Object.prototype,xx=mx.hasOwnProperty,bx=mx.toString,kx=yx?yx.toStringTag:void 0;function Cx(t){var e=xx.call(t,kx),r=t[kx];try{t[kx]=void 0;var i=!0}catch{}var n=bx.call(t);return i&&(e?t[kx]=r:delete t[kx]),n}s(Cx,"getRawTag");var wx=Cx,_x=Object.prototype.toString;function vx(t){return _x.call(t)}s(vx,"objectToString");var Sx=vx,Tx=yx?yx.toStringTag:void 0;function Mx(t){return null==t?void 0===t?"[object Undefined]":"[object Null]":Tx&&Tx in Object(t)?wx(t):Sx(t)}s(Mx,"baseGetTag");var Bx=Mx;function Ax(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}s(Ax,"isObject");var Lx=Ax;function Fx(t){if(!Lx(t))return!1;var e=Bx(t);return"[object Function]"==e||"[object GeneratorFunction]"==e||"[object AsyncFunction]"==e||"[object Proxy]"==e}s(Fx,"isFunction");var $x=Fx,Ex=gx["__core-js_shared__"],Dx=function(){var t=/[^.]+$/.exec(Ex&&Ex.keys&&Ex.keys.IE_PROTO||"");return t?"Symbol(src)_1."+t:""}();function Ox(t){return!!Dx&&Dx in t}s(Ox,"isMasked");var Ix=Ox,Nx=Function.prototype.toString;function Rx(t){if(null!=t){try{return Nx.call(t)}catch{}try{return t+""}catch{}}return""}s(Rx,"toSource");var Px=Rx,zx=/^\[object .+?Constructor\]$/,qx=Function.prototype,jx=Object.prototype,Wx=qx.toString,Hx=jx.hasOwnProperty,Ux=RegExp("^"+Wx.call(Hx).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");function Yx(t){return!(!Lx(t)||Ix(t))&&($x(t)?Ux:zx).test(Px(t))}s(Yx,"baseIsNative");var Vx=Yx;function Gx(t,e){return t?.[e]}s(Gx,"getValue");var Xx=Gx;function Zx(t,e){var r=Xx(t,e);return Vx(r)?r:void 0}s(Zx,"getNative");var Qx=Zx,Kx=Qx(Object,"create");function Jx(){this.__data__=Kx?Kx(null):{},this.size=0}s(Jx,"hashClear");var tb=Jx;function eb(t){var e=this.has(t)&&delete this.__data__[t];return this.size-=e?1:0,e}s(eb,"hashDelete");var rb=eb,ib=Object.prototype.hasOwnProperty;function nb(t){var e=this.__data__;if(Kx){var r=e[t];return"__lodash_hash_undefined__"===r?void 0:r}return ib.call(e,t)?e[t]:void 0}s(nb,"hashGet");var ab=nb,ob=Object.prototype.hasOwnProperty;function sb(t){var e=this.__data__;return Kx?void 0!==e[t]:ob.call(e,t)}s(sb,"hashHas");var lb=sb;function hb(t,e){var r=this.__data__;return this.size+=this.has(t)?0:1,r[t]=Kx&&void 0===e?"__lodash_hash_undefined__":e,this}s(hb,"hashSet");var cb=hb;function ub(t){var e=-1,r=null==t?0:t.length;for(this.clear();++e<r;){var i=t[e];this.set(i[0],i[1])}}s(ub,"Hash"),ub.prototype.clear=tb,ub.prototype.delete=rb,ub.prototype.get=ab,ub.prototype.has=lb,ub.prototype.set=cb;var db=ub;function pb(){this.__data__=[],this.size=0}s(pb,"listCacheClear");var fb=pb;function gb(t,e){return t===e||t!=t&&e!=e}s(gb,"eq");var yb=gb;function mb(t,e){for(var r=t.length;r--;)if(yb(t[r][0],e))return r;return-1}s(mb,"assocIndexOf");var xb=mb,bb=Array.prototype.splice;function kb(t){var e=this.__data__,r=xb(e,t);return!(r<0)&&(r==e.length-1?e.pop():bb.call(e,r,1),--this.size,!0)}s(kb,"listCacheDelete");var Cb=kb;function wb(t){var e=this.__data__,r=xb(e,t);return r<0?void 0:e[r][1]}s(wb,"listCacheGet");var _b=wb;function vb(t){return xb(this.__data__,t)>-1}s(vb,"listCacheHas");var Sb=vb;function Tb(t,e){var r=this.__data__,i=xb(r,t);return i<0?(++this.size,r.push([t,e])):r[i][1]=e,this}s(Tb,"listCacheSet");var Mb=Tb;function Bb(t){var e=-1,r=null==t?0:t.length;for(this.clear();++e<r;){var i=t[e];this.set(i[0],i[1])}}s(Bb,"ListCache"),Bb.prototype.clear=fb,Bb.prototype.delete=Cb,Bb.prototype.get=_b,Bb.prototype.has=Sb,Bb.prototype.set=Mb;var Ab=Bb,Lb=Qx(gx,"Map");function Fb(){this.size=0,this.__data__={hash:new db,map:new(Lb||Ab),string:new db}}s(Fb,"mapCacheClear");var $b=Fb;function Eb(t){var e=typeof t;return"string"==e||"number"==e||"symbol"==e||"boolean"==e?"__proto__"!==t:null===t}s(Eb,"isKeyable");var Db=Eb;function Ob(t,e){var r=t.__data__;return Db(e)?r["string"==typeof e?"string":"hash"]:r.map}s(Ob,"getMapData");var Ib=Ob;function Nb(t){var e=Ib(this,t).delete(t);return this.size-=e?1:0,e}s(Nb,"mapCacheDelete");var Rb=Nb;function Pb(t){return Ib(this,t).get(t)}s(Pb,"mapCacheGet");var zb=Pb;function qb(t){return Ib(this,t).has(t)}s(qb,"mapCacheHas");var jb=qb;function Wb(t,e){var r=Ib(this,t),i=r.size;return r.set(t,e),this.size+=r.size==i?0:1,this}s(Wb,"mapCacheSet");var Hb=Wb;function Ub(t){var e=-1,r=null==t?0:t.length;for(this.clear();++e<r;){var i=t[e];this.set(i[0],i[1])}}s(Ub,"MapCache"),Ub.prototype.clear=$b,Ub.prototype.delete=Rb,Ub.prototype.get=zb,Ub.prototype.has=jb,Ub.prototype.set=Hb;var Yb=Ub;function Vb(t,e){if("function"!=typeof t||null!=e&&"function"!=typeof e)throw new TypeError("Expected a function");var r=s(function(){var i=arguments,n=e?e.apply(this,i):i[0],a=r.cache;if(a.has(n))return a.get(n);var o=t.apply(this,i);return r.cache=a.set(n,o)||a,o},"memoized");return r.cache=new(Vb.Cache||Yb),r}s(Vb,"memoize"),Vb.Cache=Yb;var Gb=Vb;function Xb(t){return function(){return t}}s(Xb,"constant");var Zb=Xb;function Qb(){this.__data__=new Ab,this.size=0}s(Qb,"stackClear");var Kb=Qb;function Jb(t){var e=this.__data__,r=e.delete(t);return this.size=e.size,r}s(Jb,"stackDelete");var tk=Jb;function ek(t){return this.__data__.get(t)}s(ek,"stackGet");var rk=ek;function ik(t){return this.__data__.has(t)}s(ik,"stackHas");var nk=ik;function ak(t,e){var r=this.__data__;if(r instanceof Ab){var i=r.__data__;if(!Lb||i.length<199)return i.push([t,e]),this.size=++r.size,this;r=this.__data__=new Yb(i)}return r.set(t,e),this.size=r.size,this}s(ak,"stackSet");var ok=ak;function sk(t){var e=this.__data__=new Ab(t);this.size=e.size}s(sk,"Stack"),sk.prototype.clear=Kb,sk.prototype.delete=tk,sk.prototype.get=rk,sk.prototype.has=nk,sk.prototype.set=ok;var lk=sk,hk=function(){try{var t=Qx(Object,"defineProperty");return t({},"",{}),t}catch{}}(),ck=hk;function uk(t,e,r){"__proto__"==e&&ck?ck(t,e,{configurable:!0,enumerable:!0,value:r,writable:!0}):t[e]=r}s(uk,"baseAssignValue");var dk=uk;function pk(t,e,r){(void 0!==r&&!yb(t[e],r)||void 0===r&&!(e in t))&&dk(t,e,r)}s(pk,"assignMergeValue");var fk=pk;function gk(t){return function(e,r,i){for(var n=-1,a=Object(e),o=i(e),s=o.length;s--;){var l=o[t?s:++n];if(!1===r(a[l],l,a))break}return e}}s(gk,"createBaseFor");var yk=gk(),mk="object"==typeof exports&&exports&&!exports.nodeType&&exports,xk=mk&&"object"==typeof module&&module&&!module.nodeType&&module,bk=xk&&xk.exports===mk?gx.Buffer:void 0,kk=bk?bk.allocUnsafe:void 0;function Ck(t,e){if(e)return t.slice();var r=t.length,i=kk?kk(r):new t.constructor(r);return t.copy(i),i}s(Ck,"cloneBuffer");var wk=Ck,_k=gx.Uint8Array;function vk(t){var e=new t.constructor(t.byteLength);return new _k(e).set(new _k(t)),e}s(vk,"cloneArrayBuffer");var Sk=vk;function Tk(t,e){var r=e?Sk(t.buffer):t.buffer;return new t.constructor(r,t.byteOffset,t.length)}s(Tk,"cloneTypedArray");var Mk=Tk;function Bk(t,e){var r=-1,i=t.length;for(e||(e=Array(i));++r<i;)e[r]=t[r];return e}s(Bk,"copyArray");var Ak=Bk,Lk=Object.create,Fk=function(){function t(){}return s(t,"object"),function(e){if(!Lx(e))return{};if(Lk)return Lk(e);t.prototype=e;var r=new t;return t.prototype=void 0,r}}(),$k=Fk;function Ek(t,e){return function(r){return t(e(r))}}s(Ek,"overArg");var Dk=Ek,Ok=Dk(Object.getPrototypeOf,Object),Ik=Object.prototype;function Nk(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||Ik)}s(Nk,"isPrototype");var Rk=Nk;function Pk(t){return"function"!=typeof t.constructor||Rk(t)?{}:$k(Ok(t))}s(Pk,"initCloneObject");var zk=Pk;function qk(t){return null!=t&&"object"==typeof t}s(qk,"isObjectLike");var jk=qk;function Wk(t){return jk(t)&&"[object Arguments]"==Bx(t)}s(Wk,"baseIsArguments");var Hk=Wk,Uk=Object.prototype,Yk=Uk.hasOwnProperty,Vk=Uk.propertyIsEnumerable,Gk=Hk(function(){return arguments}())?Hk:function(t){return jk(t)&&Yk.call(t,"callee")&&!Vk.call(t,"callee")},Xk=Gk,Zk=Array.isArray;function Qk(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=9007199254740991}s(Qk,"isLength");var Kk=Qk;function Jk(t){return null!=t&&Kk(t.length)&&!$x(t)}s(Jk,"isArrayLike");var tC=Jk;function eC(t){return jk(t)&&tC(t)}s(eC,"isArrayLikeObject");var rC=eC;function iC(){return!1}s(iC,"stubFalse");var nC=iC,aC="object"==typeof exports&&exports&&!exports.nodeType&&exports,oC=aC&&"object"==typeof module&&module&&!module.nodeType&&module,sC=oC&&oC.exports===aC?gx.Buffer:void 0,lC=(sC?sC.isBuffer:void 0)||nC,hC=Function.prototype,cC=Object.prototype,uC=hC.toString,dC=cC.hasOwnProperty,pC=uC.call(Object);function fC(t){if(!jk(t)||"[object Object]"!=Bx(t))return!1;var e=Ok(t);if(null===e)return!0;var r=dC.call(e,"constructor")&&e.constructor;return"function"==typeof r&&r instanceof r&&uC.call(r)==pC}s(fC,"isPlainObject");var gC=fC,yC={};function mC(t){return jk(t)&&Kk(t.length)&&!!yC[Bx(t)]}yC["[object Float32Array]"]=yC["[object Float64Array]"]=yC["[object Int8Array]"]=yC["[object Int16Array]"]=yC["[object Int32Array]"]=yC["[object Uint8Array]"]=yC["[object Uint8ClampedArray]"]=yC["[object Uint16Array]"]=yC["[object Uint32Array]"]=!0,yC["[object Arguments]"]=yC["[object Array]"]=yC["[object ArrayBuffer]"]=yC["[object Boolean]"]=yC["[object DataView]"]=yC["[object Date]"]=yC["[object Error]"]=yC["[object Function]"]=yC["[object Map]"]=yC["[object Number]"]=yC["[object Object]"]=yC["[object RegExp]"]=yC["[object Set]"]=yC["[object String]"]=yC["[object WeakMap]"]=!1,s(mC,"baseIsTypedArray");var xC=mC;function bC(t){return function(e){return t(e)}}s(bC,"baseUnary");var kC=bC,CC="object"==typeof exports&&exports&&!exports.nodeType&&exports,wC=CC&&"object"==typeof module&&module&&!module.nodeType&&module,_C=wC&&wC.exports===CC&&px.process,vC=function(){try{return wC&&wC.require&&wC.require("util").types||_C&&_C.binding&&_C.binding("util")}catch{}}(),SC=vC&&vC.isTypedArray,TC=SC?kC(SC):xC;function MC(t,e){if(("constructor"!==e||"function"!=typeof t[e])&&"__proto__"!=e)return t[e]}s(MC,"safeGet");var BC=MC,AC=Object.prototype.hasOwnProperty;function LC(t,e,r){var i=t[e];(!AC.call(t,e)||!yb(i,r)||void 0===r&&!(e in t))&&dk(t,e,r)}s(LC,"assignValue");var FC=LC;function $C(t,e,r,i){var n=!r;r||(r={});for(var a=-1,o=e.length;++a<o;){var s=e[a],l=i?i(r[s],t[s],s,r,t):void 0;void 0===l&&(l=t[s]),n?dk(r,s,l):FC(r,s,l)}return r}s($C,"copyObject");var EC=$C;function DC(t,e){for(var r=-1,i=Array(t);++r<t;)i[r]=e(r);return i}s(DC,"baseTimes");var OC=DC,IC=/^(?:0|[1-9]\d*)$/;function NC(t,e){var r=typeof t;return!!(e=e??9007199254740991)&&("number"==r||"symbol"!=r&&IC.test(t))&&t>-1&&t%1==0&&t<e}s(NC,"isIndex");var RC=NC,PC=Object.prototype.hasOwnProperty;function zC(t,e){var r=Zk(t),i=!r&&Xk(t),n=!r&&!i&&lC(t),a=!r&&!i&&!n&&TC(t),o=r||i||n||a,s=o?OC(t.length,String):[],l=s.length;for(var h in t)(e||PC.call(t,h))&&(!o||!("length"==h||n&&("offset"==h||"parent"==h)||a&&("buffer"==h||"byteLength"==h||"byteOffset"==h)||RC(h,l)))&&s.push(h);return s}s(zC,"arrayLikeKeys");var qC=zC;function jC(t){var e=[];if(null!=t)for(var r in Object(t))e.push(r);return e}s(jC,"nativeKeysIn");var WC=jC,HC=Object.prototype.hasOwnProperty;function UC(t){if(!Lx(t))return WC(t);var e=Rk(t),r=[];for(var i in t)"constructor"==i&&(e||!HC.call(t,i))||r.push(i);return r}s(UC,"baseKeysIn");var YC=UC;function VC(t){return tC(t)?qC(t,!0):YC(t)}s(VC,"keysIn");var GC=VC;function XC(t){return EC(t,GC(t))}s(XC,"toPlainObject");var ZC=XC;function QC(t,e,r,i,n,a,o){var s=BC(t,r),l=BC(e,r),h=o.get(l);if(h)fk(t,r,h);else{var c=a?a(s,l,r+"",t,e,o):void 0,u=void 0===c;if(u){var d=Zk(l),p=!d&&lC(l),f=!d&&!p&&TC(l);c=l,d||p||f?Zk(s)?c=s:rC(s)?c=Ak(s):p?(u=!1,c=wk(l,!0)):f?(u=!1,c=Mk(l,!0)):c=[]:gC(l)||Xk(l)?(c=s,Xk(s)?c=ZC(s):(!Lx(s)||$x(s))&&(c=zk(l))):u=!1}u&&(o.set(l,c),n(c,l,i,a,o),o.delete(l)),fk(t,r,c)}}s(QC,"baseMergeDeep");var KC=QC;function JC(t,e,r,i,n){t!==e&&yk(e,function(a,o){if(n||(n=new lk),Lx(a))KC(t,e,o,r,JC,i,n);else{var s=i?i(BC(t,o),a,o+"",t,e,n):void 0;void 0===s&&(s=a),fk(t,o,s)}},GC)}s(JC,"baseMerge");var tw=JC;function ew(t){return t}s(ew,"identity");var rw=ew;function iw(t,e,r){switch(r.length){case 0:return t.call(e);case 1:return t.call(e,r[0]);case 2:return t.call(e,r[0],r[1]);case 3:return t.call(e,r[0],r[1],r[2])}return t.apply(e,r)}s(iw,"apply");var nw=iw,aw=Math.max;function ow(t,e,r){return e=aw(void 0===e?t.length-1:e,0),function(){for(var i=arguments,n=-1,a=aw(i.length-e,0),o=Array(a);++n<a;)o[n]=i[e+n];n=-1;for(var s=Array(e+1);++n<e;)s[n]=i[n];return s[e]=r(o),nw(t,this,s)}}s(ow,"overRest");var sw=ow,lw=ck?function(t,e){return ck(t,"toString",{configurable:!0,enumerable:!1,value:Zb(e),writable:!0})}:rw,hw=lw,cw=Date.now;function uw(t){var e=0,r=0;return function(){var i=cw(),n=16-(i-r);if(r=i,n>0){if(++e>=800)return arguments[0]}else e=0;return t.apply(void 0,arguments)}}s(uw,"shortOut");var dw=uw(hw);function pw(t,e){return dw(sw(t,e,rw),t+"")}s(pw,"baseRest");var fw=pw;function gw(t,e,r){if(!Lx(r))return!1;var i=typeof e;return!!("number"==i?tC(r)&&RC(e,r.length):"string"==i&&e in r)&&yb(r[e],t)}s(gw,"isIterateeCall");var yw=gw;function mw(t){return fw(function(e,r){var i=-1,n=r.length,a=n>1?r[n-1]:void 0,o=n>2?r[2]:void 0;for(a=t.length>3&&"function"==typeof a?(n--,a):void 0,o&&yw(r[0],r[1],o)&&(a=n<3?void 0:a,n=1),e=Object(e);++i<n;){var s=r[i];s&&t(e,s,i,a)}return e})}s(mw,"createAssigner");var xw=mw,bw=xw(function(t,e,r){tw(t,e,r)}),kw=bw,Cw=d(dx()),ww="​",_w={curveBasis:ll,curveBasisClosed:ul,curveBasisOpen:pl,curveBumpX:nl,curveBumpY:al,curveBundle:gl,curveCardinalClosed:kl,curveCardinalOpen:wl,curveCardinal:xl,curveCatmullRomClosed:Ml,curveCatmullRomOpen:Al,curveCatmullRom:Sl,curveLinear:Xs,curveLinearClosed:Fl,curveMonotoneX:Pl,curveMonotoneY:zl,curveNatural:Wl,curveStep:Ul,curveStepAfter:Vl,curveStepBefore:Yl},vw=/\s*(?:(\w+)(?=:):|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi,Sw=s(function(t,e){let r=Tw(t,/(?:init\b)|(?:initialize\b)/),i={};if(Array.isArray(r)){let t=r.map(t=>t.args);yd(t),i=eu(i,[...t])}else i=r.args;if(!i)return;let n=Zc(t,e),a="config";return void 0!==i[a]&&("flowchart-v2"===n&&(n="flowchart"),i[n]=i[a],delete i[a]),i},"detectInit"),Tw=s(function(t,e=null){try{let r=new RegExp(`[%]{2}(?![{]${vw.source})(?=[}][%]{2}).*\n`,"ig");t=t.trim().replace(r,"").replace(/'/gm,'"'),y.debug(`Detecting diagram directive${null!==e?" type:"+e:""} based on the text:${t}`);let i,n=[];for(;null!==(i=Yc.exec(t));)if(i.index===Yc.lastIndex&&Yc.lastIndex++,i&&!e||e&&i[1]?.match(e)||e&&i[2]?.match(e)){let t=i[1]?i[1]:i[2],e=i[3]?i[3].trim():i[4]?JSON.parse(i[4].trim()):null;n.push({type:t,args:e})}return 0===n.length?{type:t,args:null}:1===n.length?n[0]:n}catch(r){return y.error(`ERROR: ${r.message} - Unable to parse directive type: '${e}' based on the text: '${t}'`),{type:void 0,args:null}}},"detectDirective"),Mw=s(function(t){return t.replace(Yc,"")},"removeDirectives"),Bw=s(function(t,e){for(let[r,i]of e.entries())if(i.match(t))return r;return-1},"isSubstringInArray");function Aw(t,e){if(!t)return e;let r=`curve${t.charAt(0).toUpperCase()+t.slice(1)}`;return _w[r]??e}function Lw(t,e){let r=t.trim();if(r)return"loose"!==e.securityLevel?(0,Cw.sanitizeUrl)(r):r}s(Aw,"interpolateToCurve"),s(Lw,"formatUrl");var Fw=s((t,...e)=>{let r=t.split("."),i=r.length-1,n=r[i],a=window;for(let e=0;e<i;e++)if(a=a[r[e]],!a)return void y.error(`Function name: ${t} not found in window`);a[n](...e)},"runFunc");function $w(t,e){return t&&e?Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2)):0}function Ew(t){let e,r=0;return t.forEach(t=>{r+=$w(t,e),e=t}),Iw(t,r/2)}function Dw(t){return 1===t.length?t[0]:Ew(t)}s($w,"distance"),s(Ew,"traverseEdge"),s(Dw,"calcLabelPosition");var Ow=s((t,e=2)=>{let r=Math.pow(10,e);return Math.round(t*r)/r},"roundNumber"),Iw=s((t,e)=>{let r,i=e;for(let e of t){if(r){let t=$w(e,r);if(0===t)return r;if(t<i)i-=t;else{let n=i/t;if(n<=0)return r;if(n>=1)return{x:e.x,y:e.y};if(n>0&&n<1)return{x:Ow((1-n)*r.x+n*e.x,5),y:Ow((1-n)*r.y+n*e.y,5)}}}r=e}throw new Error("Could not find a suitable point for the given distance")},"calculatePoint"),Nw=s((t,e,r)=>{y.info(`our points ${JSON.stringify(e)}`),e[0]!==r&&(e=e.reverse());let i=Iw(e,25),n=t?10:5,a=Math.atan2(e[0].y-i.y,e[0].x-i.x),o={x:0,y:0};return o.x=Math.sin(a)*n+(e[0].x+i.x)/2,o.y=-Math.cos(a)*n+(e[0].y+i.y)/2,o},"calcCardinalityPosition");function Rw(t,e,r){let i=structuredClone(r);y.info("our points",i),"start_left"!==e&&"start_right"!==e&&i.reverse();let n=Iw(i,25+t),a=10+.5*t,o=Math.atan2(i[0].y-n.y,i[0].x-n.x),s={x:0,y:0};return"start_left"===e?(s.x=Math.sin(o+Math.PI)*a+(i[0].x+n.x)/2,s.y=-Math.cos(o+Math.PI)*a+(i[0].y+n.y)/2):"end_right"===e?(s.x=Math.sin(o-Math.PI)*a+(i[0].x+n.x)/2-5,s.y=-Math.cos(o-Math.PI)*a+(i[0].y+n.y)/2-5):"end_left"===e?(s.x=Math.sin(o)*a+(i[0].x+n.x)/2-5,s.y=-Math.cos(o)*a+(i[0].y+n.y)/2-5):(s.x=Math.sin(o)*a+(i[0].x+n.x)/2,s.y=-Math.cos(o)*a+(i[0].y+n.y)/2),s}function Pw(t){let e="",r="";for(let i of t)void 0!==i&&(i.startsWith("color:")||i.startsWith("text-align:")?r=r+i+";":e=e+i+";");return{style:e,labelStyle:r}}s(Rw,"calcTerminalLabelPosition"),s(Pw,"getStylesFromArray");var zw=0,qw=s(()=>(zw++,"id-"+Math.random().toString(36).substr(2,12)+"-"+zw),"generateId");function jw(t){let e="",r="0123456789abcdef";for(let i=0;i<t;i++)e+=r.charAt(Math.floor(16*Math.random()));return e}s(jw,"makeRandomHex");var Ww=s(t=>jw(t.length),"random"),Hw=s(function(){return{x:0,y:0,fill:void 0,anchor:"start",style:"#666",width:100,height:100,textMargin:0,rx:0,ry:0,valign:void 0,text:""}},"getTextObj"),Uw=s(function(t,e){let r=e.text.replace(xf.lineBreakRegex," "),[,i]=r_(e.fontSize),n=t.append("text");n.attr("x",e.x),n.attr("y",e.y),n.style("text-anchor",e.anchor),n.style("font-family",e.fontFamily),n.style("font-size",i),n.style("font-weight",e.fontWeight),n.attr("fill",e.fill),void 0!==e.class&&n.attr("class",e.class);let a=n.append("tspan");return a.attr("x",e.x+2*e.textMargin),a.attr("fill",e.fill),a.text(r),n},"drawSimpleText"),Yw=Gb((t,e,r)=>{if(!t||(r=Object.assign({fontSize:12,fontWeight:400,fontFamily:"Arial",joinWith:"<br/>"},r),xf.lineBreakRegex.test(t)))return t;let i=t.split(" ").filter(Boolean),n=[],a="";return i.forEach((t,o)=>{let s=Xw(`${t} `,r),l=Xw(a,r);if(s>e){let{hyphenatedStrings:i,remainingWord:o}=Vw(t,e,"-",r);n.push(a,...i),a=o}else l+s>=e?(n.push(a),a=t):a=[a,t].filter(Boolean).join(" ");o+1===i.length&&n.push(a)}),n.filter(t=>""!==t).join(r.joinWith)},(t,e,r)=>`${t}${e}${r.fontSize}${r.fontWeight}${r.fontFamily}${r.joinWith}`),Vw=Gb((t,e,r="-",i)=>{i=Object.assign({fontSize:12,fontWeight:400,fontFamily:"Arial",margin:0},i);let n=[...t],a=[],o="";return n.forEach((t,s)=>{let l=`${o}${t}`;if(Xw(l,i)>=e){let t=s+1,e=n.length===t,i=`${l}${r}`;a.push(e?l:i),o=""}else o=l}),{hyphenatedStrings:a,remainingWord:o}},(t,e,r="-",i)=>`${t}${e}${r}${i.fontSize}${i.fontWeight}${i.fontFamily}`);function Gw(t,e){return Qw(t,e).height}function Xw(t,e){return Qw(t,e).width}s(Gw,"calculateTextHeight"),s(Xw,"calculateTextWidth");var Zw,Qw=Gb((t,e)=>{let{fontSize:r=12,fontFamily:i="Arial",fontWeight:n=400}=e;if(!t)return{width:0,height:0};let[,a]=r_(r),o=["sans-serif",i],s=t.split(xf.lineBreakRegex),l=[],h=Ke("body");if(!h.remove)return{width:0,height:0,lineHeight:0};let c=h.append("svg");for(let t of o){let e=0,r={width:0,height:0,lineHeight:0};for(let i of s){let o=Hw();o.text=i||"​";let s=Uw(c,o).style("font-size",a).style("font-weight",n).style("font-family",t),l=(s._groups||s)[0][0].getBBox();if(0===l.width&&0===l.height)throw new Error("svg element not in render tree");r.width=Math.round(Math.max(r.width,l.width)),e=Math.round(l.height),r.height+=e,r.lineHeight=Math.round(Math.max(r.lineHeight,e))}l.push(r)}return c.remove(),l[isNaN(l[1].height)||isNaN(l[1].width)||isNaN(l[1].lineHeight)||l[0].height>l[1].height&&l[0].width>l[1].width&&l[0].lineHeight>l[1].lineHeight?0:1]},(t,e)=>`${t}${e.fontSize}${e.fontWeight}${e.fontFamily}`),Kw=class{constructor(t=!1,e){this.count=0,this.count=e?e.length:0,this.next=t?()=>this.count++:()=>Date.now()}static{s(this,"InitIDGenerator")}},Jw=s(function(t){return Zw=Zw||document.createElement("div"),t=escape(t).replace(/%26/g,"&").replace(/%23/g,"#").replace(/%3B/g,";"),Zw.innerHTML=t,unescape(Zw.textContent)},"entityDecode");function t_(t){return"str"in t}s(t_,"isDetailedError");var e_=s((t,e,r,i)=>{if(!i)return;let n=t.node()?.getBBox();n&&t.append("text").text(i).attr("text-anchor","middle").attr("x",n.x+n.width/2).attr("y",-r).attr("class",e)},"insertTitle"),r_=s(t=>{if("number"==typeof t)return[t,t+"px"];let e=parseInt(t??"",10);return Number.isNaN(e)?[void 0,void 0]:t===String(e)?[e,t+"px"]:[e,t]},"parseFontSize");function i_(t,e){return kw({},t,e)}s(i_,"cleanAndMerge");var n_={assignWithDepth:eu,wrapLabel:Yw,calculateTextHeight:Gw,calculateTextWidth:Xw,calculateTextDimensions:Qw,cleanAndMerge:i_,detectInit:Sw,detectDirective:Tw,isSubstringInArray:Bw,interpolateToCurve:Aw,calcLabelPosition:Dw,calcCardinalityPosition:Nw,calcTerminalLabelPosition:Rw,formatUrl:Lw,getStylesFromArray:Pw,generateId:qw,random:Ww,runFunc:Fw,entityDecode:Jw,insertTitle:e_,isLabelCoordinateInPath:h_,parseFontSize:r_,InitIDGenerator:Kw},a_=s(function(t){let e=t;return e=e.replace(/style.*:\S*#.*;/g,function(t){return t.substring(0,t.length-1)}),e=e.replace(/classDef.*:\S*#.*;/g,function(t){return t.substring(0,t.length-1)}),e=e.replace(/#\w+;/g,function(t){let e=t.substring(1,t.length-1);return/^\+?\d+$/.test(e)?"ﬂ°°"+e+"¶ß":"ﬂ°"+e+"¶ß"}),e},"encodeEntities"),o_=s(function(t){return t.replace(/ﬂ°°/g,"&#").replace(/ﬂ°/g,"&").replace(/¶ß/g,";")},"decodeEntities"),s_=s((t,e,{counter:r=0,prefix:i,suffix:n},a)=>a||`${i?`${i}_`:""}${t}_${e}_${r}${n?`_${n}`:""}`,"getEdgeId");function l_(t){return t??null}function h_(t,e){let r=Math.round(t.x),i=Math.round(t.y),n=e.replace(/(\d+\.\d+)/g,t=>Math.round(parseFloat(t)).toString());return n.includes(r.toString())||n.includes(i.toString())}s(l_,"handleUndefinedAttr"),s(h_,"isLabelCoordinateInPath");var c_=Object.freeze({left:0,top:0,width:16,height:16}),u_=Object.freeze({rotate:0,vFlip:!1,hFlip:!1}),d_=Object.freeze({...c_,...u_}),p_=Object.freeze({...d_,body:"",hidden:!1}),f_=Object.freeze({width:null,height:null}),g_=Object.freeze({...f_,...u_}),y_=s((t,e,r,i="")=>{let n=t.split(":");if("@"===t.slice(0,1)){if(n.length<2||n.length>3)return null;i=n.shift().slice(1)}if(n.length>3||!n.length)return null;if(n.length>1){let t=n.pop(),r=n.pop(),a={provider:n.length>0?n[0]:i,prefix:r,name:t};return e&&!m_(a)?null:a}let a=n[0],o=a.split("-");if(o.length>1){let t={provider:i,prefix:o.shift(),name:o.join("-")};return e&&!m_(t)?null:t}if(r&&""===i){let t={provider:i,prefix:"",name:a};return e&&!m_(t,r)?null:t}return null},"stringToIcon"),m_=s((t,e)=>!!t&&!(!(e&&""===t.prefix||t.prefix)||!t.name),"validateIconName");function x_(t,e){let r={};!t.hFlip!=!e.hFlip&&(r.hFlip=!0),!t.vFlip!=!e.vFlip&&(r.vFlip=!0);let i=((t.rotate||0)+(e.rotate||0))%4;return i&&(r.rotate=i),r}function b_(t,e){let r=x_(t,e);for(let i in p_)i in u_?i in t&&!(i in r)&&(r[i]=u_[i]):i in e?r[i]=e[i]:i in t&&(r[i]=t[i]);return r}function k_(t,e){let r=t.icons,i=t.aliases||Object.create(null),n=Object.create(null);function a(t){if(r[t])return n[t]=[];if(!(t in n)){n[t]=null;let e=i[t]&&i[t].parent,r=e&&a(e);r&&(n[t]=[e].concat(r))}return n[t]}return s(a,"resolve"),(e||Object.keys(r).concat(Object.keys(i))).forEach(a),n}function C_(t,e,r){let i=t.icons,n=t.aliases||Object.create(null),a={};function o(t){a=b_(i[t]||n[t],a)}return s(o,"parse"),o(e),r.forEach(o),b_(t,a)}function w_(t,e){if(t.icons[e])return C_(t,e,[]);let r=k_(t,[e])[e];return r?C_(t,e,r):null}s(x_,"mergeIconTransformations"),s(b_,"mergeIconData"),s(k_,"getIconsTree"),s(C_,"internalGetIconData"),s(w_,"getIconData");var __=/(-?[0-9.]*[0-9]+[0-9.]*)/g,v_=/^-?[0-9.]*[0-9]+[0-9.]*$/g;function S_(t,e,r){if(1===e)return t;if(r=r||100,"number"==typeof t)return Math.ceil(t*e*r)/r;if("string"!=typeof t)return t;let i=t.split(__);if(null===i||!i.length)return t;let n=[],a=i.shift(),o=v_.test(a);for(;;){if(o){let t=parseFloat(a);isNaN(t)?n.push(a):n.push(Math.ceil(t*e*r)/r)}else n.push(a);if(a=i.shift(),void 0===a)return n.join("");o=!o}}function T_(t,e="defs"){let r="",i=t.indexOf("<"+e);for(;i>=0;){let n=t.indexOf(">",i),a=t.indexOf("</"+e);if(-1===n||-1===a)break;let o=t.indexOf(">",a);if(-1===o)break;r+=t.slice(n+1,a).trim(),t=t.slice(0,i).trim()+t.slice(o+1)}return{defs:r,content:t}}function M_(t,e){return t?"<defs>"+t+"</defs>"+e:e}function B_(t,e,r){let i=T_(t);return M_(i.defs,e+i.content+r)}s(S_,"calculateSize"),s(T_,"splitSVGDefs"),s(M_,"mergeDefsAndContent"),s(B_,"wrapSVGContent");var A_=s(t=>"unset"===t||"undefined"===t||"none"===t,"isUnsetKeyword");function L_(t,e){let r={...d_,...t},i={...g_,...e},n={left:r.left,top:r.top,width:r.width,height:r.height},a=r.body;[r,i].forEach(t=>{let e,r=[],i=t.hFlip,o=t.vFlip,s=t.rotate;switch(i?o?s+=2:(r.push("translate("+(n.width+n.left).toString()+" "+(0-n.top).toString()+")"),r.push("scale(-1 1)"),n.top=n.left=0):o&&(r.push("translate("+(0-n.left).toString()+" "+(n.height+n.top).toString()+")"),r.push("scale(1 -1)"),n.top=n.left=0),s<0&&(s-=4*Math.floor(s/4)),s%=4,s){case 1:e=n.height/2+n.top,r.unshift("rotate(90 "+e.toString()+" "+e.toString()+")");break;case 2:r.unshift("rotate(180 "+(n.width/2+n.left).toString()+" "+(n.height/2+n.top).toString()+")");break;case 3:e=n.width/2+n.left,r.unshift("rotate(-90 "+e.toString()+" "+e.toString()+")")}s%2==1&&(n.left!==n.top&&(e=n.left,n.left=n.top,n.top=e),n.width!==n.height&&(e=n.width,n.width=n.height,n.height=e)),r.length&&(a=B_(a,'<g transform="'+r.join(" ")+'">',"</g>"))});let o,l,h=i.width,c=i.height,u=n.width,d=n.height;null===h?(l=null===c?"1em":"auto"===c?d:c,o=S_(l,u/d)):(o="auto"===h?u:h,l=null===c?S_(o,d/u):"auto"===c?d:c);let p={},f=s((t,e)=>{A_(e)||(p[t]=e.toString())},"setAttr");f("width",o),f("height",l);let g=[n.left,n.top,u,d];return p.viewBox=g.join(" "),{attributes:p,viewBox:g,body:a}}s(L_,"iconToSVG");var F_=/\sid="(\S+)"/g,$_="IconifyId"+Date.now().toString(16)+(16777216*Math.random()|0).toString(16),E_=0;function D_(t,e=$_){let r,i=[];for(;r=F_.exec(t);)i.push(r[1]);if(!i.length)return t;let n="suffix"+(16777216*Math.random()|Date.now()).toString(16);return i.forEach(r=>{let i="function"==typeof e?e(r):e+(E_++).toString(),a=r.replace(/[.*+?^${}()|[\]\\]/g,"\\$&");t=t.replace(new RegExp('([#;"])('+a+')([")]|\\.[a-z])',"g"),"$1"+i+n+"$3")}),t=t.replace(new RegExp(n,"g"),"")}function O_(t,e){let r=-1===t.indexOf("xlink:")?"":' xmlns:xlink="http://www.w3.org/1999/xlink"';for(let t in e)r+=" "+t+'="'+e[t]+'"';return'<svg xmlns="http://www.w3.org/2000/svg"'+r+">"+t+"</svg>"}s(D_,"replaceIDs"),s(O_,"iconToHTML");var I_={body:'<g><rect width="80" height="80" style="fill: #087ebf; stroke-width: 0px;"/><text transform="translate(21.16 64.67)" style="fill: #fff; font-family: ArialMT, Arial; font-size: 67.75px;"><tspan x="0" y="0">?</tspan></text></g>',height:80,width:80},N_=new Map,R_=new Map,P_=s(t=>{for(let e of t){if(!e.name)throw new Error('Invalid icon loader. Must have a "name" property with non-empty string value.');if(y.debug("Registering icon pack:",e.name),"loader"in e)R_.set(e.name,e.loader);else{if(!("icons"in e))throw y.error("Invalid icon loader:",e),new Error('Invalid icon loader. Must have either "icons" or "loader" property.');N_.set(e.name,e.icons)}}},"registerIconPacks"),z_=s(async(t,e)=>{let r=y_(t,!0,void 0!==e);if(!r)throw new Error(`Invalid icon name: ${t}`);let i=r.prefix||e;if(!i)throw new Error(`Icon name must contain a prefix: ${t}`);let n=N_.get(i);if(!n){let t=R_.get(i);if(!t)throw new Error(`Icon set not found: ${r.prefix}`);try{n={...await t(),prefix:i},N_.set(i,n)}catch(t){throw y.error(t),new Error(`Failed to load icon set: ${r.prefix}`)}}let a=w_(n,r.name);if(!a)throw new Error(`Icon not found: ${t}`);return a},"getRegisteredIconData"),q_=s(async t=>{try{return await z_(t),!0}catch{return!1}},"isIconAvailable"),j_=s(async(t,e,r)=>{let i;try{i=await z_(t,e?.fallbackPrefix)}catch(t){y.error(t),i=I_}let n=L_(i,e),a=O_(D_(n.body),{...n.attributes,...r});return Qp(a,Bd())},"getIconSVG");function W_(t){for(var e=[],r=1;r<arguments.length;r++)e[r-1]=arguments[r];var i=Array.from("string"==typeof t?[t]:t);i[i.length-1]=i[i.length-1].replace(/\r?\n([\t ]*)$/,"");var n=i.reduce(function(t,e){var r=e.match(/\n([\t ]+|(?!\s).)/g);return r?t.concat(r.map(function(t){var e,r;return null!==(r=null===(e=t.match(/[\t ]/g))||void 0===e?void 0:e.length)&&void 0!==r?r:0})):t},[]);if(n.length){var a=new RegExp("\n[\t ]{"+Math.min.apply(Math,n)+"}","g");i=i.map(function(t){return t.replace(a,"\n")})}i[0]=i[0].replace(/^\r?\n/,"");var o=i[0];return e.forEach(function(t,e){var r=o.match(/(?:^|\n)( *)$/),n=r?r[1]:"",a=t;"string"==typeof t&&t.includes("\n")&&(a=String(t).split("\n").map(function(t,e){return 0===e?t:""+n+t}).join("\n")),o+=a+i[e+1]}),o}function H_(){return{async:!1,breaks:!1,extensions:null,gfm:!0,hooks:null,pedantic:!1,renderer:null,silent:!1,tokenizer:null,walkTokens:null}}s(W_,"dedent"),s(H_,"L");var U_={async:!1,breaks:!1,extensions:null,gfm:!0,hooks:null,pedantic:!1,renderer:null,silent:!1,tokenizer:null,walkTokens:null};function Y_(t){U_=t}s(Y_,"G");var V_={exec:s(()=>null,"exec")};function G_(t,e=""){let r="string"==typeof t?t:t.source,i={replace:s((t,e)=>{let n="string"==typeof e?e:e.source;return n=n.replace(X_.caret,"$1"),r=r.replace(t,n),i},"replace"),getRegex:s(()=>new RegExp(r,e),"getRegex")};return i}s(G_,"h");var X_={codeRemoveIndent:/^(?: {1,4}| {0,3}\t)/gm,outputLinkReplace:/\\([\[\]])/g,indentCodeCompensation:/^(\s+)(?:```)/,beginningSpace:/^\s+/,endingHash:/#$/,startingSpaceChar:/^ /,endingSpaceChar:/ $/,nonSpaceChar:/[^ ]/,newLineCharGlobal:/\n/g,tabCharGlobal:/\t/g,multipleSpaceGlobal:/\s+/g,blankLine:/^[ \t]*$/,doubleBlankLine:/\n[ \t]*\n[ \t]*$/,blockquoteStart:/^ {0,3}>/,blockquoteSetextReplace:/\n {0,3}((?:=+|-+) *)(?=\n|$)/g,blockquoteSetextReplace2:/^ {0,3}>[ \t]?/gm,listReplaceTabs:/^\t+/,listReplaceNesting:/^ {1,4}(?=( {4})*[^ ])/g,listIsTask:/^\[[ xX]\] /,listReplaceTask:/^\[[ xX]\] +/,anyLine:/\n.*\n/,hrefBrackets:/^<(.*)>$/,tableDelimiter:/[:|]/,tableAlignChars:/^\||\| *$/g,tableRowBlankLine:/\n[ \t]*$/,tableAlignRight:/^ *-+: *$/,tableAlignCenter:/^ *:-+: *$/,tableAlignLeft:/^ *:-+ *$/,startATag:/^<a /i,endATag:/^<\/a>/i,startPreScriptTag:/^<(pre|code|kbd|script)(\s|>)/i,endPreScriptTag:/^<\/(pre|code|kbd|script)(\s|>)/i,startAngleBracket:/^</,endAngleBracket:/>$/,pedanticHrefTitle:/^([^'"]*[^\s])\s+(['"])(.*)\2/,unicodeAlphaNumeric:/[\p{L}\p{N}]/u,escapeTest:/[&<>"']/,escapeReplace:/[&<>"']/g,escapeTestNoEncode:/[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/,escapeReplaceNoEncode:/[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/g,unescapeTest:/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/gi,caret:/(^|[^\[])\^/g,percentDecode:/%25/g,findPipe:/\|/g,splitPipe:/ \|/,slashPipe:/\\\|/g,carriageReturn:/\r\n|\r/g,spaceLine:/^ +$/gm,notSpaceStart:/^\S*/,endingNewline:/\n$/,listItemRegex:s(t=>new RegExp(`^( {0,3}${t})((?:[\t ][^\\n]*)?(?:\\n|$))`),"listItemRegex"),nextBulletRegex:s(t=>new RegExp(`^ {0,${Math.min(3,t-1)}}(?:[*+-]|\\d{1,9}[.)])((?:[ \t][^\\n]*)?(?:\\n|$))`),"nextBulletRegex"),hrRegex:s(t=>new RegExp(`^ {0,${Math.min(3,t-1)}}((?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$)`),"hrRegex"),fencesBeginRegex:s(t=>new RegExp(`^ {0,${Math.min(3,t-1)}}(?:\`\`\`|~~~)`),"fencesBeginRegex"),headingBeginRegex:s(t=>new RegExp(`^ {0,${Math.min(3,t-1)}}#`),"headingBeginRegex"),htmlBeginRegex:s(t=>new RegExp(`^ {0,${Math.min(3,t-1)}}<(?:[a-z].*>|!--)`,"i"),"htmlBeginRegex")},Z_=/^ {0,3}((?:-[\t ]*){3,}|(?:_[ \t]*){3,}|(?:\*[ \t]*){3,})(?:\n+|$)/,Q_=/(?:[*+-]|\d{1,9}[.)])/,K_=/^(?!bull |blockCode|fences|blockquote|heading|html|table)((?:.|\n(?!\s*?\n|bull |blockCode|fences|blockquote|heading|html|table))+?)\n {0,3}(=+|-+) *(?:\n+|$)/,J_=G_(K_).replace(/bull/g,Q_).replace(/blockCode/g,/(?: {4}| {0,3}\t)/).replace(/fences/g,/ {0,3}(?:`{3,}|~{3,})/).replace(/blockquote/g,/ {0,3}>/).replace(/heading/g,/ {0,3}#{1,6}/).replace(/html/g,/ {0,3}<[^\n>]+>\n/).replace(/\|table/g,"").getRegex(),tv=G_(K_).replace(/bull/g,Q_).replace(/blockCode/g,/(?: {4}| {0,3}\t)/).replace(/fences/g,/ {0,3}(?:`{3,}|~{3,})/).replace(/blockquote/g,/ {0,3}>/).replace(/heading/g,/ {0,3}#{1,6}/).replace(/html/g,/ {0,3}<[^\n>]+>\n/).replace(/table/g,/ {0,3}\|?(?:[:\- ]*\|)+[\:\- ]*\n/).getRegex(),ev=/^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html|table| +\n)[^\n]+)*)/,rv=/(?!\s*\])(?:\\[\s\S]|[^\[\]\\])+/,iv=G_(/^ {0,3}\[(label)\]: *(?:\n[ \t]*)?([^<\s][^\s]*|<.*?>)(?:(?: +(?:\n[ \t]*)?| *\n[ \t]*)(title))? *(?:\n+|$)/).replace("label",rv).replace("title",/(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/).getRegex(),nv=G_(/^( {0,3}bull)([ \t][^\n]+?)?(?:\n|$)/).replace(/bull/g,Q_).getRegex(),av="address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|search|section|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul",ov=/<!--(?:-?>|[\s\S]*?(?:-->|$))/,sv=G_("^ {0,3}(?:<(script|pre|style|textarea)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)|comment[^\\n]*(\\n+|$)|<\\?[\\s\\S]*?(?:\\?>\\n*|$)|<![A-Z][\\s\\S]*?(?:>\\n*|$)|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:(?:\\n[ \t]*)+\\n|$)|<(?!script|pre|style|textarea)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n[ \t]*)+\\n|$)|</(?!script|pre|style|textarea)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n[ \t]*)+\\n|$))","i").replace("comment",ov).replace("tag",av).replace("attribute",/ +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/).getRegex(),lv=G_(ev).replace("hr",Z_).replace("heading"," {0,3}#{1,6}(?:\\s|$)").replace("|lheading","").replace("|table","").replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",av).getRegex(),hv={blockquote:G_(/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/).replace("paragraph",lv).getRegex(),code:/^((?: {4}| {0,3}\t)[^\n]+(?:\n(?:[ \t]*(?:\n|$))*)?)+/,def:iv,fences:/^ {0,3}(`{3,}(?=[^`\n]*(?:\n|$))|~{3,})([^\n]*)(?:\n|$)(?:|([\s\S]*?)(?:\n|$))(?: {0,3}\1[~`]* *(?=\n|$)|$)/,heading:/^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/,hr:Z_,html:sv,lheading:J_,list:nv,newline:/^(?:[ \t]*(?:\n|$))+/,paragraph:lv,table:V_,text:/^[^\n]+/},cv=G_("^ *([^\\n ].*)\\n {0,3}((?:\\| *)?:?-+:? *(?:\\| *:?-+:? *)*(?:\\| *)?)(?:\\n((?:(?! *\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)").replace("hr",Z_).replace("heading"," {0,3}#{1,6}(?:\\s|$)").replace("blockquote"," {0,3}>").replace("code","(?: {4}| {0,3}\t)[^\\n]").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",av).getRegex(),uv={...hv,lheading:tv,table:cv,paragraph:G_(ev).replace("hr",Z_).replace("heading"," {0,3}#{1,6}(?:\\s|$)").replace("|lheading","").replace("table",cv).replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",av).getRegex()},dv={...hv,html:G_("^ *(?:comment *(?:\\n|\\s*$)|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)|<tag(?:\"[^\"]*\"|'[^']*'|\\s[^'\"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))").replace("comment",ov).replace(/tag/g,"(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b").getRegex(),def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/,heading:/^(#{1,6})(.*)(?:\n+|$)/,fences:V_,lheading:/^(.+?)\n {0,3}(=+|-+) *(?:\n+|$)/,paragraph:G_(ev).replace("hr",Z_).replace("heading"," *#{1,6} *[^\n]").replace("lheading",J_).replace("|table","").replace("blockquote"," {0,3}>").replace("|fences","").replace("|list","").replace("|html","").replace("|tag","").getRegex()},pv=/^( {2,}|\\)\n(?!\s*$)/,fv=/[\p{P}\p{S}]/u,gv=/[\s\p{P}\p{S}]/u,yv=/[^\s\p{P}\p{S}]/u,mv=G_(/^((?![*_])punctSpace)/,"u").replace(/punctSpace/g,gv).getRegex(),xv=/(?!~)[\p{P}\p{S}]/u,bv=/^(?:\*+(?:((?!\*)punct)|[^\s*]))|^_+(?:((?!_)punct)|([^\s_]))/,kv=G_(bv,"u").replace(/punct/g,fv).getRegex(),Cv=G_(bv,"u").replace(/punct/g,xv).getRegex(),wv="^[^_*]*?__[^_*]*?\\*[^_*]*?(?=__)|[^*]+(?=[^*])|(?!\\*)punct(\\*+)(?=[\\s]|$)|notPunctSpace(\\*+)(?!\\*)(?=punctSpace|$)|(?!\\*)punctSpace(\\*+)(?=notPunctSpace)|[\\s](\\*+)(?!\\*)(?=punct)|(?!\\*)punct(\\*+)(?!\\*)(?=punct)|notPunctSpace(\\*+)(?=notPunctSpace)",_v=G_(wv,"gu").replace(/notPunctSpace/g,yv).replace(/punctSpace/g,gv).replace(/punct/g,fv).getRegex(),vv=G_(wv,"gu").replace(/notPunctSpace/g,/(?:[^\s\p{P}\p{S}]|~)/u).replace(/punctSpace/g,/(?!~)[\s\p{P}\p{S}]/u).replace(/punct/g,xv).getRegex(),Sv=G_("^[^_*]*?\\*\\*[^_*]*?_[^_*]*?(?=\\*\\*)|[^_]+(?=[^_])|(?!_)punct(_+)(?=[\\s]|$)|notPunctSpace(_+)(?!_)(?=punctSpace|$)|(?!_)punctSpace(_+)(?=notPunctSpace)|[\\s](_+)(?!_)(?=punct)|(?!_)punct(_+)(?!_)(?=punct)","gu").replace(/notPunctSpace/g,yv).replace(/punctSpace/g,gv).replace(/punct/g,fv).getRegex(),Tv=G_(/\\(punct)/,"gu").replace(/punct/g,fv).getRegex(),Mv=G_(/^<(scheme:[^\s\x00-\x1f<>]*|email)>/).replace("scheme",/[a-zA-Z][a-zA-Z0-9+.-]{1,31}/).replace("email",/[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/).getRegex(),Bv=G_(ov).replace("(?:--\x3e|$)","--\x3e").getRegex(),Av=G_("^comment|^</[a-zA-Z][\\w:-]*\\s*>|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>|^<\\?[\\s\\S]*?\\?>|^<![a-zA-Z]+\\s[\\s\\S]*?>|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>").replace("comment",Bv).replace("attribute",/\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/).getRegex(),Lv=/(?:\[(?:\\[\s\S]|[^\[\]\\])*\]|\\[\s\S]|`[^`]*`|[^\[\]\\`])*?/,Fv=G_(/^!?\[(label)\]\(\s*(href)(?:(?:[ \t]*(?:\n[ \t]*)?)(title))?\s*\)/).replace("label",Lv).replace("href",/<(?:\\.|[^\n<>\\])+>|[^ \t\n\x00-\x1f]*/).replace("title",/"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/).getRegex(),$v=G_(/^!?\[(label)\]\[(ref)\]/).replace("label",Lv).replace("ref",rv).getRegex(),Ev=G_(/^!?\[(ref)\](?:\[\])?/).replace("ref",rv).getRegex(),Dv={_backpedal:V_,anyPunctuation:Tv,autolink:Mv,blockSkip:/\[[^\[\]]*?\]\((?:\\[\s\S]|[^\\\(\)]|\((?:\\[\s\S]|[^\\\(\)])*\))*\)|`[^`]*?`|<(?! )[^<>]*?>/g,br:pv,code:/^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/,del:V_,emStrongLDelim:kv,emStrongRDelimAst:_v,emStrongRDelimUnd:Sv,escape:/^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/,link:Fv,nolink:Ev,punctuation:mv,reflink:$v,reflinkSearch:G_("reflink|nolink(?!\\()","g").replace("reflink",$v).replace("nolink",Ev).getRegex(),tag:Av,text:/^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/,url:V_},Ov={...Dv,link:G_(/^!?\[(label)\]\((.*?)\)/).replace("label",Lv).getRegex(),reflink:G_(/^!?\[(label)\]\s*\[([^\]]*)\]/).replace("label",Lv).getRegex()},Iv={...Dv,emStrongRDelimAst:vv,emStrongLDelim:Cv,url:G_(/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/,"i").replace("email",/[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/).getRegex(),_backpedal:/(?:[^?!.,:;*_'"~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_'"~)]+(?!$))+/,del:/^(~~?)(?=[^\s~])((?:\\[\s\S]|[^\\])*?(?:\\[\s\S]|[^\s~\\]))\1(?=[^~]|$)/,text:/^([`~]+|[^`~])(?:(?= {2,}\n)|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|https?:\/\/|ftp:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)))/},Nv={...Iv,br:G_(pv).replace("{2,}","*").getRegex(),text:G_(Iv.text).replace("\\b_","\\b_| {2,}\\n").replace(/\{2,\}/g,"*").getRegex()},Rv={normal:hv,gfm:uv,pedantic:dv},Pv={normal:Dv,gfm:Iv,breaks:Nv,pedantic:Ov},zv={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"},qv=s(t=>zv[t],"ke");function jv(t,e){if(e){if(X_.escapeTest.test(t))return t.replace(X_.escapeReplace,qv)}else if(X_.escapeTestNoEncode.test(t))return t.replace(X_.escapeReplaceNoEncode,qv);return t}function Wv(t){try{t=encodeURI(t).replace(X_.percentDecode,"%")}catch{return null}return t}function Hv(t,e){let r=t.replace(X_.findPipe,(t,e,r)=>{let i=!1,n=e;for(;--n>=0&&"\\"===r[n];)i=!i;return i?"|":" |"}),i=r.split(X_.splitPipe),n=0;if(i[0].trim()||i.shift(),i.length>0&&!i.at(-1)?.trim()&&i.pop(),e)if(i.length>e)i.splice(e);else for(;i.length<e;)i.push("");for(;n<i.length;n++)i[n]=i[n].trim().replace(X_.slashPipe,"|");return i}function Uv(t,e,r){let i=t.length;if(0===i)return"";let n=0;for(;n<i;){let a=t.charAt(i-n-1);if(a!==e||r){if(a===e||!r)break;n++}else n++}return t.slice(0,i-n)}function Yv(t,e){if(-1===t.indexOf(e[1]))return-1;let r=0;for(let i=0;i<t.length;i++)if("\\"===t[i])i++;else if(t[i]===e[0])r++;else if(t[i]===e[1]&&(r--,r<0))return i;return r>0?-2:-1}function Vv(t,e,r,i,n){let a=e.href,o=e.title||null,s=t[1].replace(n.other.outputLinkReplace,"$1");i.state.inLink=!0;let l={type:"!"===t[0].charAt(0)?"image":"link",raw:r,href:a,title:o,text:s,tokens:i.inlineTokens(s)};return i.state.inLink=!1,l}function Gv(t,e,r){let i=t.match(r.other.indentCodeCompensation);if(null===i)return e;let n=i[1];return e.split("\n").map(t=>{let e=t.match(r.other.beginningSpace);if(null===e)return t;let[i]=e;return i.length>=n.length?t.slice(n.length):t}).join("\n")}s(jv,"w"),s(Wv,"J"),s(Hv,"V"),s(Uv,"z"),s(Yv,"ge"),s(Vv,"fe"),s(Gv,"Je");var Xv=class{static{s(this,"y")}options;rules;lexer;constructor(t){this.options=t||U_}space(t){let e=this.rules.block.newline.exec(t);if(e&&e[0].length>0)return{type:"space",raw:e[0]}}code(t){let e=this.rules.block.code.exec(t);if(e){let t=e[0].replace(this.rules.other.codeRemoveIndent,"");return{type:"code",raw:e[0],codeBlockStyle:"indented",text:this.options.pedantic?t:Uv(t,"\n")}}}fences(t){let e=this.rules.block.fences.exec(t);if(e){let t=e[0],r=Gv(t,e[3]||"",this.rules);return{type:"code",raw:t,lang:e[2]?e[2].trim().replace(this.rules.inline.anyPunctuation,"$1"):e[2],text:r}}}heading(t){let e=this.rules.block.heading.exec(t);if(e){let t=e[2].trim();if(this.rules.other.endingHash.test(t)){let e=Uv(t,"#");(this.options.pedantic||!e||this.rules.other.endingSpaceChar.test(e))&&(t=e.trim())}return{type:"heading",raw:e[0],depth:e[1].length,text:t,tokens:this.lexer.inline(t)}}}hr(t){let e=this.rules.block.hr.exec(t);if(e)return{type:"hr",raw:Uv(e[0],"\n")}}blockquote(t){let e=this.rules.block.blockquote.exec(t);if(e){let t=Uv(e[0],"\n").split("\n"),r="",i="",n=[];for(;t.length>0;){let e,a=!1,o=[];for(e=0;e<t.length;e++)if(this.rules.other.blockquoteStart.test(t[e]))o.push(t[e]),a=!0;else{if(a)break;o.push(t[e])}t=t.slice(e);let s=o.join("\n"),l=s.replace(this.rules.other.blockquoteSetextReplace,"\n    $1").replace(this.rules.other.blockquoteSetextReplace2,"");r=r?`${r}\n${s}`:s,i=i?`${i}\n${l}`:l;let h=this.lexer.state.top;if(this.lexer.state.top=!0,this.lexer.blockTokens(l,n,!0),this.lexer.state.top=h,0===t.length)break;let c=n.at(-1);if("code"===c?.type)break;if("blockquote"===c?.type){let e=c,a=e.raw+"\n"+t.join("\n"),o=this.blockquote(a);n[n.length-1]=o,r=r.substring(0,r.length-e.raw.length)+o.raw,i=i.substring(0,i.length-e.text.length)+o.text;break}if("list"===c?.type){let e=c,a=e.raw+"\n"+t.join("\n"),o=this.list(a);n[n.length-1]=o,r=r.substring(0,r.length-c.raw.length)+o.raw,i=i.substring(0,i.length-e.raw.length)+o.raw,t=a.substring(n.at(-1).raw.length).split("\n");continue}}return{type:"blockquote",raw:r,tokens:n,text:i}}}list(t){let e=this.rules.block.list.exec(t);if(e){let r=e[1].trim(),i=r.length>1,n={type:"list",raw:"",ordered:i,start:i?+r.slice(0,-1):"",loose:!1,items:[]};r=i?`\\d{1,9}\\${r.slice(-1)}`:`\\${r}`,this.options.pedantic&&(r=i?r:"[*+-]");let a=this.rules.other.listItemRegex(r),o=!1;for(;t;){let r=!1,i="",s="";if(!(e=a.exec(t))||this.rules.block.hr.test(t))break;i=e[0],t=t.substring(i.length);let l=e[2].split("\n",1)[0].replace(this.rules.other.listReplaceTabs,t=>" ".repeat(3*t.length)),h=t.split("\n",1)[0],c=!l.trim(),u=0;if(this.options.pedantic?(u=2,s=l.trimStart()):c?u=e[1].length+1:(u=e[2].search(this.rules.other.nonSpaceChar),u=u>4?1:u,s=l.slice(u),u+=e[1].length),c&&this.rules.other.blankLine.test(h)&&(i+=h+"\n",t=t.substring(h.length+1),r=!0),!r){let e=this.rules.other.nextBulletRegex(u),r=this.rules.other.hrRegex(u),n=this.rules.other.fencesBeginRegex(u),a=this.rules.other.headingBeginRegex(u),o=this.rules.other.htmlBeginRegex(u);for(;t;){let d,p=t.split("\n",1)[0];if(h=p,this.options.pedantic?(h=h.replace(this.rules.other.listReplaceNesting,"  "),d=h):d=h.replace(this.rules.other.tabCharGlobal,"    "),n.test(h)||a.test(h)||o.test(h)||e.test(h)||r.test(h))break;if(d.search(this.rules.other.nonSpaceChar)>=u||!h.trim())s+="\n"+d.slice(u);else{if(c||l.replace(this.rules.other.tabCharGlobal,"    ").search(this.rules.other.nonSpaceChar)>=4||n.test(l)||a.test(l)||r.test(l))break;s+="\n"+h}!c&&!h.trim()&&(c=!0),i+=p+"\n",t=t.substring(p.length+1),l=d.slice(u)}}n.loose||(o?n.loose=!0:this.rules.other.doubleBlankLine.test(i)&&(o=!0));let d,p=null;this.options.gfm&&(p=this.rules.other.listIsTask.exec(s),p&&(d="[ ] "!==p[0],s=s.replace(this.rules.other.listReplaceTask,""))),n.items.push({type:"list_item",raw:i,task:!!p,checked:d,loose:!1,text:s,tokens:[]}),n.raw+=i}let s=n.items.at(-1);if(!s)return;s.raw=s.raw.trimEnd(),s.text=s.text.trimEnd(),n.raw=n.raw.trimEnd();for(let t=0;t<n.items.length;t++)if(this.lexer.state.top=!1,n.items[t].tokens=this.lexer.blockTokens(n.items[t].text,[]),!n.loose){let e=n.items[t].tokens.filter(t=>"space"===t.type),r=e.length>0&&e.some(t=>this.rules.other.anyLine.test(t.raw));n.loose=r}if(n.loose)for(let t=0;t<n.items.length;t++)n.items[t].loose=!0;return n}}html(t){let e=this.rules.block.html.exec(t);if(e)return{type:"html",block:!0,raw:e[0],pre:"pre"===e[1]||"script"===e[1]||"style"===e[1],text:e[0]}}def(t){let e=this.rules.block.def.exec(t);if(e){let t=e[1].toLowerCase().replace(this.rules.other.multipleSpaceGlobal," "),r=e[2]?e[2].replace(this.rules.other.hrefBrackets,"$1").replace(this.rules.inline.anyPunctuation,"$1"):"",i=e[3]?e[3].substring(1,e[3].length-1).replace(this.rules.inline.anyPunctuation,"$1"):e[3];return{type:"def",tag:t,raw:e[0],href:r,title:i}}}table(t){let e=this.rules.block.table.exec(t);if(!e||!this.rules.other.tableDelimiter.test(e[2]))return;let r=Hv(e[1]),i=e[2].replace(this.rules.other.tableAlignChars,"").split("|"),n=e[3]?.trim()?e[3].replace(this.rules.other.tableRowBlankLine,"").split("\n"):[],a={type:"table",raw:e[0],header:[],align:[],rows:[]};if(r.length===i.length){for(let t of i)this.rules.other.tableAlignRight.test(t)?a.align.push("right"):this.rules.other.tableAlignCenter.test(t)?a.align.push("center"):this.rules.other.tableAlignLeft.test(t)?a.align.push("left"):a.align.push(null);for(let t=0;t<r.length;t++)a.header.push({text:r[t],tokens:this.lexer.inline(r[t]),header:!0,align:a.align[t]});for(let t of n)a.rows.push(Hv(t,a.header.length).map((t,e)=>({text:t,tokens:this.lexer.inline(t),header:!1,align:a.align[e]})));return a}}lheading(t){let e=this.rules.block.lheading.exec(t);if(e)return{type:"heading",raw:e[0],depth:"="===e[2].charAt(0)?1:2,text:e[1],tokens:this.lexer.inline(e[1])}}paragraph(t){let e=this.rules.block.paragraph.exec(t);if(e){let t="\n"===e[1].charAt(e[1].length-1)?e[1].slice(0,-1):e[1];return{type:"paragraph",raw:e[0],text:t,tokens:this.lexer.inline(t)}}}text(t){let e=this.rules.block.text.exec(t);if(e)return{type:"text",raw:e[0],text:e[0],tokens:this.lexer.inline(e[0])}}escape(t){let e=this.rules.inline.escape.exec(t);if(e)return{type:"escape",raw:e[0],text:e[1]}}tag(t){let e=this.rules.inline.tag.exec(t);if(e)return!this.lexer.state.inLink&&this.rules.other.startATag.test(e[0])?this.lexer.state.inLink=!0:this.lexer.state.inLink&&this.rules.other.endATag.test(e[0])&&(this.lexer.state.inLink=!1),!this.lexer.state.inRawBlock&&this.rules.other.startPreScriptTag.test(e[0])?this.lexer.state.inRawBlock=!0:this.lexer.state.inRawBlock&&this.rules.other.endPreScriptTag.test(e[0])&&(this.lexer.state.inRawBlock=!1),{type:"html",raw:e[0],inLink:this.lexer.state.inLink,inRawBlock:this.lexer.state.inRawBlock,block:!1,text:e[0]}}link(t){let e=this.rules.inline.link.exec(t);if(e){let t=e[2].trim();if(!this.options.pedantic&&this.rules.other.startAngleBracket.test(t)){if(!this.rules.other.endAngleBracket.test(t))return;let e=Uv(t.slice(0,-1),"\\");if((t.length-e.length)%2==0)return}else{let t=Yv(e[2],"()");if(-2===t)return;if(t>-1){let r=(0===e[0].indexOf("!")?5:4)+e[1].length+t;e[2]=e[2].substring(0,t),e[0]=e[0].substring(0,r).trim(),e[3]=""}}let r=e[2],i="";if(this.options.pedantic){let t=this.rules.other.pedanticHrefTitle.exec(r);t&&(r=t[1],i=t[3])}else i=e[3]?e[3].slice(1,-1):"";return r=r.trim(),this.rules.other.startAngleBracket.test(r)&&(r=this.options.pedantic&&!this.rules.other.endAngleBracket.test(t)?r.slice(1):r.slice(1,-1)),Vv(e,{href:r&&r.replace(this.rules.inline.anyPunctuation,"$1"),title:i&&i.replace(this.rules.inline.anyPunctuation,"$1")},e[0],this.lexer,this.rules)}}reflink(t,e){let r;if((r=this.rules.inline.reflink.exec(t))||(r=this.rules.inline.nolink.exec(t))){let t=e[(r[2]||r[1]).replace(this.rules.other.multipleSpaceGlobal," ").toLowerCase()];if(!t){let t=r[0].charAt(0);return{type:"text",raw:t,text:t}}return Vv(r,t,r[0],this.lexer,this.rules)}}emStrong(t,e,r=""){let i=this.rules.inline.emStrongLDelim.exec(t);if(!(!i||i[3]&&r.match(this.rules.other.unicodeAlphaNumeric))&&(!i[1]&&!i[2]||!r||this.rules.inline.punctuation.exec(r))){let r,n,a=[...i[0]].length-1,o=a,s=0,l="*"===i[0][0]?this.rules.inline.emStrongRDelimAst:this.rules.inline.emStrongRDelimUnd;for(l.lastIndex=0,e=e.slice(-1*t.length+a);null!=(i=l.exec(e));){if(r=i[1]||i[2]||i[3]||i[4]||i[5]||i[6],!r)continue;if(n=[...r].length,i[3]||i[4]){o+=n;continue}if((i[5]||i[6])&&a%3&&!((a+n)%3)){s+=n;continue}if(o-=n,o>0)continue;n=Math.min(n,n+o+s);let e=[...i[0]][0].length,l=t.slice(0,a+i.index+e+n);if(Math.min(a,n)%2){let t=l.slice(1,-1);return{type:"em",raw:l,text:t,tokens:this.lexer.inlineTokens(t)}}let h=l.slice(2,-2);return{type:"strong",raw:l,text:h,tokens:this.lexer.inlineTokens(h)}}}}codespan(t){let e=this.rules.inline.code.exec(t);if(e){let t=e[2].replace(this.rules.other.newLineCharGlobal," "),r=this.rules.other.nonSpaceChar.test(t),i=this.rules.other.startingSpaceChar.test(t)&&this.rules.other.endingSpaceChar.test(t);return r&&i&&(t=t.substring(1,t.length-1)),{type:"codespan",raw:e[0],text:t}}}br(t){let e=this.rules.inline.br.exec(t);if(e)return{type:"br",raw:e[0]}}del(t){let e=this.rules.inline.del.exec(t);if(e)return{type:"del",raw:e[0],text:e[2],tokens:this.lexer.inlineTokens(e[2])}}autolink(t){let e=this.rules.inline.autolink.exec(t);if(e){let t,r;return"@"===e[2]?(t=e[1],r="mailto:"+t):(t=e[1],r=t),{type:"link",raw:e[0],text:t,href:r,tokens:[{type:"text",raw:t,text:t}]}}}url(t){let e;if(e=this.rules.inline.url.exec(t)){let t,r;if("@"===e[2])t=e[0],r="mailto:"+t;else{let i;do{i=e[0],e[0]=this.rules.inline._backpedal.exec(e[0])?.[0]??""}while(i!==e[0]);t=e[0],r="www."===e[1]?"http://"+e[0]:e[0]}return{type:"link",raw:e[0],text:t,href:r,tokens:[{type:"text",raw:t,text:t}]}}}inlineText(t){let e=this.rules.inline.text.exec(t);if(e){let t=this.lexer.state.inRawBlock;return{type:"text",raw:e[0],text:e[0],escaped:t}}}},Zv=class t{static{s(this,"l")}tokens;options;state;tokenizer;inlineQueue;constructor(t){this.tokens=[],this.tokens.links=Object.create(null),this.options=t||U_,this.options.tokenizer=this.options.tokenizer||new Xv,this.tokenizer=this.options.tokenizer,this.tokenizer.options=this.options,this.tokenizer.lexer=this,this.inlineQueue=[],this.state={inLink:!1,inRawBlock:!1,top:!0};let e={other:X_,block:Rv.normal,inline:Pv.normal};this.options.pedantic?(e.block=Rv.pedantic,e.inline=Pv.pedantic):this.options.gfm&&(e.block=Rv.gfm,this.options.breaks?e.inline=Pv.breaks:e.inline=Pv.gfm),this.tokenizer.rules=e}static get rules(){return{block:Rv,inline:Pv}}static lex(e,r){return new t(r).lex(e)}static lexInline(e,r){return new t(r).inlineTokens(e)}lex(t){t=t.replace(X_.carriageReturn,"\n"),this.blockTokens(t,this.tokens);for(let t=0;t<this.inlineQueue.length;t++){let e=this.inlineQueue[t];this.inlineTokens(e.src,e.tokens)}return this.inlineQueue=[],this.tokens}blockTokens(t,e=[],r=!1){for(this.options.pedantic&&(t=t.replace(X_.tabCharGlobal,"    ").replace(X_.spaceLine,""));t;){let i;if(this.options.extensions?.block?.some(r=>!!(i=r.call({lexer:this},t,e))&&(t=t.substring(i.raw.length),e.push(i),!0)))continue;if(i=this.tokenizer.space(t)){t=t.substring(i.raw.length);let r=e.at(-1);1===i.raw.length&&void 0!==r?r.raw+="\n":e.push(i);continue}if(i=this.tokenizer.code(t)){t=t.substring(i.raw.length);let r=e.at(-1);"paragraph"===r?.type||"text"===r?.type?(r.raw+=(r.raw.endsWith("\n")?"":"\n")+i.raw,r.text+="\n"+i.text,this.inlineQueue.at(-1).src=r.text):e.push(i);continue}if(i=this.tokenizer.fences(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.heading(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.hr(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.blockquote(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.list(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.html(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.def(t)){t=t.substring(i.raw.length);let r=e.at(-1);"paragraph"===r?.type||"text"===r?.type?(r.raw+=(r.raw.endsWith("\n")?"":"\n")+i.raw,r.text+="\n"+i.raw,this.inlineQueue.at(-1).src=r.text):this.tokens.links[i.tag]||(this.tokens.links[i.tag]={href:i.href,title:i.title},e.push(i));continue}if(i=this.tokenizer.table(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.lheading(t)){t=t.substring(i.raw.length),e.push(i);continue}let n=t;if(this.options.extensions?.startBlock){let e,r=1/0,i=t.slice(1);this.options.extensions.startBlock.forEach(t=>{e=t.call({lexer:this},i),"number"==typeof e&&e>=0&&(r=Math.min(r,e))}),r<1/0&&r>=0&&(n=t.substring(0,r+1))}if(this.state.top&&(i=this.tokenizer.paragraph(n))){let a=e.at(-1);r&&"paragraph"===a?.type?(a.raw+=(a.raw.endsWith("\n")?"":"\n")+i.raw,a.text+="\n"+i.text,this.inlineQueue.pop(),this.inlineQueue.at(-1).src=a.text):e.push(i),r=n.length!==t.length,t=t.substring(i.raw.length);continue}if(i=this.tokenizer.text(t)){t=t.substring(i.raw.length);let r=e.at(-1);"text"===r?.type?(r.raw+=(r.raw.endsWith("\n")?"":"\n")+i.raw,r.text+="\n"+i.text,this.inlineQueue.pop(),this.inlineQueue.at(-1).src=r.text):e.push(i);continue}if(t){let e="Infinite loop on byte: "+t.charCodeAt(0);if(this.options.silent){console.error(e);break}throw new Error(e)}}return this.state.top=!0,e}inline(t,e=[]){return this.inlineQueue.push({src:t,tokens:e}),e}inlineTokens(t,e=[]){let r=t,i=null;if(this.tokens.links){let t=Object.keys(this.tokens.links);if(t.length>0)for(;null!=(i=this.tokenizer.rules.inline.reflinkSearch.exec(r));)t.includes(i[0].slice(i[0].lastIndexOf("[")+1,-1))&&(r=r.slice(0,i.index)+"["+"a".repeat(i[0].length-2)+"]"+r.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex))}for(;null!=(i=this.tokenizer.rules.inline.anyPunctuation.exec(r));)r=r.slice(0,i.index)+"++"+r.slice(this.tokenizer.rules.inline.anyPunctuation.lastIndex);for(;null!=(i=this.tokenizer.rules.inline.blockSkip.exec(r));)r=r.slice(0,i.index)+"["+"a".repeat(i[0].length-2)+"]"+r.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);r=this.options.hooks?.emStrongMask?.call({lexer:this},r)??r;let n=!1,a="";for(;t;){let i;if(n||(a=""),n=!1,this.options.extensions?.inline?.some(r=>!!(i=r.call({lexer:this},t,e))&&(t=t.substring(i.raw.length),e.push(i),!0)))continue;if(i=this.tokenizer.escape(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.tag(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.link(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.reflink(t,this.tokens.links)){t=t.substring(i.raw.length);let r=e.at(-1);"text"===i.type&&"text"===r?.type?(r.raw+=i.raw,r.text+=i.text):e.push(i);continue}if(i=this.tokenizer.emStrong(t,r,a)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.codespan(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.br(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.del(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.autolink(t)){t=t.substring(i.raw.length),e.push(i);continue}if(!this.state.inLink&&(i=this.tokenizer.url(t))){t=t.substring(i.raw.length),e.push(i);continue}let o=t;if(this.options.extensions?.startInline){let e,r=1/0,i=t.slice(1);this.options.extensions.startInline.forEach(t=>{e=t.call({lexer:this},i),"number"==typeof e&&e>=0&&(r=Math.min(r,e))}),r<1/0&&r>=0&&(o=t.substring(0,r+1))}if(i=this.tokenizer.inlineText(o)){t=t.substring(i.raw.length),"_"!==i.raw.slice(-1)&&(a=i.raw.slice(-1)),n=!0;let r=e.at(-1);"text"===r?.type?(r.raw+=i.raw,r.text+=i.text):e.push(i);continue}if(t){let e="Infinite loop on byte: "+t.charCodeAt(0);if(this.options.silent){console.error(e);break}throw new Error(e)}}return e}},Qv=class{static{s(this,"P")}options;parser;constructor(t){this.options=t||U_}space(t){return""}code({text:t,lang:e,escaped:r}){let i=(e||"").match(X_.notSpaceStart)?.[0],n=t.replace(X_.endingNewline,"")+"\n";return i?'<pre><code class="language-'+jv(i)+'">'+(r?n:jv(n,!0))+"</code></pre>\n":"<pre><code>"+(r?n:jv(n,!0))+"</code></pre>\n"}blockquote({tokens:t}){return`<blockquote>\n${this.parser.parse(t)}</blockquote>\n`}html({text:t}){return t}def(t){return""}heading({tokens:t,depth:e}){return`<h${e}>${this.parser.parseInline(t)}</h${e}>\n`}hr(t){return"<hr>\n"}list(t){let e=t.ordered,r=t.start,i="";for(let e=0;e<t.items.length;e++){let r=t.items[e];i+=this.listitem(r)}let n=e?"ol":"ul";return"<"+n+(e&&1!==r?' start="'+r+'"':"")+">\n"+i+"</"+n+">\n"}listitem(t){let e="";if(t.task){let r=this.checkbox({checked:!!t.checked});t.loose?"paragraph"===t.tokens[0]?.type?(t.tokens[0].text=r+" "+t.tokens[0].text,t.tokens[0].tokens&&t.tokens[0].tokens.length>0&&"text"===t.tokens[0].tokens[0].type&&(t.tokens[0].tokens[0].text=r+" "+jv(t.tokens[0].tokens[0].text),t.tokens[0].tokens[0].escaped=!0)):t.tokens.unshift({type:"text",raw:r+" ",text:r+" ",escaped:!0}):e+=r+" "}return e+=this.parser.parse(t.tokens,!!t.loose),`<li>${e}</li>\n`}checkbox({checked:t}){return"<input "+(t?'checked="" ':"")+'disabled="" type="checkbox">'}paragraph({tokens:t}){return`<p>${this.parser.parseInline(t)}</p>\n`}table(t){let e="",r="";for(let e=0;e<t.header.length;e++)r+=this.tablecell(t.header[e]);e+=this.tablerow({text:r});let i="";for(let e=0;e<t.rows.length;e++){let n=t.rows[e];r="";for(let t=0;t<n.length;t++)r+=this.tablecell(n[t]);i+=this.tablerow({text:r})}return i&&(i=`<tbody>${i}</tbody>`),"<table>\n<thead>\n"+e+"</thead>\n"+i+"</table>\n"}tablerow({text:t}){return`<tr>\n${t}</tr>\n`}tablecell(t){let e=this.parser.parseInline(t.tokens),r=t.header?"th":"td";return(t.align?`<${r} align="${t.align}">`:`<${r}>`)+e+`</${r}>\n`}strong({tokens:t}){return`<strong>${this.parser.parseInline(t)}</strong>`}em({tokens:t}){return`<em>${this.parser.parseInline(t)}</em>`}codespan({text:t}){return`<code>${jv(t,!0)}</code>`}br(t){return"<br>"}del({tokens:t}){return`<del>${this.parser.parseInline(t)}</del>`}link({href:t,title:e,tokens:r}){let i=this.parser.parseInline(r),n=Wv(t);if(null===n)return i;let a='<a href="'+(t=n)+'"';return e&&(a+=' title="'+jv(e)+'"'),a+=">"+i+"</a>",a}image({href:t,title:e,text:r,tokens:i}){i&&(r=this.parser.parseInline(i,this.parser.textRenderer));let n=Wv(t);if(null===n)return jv(r);let a=`<img src="${t=n}" alt="${r}"`;return e&&(a+=` title="${jv(e)}"`),a+=">",a}text(t){return"tokens"in t&&t.tokens?this.parser.parseInline(t.tokens):"escaped"in t&&t.escaped?t.text:jv(t.text)}},Kv=class{static{s(this,"$")}strong({text:t}){return t}em({text:t}){return t}codespan({text:t}){return t}del({text:t}){return t}html({text:t}){return t}text({text:t}){return t}link({text:t}){return""+t}image({text:t}){return""+t}br(){return""}},Jv=class t{static{s(this,"l")}options;renderer;textRenderer;constructor(t){this.options=t||U_,this.options.renderer=this.options.renderer||new Qv,this.renderer=this.options.renderer,this.renderer.options=this.options,this.renderer.parser=this,this.textRenderer=new Kv}static parse(e,r){return new t(r).parse(e)}static parseInline(e,r){return new t(r).parseInline(e)}parse(t,e=!0){let r="";for(let i=0;i<t.length;i++){let n=t[i];if(this.options.extensions?.renderers?.[n.type]){let t=n,e=this.options.extensions.renderers[t.type].call({parser:this},t);if(!1!==e||!["space","hr","heading","code","table","blockquote","list","html","def","paragraph","text"].includes(t.type)){r+=e||"";continue}}let a=n;switch(a.type){case"space":r+=this.renderer.space(a);continue;case"hr":r+=this.renderer.hr(a);continue;case"heading":r+=this.renderer.heading(a);continue;case"code":r+=this.renderer.code(a);continue;case"table":r+=this.renderer.table(a);continue;case"blockquote":r+=this.renderer.blockquote(a);continue;case"list":r+=this.renderer.list(a);continue;case"html":r+=this.renderer.html(a);continue;case"def":r+=this.renderer.def(a);continue;case"paragraph":r+=this.renderer.paragraph(a);continue;case"text":{let n=a,o=this.renderer.text(n);for(;i+1<t.length&&"text"===t[i+1].type;)n=t[++i],o+="\n"+this.renderer.text(n);r+=e?this.renderer.paragraph({type:"paragraph",raw:o,text:o,tokens:[{type:"text",raw:o,text:o,escaped:!0}]}):o;continue}default:{let t='Token with "'+a.type+'" type was not found.';if(this.options.silent)return console.error(t),"";throw new Error(t)}}}return r}parseInline(t,e=this.renderer){let r="";for(let i=0;i<t.length;i++){let n=t[i];if(this.options.extensions?.renderers?.[n.type]){let t=this.options.extensions.renderers[n.type].call({parser:this},n);if(!1!==t||!["escape","html","link","image","strong","em","codespan","br","del","text"].includes(n.type)){r+=t||"";continue}}let a=n;switch(a.type){case"escape":case"text":r+=e.text(a);break;case"html":r+=e.html(a);break;case"link":r+=e.link(a);break;case"image":r+=e.image(a);break;case"strong":r+=e.strong(a);break;case"em":r+=e.em(a);break;case"codespan":r+=e.codespan(a);break;case"br":r+=e.br(a);break;case"del":r+=e.del(a);break;default:{let t='Token with "'+a.type+'" type was not found.';if(this.options.silent)return console.error(t),"";throw new Error(t)}}}return r}},tS=class{static{s(this,"S")}options;block;constructor(t){this.options=t||U_}static passThroughHooks=new Set(["preprocess","postprocess","processAllTokens","emStrongMask"]);static passThroughHooksRespectAsync=new Set(["preprocess","postprocess","processAllTokens"]);preprocess(t){return t}postprocess(t){return t}processAllTokens(t){return t}emStrongMask(t){return t}provideLexer(){return this.block?Zv.lex:Zv.lexInline}provideParser(){return this.block?Jv.parse:Jv.parseInline}},eS=class{static{s(this,"B")}defaults={async:!1,breaks:!1,extensions:null,gfm:!0,hooks:null,pedantic:!1,renderer:null,silent:!1,tokenizer:null,walkTokens:null};options=this.setOptions;parse=this.parseMarkdown(!0);parseInline=this.parseMarkdown(!1);Parser=Jv;Renderer=Qv;TextRenderer=Kv;Lexer=Zv;Tokenizer=Xv;Hooks=tS;constructor(...t){this.use(...t)}walkTokens(t,e){let r=[];for(let i of t)switch(r=r.concat(e.call(this,i)),i.type){case"table":{let t=i;for(let i of t.header)r=r.concat(this.walkTokens(i.tokens,e));for(let i of t.rows)for(let t of i)r=r.concat(this.walkTokens(t.tokens,e));break}case"list":{let t=i;r=r.concat(this.walkTokens(t.items,e));break}default:{let t=i;this.defaults.extensions?.childTokens?.[t.type]?this.defaults.extensions.childTokens[t.type].forEach(i=>{let n=t[i].flat(1/0);r=r.concat(this.walkTokens(n,e))}):t.tokens&&(r=r.concat(this.walkTokens(t.tokens,e)))}}return r}use(...t){let e=this.defaults.extensions||{renderers:{},childTokens:{}};return t.forEach(t=>{let r={...t};if(r.async=this.defaults.async||r.async||!1,t.extensions&&(t.extensions.forEach(t=>{if(!t.name)throw new Error("extension name required");if("renderer"in t){let r=e.renderers[t.name];e.renderers[t.name]=r?function(...e){let i=t.renderer.apply(this,e);return!1===i&&(i=r.apply(this,e)),i}:t.renderer}if("tokenizer"in t){if(!t.level||"block"!==t.level&&"inline"!==t.level)throw new Error("extension level must be 'block' or 'inline'");let r=e[t.level];r?r.unshift(t.tokenizer):e[t.level]=[t.tokenizer],t.start&&("block"===t.level?e.startBlock?e.startBlock.push(t.start):e.startBlock=[t.start]:"inline"===t.level&&(e.startInline?e.startInline.push(t.start):e.startInline=[t.start]))}"childTokens"in t&&t.childTokens&&(e.childTokens[t.name]=t.childTokens)}),r.extensions=e),t.renderer){let e=this.defaults.renderer||new Qv(this.defaults);for(let r in t.renderer){if(!(r in e))throw new Error(`renderer '${r}' does not exist`);if(["options","parser"].includes(r))continue;let i=r,n=t.renderer[i],a=e[i];e[i]=(...t)=>{let r=n.apply(e,t);return!1===r&&(r=a.apply(e,t)),r||""}}r.renderer=e}if(t.tokenizer){let e=this.defaults.tokenizer||new Xv(this.defaults);for(let r in t.tokenizer){if(!(r in e))throw new Error(`tokenizer '${r}' does not exist`);if(["options","rules","lexer"].includes(r))continue;let i=r,n=t.tokenizer[i],a=e[i];e[i]=(...t)=>{let r=n.apply(e,t);return!1===r&&(r=a.apply(e,t)),r}}r.tokenizer=e}if(t.hooks){let e=this.defaults.hooks||new tS;for(let r in t.hooks){if(!(r in e))throw new Error(`hook '${r}' does not exist`);if(["options","block"].includes(r))continue;let i=r,n=t.hooks[i],a=e[i];tS.passThroughHooks.has(r)?e[i]=t=>{if(this.defaults.async&&tS.passThroughHooksRespectAsync.has(r))return Promise.resolve(n.call(e,t)).then(t=>a.call(e,t));let i=n.call(e,t);return a.call(e,i)}:e[i]=(...t)=>{let r=n.apply(e,t);return!1===r&&(r=a.apply(e,t)),r}}r.hooks=e}if(t.walkTokens){let e=this.defaults.walkTokens,i=t.walkTokens;r.walkTokens=function(t){let r=[];return r.push(i.call(this,t)),e&&(r=r.concat(e.call(this,t))),r}}this.defaults={...this.defaults,...r}}),this}setOptions(t){return this.defaults={...this.defaults,...t},this}lexer(t,e){return Zv.lex(t,e??this.defaults)}parser(t,e){return Jv.parse(t,e??this.defaults)}parseMarkdown(t){return(e,r)=>{let i={...r},n={...this.defaults,...i},a=this.onError(!!n.silent,!!n.async);if(!0===this.defaults.async&&!1===i.async)return a(new Error("marked(): The async option was set to true by an extension. Remove async: false from the parse options object to return a Promise."));if(typeof e>"u"||null===e)return a(new Error("marked(): input parameter is undefined or null"));if("string"!=typeof e)return a(new Error("marked(): input parameter is of type "+Object.prototype.toString.call(e)+", string expected"));n.hooks&&(n.hooks.options=n,n.hooks.block=t);let o=n.hooks?n.hooks.provideLexer():t?Zv.lex:Zv.lexInline,s=n.hooks?n.hooks.provideParser():t?Jv.parse:Jv.parseInline;if(n.async)return Promise.resolve(n.hooks?n.hooks.preprocess(e):e).then(t=>o(t,n)).then(t=>n.hooks?n.hooks.processAllTokens(t):t).then(t=>n.walkTokens?Promise.all(this.walkTokens(t,n.walkTokens)).then(()=>t):t).then(t=>s(t,n)).then(t=>n.hooks?n.hooks.postprocess(t):t).catch(a);try{n.hooks&&(e=n.hooks.preprocess(e));let t=o(e,n);n.hooks&&(t=n.hooks.processAllTokens(t)),n.walkTokens&&this.walkTokens(t,n.walkTokens);let r=s(t,n);return n.hooks&&(r=n.hooks.postprocess(r)),r}catch(t){return a(t)}}}onError(t,e){return r=>{if(r.message+="\nPlease report this to https://github.com/markedjs/marked.",t){let t="<p>An error occurred:</p><pre>"+jv(r.message+"",!0)+"</pre>";return e?Promise.resolve(t):t}if(e)return Promise.reject(r);throw r}}},rS=new eS;function iS(t,e){return rS.parse(t,e)}function nS(t,{markdownAutoWrap:e}){let r=W_(t.replace(/<br\/>/g,"\n").replace(/\n{2,}/g,"\n"));return!1===e?r.replace(/ /g,"&nbsp;"):r}function aS(t,e={}){let r=nS(t,e),i=iS.lexer(r),n=[[]],a=0;function o(t,e="normal"){"text"===t.type?t.text.split("\n").forEach((t,r)=>{0!==r&&(a++,n.push([])),t.split(" ").forEach(t=>{(t=t.replace(/&#39;/g,"'"))&&n[a].push({content:t,type:e})})}):"strong"===t.type||"em"===t.type?t.tokens.forEach(e=>{o(e,t.type)}):"html"===t.type&&n[a].push({content:t.text,type:"normal"})}return s(o,"processNode"),i.forEach(t=>{"paragraph"===t.type?t.tokens?.forEach(t=>{o(t)}):"html"===t.type?n[a].push({content:t.text,type:"normal"}):n[a].push({content:t.raw,type:"normal"})}),n}function oS(t,{markdownAutoWrap:e}={}){let r=iS.lexer(t);function i(t){return"text"===t.type?!1===e?t.text.replace(/\n */g,"<br/>").replace(/ /g,"&nbsp;"):t.text.replace(/\n */g,"<br/>"):"strong"===t.type?`<strong>${t.tokens?.map(i).join("")}</strong>`:"em"===t.type?`<em>${t.tokens?.map(i).join("")}</em>`:"paragraph"===t.type?`<p>${t.tokens?.map(i).join("")}</p>`:"space"===t.type?"":"html"===t.type?`${t.text}`:"escape"===t.type?t.text:(y.warn(`Unsupported markdown: ${t.type}`),t.raw)}return s(i,"output"),r.map(i).join("")}function sS(t){return Intl.Segmenter?[...(new Intl.Segmenter).segment(t)].map(t=>t.segment):[...t]}function lS(t,e){return hS(t,[],sS(e.content),e.type)}function hS(t,e,r,i){if(0===r.length)return[{content:e.join(""),type:i},{content:"",type:i}];let[n,...a]=r,o=[...e,n];return t([{content:o.join(""),type:i}])?hS(t,o,a,i):(0===e.length&&n&&(e.push(n),r.shift()),[{content:e.join(""),type:i},{content:r.join(""),type:i}])}function cS(t,e){if(t.some(({content:t})=>t.includes("\n")))throw new Error("splitLineToFitWidth does not support newlines in the line");return uS(t,e)}function uS(t,e,r=[],i=[]){if(0===t.length)return i.length>0&&r.push(i),r.length>0?r:[];let n="";" "===t[0].content&&(n=" ",t.shift());let a=t.shift()??{content:" ",type:"normal"},o=[...i];if(""!==n&&o.push({content:n,type:"normal"}),o.push(a),e(o))return uS(t,e,r,o);if(i.length>0)r.push(i),t.unshift(a);else if(a.content){let[i,n]=lS(e,a);r.push([i]),n.content&&t.unshift(n)}return uS(t,e,r)}function dS(t,e){e&&t.attr("style",e)}async function pS(t,e,r,i,n=!1,a=Bd()){let o=t.append("foreignObject");o.attr("width",10*r+"px"),o.attr("height",10*r+"px");let s=o.append("xhtml:div"),l=ff(e.label)?await mf(e.label.replace(xf.lineBreakRegex,"\n"),a):Qp(e.label,a),h=e.isNode?"nodeLabel":"edgeLabel",c=s.append("span");c.html(l),dS(c,e.labelStyle),c.attr("class",`${h} ${i}`),dS(s,e.labelStyle),s.style("display","table-cell"),s.style("white-space","nowrap"),s.style("line-height","1.5"),s.style("max-width",r+"px"),s.style("text-align","center"),s.attr("xmlns","http://www.w3.org/1999/xhtml"),n&&s.attr("class","labelBkg");let u=s.node().getBoundingClientRect();return u.width===r&&(s.style("display","table"),s.style("white-space","break-spaces"),s.style("width",r+"px"),u=s.node().getBoundingClientRect()),o.node()}function fS(t,e,r){return t.append("tspan").attr("class","text-outer-tspan").attr("x",0).attr("y",e*r-.1+"em").attr("dy",r+"em")}function gS(t,e,r){let i=t.append("text"),n=fS(i,1,e);xS(n,r);let a=n.node().getComputedTextLength();return i.remove(),a}function yS(t,e,r){let i=t.append("text"),n=fS(i,1,e);xS(n,[{content:r,type:"normal"}]);let a=n.node()?.getBoundingClientRect();return a&&i.remove(),a}function mS(t,e,r,i=!1){let n=e.append("g"),a=n.insert("rect").attr("class","background").attr("style","stroke: none"),o=n.append("text").attr("y","-10.1"),l=0;for(let e of r){let r=s(e=>gS(n,1.1,e)<=t,"checkWidth"),i=r(e)?[e]:cS(e,r);for(let t of i){xS(fS(o,l,1.1),t),l++}}if(i){let t=o.node().getBBox(),e=2;return a.attr("x",t.x-e).attr("y",t.y-e).attr("width",t.width+2*e).attr("height",t.height+2*e),n.node()}return o.node()}function xS(t,e){t.text(""),e.forEach((e,r)=>{let i=t.append("tspan").attr("font-style","em"===e.type?"italic":"normal").attr("class","text-inner-tspan").attr("font-weight","strong"===e.type?"bold":"normal");0===r?i.text(e.content):i.text(" "+e.content)})}async function bS(t,e={}){let r=[];t.replace(/(fa[bklrs]?):fa-([\w-]+)/g,(t,i,n)=>(r.push((async()=>{let r=`${i}:${n}`;return await q_(r)?await j_(r,void 0,{class:"label-icon"}):`<i class='${Qp(t,e).replace(":"," ")}'></i>`})()),t));let i=await Promise.all(r);return t.replace(/(fa[bklrs]?):fa-([\w-]+)/g,()=>i.shift()??"")}s(iS,"d"),iS.options=iS.setOptions=function(t){return rS.setOptions(t),iS.defaults=rS.defaults,Y_(iS.defaults),iS},iS.getDefaults=H_,iS.defaults=U_,iS.use=function(...t){return rS.use(...t),iS.defaults=rS.defaults,Y_(iS.defaults),iS},iS.walkTokens=function(t,e){return rS.walkTokens(t,e)},iS.parseInline=rS.parseInline,iS.Parser=Jv,iS.parser=Jv.parse,iS.Renderer=Qv,iS.TextRenderer=Kv,iS.Lexer=Zv,iS.lexer=Zv.lex,iS.Tokenizer=Xv,iS.Hooks=tS,iS.parse=iS,iS.options,iS.setOptions,iS.use,iS.walkTokens,iS.parseInline,Jv.parse,Zv.lex,s(nS,"preprocessMarkdown"),s(aS,"markdownToLines"),s(oS,"markdownToHTML"),s(sS,"splitTextToChars"),s(lS,"splitWordToFitWidth"),s(hS,"splitWordToFitWidthRecursion"),s(cS,"splitLineToFitWidth"),s(uS,"splitLineToFitWidthRecursion"),s(dS,"applyStyle"),s(pS,"addHtmlSpan"),s(fS,"createTspan"),s(gS,"computeWidthOfText"),s(yS,"computeDimensionOfText"),s(mS,"createFormattedText"),s(xS,"updateTextContentAndStyles"),s(bS,"replaceIconSubstring");var kS=s(async(t,e="",{style:r="",isTitle:i=!1,classes:n="",useHtmlLabels:a=!0,isNode:o=!0,width:s=200,addSvgBackground:l=!1}={},h)=>{if(y.debug("XYZ createText",e,r,i,n,a,o,"addSvgBackground: ",l),a){let i=oS(e,h),a=await bS(o_(i),h),c=e.replace(/\\\\/g,"\\"),u={isNode:o,label:ff(e)?c:a,labelStyle:r.replace("fill:","color:")};return await pS(t,u,s,n,l,h)}{let i=mS(s,t,aS(e.replace(/<br\s*\/?>/g,"<br/>").replace("<br>","<br/>"),h),!!e&&l);if(o){/stroke:/.exec(r)&&(r=r.replace("stroke:","lineColor:"));let t=r.replace(/stroke:[^;]+;?/g,"").replace(/stroke-width:[^;]+;?/g,"").replace(/fill:[^;]+;?/g,"").replace(/color:/g,"fill:");Ke(i).attr("style",t)}else{let t=r.replace(/stroke:[^;]+;?/g,"").replace(/stroke-width:[^;]+;?/g,"").replace(/fill:[^;]+;?/g,"").replace(/background:/g,"fill:");Ke(i).select("rect").attr("style",t.replace(/background:/g,"fill:"));let e=r.replace(/stroke:[^;]+;?/g,"").replace(/stroke-width:[^;]+;?/g,"").replace(/fill:[^;]+;?/g,"").replace(/color:/g,"fill:");Ke(i).select("text").attr("style",e)}return i}},"createText"),CS=s(async(t,e,r)=>{let i,n=e.useHtmlLabels||af(qf()?.htmlLabels);i=r||"node default";let a,o=t.insert("g").attr("class",i).attr("id",e.domId||e.id),l=o.insert("g").attr("class","label").attr("style",l_(e.labelStyle));a=void 0===e.label?"":"string"==typeof e.label?e.label:e.label[0];let h=await kS(l,Qp(o_(a),qf()),{useHtmlLabels:n,width:e.width||qf().flowchart?.wrappingWidth,cssClasses:"markdown-node-label",style:e.labelStyle,addSvgBackground:!!e.icon||!!e.img}),c=h.getBBox(),u=(e?.padding??0)/2;if(n){let t=h.children[0],e=Ke(h),r=t.getElementsByTagName("img");if(r){let t=""===a.replace(/<img[^>]*>/g,"").trim();await Promise.all([...r].map(e=>new Promise(r=>{function i(){if(e.style.display="flex",e.style.flexDirection="column",t){let t=qf().fontSize?qf().fontSize:window.getComputedStyle(document.body).fontSize,r=5,[i=gd.fontSize]=r_(t),n=i*r+"px";e.style.minWidth=n,e.style.maxWidth=n}else e.style.width="100%";r(e)}s(i,"setupImage"),setTimeout(()=>{e.complete&&i()}),e.addEventListener("error",i),e.addEventListener("load",i)})))}c=t.getBoundingClientRect(),e.attr("width",c.width),e.attr("height",c.height)}return n?l.attr("transform","translate("+-c.width/2+", "+-c.height/2+")"):l.attr("transform","translate(0, "+-c.height/2+")"),e.centerLabel&&l.attr("transform","translate("+-c.width/2+", "+-c.height/2+")"),l.insert("rect",":first-child"),{shapeSvg:o,bbox:c,halfPadding:u,label:l}},"labelHelper"),wS=s(async(t,e,r)=>{let i=r.useHtmlLabels||af(qf()?.flowchart?.htmlLabels),n=t.insert("g").attr("class","label").attr("style",r.labelStyle||""),a=await kS(n,Qp(o_(e),qf()),{useHtmlLabels:i,width:r.width||qf()?.flowchart?.wrappingWidth,style:r.labelStyle,addSvgBackground:!!r.icon||!!r.img}),o=a.getBBox(),s=r.padding/2;if(af(qf()?.flowchart?.htmlLabels)){let t=a.children[0],e=Ke(a);o=t.getBoundingClientRect(),e.attr("width",o.width),e.attr("height",o.height)}return i?n.attr("transform","translate("+-o.width/2+", "+-o.height/2+")"):n.attr("transform","translate(0, "+-o.height/2+")"),r.centerLabel&&n.attr("transform","translate("+-o.width/2+", "+-o.height/2+")"),n.insert("rect",":first-child"),{shapeSvg:t,bbox:o,halfPadding:s,label:n}},"insertLabel"),_S=s((t,e)=>{let r=e.node().getBBox();t.width=r.width,t.height=r.height},"updateNodeBounds"),vS=s((t,e)=>("handDrawn"===t.look?"rough-node":"node")+" "+t.cssClasses+" "+(e||""),"getNodeClasses");function SS(t){let e=t.map((t,e)=>`${0===e?"M":"L"}${t.x},${t.y}`);return e.push("Z"),e.join(" ")}function TS(t,e,r,i,n,a){let o=[],s=r-t,l=i-e,h=s/a,c=2*Math.PI/h,u=e+l/2;for(let e=0;e<=50;e++){let r=t+e/50*s,i=u+n*Math.sin(c*(r-t));o.push({x:r,y:i})}return o}function MS(t,e,r,i,n,a){let o=[],s=n*Math.PI/180,l=(a*Math.PI/180-s)/(i-1);for(let n=0;n<i;n++){let i=s+n*l,a=t+r*Math.cos(i),h=e+r*Math.sin(i);o.push({x:-a,y:-h})}return o}function BS(t,e,r){if(t&&t.length){let[i,n]=e,a=Math.PI/180*r,o=Math.cos(a),s=Math.sin(a);for(let e of t){let[t,r]=e;e[0]=(t-i)*o-(r-n)*s+i,e[1]=(t-i)*s+(r-n)*o+n}}}function AS(t,e){return t[0]===e[0]&&t[1]===e[1]}function LS(t,e,r,i=1){let n=r,a=Math.max(e,.1),o=t[0]&&t[0][0]&&"number"==typeof t[0][0]?[t]:t,s=[0,0];if(n)for(let t of o)BS(t,s,n);let l=function(t,e,r){let i=[];for(let e of t){let t=[...e];AS(t[0],t[t.length-1])||t.push([t[0][0],t[0][1]]),t.length>2&&i.push(t)}let n=[];e=Math.max(e,.1);let a=[];for(let t of i)for(let e=0;e<t.length-1;e++){let r=t[e],i=t[e+1];if(r[1]!==i[1]){let t=Math.min(r[1],i[1]);a.push({ymin:t,ymax:Math.max(r[1],i[1]),x:t===r[1]?r[0]:i[0],islope:(i[0]-r[0])/(i[1]-r[1])})}}if(a.sort((t,e)=>t.ymin<e.ymin?-1:t.ymin>e.ymin?1:t.x<e.x?-1:t.x>e.x?1:t.ymax===e.ymax?0:(t.ymax-e.ymax)/Math.abs(t.ymax-e.ymax)),!a.length)return n;let o=[],s=a[0].ymin,l=0;for(;o.length||a.length;){if(a.length){let t=-1;for(let e=0;e<a.length&&!(a[e].ymin>s);e++)t=e;a.splice(0,t+1).forEach(t=>{o.push({s:s,edge:t})})}if(o=o.filter(t=>!(t.edge.ymax<=s)),o.sort((t,e)=>t.edge.x===e.edge.x?0:(t.edge.x-e.edge.x)/Math.abs(t.edge.x-e.edge.x)),(1!==r||l%e==0)&&o.length>1)for(let t=0;t<o.length;t+=2){let e=t+1;if(e>=o.length)break;let r=o[t].edge,i=o[e].edge;n.push([[Math.round(r.x),s],[Math.round(i.x),s]])}s+=r,o.forEach(t=>{t.edge.x=t.edge.x+r*t.edge.islope}),l++}return n}(o,a,i);if(n){for(let t of o)BS(t,s,-n);!function(t,e,r){let i=[];t.forEach(t=>i.push(...t)),BS(i,e,r)}(l,s,-n)}return l}function FS(t,e){var r;let i=e.hachureAngle+90,n=e.hachureGap;n<0&&(n=4*e.strokeWidth),n=Math.round(Math.max(n,.1));let a=1;return e.roughness>=1&&((null===(r=e.randomizer)||void 0===r?void 0:r.next())||Math.random())>.7&&(a=n),LS(t,n,i,a||1)}s(SS,"createPathFromPoints"),s(TS,"generateFullSineWavePoints"),s(MS,"generateCirclePoints"),s(BS,"t"),s(AS,"e"),s(LS,"s"),s(FS,"n");var $S=class{static{s(this,"o")}constructor(t){this.helper=t}fillPolygons(t,e){return this._fillPolygons(t,e)}_fillPolygons(t,e){let r=FS(t,e);return{type:"fillSketch",ops:this.renderLines(r,e)}}renderLines(t,e){let r=[];for(let i of t)r.push(...this.helper.doubleLineOps(i[0][0],i[0][1],i[1][0],i[1][1],e));return r}};function ES(t){let e=t[0],r=t[1];return Math.sqrt(Math.pow(e[0]-r[0],2)+Math.pow(e[1]-r[1],2))}s(ES,"a");var DS=class extends $S{static{s(this,"h")}fillPolygons(t,e){let r=e.hachureGap;r<0&&(r=4*e.strokeWidth),r=Math.max(r,.1);let i=FS(t,Object.assign({},e,{hachureGap:r})),n=Math.PI/180*e.hachureAngle,a=[],o=.5*r*Math.cos(n),s=.5*r*Math.sin(n);for(let[t,e]of i)ES([t,e])&&a.push([[t[0]-o,t[1]+s],[...e]],[[t[0]+o,t[1]-s],[...e]]);return{type:"fillSketch",ops:this.renderLines(a,e)}}},OS=class extends $S{static{s(this,"r")}fillPolygons(t,e){let r=this._fillPolygons(t,e),i=Object.assign({},e,{hachureAngle:e.hachureAngle+90}),n=this._fillPolygons(t,i);return r.ops=r.ops.concat(n.ops),r}},IS=class{static{s(this,"i")}constructor(t){this.helper=t}fillPolygons(t,e){let r=FS(t,e=Object.assign({},e,{hachureAngle:0}));return this.dotsOnLines(r,e)}dotsOnLines(t,e){let r=[],i=e.hachureGap;i<0&&(i=4*e.strokeWidth),i=Math.max(i,.1);let n=e.fillWeight;n<0&&(n=e.strokeWidth/2);let a=i/4;for(let o of t){let t=ES(o),s=t/i,l=Math.ceil(s)-1,h=t-l*i,c=(o[0][0]+o[1][0])/2-i/4,u=Math.min(o[0][1],o[1][1]);for(let t=0;t<l;t++){let o=u+h+t*i,s=c-a+2*Math.random()*a,l=o-a+2*Math.random()*a,d=this.helper.ellipse(s,l,n,n,e);r.push(...d.ops)}}return{type:"fillSketch",ops:r}}},NS=class{static{s(this,"c")}constructor(t){this.helper=t}fillPolygons(t,e){let r=FS(t,e);return{type:"fillSketch",ops:this.dashedLine(r,e)}}dashedLine(t,e){let r=e.dashOffset<0?e.hachureGap<0?4*e.strokeWidth:e.hachureGap:e.dashOffset,i=e.dashGap<0?e.hachureGap<0?4*e.strokeWidth:e.hachureGap:e.dashGap,n=[];return t.forEach(t=>{let a=ES(t),o=Math.floor(a/(r+i)),s=(a+i-o*(r+i))/2,l=t[0],h=t[1];l[0]>h[0]&&(l=t[1],h=t[0]);let c=Math.atan((h[1]-l[1])/(h[0]-l[0]));for(let t=0;t<o;t++){let a=t*(r+i),o=a+r,h=[l[0]+a*Math.cos(c)+s*Math.cos(c),l[1]+a*Math.sin(c)+s*Math.sin(c)],u=[l[0]+o*Math.cos(c)+s*Math.cos(c),l[1]+o*Math.sin(c)+s*Math.sin(c)];n.push(...this.helper.doubleLineOps(h[0],h[1],u[0],u[1],e))}}),n}},RS=class{static{s(this,"l")}constructor(t){this.helper=t}fillPolygons(t,e){let r=e.hachureGap<0?4*e.strokeWidth:e.hachureGap,i=e.zigzagOffset<0?r:e.zigzagOffset,n=FS(t,e=Object.assign({},e,{hachureGap:r+i}));return{type:"fillSketch",ops:this.zigzagLines(n,i,e)}}zigzagLines(t,e,r){let i=[];return t.forEach(t=>{let n=ES(t),a=Math.round(n/(2*e)),o=t[0],s=t[1];o[0]>s[0]&&(o=t[1],s=t[0]);let l=Math.atan((s[1]-o[1])/(s[0]-o[0]));for(let t=0;t<a;t++){let n=2*t*e,a=2*(t+1)*e,s=Math.sqrt(2*Math.pow(e,2)),h=[o[0]+n*Math.cos(l),o[1]+n*Math.sin(l)],c=[o[0]+a*Math.cos(l),o[1]+a*Math.sin(l)],u=[h[0]+s*Math.cos(l+Math.PI/4),h[1]+s*Math.sin(l+Math.PI/4)];i.push(...this.helper.doubleLineOps(h[0],h[1],u[0],u[1],r),...this.helper.doubleLineOps(u[0],u[1],c[0],c[1],r))}}),i}},PS={},zS=class{static{s(this,"p")}constructor(t){this.seed=t}next(){return this.seed?(2**31-1&(this.seed=Math.imul(48271,this.seed)))/2**31:Math.random()}},qS={A:7,a:7,C:6,c:6,H:1,h:1,L:2,l:2,M:2,m:2,Q:4,q:4,S:4,s:4,T:2,t:2,V:1,v:1,Z:0,z:0};function jS(t,e){return t.type===e}function WS(t){let e=[],r=function(t){let e=new Array;for(;""!==t;)if(t.match(/^([ \t\r\n,]+)/))t=t.substr(RegExp.$1.length);else if(t.match(/^([aAcChHlLmMqQsStTvVzZ])/))e[e.length]={type:0,text:RegExp.$1},t=t.substr(RegExp.$1.length);else{if(!t.match(/^(([-+]?[0-9]+(\.[0-9]*)?|[-+]?\.[0-9]+)([eE][-+]?[0-9]+)?)/))return[];e[e.length]={type:1,text:`${parseFloat(RegExp.$1)}`},t=t.substr(RegExp.$1.length)}return e[e.length]={type:2,text:""},e}(t),i="BOD",n=0,a=r[n];for(;!jS(a,2);){let o=0,s=[];if("BOD"===i){if("M"!==a.text&&"m"!==a.text)return WS("M0,0"+t);n++,o=qS[a.text],i=a.text}else jS(a,1)?o=qS[i]:(n++,o=qS[a.text],i=a.text);if(!(n+o<r.length))throw new Error("Path data ended short");for(let t=n;t<n+o;t++){let e=r[t];if(!jS(e,1))throw new Error("Param not a number: "+i+","+e.text);s[s.length]=+e.text}if("number"!=typeof qS[i])throw new Error("Bad segment: "+i);{let t={key:i,data:s};e.push(t),n+=o,a=r[n],"M"===i&&(i="L"),"m"===i&&(i="l")}}return e}function HS(t){let e=0,r=0,i=0,n=0,a=[];for(let{key:o,data:s}of t)switch(o){case"M":a.push({key:"M",data:[...s]}),[e,r]=s,[i,n]=s;break;case"m":e+=s[0],r+=s[1],a.push({key:"M",data:[e,r]}),i=e,n=r;break;case"L":a.push({key:"L",data:[...s]}),[e,r]=s;break;case"l":e+=s[0],r+=s[1],a.push({key:"L",data:[e,r]});break;case"C":a.push({key:"C",data:[...s]}),e=s[4],r=s[5];break;case"c":{let t=s.map((t,i)=>i%2?t+r:t+e);a.push({key:"C",data:t}),e=t[4],r=t[5];break}case"Q":a.push({key:"Q",data:[...s]}),e=s[2],r=s[3];break;case"q":{let t=s.map((t,i)=>i%2?t+r:t+e);a.push({key:"Q",data:t}),e=t[2],r=t[3];break}case"A":a.push({key:"A",data:[...s]}),e=s[5],r=s[6];break;case"a":e+=s[5],r+=s[6],a.push({key:"A",data:[s[0],s[1],s[2],s[3],s[4],e,r]});break;case"H":a.push({key:"H",data:[...s]}),e=s[0];break;case"h":e+=s[0],a.push({key:"H",data:[e]});break;case"V":a.push({key:"V",data:[...s]}),r=s[0];break;case"v":r+=s[0],a.push({key:"V",data:[r]});break;case"S":a.push({key:"S",data:[...s]}),e=s[2],r=s[3];break;case"s":{let t=s.map((t,i)=>i%2?t+r:t+e);a.push({key:"S",data:t}),e=t[2],r=t[3];break}case"T":a.push({key:"T",data:[...s]}),e=s[0],r=s[1];break;case"t":e+=s[0],r+=s[1],a.push({key:"T",data:[e,r]});break;case"Z":case"z":a.push({key:"Z",data:[]}),e=i,r=n}return a}function US(t){let e=[],r="",i=0,n=0,a=0,o=0,s=0,l=0;for(let{key:h,data:c}of t){switch(h){case"M":e.push({key:"M",data:[...c]}),[i,n]=c,[a,o]=c;break;case"C":e.push({key:"C",data:[...c]}),i=c[4],n=c[5],s=c[2],l=c[3];break;case"L":e.push({key:"L",data:[...c]}),[i,n]=c;break;case"H":i=c[0],e.push({key:"L",data:[i,n]});break;case"V":n=c[0],e.push({key:"L",data:[i,n]});break;case"S":{let t=0,a=0;"C"===r||"S"===r?(t=i+(i-s),a=n+(n-l)):(t=i,a=n),e.push({key:"C",data:[t,a,...c]}),s=c[0],l=c[1],i=c[2],n=c[3];break}case"T":{let[t,a]=c,o=0,h=0;"Q"===r||"T"===r?(o=i+(i-s),h=n+(n-l)):(o=i,h=n);let u=i+2*(o-i)/3,d=n+2*(h-n)/3,p=t+2*(o-t)/3,f=a+2*(h-a)/3;e.push({key:"C",data:[u,d,p,f,t,a]}),s=o,l=h,i=t,n=a;break}case"Q":{let[t,r,a,o]=c,h=i+2*(t-i)/3,u=n+2*(r-n)/3,d=a+2*(t-a)/3,p=o+2*(r-o)/3;e.push({key:"C",data:[h,u,d,p,a,o]}),s=t,l=r,i=a,n=o;break}case"A":{let t=Math.abs(c[0]),r=Math.abs(c[1]),a=c[2],o=c[3],s=c[4],l=c[5],h=c[6];0===t||0===r?(e.push({key:"C",data:[i,n,l,h,l,h]}),i=l,n=h):(i!==l||n!==h)&&(VS(i,n,l,h,t,r,a,o,s).forEach(function(t){e.push({key:"C",data:t})}),i=l,n=h);break}case"Z":e.push({key:"Z",data:[]}),i=a,n=o}r=h}return e}function YS(t,e,r){return[t*Math.cos(r)-e*Math.sin(r),t*Math.sin(r)+e*Math.cos(r)]}function VS(t,e,r,i,n,a,o,s,l,h){let c=(u=o,Math.PI*u/180);var u;let d=[],p=0,f=0,g=0,y=0;if(h)[p,f,g,y]=h;else{[t,e]=YS(t,e,-c),[r,i]=YS(r,i,-c);let o=(t-r)/2,h=(e-i)/2,u=o*o/(n*n)+h*h/(a*a);u>1&&(u=Math.sqrt(u),n*=u,a*=u);let d=n*n,m=a*a,x=d*m-d*h*h-m*o*o,b=d*h*h+m*o*o,k=(s===l?-1:1)*Math.sqrt(Math.abs(x/b));g=k*n*h/a+(t+r)/2,y=k*-a*o/n+(e+i)/2,p=Math.asin(parseFloat(((e-y)/a).toFixed(9))),f=Math.asin(parseFloat(((i-y)/a).toFixed(9))),t<g&&(p=Math.PI-p),r<g&&(f=Math.PI-f),p<0&&(p=2*Math.PI+p),f<0&&(f=2*Math.PI+f),l&&p>f&&(p-=2*Math.PI),!l&&f>p&&(f-=2*Math.PI)}let m=f-p;if(Math.abs(m)>120*Math.PI/180){let t=f,e=r,s=i;f=l&&f>p?p+120*Math.PI/180*1:p+120*Math.PI/180*-1,d=VS(r=g+n*Math.cos(f),i=y+a*Math.sin(f),e,s,n,a,o,0,l,[f,t,g,y])}m=f-p;let x=Math.cos(p),b=Math.sin(p),k=Math.cos(f),C=Math.sin(f),w=Math.tan(m/4),_=4/3*n*w,v=4/3*a*w,S=[t,e],T=[t+_*b,e-v*x],M=[r+_*C,i-v*k],B=[r,i];if(T[0]=2*S[0]-T[0],T[1]=2*S[1]-T[1],h)return[T,M,B].concat(d);{d=[T,M,B].concat(d);let t=[];for(let e=0;e<d.length;e+=3){let r=YS(d[e][0],d[e][1],c),i=YS(d[e+1][0],d[e+1][1],c),n=YS(d[e+2][0],d[e+2][1],c);t.push([r[0],r[1],i[0],i[1],n[0],n[1]])}return t}}s(jS,"k"),s(WS,"b"),s(HS,"y"),s(US,"m"),s(YS,"w"),s(VS,"x");var GS={randOffset:s(function(t,e){return lT(t,e)},"randOffset"),randOffsetWithRange:s(function(t,e,r){return sT(t,e,r)},"randOffsetWithRange"),ellipse:s(function(t,e,r,i,n){return tT(t,e,n,JS(r,i,n)).opset},"ellipse"),doubleLineOps:s(function(t,e,r,i,n){return hT(t,e,r,i,n,!0)},"doubleLineOps")};function XS(t,e,r,i,n){return{type:"path",ops:hT(t,e,r,i,n)}}function ZS(t,e,r){let i=(t||[]).length;if(i>2){let n=[];for(let e=0;e<i-1;e++)n.push(...hT(t[e][0],t[e][1],t[e+1][0],t[e+1][1],r));return e&&n.push(...hT(t[i-1][0],t[i-1][1],t[0][0],t[0][1],r)),{type:"path",ops:n}}return 2===i?XS(t[0][0],t[0][1],t[1][0],t[1][1],r):{type:"path",ops:[]}}function QS(t,e,r,i,n){return function(t,e){return ZS(t,!0,e)}([[t,e],[t+r,e],[t+r,e+i],[t,e+i]],n)}function KS(t,e){if(t.length){let r="number"==typeof t[0][0]?[t]:t,i=uT(r[0],1*(1+.2*e.roughness),e),n=e.disableMultiStroke?[]:uT(r[0],1.5*(1+.22*e.roughness),aT(e));for(let t=1;t<r.length;t++){let a=r[t];if(a.length){let t=uT(a,1*(1+.2*e.roughness),e),r=e.disableMultiStroke?[]:uT(a,1.5*(1+.22*e.roughness),aT(e));for(let e of t)"move"!==e.op&&i.push(e);for(let t of r)"move"!==t.op&&n.push(t)}}return{type:"path",ops:i.concat(n)}}return{type:"path",ops:[]}}function JS(t,e,r){let i=Math.sqrt(2*Math.PI*Math.sqrt((Math.pow(t/2,2)+Math.pow(e/2,2))/2)),n=Math.ceil(Math.max(r.curveStepCount,r.curveStepCount/Math.sqrt(200)*i)),a=2*Math.PI/n,o=Math.abs(t/2),s=Math.abs(e/2),l=1-r.curveFitting;return o+=lT(o*l,r),s+=lT(s*l,r),{increment:a,rx:o,ry:s}}function tT(t,e,r,i){let[n,a]=pT(i.increment,t,e,i.rx,i.ry,1,i.increment*sT(.1,sT(.4,1,r),r),r),o=dT(n,null,r);if(!r.disableMultiStroke&&0!==r.roughness){let[n]=pT(i.increment,t,e,i.rx,i.ry,1.5,0,r),a=dT(n,null,r);o=o.concat(a)}return{estimatedPoints:a,opset:{type:"path",ops:o}}}function eT(t,e,r,i,n,a,o,s,l){let h=t,c=e,u=Math.abs(r/2),d=Math.abs(i/2);u+=lT(.01*u,l),d+=lT(.01*d,l);let p=n,f=a;for(;p<0;)p+=2*Math.PI,f+=2*Math.PI;f-p>2*Math.PI&&(p=0,f=2*Math.PI);let g=2*Math.PI/l.curveStepCount,y=Math.min(g/2,(f-p)/2),m=fT(y,h,c,u,d,p,f,1,l);if(!l.disableMultiStroke){let t=fT(y,h,c,u,d,p,f,1.5,l);m.push(...t)}return o&&(s?m.push(...hT(h,c,h+u*Math.cos(p),c+d*Math.sin(p),l),...hT(h,c,h+u*Math.cos(f),c+d*Math.sin(f),l)):m.push({op:"lineTo",data:[h,c]},{op:"lineTo",data:[h+u*Math.cos(p),c+d*Math.sin(p)]})),{type:"path",ops:m}}function rT(t,e){let r=US(HS(WS(t))),i=[],n=[0,0],a=[0,0];for(let{key:t,data:o}of r)switch(t){case"M":a=[o[0],o[1]],n=[o[0],o[1]];break;case"L":i.push(...hT(a[0],a[1],o[0],o[1],e)),a=[o[0],o[1]];break;case"C":{let[t,r,n,s,l,h]=o;i.push(...gT(t,r,n,s,l,h,a,e)),a=[l,h];break}case"Z":i.push(...hT(a[0],a[1],n[0],n[1],e)),a=[n[0],n[1]]}return{type:"path",ops:i}}function iT(t,e){let r=[];for(let i of t)if(i.length){let t=e.maxRandomnessOffset||0,n=i.length;if(n>2){r.push({op:"move",data:[i[0][0]+lT(t,e),i[0][1]+lT(t,e)]});for(let a=1;a<n;a++)r.push({op:"lineTo",data:[i[a][0]+lT(t,e),i[a][1]+lT(t,e)]})}}return{type:"fillPath",ops:r}}function nT(t,e){return function(t,e){let r=t.fillStyle||"hachure";if(!PS[r])switch(r){case"zigzag":PS[r]||(PS[r]=new DS(e));break;case"cross-hatch":PS[r]||(PS[r]=new OS(e));break;case"dots":PS[r]||(PS[r]=new IS(e));break;case"dashed":PS[r]||(PS[r]=new NS(e));break;case"zigzag-line":PS[r]||(PS[r]=new RS(e));break;default:r="hachure",PS[r]||(PS[r]=new $S(e))}return PS[r]}(e,GS).fillPolygons(t,e)}function aT(t){let e=Object.assign({},t);return e.randomizer=void 0,t.seed&&(e.seed=t.seed+1),e}function oT(t){return t.randomizer||(t.randomizer=new zS(t.seed||0)),t.randomizer.next()}function sT(t,e,r,i=1){return r.roughness*i*(oT(r)*(e-t)+t)}function lT(t,e,r=1){return sT(-t,t,e,r)}function hT(t,e,r,i,n,a=!1){let o=a?n.disableMultiStrokeFill:n.disableMultiStroke,s=cT(t,e,r,i,n,!0,!1);if(o)return s;let l=cT(t,e,r,i,n,!0,!0);return s.concat(l)}function cT(t,e,r,i,n,a,o){let l=Math.pow(t-r,2)+Math.pow(e-i,2),h=Math.sqrt(l),c=1;c=h<200?1:h>500?.4:-.0016668*h+1.233334;let u=n.maxRandomnessOffset||0;u*u*100>l&&(u=h/10);let d=u/2,p=.2+.2*oT(n),f=n.bowing*n.maxRandomnessOffset*(i-e)/200,g=n.bowing*n.maxRandomnessOffset*(t-r)/200;f=lT(f,n,c),g=lT(g,n,c);let y=[],m=s(()=>lT(d,n,c),"M"),x=s(()=>lT(u,n,c),"k"),b=n.preserveVertices;return a&&(o?y.push({op:"move",data:[t+(b?0:m()),e+(b?0:m())]}):y.push({op:"move",data:[t+(b?0:lT(u,n,c)),e+(b?0:lT(u,n,c))]})),o?y.push({op:"bcurveTo",data:[f+t+(r-t)*p+m(),g+e+(i-e)*p+m(),f+t+2*(r-t)*p+m(),g+e+2*(i-e)*p+m(),r+(b?0:m()),i+(b?0:m())]}):y.push({op:"bcurveTo",data:[f+t+(r-t)*p+x(),g+e+(i-e)*p+x(),f+t+2*(r-t)*p+x(),g+e+2*(i-e)*p+x(),r+(b?0:x()),i+(b?0:x())]}),y}function uT(t,e,r){if(!t.length)return[];let i=[];i.push([t[0][0]+lT(e,r),t[0][1]+lT(e,r)]),i.push([t[0][0]+lT(e,r),t[0][1]+lT(e,r)]);for(let n=1;n<t.length;n++)i.push([t[n][0]+lT(e,r),t[n][1]+lT(e,r)]),n===t.length-1&&i.push([t[n][0]+lT(e,r),t[n][1]+lT(e,r)]);return dT(i,null,r)}function dT(t,e,r){let i=t.length,n=[];if(i>3){let a=[],o=1-r.curveTightness;n.push({op:"move",data:[t[1][0],t[1][1]]});for(let e=1;e+2<i;e++){let r=t[e];a[0]=[r[0],r[1]],a[1]=[r[0]+(o*t[e+1][0]-o*t[e-1][0])/6,r[1]+(o*t[e+1][1]-o*t[e-1][1])/6],a[2]=[t[e+1][0]+(o*t[e][0]-o*t[e+2][0])/6,t[e+1][1]+(o*t[e][1]-o*t[e+2][1])/6],a[3]=[t[e+1][0],t[e+1][1]],n.push({op:"bcurveTo",data:[a[1][0],a[1][1],a[2][0],a[2][1],a[3][0],a[3][1]]})}if(e&&2===e.length){let t=r.maxRandomnessOffset;n.push({op:"lineTo",data:[e[0]+lT(t,r),e[1]+lT(t,r)]})}}else 3===i?(n.push({op:"move",data:[t[1][0],t[1][1]]}),n.push({op:"bcurveTo",data:[t[1][0],t[1][1],t[2][0],t[2][1],t[2][0],t[2][1]]})):2===i&&n.push(...cT(t[0][0],t[0][1],t[1][0],t[1][1],r,!0,!0));return n}function pT(t,e,r,i,n,a,o,s){let l=[],h=[];if(0===s.roughness){t/=4,h.push([e+i*Math.cos(-t),r+n*Math.sin(-t)]);for(let a=0;a<=2*Math.PI;a+=t){let t=[e+i*Math.cos(a),r+n*Math.sin(a)];l.push(t),h.push(t)}h.push([e+i*Math.cos(0),r+n*Math.sin(0)]),h.push([e+i*Math.cos(t),r+n*Math.sin(t)])}else{let c=lT(.5,s)-Math.PI/2;h.push([lT(a,s)+e+.9*i*Math.cos(c-t),lT(a,s)+r+.9*n*Math.sin(c-t)]);let u=2*Math.PI+c-.01;for(let o=c;o<u;o+=t){let t=[lT(a,s)+e+i*Math.cos(o),lT(a,s)+r+n*Math.sin(o)];l.push(t),h.push(t)}h.push([lT(a,s)+e+i*Math.cos(c+2*Math.PI+.5*o),lT(a,s)+r+n*Math.sin(c+2*Math.PI+.5*o)]),h.push([lT(a,s)+e+.98*i*Math.cos(c+o),lT(a,s)+r+.98*n*Math.sin(c+o)]),h.push([lT(a,s)+e+.9*i*Math.cos(c+.5*o),lT(a,s)+r+.9*n*Math.sin(c+.5*o)])}return[h,l]}function fT(t,e,r,i,n,a,o,s,l){let h=a+lT(.1,l),c=[];c.push([lT(s,l)+e+.9*i*Math.cos(h-t),lT(s,l)+r+.9*n*Math.sin(h-t)]);for(let a=h;a<=o;a+=t)c.push([lT(s,l)+e+i*Math.cos(a),lT(s,l)+r+n*Math.sin(a)]);return c.push([e+i*Math.cos(o),r+n*Math.sin(o)]),c.push([e+i*Math.cos(o),r+n*Math.sin(o)]),dT(c,null,l)}function gT(t,e,r,i,n,a,o,s){let l=[],h=[s.maxRandomnessOffset||1,(s.maxRandomnessOffset||1)+.3],c=[0,0],u=s.disableMultiStroke?1:2,d=s.preserveVertices;for(let p=0;p<u;p++)0===p?l.push({op:"move",data:[o[0],o[1]]}):l.push({op:"move",data:[o[0]+(d?0:lT(h[0],s)),o[1]+(d?0:lT(h[0],s))]}),c=d?[n,a]:[n+lT(h[p],s),a+lT(h[p],s)],l.push({op:"bcurveTo",data:[t+lT(h[p],s),e+lT(h[p],s),r+lT(h[p],s),i+lT(h[p],s),c[0],c[1]]});return l}function yT(t){return[...t]}function mT(t,e=0){let r=t.length;if(r<3)throw new Error("A curve must have at least three points.");let i=[];if(3===r)i.push(yT(t[0]),yT(t[1]),yT(t[2]),yT(t[2]));else{let r=[];r.push(t[0],t[0]);for(let e=1;e<t.length;e++)r.push(t[e]),e===t.length-1&&r.push(t[e]);let n=[],a=1-e;i.push(yT(r[0]));for(let t=1;t+2<r.length;t++){let e=r[t];n[0]=[e[0],e[1]],n[1]=[e[0]+(a*r[t+1][0]-a*r[t-1][0])/6,e[1]+(a*r[t+1][1]-a*r[t-1][1])/6],n[2]=[r[t+1][0]+(a*r[t][0]-a*r[t+2][0])/6,r[t+1][1]+(a*r[t][1]-a*r[t+2][1])/6],n[3]=[r[t+1][0],r[t+1][1]],i.push(n[1],n[2],n[3])}}return i}function xT(t,e){return Math.pow(t[0]-e[0],2)+Math.pow(t[1]-e[1],2)}function bT(t,e,r){let i=xT(e,r);if(0===i)return xT(t,e);let n=((t[0]-e[0])*(r[0]-e[0])+(t[1]-e[1])*(r[1]-e[1]))/i;return n=Math.max(0,Math.min(1,n)),xT(t,kT(e,r,n))}function kT(t,e,r){return[t[0]+(e[0]-t[0])*r,t[1]+(e[1]-t[1])*r]}function CT(t,e,r,i){let n=i||[];if(function(t,e){let r=t[e+0],i=t[e+1],n=t[e+2],a=t[e+3],o=3*i[0]-2*r[0]-a[0];o*=o;let s=3*i[1]-2*r[1]-a[1];s*=s;let l=3*n[0]-2*a[0]-r[0];l*=l;let h=3*n[1]-2*a[1]-r[1];return h*=h,o<l&&(o=l),s<h&&(s=h),o+s}(t,e)<r){let r=t[e+0];n.length?(a=n[n.length-1],o=r,Math.sqrt(xT(a,o))>1&&n.push(r)):n.push(r),n.push(t[e+3])}else{let i=t[e+0],a=t[e+1],o=t[e+2],s=t[e+3],l=kT(i,a,.5),h=kT(a,o,.5),c=kT(o,s,.5),u=kT(l,h,.5),d=kT(h,c,.5),p=kT(u,d,.5);CT([i,l,u,p],0,r,n),CT([p,d,c,s],0,r,n)}var a,o;return n}function wT(t,e){return _T(t,0,t.length,e)}function _T(t,e,r,i,n){let a=n||[],o=t[e],s=t[r-1],l=0,h=1;for(let i=e+1;i<r-1;++i){let e=bT(t[i],o,s);e>l&&(l=e,h=i)}return Math.sqrt(l)>i?(_T(t,e,h+1,i,a),_T(t,h,r,i,a)):(a.length||a.push(o),a.push(s)),a}function vT(t,e=.15,r){let i=[],n=(t.length-1)/3;for(let r=0;r<n;r++)CT(t,3*r,e,i);return r&&r>0?_T(i,0,i.length,r):i}s(XS,"v"),s(ZS,"S"),s(QS,"O"),s(KS,"L"),s(JS,"T"),s(tT,"D"),s(eT,"A"),s(rT,"_"),s(iT,"I"),s(nT,"C"),s(aT,"z"),s(oT,"W"),s(sT,"E"),s(lT,"G"),s(hT,"$"),s(cT,"R"),s(uT,"j"),s(dT,"q"),s(pT,"F"),s(fT,"V"),s(gT,"Z"),s(yT,"Q"),s(mT,"H"),s(xT,"N"),s(bT,"B"),s(kT,"J"),s(CT,"K"),s(wT,"U"),s(_T,"X"),s(vT,"Y");var ST="none",TT=class{static{s(this,"et")}constructor(t){this.defaultOptions={maxRandomnessOffset:2,roughness:1,bowing:1,stroke:"#000",strokeWidth:1,curveTightness:0,curveFitting:.95,curveStepCount:9,fillStyle:"hachure",fillWeight:-1,hachureAngle:-41,hachureGap:-1,dashOffset:-1,dashGap:-1,zigzagOffset:-1,seed:0,disableMultiStroke:!1,disableMultiStrokeFill:!1,preserveVertices:!1,fillShapeRoughnessGain:.8},this.config=t||{},this.config.options&&(this.defaultOptions=this._o(this.config.options))}static newSeed(){return Math.floor(Math.random()*2**31)}_o(t){return t?Object.assign({},this.defaultOptions,t):this.defaultOptions}_d(t,e,r){return{shape:t,sets:e||[],options:r||this.defaultOptions}}line(t,e,r,i,n){let a=this._o(n);return this._d("line",[XS(t,e,r,i,a)],a)}rectangle(t,e,r,i,n){let a=this._o(n),o=[],s=QS(t,e,r,i,a);if(a.fill){let n=[[t,e],[t+r,e],[t+r,e+i],[t,e+i]];"solid"===a.fillStyle?o.push(iT([n],a)):o.push(nT([n],a))}return a.stroke!==ST&&o.push(s),this._d("rectangle",o,a)}ellipse(t,e,r,i,n){let a=this._o(n),o=[],s=JS(r,i,a),l=tT(t,e,a,s);if(a.fill)if("solid"===a.fillStyle){let r=tT(t,e,a,s).opset;r.type="fillPath",o.push(r)}else o.push(nT([l.estimatedPoints],a));return a.stroke!==ST&&o.push(l.opset),this._d("ellipse",o,a)}circle(t,e,r,i){let n=this.ellipse(t,e,r,r,i);return n.shape="circle",n}linearPath(t,e){let r=this._o(e);return this._d("linearPath",[ZS(t,!1,r)],r)}arc(t,e,r,i,n,a,o=!1,s){let l=this._o(s),h=[],c=eT(t,e,r,i,n,a,o,!0,l);if(o&&l.fill)if("solid"===l.fillStyle){let o=Object.assign({},l);o.disableMultiStroke=!0;let s=eT(t,e,r,i,n,a,!0,!1,o);s.type="fillPath",h.push(s)}else h.push(function(t,e,r,i,n,a,o){let s=t,l=e,h=Math.abs(r/2),c=Math.abs(i/2);h+=lT(.01*h,o),c+=lT(.01*c,o);let u=n,d=a;for(;u<0;)u+=2*Math.PI,d+=2*Math.PI;d-u>2*Math.PI&&(u=0,d=2*Math.PI);let p=(d-u)/o.curveStepCount,f=[];for(let t=u;t<=d;t+=p)f.push([s+h*Math.cos(t),l+c*Math.sin(t)]);return f.push([s+h*Math.cos(d),l+c*Math.sin(d)]),f.push([s,l]),nT([f],o)}(t,e,r,i,n,a,l));return l.stroke!==ST&&h.push(c),this._d("arc",h,l)}curve(t,e){let r=this._o(e),i=[],n=KS(t,r);if(r.fill&&r.fill!==ST)if("solid"===r.fillStyle){let e=KS(t,Object.assign(Object.assign({},r),{disableMultiStroke:!0,roughness:r.roughness?r.roughness+r.fillShapeRoughnessGain:0}));i.push({type:"fillPath",ops:this._mergedShape(e.ops)})}else{let e=[],n=t;if(n.length){let t="number"==typeof n[0][0]?[n]:n;for(let i of t)i.length<3?e.push(...i):3===i.length?e.push(...vT(mT([i[0],i[0],i[1],i[2]]),10,(1+r.roughness)/2)):e.push(...vT(mT(i),10,(1+r.roughness)/2))}e.length&&i.push(nT([e],r))}return r.stroke!==ST&&i.push(n),this._d("curve",i,r)}polygon(t,e){let r=this._o(e),i=[],n=ZS(t,!0,r);return r.fill&&("solid"===r.fillStyle?i.push(iT([t],r)):i.push(nT([t],r))),r.stroke!==ST&&i.push(n),this._d("polygon",i,r)}path(t,e){let r=this._o(e),i=[];if(!t)return this._d("path",i,r);t=(t||"").replace(/\n/g," ").replace(/(-\s)/g,"-").replace("/(ss)/g"," ");let n=r.fill&&"transparent"!==r.fill&&r.fill!==ST,a=r.stroke!==ST,o=!!(r.simplification&&r.simplification<1),l=function(t,e,r){let i=US(HS(WS(t))),n=[],a=[],o=[0,0],l=[],h=s(()=>{l.length>=4&&a.push(...vT(l,1)),l=[]},"i"),c=s(()=>{h(),a.length&&(n.push(a),a=[])},"c");for(let{key:t,data:e}of i)switch(t){case"M":c(),o=[e[0],e[1]],a.push(o);break;case"L":h(),a.push([e[0],e[1]]);break;case"C":if(!l.length){let t=a.length?a[a.length-1]:o;l.push([t[0],t[1]])}l.push([e[0],e[1]]),l.push([e[2],e[3]]),l.push([e[4],e[5]]);break;case"Z":h(),a.push([o[0],o[1]])}if(c(),!r)return n;let u=[];for(let t of n){let e=wT(t,r);e.length&&u.push(e)}return u}(t,0,o?4-4*(r.simplification||1):(1+r.roughness)/2),h=rT(t,r);if(n)if("solid"===r.fillStyle)if(1===l.length){let e=rT(t,Object.assign(Object.assign({},r),{disableMultiStroke:!0,roughness:r.roughness?r.roughness+r.fillShapeRoughnessGain:0}));i.push({type:"fillPath",ops:this._mergedShape(e.ops)})}else i.push(iT(l,r));else i.push(nT(l,r));return a&&(o?l.forEach(t=>{i.push(ZS(t,!1,r))}):i.push(h)),this._d("path",i,r)}opsToPath(t,e){let r="";for(let i of t.ops){let t="number"==typeof e&&e>=0?i.data.map(t=>+t.toFixed(e)):i.data;switch(i.op){case"move":r+=`M${t[0]} ${t[1]} `;break;case"bcurveTo":r+=`C${t[0]} ${t[1]}, ${t[2]} ${t[3]}, ${t[4]} ${t[5]} `;break;case"lineTo":r+=`L${t[0]} ${t[1]} `}}return r.trim()}toPaths(t){let e=t.sets||[],r=t.options||this.defaultOptions,i=[];for(let t of e){let e=null;switch(t.type){case"path":e={d:this.opsToPath(t),stroke:r.stroke,strokeWidth:r.strokeWidth,fill:ST};break;case"fillPath":e={d:this.opsToPath(t),stroke:ST,strokeWidth:0,fill:r.fill||ST};break;case"fillSketch":e=this.fillSketch(t,r)}e&&i.push(e)}return i}fillSketch(t,e){let r=e.fillWeight;return r<0&&(r=e.strokeWidth/2),{d:this.opsToPath(t),stroke:e.fill||ST,strokeWidth:r,fill:ST}}_mergedShape(t){return t.filter((t,e)=>0===e||"move"!==t.op)}},MT=class{static{s(this,"st")}constructor(t,e){this.canvas=t,this.ctx=this.canvas.getContext("2d"),this.gen=new TT(e)}draw(t){let e=t.sets||[],r=t.options||this.getDefaultOptions(),i=this.ctx,n=t.options.fixedDecimalPlaceDigits;for(let a of e)switch(a.type){case"path":i.save(),i.strokeStyle="none"===r.stroke?"transparent":r.stroke,i.lineWidth=r.strokeWidth,r.strokeLineDash&&i.setLineDash(r.strokeLineDash),r.strokeLineDashOffset&&(i.lineDashOffset=r.strokeLineDashOffset),this._drawToContext(i,a,n),i.restore();break;case"fillPath":{i.save(),i.fillStyle=r.fill||"";let e="curve"===t.shape||"polygon"===t.shape||"path"===t.shape?"evenodd":"nonzero";this._drawToContext(i,a,n,e),i.restore();break}case"fillSketch":this.fillSketch(i,a,r)}}fillSketch(t,e,r){let i=r.fillWeight;i<0&&(i=r.strokeWidth/2),t.save(),r.fillLineDash&&t.setLineDash(r.fillLineDash),r.fillLineDashOffset&&(t.lineDashOffset=r.fillLineDashOffset),t.strokeStyle=r.fill||"",t.lineWidth=i,this._drawToContext(t,e,r.fixedDecimalPlaceDigits),t.restore()}_drawToContext(t,e,r,i="nonzero"){t.beginPath();for(let i of e.ops){let e="number"==typeof r&&r>=0?i.data.map(t=>+t.toFixed(r)):i.data;switch(i.op){case"move":t.moveTo(e[0],e[1]);break;case"bcurveTo":t.bezierCurveTo(e[0],e[1],e[2],e[3],e[4],e[5]);break;case"lineTo":t.lineTo(e[0],e[1])}}"fillPath"===e.type?t.fill(i):t.stroke()}get generator(){return this.gen}getDefaultOptions(){return this.gen.defaultOptions}line(t,e,r,i,n){let a=this.gen.line(t,e,r,i,n);return this.draw(a),a}rectangle(t,e,r,i,n){let a=this.gen.rectangle(t,e,r,i,n);return this.draw(a),a}ellipse(t,e,r,i,n){let a=this.gen.ellipse(t,e,r,i,n);return this.draw(a),a}circle(t,e,r,i){let n=this.gen.circle(t,e,r,i);return this.draw(n),n}linearPath(t,e){let r=this.gen.linearPath(t,e);return this.draw(r),r}polygon(t,e){let r=this.gen.polygon(t,e);return this.draw(r),r}arc(t,e,r,i,n,a,o=!1,s){let l=this.gen.arc(t,e,r,i,n,a,o,s);return this.draw(l),l}curve(t,e){let r=this.gen.curve(t,e);return this.draw(r),r}path(t,e){let r=this.gen.path(t,e);return this.draw(r),r}},BT="http://www.w3.org/2000/svg",AT=class{static{s(this,"ot")}constructor(t,e){this.svg=t,this.gen=new TT(e)}draw(t){let e=t.sets||[],r=t.options||this.getDefaultOptions(),i=this.svg.ownerDocument||window.document,n=i.createElementNS(BT,"g"),a=t.options.fixedDecimalPlaceDigits;for(let o of e){let e=null;switch(o.type){case"path":e=i.createElementNS(BT,"path"),e.setAttribute("d",this.opsToPath(o,a)),e.setAttribute("stroke",r.stroke),e.setAttribute("stroke-width",r.strokeWidth+""),e.setAttribute("fill","none"),r.strokeLineDash&&e.setAttribute("stroke-dasharray",r.strokeLineDash.join(" ").trim()),r.strokeLineDashOffset&&e.setAttribute("stroke-dashoffset",`${r.strokeLineDashOffset}`);break;case"fillPath":e=i.createElementNS(BT,"path"),e.setAttribute("d",this.opsToPath(o,a)),e.setAttribute("stroke","none"),e.setAttribute("stroke-width","0"),e.setAttribute("fill",r.fill||""),"curve"!==t.shape&&"polygon"!==t.shape||e.setAttribute("fill-rule","evenodd");break;case"fillSketch":e=this.fillSketch(i,o,r)}e&&n.appendChild(e)}return n}fillSketch(t,e,r){let i=r.fillWeight;i<0&&(i=r.strokeWidth/2);let n=t.createElementNS(BT,"path");return n.setAttribute("d",this.opsToPath(e,r.fixedDecimalPlaceDigits)),n.setAttribute("stroke",r.fill||""),n.setAttribute("stroke-width",i+""),n.setAttribute("fill","none"),r.fillLineDash&&n.setAttribute("stroke-dasharray",r.fillLineDash.join(" ").trim()),r.fillLineDashOffset&&n.setAttribute("stroke-dashoffset",`${r.fillLineDashOffset}`),n}get generator(){return this.gen}getDefaultOptions(){return this.gen.defaultOptions}opsToPath(t,e){return this.gen.opsToPath(t,e)}line(t,e,r,i,n){let a=this.gen.line(t,e,r,i,n);return this.draw(a)}rectangle(t,e,r,i,n){let a=this.gen.rectangle(t,e,r,i,n);return this.draw(a)}ellipse(t,e,r,i,n){let a=this.gen.ellipse(t,e,r,i,n);return this.draw(a)}circle(t,e,r,i){let n=this.gen.circle(t,e,r,i);return this.draw(n)}linearPath(t,e){let r=this.gen.linearPath(t,e);return this.draw(r)}polygon(t,e){let r=this.gen.polygon(t,e);return this.draw(r)}arc(t,e,r,i,n,a,o=!1,s){let l=this.gen.arc(t,e,r,i,n,a,o,s);return this.draw(l)}curve(t,e){let r=this.gen.curve(t,e);return this.draw(r)}path(t,e){let r=this.gen.path(t,e);return this.draw(r)}},LT={canvas:s((t,e)=>new MT(t,e),"canvas"),svg:s((t,e)=>new AT(t,e),"svg"),generator:s(t=>new TT(t),"generator"),newSeed:s(()=>TT.newSeed(),"newSeed")},FT=s((t,e)=>{var r,i,n=t.x,a=t.y,o=e.x-n,s=e.y-a,l=t.width/2,h=t.height/2;return Math.abs(s)*l>Math.abs(o)*h?(s<0&&(h=-h),r=0===s?0:h*o/s,i=h):(o<0&&(l=-l),r=l,i=0===o?0:l*s/o),{x:n+r,y:a+i}},"intersectRect"),$T=FT;function ET(t,e){e&&t.attr("style",e)}async function DT(t){let e=Ke(document.createElementNS("http://www.w3.org/2000/svg","foreignObject")),r=e.append("xhtml:div"),i=qf(),n=t.label;t.label&&ff(t.label)&&(n=await mf(t.label.replace(xf.lineBreakRegex,"\n"),i));let a='<span class="'+(t.isNode?"nodeLabel":"edgeLabel")+'" '+(t.labelStyle?'style="'+t.labelStyle+'"':"")+">"+n+"</span>";return r.html(Qp(a,i)),ET(r,t.labelStyle),r.style("display","inline-block"),r.style("padding-right","1px"),r.style("white-space","nowrap"),r.attr("xmlns","http://www.w3.org/1999/xhtml"),e.node()}s(ET,"applyStyle"),s(DT,"addHtmlLabel");var OT=s(async(t,e,r,i)=>{let n=t||"";if("object"==typeof n&&(n=n[0]),af(qf().flowchart.htmlLabels)){n=n.replace(/\\n|\n/g,"<br />"),y.info("vertexText"+n);let t={isNode:i,label:o_(n).replace(/fa[blrs]?:fa-[\w-]+/g,t=>`<i class='${t.replace(":"," ")}'></i>`),labelStyle:e&&e.replace("fill:","color:")};return await DT(t)}{let t=document.createElementNS("http://www.w3.org/2000/svg","text");t.setAttribute("style",e.replace("color:","fill:"));let i=[];i="string"==typeof n?n.split(/\\n|\n|<br\s*\/?>/gi):Array.isArray(n)?n:[];for(let e of i){let i=document.createElementNS("http://www.w3.org/2000/svg","tspan");i.setAttributeNS("http://www.w3.org/XML/1998/namespace","xml:space","preserve"),i.setAttribute("dy","1em"),i.setAttribute("x","0"),r?i.setAttribute("class","title-row"):i.setAttribute("class","row"),i.textContent=e.trim(),t.appendChild(i)}return t}},"createLabel"),IT=OT,NT=s((t,e,r,i,n)=>["M",t+n,e,"H",t+r-n,"A",n,n,0,0,1,t+r,e+n,"V",e+i-n,"A",n,n,0,0,1,t+r-n,e+i,"H",t+n,"A",n,n,0,0,1,t,e+i-n,"V",e+n,"A",n,n,0,0,1,t+n,e,"Z"].join(" "),"createRoundedRectPathD"),RT=s(async(t,e)=>{y.info("Creating subgraph rect for ",e.id,e);let r=qf(),{themeVariables:i,handDrawnSeed:n}=r,{clusterBkg:a,clusterBorder:o}=i,{labelStyles:s,nodeStyles:l,borderStyles:h,backgroundStyles:c}=lx(e),u=t.insert("g").attr("class","cluster "+e.cssClasses).attr("id",e.id).attr("data-look",e.look),d=af(r.flowchart.htmlLabels),p=u.insert("g").attr("class","cluster-label "),f=await kS(p,e.label,{style:e.labelStyle,useHtmlLabels:d,isNode:!0}),g=f.getBBox();if(af(r.flowchart.htmlLabels)){let t=f.children[0],e=Ke(f);g=t.getBoundingClientRect(),e.attr("width",g.width),e.attr("height",g.height)}let m=e.width<=g.width+e.padding?g.width+e.padding:e.width;e.width<=g.width+e.padding?e.diff=(m-e.width)/2-e.padding:e.diff=-e.padding;let x,b=e.height,k=e.x-m/2,C=e.y-b/2;if(y.trace("Data ",e,JSON.stringify(e)),"handDrawn"===e.look){let t=LT.svg(u),r=hx(e,{roughness:.7,fill:a,stroke:o,fillWeight:3,seed:n}),i=t.path(NT(k,C,m,b,0),r);x=u.insert(()=>(y.debug("Rough node insert CXC",i),i),":first-child"),x.select("path:nth-child(2)").attr("style",h.join(";")),x.select("path").attr("style",c.join(";").replace("fill","stroke"))}else x=u.insert("rect",":first-child"),x.attr("style",l).attr("rx",e.rx).attr("ry",e.ry).attr("x",k).attr("y",C).attr("width",m).attr("height",b);let{subGraphTitleTopMargin:w}=ix(r);if(p.attr("transform",`translate(${e.x-g.width/2}, ${e.y-e.height/2+w})`),s){let t=p.select("span");t&&t.attr("style",s)}let _=x.node().getBBox();return e.offsetX=0,e.width=_.width,e.height=_.height,e.offsetY=g.height-e.padding/2,e.intersect=function(t){return $T(e,t)},{cluster:u,labelBBox:g}},"rect"),PT=s((t,e)=>{let r=t.insert("g").attr("class","note-cluster").attr("id",e.id),i=r.insert("rect",":first-child"),n=0*e.padding,a=n/2;i.attr("rx",e.rx).attr("ry",e.ry).attr("x",e.x-e.width/2-a).attr("y",e.y-e.height/2-a).attr("width",e.width+n).attr("height",e.height+n).attr("fill","none");let o=i.node().getBBox();return e.width=o.width,e.height=o.height,e.intersect=function(t){return $T(e,t)},{cluster:r,labelBBox:{width:0,height:0}}},"noteGroup"),zT=s(async(t,e)=>{let r=qf(),{themeVariables:i,handDrawnSeed:n}=r,{altBackground:a,compositeBackground:o,compositeTitleBackground:s,nodeBorder:l}=i,h=t.insert("g").attr("class",e.cssClasses).attr("id",e.id).attr("data-id",e.id).attr("data-look",e.look),c=h.insert("g",":first-child"),u=h.insert("g").attr("class","cluster-label"),d=h.append("rect"),p=u.node().appendChild(await IT(e.label,e.labelStyle,void 0,!0)),f=p.getBBox();if(af(r.flowchart.htmlLabels)){let t=p.children[0],e=Ke(p);f=t.getBoundingClientRect(),e.attr("width",f.width),e.attr("height",f.height)}let g=0*e.padding,y=g/2,m=(e.width<=f.width+e.padding?f.width+e.padding:e.width)+g;e.width<=f.width+e.padding?e.diff=(m-e.width)/2-e.padding:e.diff=-e.padding;let x=e.height+g,b=e.height+g-f.height-6,k=e.x-m/2,C=e.y-x/2;e.width=m;let w,_=e.y-e.height/2-y+f.height+2;if("handDrawn"===e.look){let t=e.cssClasses.includes("statediagram-cluster-alt"),r=LT.svg(h),i=e.rx||e.ry?r.path(NT(k,C,m,x,10),{roughness:.7,fill:s,fillStyle:"solid",stroke:l,seed:n}):r.rectangle(k,C,m,x,{seed:n});w=h.insert(()=>i,":first-child");let c=r.rectangle(k,_,m,b,{fill:t?a:o,fillStyle:t?"hachure":"solid",stroke:l,seed:n});w=h.insert(()=>i,":first-child"),d=h.insert(()=>c)}else w=c.insert("rect",":first-child"),w.attr("class","outer").attr("x",k).attr("y",C).attr("width",m).attr("height",x).attr("data-look",e.look),d.attr("class","inner").attr("x",k).attr("y",_).attr("width",m).attr("height",b);u.attr("transform",`translate(${e.x-f.width/2}, ${C+1-(af(r.flowchart.htmlLabels)?0:3)})`);let v=w.node().getBBox();return e.height=v.height,e.offsetX=0,e.offsetY=f.height-e.padding/2,e.labelBBox=f,e.intersect=function(t){return $T(e,t)},{cluster:h,labelBBox:f}},"roundedWithTitle"),qT=s(async(t,e)=>{y.info("Creating subgraph rect for ",e.id,e);let r=qf(),{themeVariables:i,handDrawnSeed:n}=r,{clusterBkg:a,clusterBorder:o}=i,{labelStyles:s,nodeStyles:l,borderStyles:h,backgroundStyles:c}=lx(e),u=t.insert("g").attr("class","cluster "+e.cssClasses).attr("id",e.id).attr("data-look",e.look),d=af(r.flowchart.htmlLabels),p=u.insert("g").attr("class","cluster-label "),f=await kS(p,e.label,{style:e.labelStyle,useHtmlLabels:d,isNode:!0,width:e.width}),g=f.getBBox();if(af(r.flowchart.htmlLabels)){let t=f.children[0],e=Ke(f);g=t.getBoundingClientRect(),e.attr("width",g.width),e.attr("height",g.height)}let m=e.width<=g.width+e.padding?g.width+e.padding:e.width;e.width<=g.width+e.padding?e.diff=(m-e.width)/2-e.padding:e.diff=-e.padding;let x,b=e.height,k=e.x-m/2,C=e.y-b/2;if(y.trace("Data ",e,JSON.stringify(e)),"handDrawn"===e.look){let t=LT.svg(u),r=hx(e,{roughness:.7,fill:a,stroke:o,fillWeight:4,seed:n}),i=t.path(NT(k,C,m,b,e.rx),r);x=u.insert(()=>(y.debug("Rough node insert CXC",i),i),":first-child"),x.select("path:nth-child(2)").attr("style",h.join(";")),x.select("path").attr("style",c.join(";").replace("fill","stroke"))}else x=u.insert("rect",":first-child"),x.attr("style",l).attr("rx",e.rx).attr("ry",e.ry).attr("x",k).attr("y",C).attr("width",m).attr("height",b);let{subGraphTitleTopMargin:w}=ix(r);if(p.attr("transform",`translate(${e.x-g.width/2}, ${e.y-e.height/2+w})`),s){let t=p.select("span");t&&t.attr("style",s)}let _=x.node().getBBox();return e.offsetX=0,e.width=_.width,e.height=_.height,e.offsetY=g.height-e.padding/2,e.intersect=function(t){return $T(e,t)},{cluster:u,labelBBox:g}},"kanbanSection"),jT=s((t,e)=>{let r=qf(),{themeVariables:i,handDrawnSeed:n}=r,{nodeBorder:a}=i,o=t.insert("g").attr("class",e.cssClasses).attr("id",e.id).attr("data-look",e.look),s=o.insert("g",":first-child"),l=0*e.padding,h=e.width+l;e.diff=-e.padding;let c,u=e.height+l,d=e.x-h/2,p=e.y-u/2;if(e.width=h,"handDrawn"===e.look){let t=LT.svg(o).rectangle(d,p,h,u,{fill:"lightgrey",roughness:.5,strokeLineDash:[5],stroke:a,seed:n});c=o.insert(()=>t,":first-child")}else c=s.insert("rect",":first-child"),c.attr("class","divider").attr("x",d).attr("y",p).attr("width",h).attr("height",u).attr("data-look",e.look);let f=c.node().getBBox();return e.height=f.height,e.offsetX=0,e.offsetY=0,e.intersect=function(t){return $T(e,t)},{cluster:o,labelBBox:{}}},"divider"),WT={rect:RT,squareRect:RT,roundedWithTitle:zT,noteGroup:PT,divider:jT,kanbanSection:qT},HT=new Map,UT=s(async(t,e)=>{let r=e.shape||"rect",i=await WT[r](t,e);return HT.set(e.id,i),i},"insertCluster"),YT=s(()=>{HT=new Map},"clear");function VT(t,e){return t.intersect(e)}s(VT,"intersectNode");var GT=VT;function XT(t,e,r,i){var n=t.x,a=t.y,o=n-i.x,s=a-i.y,l=Math.sqrt(e*e*s*s+r*r*o*o),h=Math.abs(e*r*o/l);i.x<n&&(h=-h);var c=Math.abs(e*r*s/l);return i.y<a&&(c=-c),{x:n+h,y:a+c}}s(XT,"intersectEllipse");var ZT=XT;function QT(t,e,r){return ZT(t,e,e,r)}s(QT,"intersectCircle");var KT=QT;function JT(t,e,r,i){{let n=e.y-t.y,a=t.x-e.x,o=e.x*t.y-t.x*e.y,s=n*r.x+a*r.y+o,l=n*i.x+a*i.y+o,h=1e-6;if(0!==s&&0!==l&&tM(s,l))return;let c=i.y-r.y,u=r.x-i.x,d=i.x*r.y-r.x*i.y,p=c*t.x+u*t.y+d,f=c*e.x+u*e.y+d;if(Math.abs(p)<h&&Math.abs(f)<h&&tM(p,f))return;let g=n*u-c*a;if(0===g)return;let y=Math.abs(g/2),m=a*d-u*o,x=m<0?(m-y)/g:(m+y)/g;return m=c*o-n*d,{x:x,y:m<0?(m-y)/g:(m+y)/g}}}function tM(t,e){return t*e>0}s(JT,"intersectLine"),s(tM,"sameSign");var eM=JT;function rM(t,e,r){let i=t.x,n=t.y,a=[],o=Number.POSITIVE_INFINITY,s=Number.POSITIVE_INFINITY;"function"==typeof e.forEach?e.forEach(function(t){o=Math.min(o,t.x),s=Math.min(s,t.y)}):(o=Math.min(o,e.x),s=Math.min(s,e.y));let l=i-t.width/2-o,h=n-t.height/2-s;for(let i=0;i<e.length;i++){let n=e[i],o=e[i<e.length-1?i+1:0],s=eM(t,r,{x:l+n.x,y:h+n.y},{x:l+o.x,y:h+o.y});s&&a.push(s)}return a.length?(a.length>1&&a.sort(function(t,e){let i=t.x-r.x,n=t.y-r.y,a=Math.sqrt(i*i+n*n),o=e.x-r.x,s=e.y-r.y,l=Math.sqrt(o*o+s*s);return a<l?-1:a===l?0:1}),a[0]):t}s(rM,"intersectPolygon");var iM={node:GT,circle:KT,ellipse:ZT,polygon:rM,rect:$T};function nM(t,e){let{labelStyles:r}=lx(e);e.labelStyle=r;let i=vS(e),n=i;i||(n="anchor");let a=t.insert("g").attr("class",n).attr("id",e.domId||e.id),{cssStyles:o}=e,s=LT.svg(a),l=hx(e,{fill:"black",stroke:"none",fillStyle:"solid"});"handDrawn"!==e.look&&(l.roughness=0);let h=s.circle(0,0,2,l),c=a.insert(()=>h,":first-child");return c.attr("class","anchor").attr("style",l_(o)),_S(e,c),e.intersect=function(t){return y.info("Circle intersect",e,1,t),iM.circle(e,1,t)},a}function aM(t,e,r,i,n,a,o){let s=(t+r)/2,l=(e+i)/2,h=Math.atan2(i-e,r-t),c=(r-t)/2/n,u=(i-e)/2/a,d=Math.sqrt(c**2+u**2);if(d>1)throw new Error("The given radii are too small to create an arc between the points.");let p=Math.sqrt(1-d**2),f=s+p*a*Math.sin(h)*(o?-1:1),g=l-p*n*Math.cos(h)*(o?-1:1),y=Math.atan2((e-g)/a,(t-f)/n),m=Math.atan2((i-g)/a,(r-f)/n)-y;o&&m<0&&(m+=2*Math.PI),!o&&m>0&&(m-=2*Math.PI);let x=[];for(let t=0;t<20;t++){let e=y+t/19*m,r=f+n*Math.cos(e),i=g+a*Math.sin(e);x.push({x:r,y:i})}return x}async function oM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=a.width+e.padding+20,s=a.height+e.padding,l=s/2,h=l/(2.5+s/50),{cssStyles:c}=e,u=[{x:o/2,y:-s/2},{x:-o/2,y:-s/2},...aM(-o/2,-s/2,-o/2,s/2,h,l,!1),{x:o/2,y:s/2},...aM(o/2,s/2,o/2,-s/2,h,l,!0)],d=LT.svg(n),p=hx(e,{});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=SS(u),g=d.path(f,p),y=n.insert(()=>g,":first-child");return y.attr("class","basic label-container"),c&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",c),i&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",i),y.attr("transform",`translate(${h/2}, 0)`),_S(e,y),e.intersect=function(t){return iM.polygon(e,u,t)},n}function sM(t,e,r,i){return t.insert("polygon",":first-child").attr("points",i.map(function(t){return t.x+","+t.y}).join(" ")).attr("class","label-container").attr("transform","translate("+-e/2+","+r/2+")")}async function lM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await CS(t,e,vS(e)),s=o.height+e.padding,l=o.width+e.padding+12,h=-s,c=[{x:12,y:h},{x:l,y:h},{x:l,y:0},{x:0,y:0},{x:0,y:h+12},{x:12,y:h}],{cssStyles:u}=e;if("handDrawn"===e.look){let t=LT.svg(a),r=hx(e,{}),i=SS(c),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-l/2}, ${s/2})`),u&&n.attr("style",u)}else n=sM(a,l,s,c);return i&&n.attr("style",i),_S(e,n),e.intersect=function(t){return iM.polygon(e,c,t)},a}function hM(t,e){let{nodeStyles:r}=lx(e);e.label="";let i=t.insert("g").attr("class",vS(e)).attr("id",e.domId??e.id),{cssStyles:n}=e,a=Math.max(28,e.width??0),o=[{x:0,y:a/2},{x:a/2,y:0},{x:0,y:-a/2},{x:-a/2,y:0}],s=LT.svg(i),l=hx(e,{});"handDrawn"!==e.look&&(l.roughness=0,l.fillStyle="solid");let h=SS(o),c=s.path(h,l),u=i.insert(()=>c,":first-child");return n&&"handDrawn"!==e.look&&u.selectAll("path").attr("style",n),r&&"handDrawn"!==e.look&&u.selectAll("path").attr("style",r),e.width=28,e.height=28,e.intersect=function(t){return iM.polygon(e,o,t)},i}async function cM(t,e,r){let{labelStyles:i,nodeStyles:n}=lx(e);e.labelStyle=i;let a,{shapeSvg:o,bbox:s,halfPadding:l}=await CS(t,e,vS(e)),h=r?.padding??l,c=s.width/2+h,{cssStyles:u}=e;if("handDrawn"===e.look){let t=LT.svg(o),r=hx(e,{}),i=t.circle(0,0,2*c,r);a=o.insert(()=>i,":first-child"),a.attr("class","basic label-container").attr("style",l_(u))}else a=o.insert("circle",":first-child").attr("class","basic label-container").attr("style",n).attr("r",c).attr("cx",0).attr("cy",0);return _S(e,a),e.calcIntersect=function(t,e){let r=t.width/2;return iM.circle(t,r,e)},e.intersect=function(t){return y.info("Circle intersect",e,c,t),iM.circle(e,c,t)},o}function uM(t){let e=Math.cos(Math.PI/4),r=Math.sin(Math.PI/4),i=2*t;return`M ${-i/2*e},${i/2*r} L ${i/2*e},${-i/2*r}\n                   M ${i/2*e},${i/2*r} L ${-i/2*e},${-i/2*r}`}function dM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r,e.label="";let n=t.insert("g").attr("class",vS(e)).attr("id",e.domId??e.id),a=Math.max(30,e?.width??0),{cssStyles:o}=e,s=LT.svg(n),l=hx(e,{});"handDrawn"!==e.look&&(l.roughness=0,l.fillStyle="solid");let h=s.circle(0,0,2*a,l),c=uM(a),u=s.path(c,l),d=n.insert(()=>h,":first-child");return d.insert(()=>u),o&&"handDrawn"!==e.look&&d.selectAll("path").attr("style",o),i&&"handDrawn"!==e.look&&d.selectAll("path").attr("style",i),_S(e,d),e.intersect=function(t){return y.info("crossedCircle intersect",e,{radius:a,point:t}),iM.circle(e,a,t)},n}function pM(t,e,r,i=100,n=0,a=180){let o=[],s=n*Math.PI/180,l=(a*Math.PI/180-s)/(i-1);for(let n=0;n<i;n++){let i=s+n*l,a=t+r*Math.cos(i),h=e+r*Math.sin(i);o.push({x:-a,y:-h})}return o}async function fM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=a.width+(e.padding??0),l=a.height+(e.padding??0),h=Math.max(5,.1*l),{cssStyles:c}=e,u=[...pM(s/2,-l/2,h,30,-90,0),{x:-s/2-h,y:h},...pM(s/2+2*h,-h,h,20,-180,-270),...pM(s/2+2*h,h,h,20,-90,-180),{x:-s/2-h,y:-l/2},...pM(s/2,l/2,h,20,0,90)],d=[{x:s/2,y:-l/2-h},{x:-s/2,y:-l/2-h},...pM(s/2,-l/2,h,20,-90,0),{x:-s/2-h,y:-h},...pM(s/2+.1*s,-h,h,20,-180,-270),...pM(s/2+.1*s,h,h,20,-90,-180),{x:-s/2-h,y:l/2},...pM(s/2,l/2,h,20,0,90),{x:-s/2,y:l/2+h},{x:s/2,y:l/2+h}],p=LT.svg(n),f=hx(e,{fill:"none"});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=SS(u).replace("Z",""),y=p.path(g,f),m=SS(d),x=p.path(m,{...f}),b=n.insert("g",":first-child");return b.insert(()=>x,":first-child").attr("stroke-opacity",0),b.insert(()=>y,":first-child"),b.attr("class","text"),c&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",c),i&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",i),b.attr("transform",`translate(${h}, 0)`),o.attr("transform",`translate(${-s/2+h-(a.x-(a.left??0))},${-l/2+(e.padding??0)/2-(a.y-(a.top??0))})`),_S(e,b),e.intersect=function(t){return iM.polygon(e,d,t)},n}function gM(t,e,r,i=100,n=0,a=180){let o=[],s=n*Math.PI/180,l=(a*Math.PI/180-s)/(i-1);for(let n=0;n<i;n++){let i=s+n*l,a=t+r*Math.cos(i),h=e+r*Math.sin(i);o.push({x:a,y:h})}return o}async function yM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=a.width+(e.padding??0),l=a.height+(e.padding??0),h=Math.max(5,.1*l),{cssStyles:c}=e,u=[...gM(s/2,-l/2,h,20,-90,0),{x:s/2+h,y:-h},...gM(s/2+2*h,-h,h,20,-180,-270),...gM(s/2+2*h,h,h,20,-90,-180),{x:s/2+h,y:l/2},...gM(s/2,l/2,h,20,0,90)],d=[{x:-s/2,y:-l/2-h},{x:s/2,y:-l/2-h},...gM(s/2,-l/2,h,20,-90,0),{x:s/2+h,y:-h},...gM(s/2+2*h,-h,h,20,-180,-270),...gM(s/2+2*h,h,h,20,-90,-180),{x:s/2+h,y:l/2},...gM(s/2,l/2,h,20,0,90),{x:s/2,y:l/2+h},{x:-s/2,y:l/2+h}],p=LT.svg(n),f=hx(e,{fill:"none"});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=SS(u).replace("Z",""),y=p.path(g,f),m=SS(d),x=p.path(m,{...f}),b=n.insert("g",":first-child");return b.insert(()=>x,":first-child").attr("stroke-opacity",0),b.insert(()=>y,":first-child"),b.attr("class","text"),c&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",c),i&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",i),b.attr("transform",`translate(${-h}, 0)`),o.attr("transform",`translate(${-s/2+(e.padding??0)/2-(a.x-(a.left??0))},${-l/2+(e.padding??0)/2-(a.y-(a.top??0))})`),_S(e,b),e.intersect=function(t){return iM.polygon(e,d,t)},n}function mM(t,e,r,i=100,n=0,a=180){let o=[],s=n*Math.PI/180,l=(a*Math.PI/180-s)/(i-1);for(let n=0;n<i;n++){let i=s+n*l,a=t+r*Math.cos(i),h=e+r*Math.sin(i);o.push({x:-a,y:-h})}return o}async function xM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=a.width+(e.padding??0),l=a.height+(e.padding??0),h=Math.max(5,.1*l),{cssStyles:c}=e,u=[...mM(s/2,-l/2,h,30,-90,0),{x:-s/2-h,y:h},...mM(s/2+2*h,-h,h,20,-180,-270),...mM(s/2+2*h,h,h,20,-90,-180),{x:-s/2-h,y:-l/2},...mM(s/2,l/2,h,20,0,90)],d=[...mM(-s/2+h+h/2,-l/2,h,20,-90,-180),{x:s/2-h/2,y:h},...mM(-s/2-h/2,-h,h,20,0,90),...mM(-s/2-h/2,h,h,20,-90,0),{x:s/2-h/2,y:-h},...mM(-s/2+h+h/2,l/2,h,30,-180,-270)],p=[{x:s/2,y:-l/2-h},{x:-s/2,y:-l/2-h},...mM(s/2,-l/2,h,20,-90,0),{x:-s/2-h,y:-h},...mM(s/2+2*h,-h,h,20,-180,-270),...mM(s/2+2*h,h,h,20,-90,-180),{x:-s/2-h,y:l/2},...mM(s/2,l/2,h,20,0,90),{x:-s/2,y:l/2+h},{x:s/2-h-h/2,y:l/2+h},...mM(-s/2+h+h/2,-l/2,h,20,-90,-180),{x:s/2-h/2,y:h},...mM(-s/2-h/2,-h,h,20,0,90),...mM(-s/2-h/2,h,h,20,-90,0),{x:s/2-h/2,y:-h},...mM(-s/2+h+h/2,l/2,h,30,-180,-270)],f=LT.svg(n),g=hx(e,{fill:"none"});"handDrawn"!==e.look&&(g.roughness=0,g.fillStyle="solid");let y=SS(u).replace("Z",""),m=f.path(y,g),x=SS(d).replace("Z",""),b=f.path(x,g),k=SS(p),C=f.path(k,{...g}),w=n.insert("g",":first-child");return w.insert(()=>C,":first-child").attr("stroke-opacity",0),w.insert(()=>m,":first-child"),w.insert(()=>b,":first-child"),w.attr("class","text"),c&&"handDrawn"!==e.look&&w.selectAll("path").attr("style",c),i&&"handDrawn"!==e.look&&w.selectAll("path").attr("style",i),w.attr("transform",`translate(${h-h/4}, 0)`),o.attr("transform",`translate(${-s/2+(e.padding??0)/2-(a.x-(a.left??0))},${-l/2+(e.padding??0)/2-(a.y-(a.top??0))})`),_S(e,w),e.intersect=function(t){return iM.polygon(e,p,t)},n}async function bM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=Math.max(80,1.25*(a.width+2*(e.padding??0)),e?.width??0),s=Math.max(20,a.height+2*(e.padding??0),e?.height??0),l=s/2,{cssStyles:h}=e,c=LT.svg(n),u=hx(e,{});"handDrawn"!==e.look&&(u.roughness=0,u.fillStyle="solid");let d=o-l,p=s/4,f=[{x:d,y:0},{x:p,y:0},{x:0,y:s/2},{x:p,y:s},{x:d,y:s},...MS(-d,-s/2,l,50,270,90)],g=SS(f),y=c.path(g,u),m=n.insert(()=>y,":first-child");return m.attr("class","basic label-container"),h&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",h),i&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",i),m.attr("transform",`translate(${-o/2}, ${-s/2})`),_S(e,m),e.intersect=function(t){return iM.polygon(e,f,t)},n}s(nM,"anchor"),s(aM,"generateArcPoints"),s(oM,"bowTieRect"),s(sM,"insertPolygonShape"),s(lM,"card"),s(hM,"choice"),s(cM,"circle"),s(uM,"createLine"),s(dM,"crossedCircle"),s(pM,"generateCirclePoints"),s(fM,"curlyBraceLeft"),s(gM,"generateCirclePoints"),s(yM,"curlyBraceRight"),s(mM,"generateCirclePoints"),s(xM,"curlyBraces"),s(bM,"curvedTrapezoid");var kM=s((t,e,r,i,n,a)=>[`M${t},${e+a}`,`a${n},${a} 0,0,0 ${r},0`,`a${n},${a} 0,0,0 ${-r},0`,`l0,${i}`,`a${n},${a} 0,0,0 ${r},0`,"l0,"+-i].join(" "),"createCylinderPathD"),CM=s((t,e,r,i,n,a)=>[`M${t},${e+a}`,`M${t+r},${e+a}`,`a${n},${a} 0,0,0 ${-r},0`,`l0,${i}`,`a${n},${a} 0,0,0 ${r},0`,"l0,"+-i].join(" "),"createOuterCylinderPathD"),wM=s((t,e,r,i,n,a)=>[`M${t-r/2},${-i/2}`,`a${n},${a} 0,0,0 ${r},0`].join(" "),"createInnerCylinderPathD");async function _M(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o,label:s}=await CS(t,e,vS(e)),l=Math.max(o.width+e.padding,e.width??0),h=l/2,c=h/(2.5+l/50),u=Math.max(o.height+c+e.padding,e.height??0),{cssStyles:d}=e;if("handDrawn"===e.look){let t=LT.svg(a),r=CM(0,0,l,u,h,c),i=wM(0,c,l,u,h,c),o=t.path(r,hx(e,{})),s=t.path(i,hx(e,{fill:"none"}));n=a.insert(()=>s,":first-child"),n=a.insert(()=>o,":first-child"),n.attr("class","basic label-container"),d&&n.attr("style",d)}else{let t=kM(0,0,l,u,h,c);n=a.insert("path",":first-child").attr("d",t).attr("class","basic label-container").attr("style",l_(d)).attr("style",i)}return n.attr("label-offset-y",c),n.attr("transform",`translate(${-l/2}, ${-(u/2+c)})`),_S(e,n),s.attr("transform",`translate(${-o.width/2-(o.x-(o.left??0))}, ${-o.height/2+(e.padding??0)/1.5-(o.y-(o.top??0))})`),e.intersect=function(t){let r=iM.rect(e,t),i=r.x-(e.x??0);if(0!=h&&(Math.abs(i)<(e.width??0)/2||Math.abs(i)==(e.width??0)/2&&Math.abs(r.y-(e.y??0))>(e.height??0)/2-c)){let n=c*c*(1-i*i/(h*h));n>0&&(n=Math.sqrt(n)),n=c-n,t.y-(e.y??0)>0&&(n=-n),r.y+=n}return r},a}async function vM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=a.width+e.padding,l=a.height+e.padding,h=.2*l,c=-s/2,u=-l/2-h/2,{cssStyles:d}=e,p=LT.svg(n),f=hx(e,{});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=[{x:c,y:u+h},{x:-c,y:u+h},{x:-c,y:-u},{x:c,y:-u},{x:c,y:u},{x:-c,y:u},{x:-c,y:u+h}],y=p.polygon(g.map(t=>[t.x,t.y]),f),m=n.insert(()=>y,":first-child");return m.attr("class","basic label-container"),d&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",d),i&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",i),o.attr("transform",`translate(${c+(e.padding??0)/2-(a.x-(a.left??0))}, ${u+h+(e.padding??0)/2-(a.y-(a.top??0))})`),_S(e,m),e.intersect=function(t){return iM.rect(e,t)},n}async function SM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o,halfPadding:s}=await CS(t,e,vS(e)),l=o.width/2+s+5,h=o.width/2+s,{cssStyles:c}=e;if("handDrawn"===e.look){let t=LT.svg(a),r=hx(e,{roughness:.2,strokeWidth:2.5}),i=hx(e,{roughness:.2,strokeWidth:1.5}),o=t.circle(0,0,2*l,r),s=t.circle(0,0,2*h,i);n=a.insert("g",":first-child"),n.attr("class",l_(e.cssClasses)).attr("style",l_(c)),n.node()?.appendChild(o),n.node()?.appendChild(s)}else{n=a.insert("g",":first-child");let t=n.insert("circle",":first-child"),e=n.insert("circle");n.attr("class","basic label-container").attr("style",i),t.attr("class","outer-circle").attr("style",i).attr("r",l).attr("cx",0).attr("cy",0),e.attr("class","inner-circle").attr("style",i).attr("r",h).attr("cx",0).attr("cy",0)}return _S(e,n),e.intersect=function(t){return y.info("DoubleCircle intersect",e,l,t),iM.circle(e,l,t)},a}function TM(t,e,{config:{themeVariables:r}}){let{labelStyles:i,nodeStyles:n}=lx(e);e.label="",e.labelStyle=i;let a=t.insert("g").attr("class",vS(e)).attr("id",e.domId??e.id),{cssStyles:o}=e,s=LT.svg(a),{nodeBorder:l}=r,h=hx(e,{fillStyle:"solid"});"handDrawn"!==e.look&&(h.roughness=0);let c=s.circle(0,0,14,h),u=a.insert(()=>c,":first-child");return u.selectAll("path").attr("style",`fill: ${l} !important;`),o&&o.length>0&&"handDrawn"!==e.look&&u.selectAll("path").attr("style",o),n&&"handDrawn"!==e.look&&u.selectAll("path").attr("style",n),_S(e,u),e.intersect=function(t){return y.info("filledCircle intersect",e,{radius:7,point:t}),iM.circle(e,7,t)},a}async function MM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=a.width+(e.padding??0),l=s+a.height,h=s+a.height,c=[{x:0,y:-l},{x:h,y:-l},{x:h/2,y:0}],{cssStyles:u}=e,d=LT.svg(n),p=hx(e,{});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=SS(c),g=d.path(f,p),m=n.insert(()=>g,":first-child").attr("transform",`translate(${-l/2}, ${l/2})`);return u&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",u),i&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",i),e.width=s,e.height=l,_S(e,m),o.attr("transform",`translate(${-a.width/2-(a.x-(a.left??0))}, ${-l/2+(e.padding??0)/2+(a.y-(a.top??0))})`),e.intersect=function(t){return y.info("Triangle intersect",e,c,t),iM.polygon(e,c,t)},n}function BM(t,e,{dir:r,config:{state:i,themeVariables:n}}){let{nodeStyles:a}=lx(e);e.label="";let o=t.insert("g").attr("class",vS(e)).attr("id",e.domId??e.id),{cssStyles:s}=e,l=Math.max(70,e?.width??0),h=Math.max(10,e?.height??0);"LR"===r&&(l=Math.max(10,e?.width??0),h=Math.max(70,e?.height??0));let c=-1*l/2,u=-1*h/2,d=LT.svg(o),p=hx(e,{stroke:n.lineColor,fill:n.lineColor});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=d.rectangle(c,u,l,h,p),g=o.insert(()=>f,":first-child");s&&"handDrawn"!==e.look&&g.selectAll("path").attr("style",s),a&&"handDrawn"!==e.look&&g.selectAll("path").attr("style",a),_S(e,g);let y=i?.padding??0;return e.width&&e.height&&(e.width+=y/2||0,e.height+=y/2||0),e.intersect=function(t){return iM.rect(e,t)},o}async function AM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=Math.max(80,a.width+2*(e.padding??0),e?.width??0),s=Math.max(50,a.height+2*(e.padding??0),e?.height??0),l=s/2,{cssStyles:h}=e,c=LT.svg(n),u=hx(e,{});"handDrawn"!==e.look&&(u.roughness=0,u.fillStyle="solid");let d=[{x:-o/2,y:-s/2},{x:o/2-l,y:-s/2},...MS(-o/2+l,0,l,50,90,270),{x:o/2-l,y:s/2},{x:-o/2,y:s/2}],p=SS(d),f=c.path(p,u),g=n.insert(()=>f,":first-child");return g.attr("class","basic label-container"),h&&"handDrawn"!==e.look&&g.selectChildren("path").attr("style",h),i&&"handDrawn"!==e.look&&g.selectChildren("path").attr("style",i),_S(e,g),e.intersect=function(t){return y.info("Pill intersect",e,{radius:l,point:t}),iM.polygon(e,d,t)},n}async function LM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=a.height+(e.padding??0),s=a.width+2.5*(e.padding??0),{cssStyles:l}=e,h=LT.svg(n),c=hx(e,{});"handDrawn"!==e.look&&(c.roughness=0,c.fillStyle="solid");let u=s/2;u+=u/6;let d=o/2,p=u-d/2,f=[{x:-p,y:-d},{x:0,y:-d},{x:p,y:-d},{x:u,y:0},{x:p,y:d},{x:0,y:d},{x:-p,y:d},{x:-u,y:0}],g=SS(f),y=h.path(g,c),m=n.insert(()=>y,":first-child");return m.attr("class","basic label-container"),l&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",l),i&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",i),e.width=s,e.height=o,_S(e,m),e.intersect=function(t){return iM.polygon(e,f,t)},n}async function FM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.label="",e.labelStyle=r;let{shapeSvg:n}=await CS(t,e,vS(e)),a=Math.max(30,e?.width??0),o=Math.max(30,e?.height??0),{cssStyles:s}=e,l=LT.svg(n),h=hx(e,{});"handDrawn"!==e.look&&(h.roughness=0,h.fillStyle="solid");let c=[{x:0,y:0},{x:a,y:0},{x:0,y:o},{x:a,y:o}],u=SS(c),d=l.path(u,h),p=n.insert(()=>d,":first-child");return p.attr("class","basic label-container"),s&&"handDrawn"!==e.look&&p.selectChildren("path").attr("style",s),i&&"handDrawn"!==e.look&&p.selectChildren("path").attr("style",i),p.attr("transform",`translate(${-a/2}, ${-o/2})`),_S(e,p),e.intersect=function(t){return y.info("Pill intersect",e,{points:c}),iM.polygon(e,c,t)},n}async function $M(t,e,{config:{themeVariables:r,flowchart:i}}){let{labelStyles:n}=lx(e);e.labelStyle=n;let a=e.assetHeight??48,o=e.assetWidth??48,s=Math.max(a,o),l=i?.wrappingWidth;e.width=Math.max(s,l??0);let{shapeSvg:h,bbox:c,label:u}=await CS(t,e,"icon-shape default"),d="t"===e.pos,p=s,f=s,{nodeBorder:g}=r,{stylesMap:m}=ax(e),x=-f/2,b=-p/2,k=e.label?8:0,C=LT.svg(h),w=hx(e,{stroke:"none",fill:"none"});"handDrawn"!==e.look&&(w.roughness=0,w.fillStyle="solid");let _=C.rectangle(x,b,f,p,w),v=Math.max(f,c.width),S=p+c.height+k,T=C.rectangle(-v/2,-S/2,v,S,{...w,fill:"transparent",stroke:"none"}),M=h.insert(()=>_,":first-child"),B=h.insert(()=>T);if(e.icon){let t=h.append("g");t.html(`<g>${await j_(e.icon,{height:s,width:s,fallbackPrefix:""})}</g>`);let r=t.node().getBBox(),i=r.width,n=r.height,a=r.x,o=r.y;t.attr("transform",`translate(${-i/2-a},${d?c.height/2+k/2-n/2-o:-c.height/2-k/2-n/2-o})`),t.attr("style",`color: ${m.get("stroke")??g};`)}return u.attr("transform",`translate(${-c.width/2-(c.x-(c.left??0))},${d?-S/2:S/2-c.height})`),M.attr("transform",`translate(0,${d?c.height/2+k/2:-c.height/2-k/2})`),_S(e,B),e.intersect=function(t){if(y.info("iconSquare intersect",e,t),!e.label)return iM.rect(e,t);let r=e.x??0,i=e.y??0,n=e.height??0,a=[];return a=d?[{x:r-c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2+c.height+k},{x:r+f/2,y:i-n/2+c.height+k},{x:r+f/2,y:i+n/2},{x:r-f/2,y:i+n/2},{x:r-f/2,y:i-n/2+c.height+k},{x:r-c.width/2,y:i-n/2+c.height+k}]:[{x:r-f/2,y:i-n/2},{x:r+f/2,y:i-n/2},{x:r+f/2,y:i-n/2+p},{x:r+c.width/2,y:i-n/2+p},{x:r+c.width/2/2,y:i+n/2},{x:r-c.width/2,y:i+n/2},{x:r-c.width/2,y:i-n/2+p},{x:r-f/2,y:i-n/2+p}],iM.polygon(e,a,t)},h}async function EM(t,e,{config:{themeVariables:r,flowchart:i}}){let{labelStyles:n}=lx(e);e.labelStyle=n;let a=e.assetHeight??48,o=e.assetWidth??48,s=Math.max(a,o),l=i?.wrappingWidth;e.width=Math.max(s,l??0);let{shapeSvg:h,bbox:c,label:u}=await CS(t,e,"icon-shape default"),d=e.label?8:0,p="t"===e.pos,{nodeBorder:f,mainBkg:g}=r,{stylesMap:m}=ax(e),x=LT.svg(h),b=hx(e,{});"handDrawn"!==e.look&&(b.roughness=0,b.fillStyle="solid");let k=m.get("fill");b.stroke=k??g;let C=h.append("g");e.icon&&C.html(`<g>${await j_(e.icon,{height:s,width:s,fallbackPrefix:""})}</g>`);let w=C.node().getBBox(),_=w.width,v=w.height,S=w.x,T=w.y,M=Math.max(_,v)*Math.SQRT2+40,B=x.circle(0,0,M,b),A=Math.max(M,c.width),L=M+c.height+d,F=x.rectangle(-A/2,-L/2,A,L,{...b,fill:"transparent",stroke:"none"}),$=h.insert(()=>B,":first-child"),E=h.insert(()=>F);return C.attr("transform",`translate(${-_/2-S},${p?c.height/2+d/2-v/2-T:-c.height/2-d/2-v/2-T})`),C.attr("style",`color: ${m.get("stroke")??f};`),u.attr("transform",`translate(${-c.width/2-(c.x-(c.left??0))},${p?-L/2:L/2-c.height})`),$.attr("transform",`translate(0,${p?c.height/2+d/2:-c.height/2-d/2})`),_S(e,E),e.intersect=function(t){return y.info("iconSquare intersect",e,t),iM.rect(e,t)},h}async function DM(t,e,{config:{themeVariables:r,flowchart:i}}){let{labelStyles:n}=lx(e);e.labelStyle=n;let a=e.assetHeight??48,o=e.assetWidth??48,s=Math.max(a,o),l=i?.wrappingWidth;e.width=Math.max(s,l??0);let{shapeSvg:h,bbox:c,halfPadding:u,label:d}=await CS(t,e,"icon-shape default"),p="t"===e.pos,f=s+2*u,g=s+2*u,{nodeBorder:m,mainBkg:x}=r,{stylesMap:b}=ax(e),k=-g/2,C=-f/2,w=e.label?8:0,_=LT.svg(h),v=hx(e,{});"handDrawn"!==e.look&&(v.roughness=0,v.fillStyle="solid");let S=b.get("fill");v.stroke=S??x;let T=_.path(NT(k,C,g,f,5),v),M=Math.max(g,c.width),B=f+c.height+w,A=_.rectangle(-M/2,-B/2,M,B,{...v,fill:"transparent",stroke:"none"}),L=h.insert(()=>T,":first-child").attr("class","icon-shape2"),F=h.insert(()=>A);if(e.icon){let t=h.append("g");t.html(`<g>${await j_(e.icon,{height:s,width:s,fallbackPrefix:""})}</g>`);let r=t.node().getBBox(),i=r.width,n=r.height,a=r.x,o=r.y;t.attr("transform",`translate(${-i/2-a},${p?c.height/2+w/2-n/2-o:-c.height/2-w/2-n/2-o})`),t.attr("style",`color: ${b.get("stroke")??m};`)}return d.attr("transform",`translate(${-c.width/2-(c.x-(c.left??0))},${p?-B/2:B/2-c.height})`),L.attr("transform",`translate(0,${p?c.height/2+w/2:-c.height/2-w/2})`),_S(e,F),e.intersect=function(t){if(y.info("iconSquare intersect",e,t),!e.label)return iM.rect(e,t);let r=e.x??0,i=e.y??0,n=e.height??0,a=[];return a=p?[{x:r-c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2+c.height+w},{x:r+g/2,y:i-n/2+c.height+w},{x:r+g/2,y:i+n/2},{x:r-g/2,y:i+n/2},{x:r-g/2,y:i-n/2+c.height+w},{x:r-c.width/2,y:i-n/2+c.height+w}]:[{x:r-g/2,y:i-n/2},{x:r+g/2,y:i-n/2},{x:r+g/2,y:i-n/2+f},{x:r+c.width/2,y:i-n/2+f},{x:r+c.width/2/2,y:i+n/2},{x:r-c.width/2,y:i+n/2},{x:r-c.width/2,y:i-n/2+f},{x:r-g/2,y:i-n/2+f}],iM.polygon(e,a,t)},h}async function OM(t,e,{config:{themeVariables:r,flowchart:i}}){let{labelStyles:n}=lx(e);e.labelStyle=n;let a=e.assetHeight??48,o=e.assetWidth??48,s=Math.max(a,o),l=i?.wrappingWidth;e.width=Math.max(s,l??0);let{shapeSvg:h,bbox:c,halfPadding:u,label:d}=await CS(t,e,"icon-shape default"),p="t"===e.pos,f=s+2*u,g=s+2*u,{nodeBorder:m,mainBkg:x}=r,{stylesMap:b}=ax(e),k=-g/2,C=-f/2,w=e.label?8:0,_=LT.svg(h),v=hx(e,{});"handDrawn"!==e.look&&(v.roughness=0,v.fillStyle="solid");let S=b.get("fill");v.stroke=S??x;let T=_.path(NT(k,C,g,f,.1),v),M=Math.max(g,c.width),B=f+c.height+w,A=_.rectangle(-M/2,-B/2,M,B,{...v,fill:"transparent",stroke:"none"}),L=h.insert(()=>T,":first-child"),F=h.insert(()=>A);if(e.icon){let t=h.append("g");t.html(`<g>${await j_(e.icon,{height:s,width:s,fallbackPrefix:""})}</g>`);let r=t.node().getBBox(),i=r.width,n=r.height,a=r.x,o=r.y;t.attr("transform",`translate(${-i/2-a},${p?c.height/2+w/2-n/2-o:-c.height/2-w/2-n/2-o})`),t.attr("style",`color: ${b.get("stroke")??m};`)}return d.attr("transform",`translate(${-c.width/2-(c.x-(c.left??0))},${p?-B/2:B/2-c.height})`),L.attr("transform",`translate(0,${p?c.height/2+w/2:-c.height/2-w/2})`),_S(e,F),e.intersect=function(t){if(y.info("iconSquare intersect",e,t),!e.label)return iM.rect(e,t);let r=e.x??0,i=e.y??0,n=e.height??0,a=[];return a=p?[{x:r-c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2+c.height+w},{x:r+g/2,y:i-n/2+c.height+w},{x:r+g/2,y:i+n/2},{x:r-g/2,y:i+n/2},{x:r-g/2,y:i-n/2+c.height+w},{x:r-c.width/2,y:i-n/2+c.height+w}]:[{x:r-g/2,y:i-n/2},{x:r+g/2,y:i-n/2},{x:r+g/2,y:i-n/2+f},{x:r+c.width/2,y:i-n/2+f},{x:r+c.width/2/2,y:i+n/2},{x:r-c.width/2,y:i+n/2},{x:r-c.width/2,y:i-n/2+f},{x:r-g/2,y:i-n/2+f}],iM.polygon(e,a,t)},h}async function IM(t,e,{config:{flowchart:r}}){let i=new Image;i.src=e?.img??"",await i.decode();let n=Number(i.naturalWidth.toString().replace("px","")),a=Number(i.naturalHeight.toString().replace("px",""));e.imageAspectRatio=n/a;let{labelStyles:o}=lx(e);e.labelStyle=o;let s=r?.wrappingWidth;e.defaultWidth=r?.wrappingWidth;let l=Math.max(e.label?s??0:0,e?.assetWidth??n),h="on"===e.constraint&&e?.assetHeight?e.assetHeight*e.imageAspectRatio:l,c="on"===e.constraint?h/e.imageAspectRatio:e?.assetHeight??a;e.width=Math.max(h,s??0);let{shapeSvg:u,bbox:d,label:p}=await CS(t,e,"image-shape default"),f="t"===e.pos,g=-h/2,m=-c/2,x=e.label?8:0,b=LT.svg(u),k=hx(e,{});"handDrawn"!==e.look&&(k.roughness=0,k.fillStyle="solid");let C=b.rectangle(g,m,h,c,k),w=Math.max(h,d.width),_=c+d.height+x,v=b.rectangle(-w/2,-_/2,w,_,{...k,fill:"none",stroke:"none"}),S=u.insert(()=>C,":first-child"),T=u.insert(()=>v);if(e.img){let t=u.append("image");t.attr("href",e.img),t.attr("width",h),t.attr("height",c),t.attr("preserveAspectRatio","none"),t.attr("transform",`translate(${-h/2},${f?_/2-c:-_/2})`)}return p.attr("transform",`translate(${-d.width/2-(d.x-(d.left??0))},${f?-c/2-d.height/2-x/2:c/2-d.height/2+x/2})`),S.attr("transform",`translate(0,${f?d.height/2+x/2:-d.height/2-x/2})`),_S(e,T),e.intersect=function(t){if(y.info("iconSquare intersect",e,t),!e.label)return iM.rect(e,t);let r=e.x??0,i=e.y??0,n=e.height??0,a=[];return a=f?[{x:r-d.width/2,y:i-n/2},{x:r+d.width/2,y:i-n/2},{x:r+d.width/2,y:i-n/2+d.height+x},{x:r+h/2,y:i-n/2+d.height+x},{x:r+h/2,y:i+n/2},{x:r-h/2,y:i+n/2},{x:r-h/2,y:i-n/2+d.height+x},{x:r-d.width/2,y:i-n/2+d.height+x}]:[{x:r-h/2,y:i-n/2},{x:r+h/2,y:i-n/2},{x:r+h/2,y:i-n/2+c},{x:r+d.width/2,y:i-n/2+c},{x:r+d.width/2/2,y:i+n/2},{x:r-d.width/2,y:i+n/2},{x:r-d.width/2,y:i-n/2+c},{x:r-h/2,y:i-n/2+c}],iM.polygon(e,a,t)},u}async function NM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await CS(t,e,vS(e)),s=Math.max(o.width+2*(e.padding??0),e?.width??0),l=Math.max(o.height+2*(e.padding??0),e?.height??0),h=[{x:0,y:0},{x:s,y:0},{x:s+3*l/6,y:-l},{x:-3*l/6,y:-l}],{cssStyles:c}=e;if("handDrawn"===e.look){let t=LT.svg(a),r=hx(e,{}),i=SS(h),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-s/2}, ${l/2})`),c&&n.attr("style",c)}else n=sM(a,s,l,h);return i&&n.attr("style",i),e.width=s,e.height=l,_S(e,n),e.intersect=function(t){return iM.polygon(e,h,t)},a}async function RM(t,e,r){let{labelStyles:i,nodeStyles:n}=lx(e);e.labelStyle=i;let a,{shapeSvg:o,bbox:s}=await CS(t,e,vS(e)),l=Math.max(s.width+2*r.labelPaddingX,e?.width||0),h=Math.max(s.height+2*r.labelPaddingY,e?.height||0),c=-l/2,u=-h/2,{rx:d,ry:p}=e,{cssStyles:f}=e;if(r?.rx&&r.ry&&(d=r.rx,p=r.ry),"handDrawn"===e.look){let t=LT.svg(o),r=hx(e,{}),i=d||p?t.path(NT(c,u,l,h,d||0),r):t.rectangle(c,u,l,h,r);a=o.insert(()=>i,":first-child"),a.attr("class","basic label-container").attr("style",l_(f))}else a=o.insert("rect",":first-child"),a.attr("class","basic label-container").attr("style",n).attr("rx",l_(d)).attr("ry",l_(p)).attr("x",c).attr("y",u).attr("width",l).attr("height",h);return _S(e,a),e.calcIntersect=function(t,e){return iM.rect(t,e)},e.intersect=function(t){return iM.rect(e,t)},o}async function PM(t,e){let{shapeSvg:r,bbox:i,label:n}=await CS(t,e,"label"),a=r.insert("rect",":first-child");return a.attr("width",.1).attr("height",.1),r.attr("class","label edgeLabel"),n.attr("transform",`translate(${-i.width/2-(i.x-(i.left??0))}, ${-i.height/2-(i.y-(i.top??0))})`),_S(e,a),e.intersect=function(t){return iM.rect(e,t)},r}async function zM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await CS(t,e,vS(e)),s=Math.max(o.width+(e.padding??0),e?.width??0),l=Math.max(o.height+(e.padding??0),e?.height??0),h=[{x:0,y:0},{x:s+3*l/6,y:0},{x:s,y:-l},{x:-3*l/6,y:-l}],{cssStyles:c}=e;if("handDrawn"===e.look){let t=LT.svg(a),r=hx(e,{}),i=SS(h),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-s/2}, ${l/2})`),c&&n.attr("style",c)}else n=sM(a,s,l,h);return i&&n.attr("style",i),e.width=s,e.height=l,_S(e,n),e.intersect=function(t){return iM.polygon(e,h,t)},a}async function qM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await CS(t,e,vS(e)),s=Math.max(o.width+(e.padding??0),e?.width??0),l=Math.max(o.height+(e.padding??0),e?.height??0),h=[{x:-3*l/6,y:0},{x:s,y:0},{x:s+3*l/6,y:-l},{x:0,y:-l}],{cssStyles:c}=e;if("handDrawn"===e.look){let t=LT.svg(a),r=hx(e,{}),i=SS(h),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-s/2}, ${l/2})`),c&&n.attr("style",c)}else n=sM(a,s,l,h);return i&&n.attr("style",i),e.width=s,e.height=l,_S(e,n),e.intersect=function(t){return iM.polygon(e,h,t)},a}function jM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.label="",e.labelStyle=r;let n=t.insert("g").attr("class",vS(e)).attr("id",e.domId??e.id),{cssStyles:a}=e,o=Math.max(35,e?.width??0),s=Math.max(35,e?.height??0),l=[{x:o,y:0},{x:0,y:s+3.5},{x:o-14,y:s+3.5},{x:0,y:2*s},{x:o,y:s-3.5},{x:14,y:s-3.5}],h=LT.svg(n),c=hx(e,{});"handDrawn"!==e.look&&(c.roughness=0,c.fillStyle="solid");let u=SS(l),d=h.path(u,c),p=n.insert(()=>d,":first-child");return a&&"handDrawn"!==e.look&&p.selectAll("path").attr("style",a),i&&"handDrawn"!==e.look&&p.selectAll("path").attr("style",i),p.attr("transform",`translate(-${o/2},${-s})`),_S(e,p),e.intersect=function(t){return y.info("lightningBolt intersect",e,t),iM.polygon(e,l,t)},n}s(_M,"cylinder"),s(vM,"dividedRectangle"),s(SM,"doublecircle"),s(TM,"filledCircle"),s(MM,"flippedTriangle"),s(BM,"forkJoin"),s(AM,"halfRoundedRectangle"),s(LM,"hexagon"),s(FM,"hourglass"),s($M,"icon"),s(EM,"iconCircle"),s(DM,"iconRounded"),s(OM,"iconSquare"),s(IM,"imageSquare"),s(NM,"inv_trapezoid"),s(RM,"drawRect"),s(PM,"labelRect"),s(zM,"lean_left"),s(qM,"lean_right"),s(jM,"lightningBolt");var WM=s((t,e,r,i,n,a,o)=>[`M${t},${e+a}`,`a${n},${a} 0,0,0 ${r},0`,`a${n},${a} 0,0,0 ${-r},0`,`l0,${i}`,`a${n},${a} 0,0,0 ${r},0`,"l0,"+-i,`M${t},${e+a+o}`,`a${n},${a} 0,0,0 ${r},0`].join(" "),"createCylinderPathD"),HM=s((t,e,r,i,n,a,o)=>[`M${t},${e+a}`,`M${t+r},${e+a}`,`a${n},${a} 0,0,0 ${-r},0`,`l0,${i}`,`a${n},${a} 0,0,0 ${r},0`,"l0,"+-i,`M${t},${e+a+o}`,`a${n},${a} 0,0,0 ${r},0`].join(" "),"createOuterCylinderPathD"),UM=s((t,e,r,i,n,a)=>[`M${t-r/2},${-i/2}`,`a${n},${a} 0,0,0 ${r},0`].join(" "),"createInnerCylinderPathD");async function YM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o,label:s}=await CS(t,e,vS(e)),l=Math.max(o.width+(e.padding??0),e.width??0),h=l/2,c=h/(2.5+l/50),u=Math.max(o.height+c+(e.padding??0),e.height??0),d=.1*u,{cssStyles:p}=e;if("handDrawn"===e.look){let t=LT.svg(a),r=HM(0,0,l,u,h,c,d),i=UM(0,c,l,u,h,c),o=hx(e,{}),s=t.path(r,o),f=t.path(i,o);a.insert(()=>f,":first-child").attr("class","line"),n=a.insert(()=>s,":first-child"),n.attr("class","basic label-container"),p&&n.attr("style",p)}else{let t=WM(0,0,l,u,h,c,d);n=a.insert("path",":first-child").attr("d",t).attr("class","basic label-container").attr("style",l_(p)).attr("style",i)}return n.attr("label-offset-y",c),n.attr("transform",`translate(${-l/2}, ${-(u/2+c)})`),_S(e,n),s.attr("transform",`translate(${-o.width/2-(o.x-(o.left??0))}, ${-o.height/2+c-(o.y-(o.top??0))})`),e.intersect=function(t){let r=iM.rect(e,t),i=r.x-(e.x??0);if(0!=h&&(Math.abs(i)<(e.width??0)/2||Math.abs(i)==(e.width??0)/2&&Math.abs(r.y-(e.y??0))>(e.height??0)/2-c)){let n=c*c*(1-i*i/(h*h));n>0&&(n=Math.sqrt(n)),n=c-n,t.y-(e.y??0)>0&&(n=-n),r.y+=n}return r},a}async function VM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=l/4,c=l+h,{cssStyles:u}=e,d=LT.svg(n),p=hx(e,{});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=[{x:-s/2-s/2*.1,y:-c/2},{x:-s/2-s/2*.1,y:c/2},...TS(-s/2-s/2*.1,c/2,s/2+s/2*.1,c/2,h,.8),{x:s/2+s/2*.1,y:-c/2},{x:-s/2-s/2*.1,y:-c/2},{x:-s/2,y:-c/2},{x:-s/2,y:c/2*1.1},{x:-s/2,y:-c/2}],g=d.polygon(f.map(t=>[t.x,t.y]),p),y=n.insert(()=>g,":first-child");return y.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",u),i&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",i),y.attr("transform",`translate(0,${-h/2})`),o.attr("transform",`translate(${-s/2+(e.padding??0)+s/2*.1/2-(a.x-(a.left??0))},${-l/2+(e.padding??0)-h/2-(a.y-(a.top??0))})`),_S(e,y),e.intersect=function(t){return iM.polygon(e,f,t)},n}async function GM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=-s/2,c=-l/2,{cssStyles:u}=e,d=LT.svg(n),p=hx(e,{}),f=[{x:h-5,y:c+5},{x:h-5,y:c+l+5},{x:h+s-5,y:c+l+5},{x:h+s-5,y:c+l},{x:h+s,y:c+l},{x:h+s,y:c+l-5},{x:h+s+5,y:c+l-5},{x:h+s+5,y:c-5},{x:h+5,y:c-5},{x:h+5,y:c},{x:h,y:c},{x:h,y:c+5}],g=[{x:h,y:c+5},{x:h+s-5,y:c+5},{x:h+s-5,y:c+l},{x:h+s,y:c+l},{x:h+s,y:c},{x:h,y:c}];"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let y=SS(f),m=d.path(y,p),x=SS(g),b=d.path(x,{...p,fill:"none"}),k=n.insert(()=>b,":first-child");return k.insert(()=>m,":first-child"),k.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&k.selectAll("path").attr("style",u),i&&"handDrawn"!==e.look&&k.selectAll("path").attr("style",i),o.attr("transform",`translate(${-a.width/2-5-(a.x-(a.left??0))}, ${-a.height/2+5-(a.y-(a.top??0))})`),_S(e,k),e.intersect=function(t){return iM.polygon(e,f,t)},n}async function XM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=l/4,c=l+h,u=-s/2,d=-c/2,{cssStyles:p}=e,f=TS(u-5,d+c+5,u+s-5,d+c+5,h,.8),g=f?.[f.length-1],y=[{x:u-5,y:d+5},{x:u-5,y:d+c+5},...f,{x:u+s-5,y:g.y-5},{x:u+s,y:g.y-5},{x:u+s,y:g.y-10},{x:u+s+5,y:g.y-10},{x:u+s+5,y:d-5},{x:u+5,y:d-5},{x:u+5,y:d},{x:u,y:d},{x:u,y:d+5}],m=[{x:u,y:d+5},{x:u+s-5,y:d+5},{x:u+s-5,y:g.y-5},{x:u+s,y:g.y-5},{x:u+s,y:d},{x:u,y:d}],x=LT.svg(n),b=hx(e,{});"handDrawn"!==e.look&&(b.roughness=0,b.fillStyle="solid");let k=SS(y),C=x.path(k,b),w=SS(m),_=x.path(w,b),v=n.insert(()=>C,":first-child");return v.insert(()=>_),v.attr("class","basic label-container"),p&&"handDrawn"!==e.look&&v.selectAll("path").attr("style",p),i&&"handDrawn"!==e.look&&v.selectAll("path").attr("style",i),v.attr("transform",`translate(0,${-h/2})`),o.attr("transform",`translate(${-a.width/2-5-(a.x-(a.left??0))}, ${-a.height/2+5-h/2-(a.y-(a.top??0))})`),_S(e,v),e.intersect=function(t){return iM.polygon(e,y,t)},n}async function ZM(t,e,{config:{themeVariables:r}}){let{labelStyles:i,nodeStyles:n}=lx(e);e.labelStyle=i,e.useHtmlLabels||!1!==Bd().flowchart?.htmlLabels||(e.centerLabel=!0);let{shapeSvg:a,bbox:o,label:s}=await CS(t,e,vS(e)),l=Math.max(o.width+2*(e.padding??0),e?.width??0),h=Math.max(o.height+2*(e.padding??0),e?.height??0),c=-l/2,u=-h/2,{cssStyles:d}=e,p=LT.svg(a),f=hx(e,{fill:r.noteBkgColor,stroke:r.noteBorderColor});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=p.rectangle(c,u,l,h,f),y=a.insert(()=>g,":first-child");return y.attr("class","basic label-container"),d&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",d),n&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",n),s.attr("transform",`translate(${-o.width/2-(o.x-(o.left??0))}, ${-o.height/2-(o.y-(o.top??0))})`),_S(e,y),e.intersect=function(t){return iM.rect(e,t)},a}s(YM,"linedCylinder"),s(VM,"linedWaveEdgedRect"),s(GM,"multiRect"),s(XM,"multiWaveEdgedRectangle"),s(ZM,"note");var QM=s((t,e,r)=>[`M${t+r/2},${e}`,`L${t+r},${e-r/2}`,`L${t+r/2},${e-r}`,`L${t},${e-r/2}`,"Z"].join(" "),"createDecisionBoxPathD");async function KM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await CS(t,e,vS(e)),s=o.width+e.padding+(o.height+e.padding),l=[{x:s/2,y:0},{x:s,y:-s/2},{x:s/2,y:-s},{x:0,y:-s/2}],{cssStyles:h}=e;if("handDrawn"===e.look){let t=LT.svg(a),r=hx(e,{}),i=QM(0,0,s),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-s/2+.5}, ${s/2})`),h&&n.attr("style",h)}else n=sM(a,s,s,l),n.attr("transform",`translate(${-s/2+.5}, ${s/2})`);return i&&n.attr("style",i),_S(e,n),e.calcIntersect=function(t,e){let r=t.width,i=[{x:r/2,y:0},{x:r,y:-r/2},{x:r/2,y:-r},{x:0,y:-r/2}],n=iM.polygon(t,i,e);return{x:n.x-.5,y:n.y-.5}},e.intersect=function(t){return this.calcIntersect(e,t)},a}async function JM(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=-Math.max(a.width+(e.padding??0),e?.width??0)/2,l=-Math.max(a.height+(e.padding??0),e?.height??0)/2,h=l/2,c=[{x:s+h,y:l},{x:s,y:0},{x:s+h,y:-l},{x:-s,y:-l},{x:-s,y:l}],{cssStyles:u}=e,d=LT.svg(n),p=hx(e,{});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=SS(c),g=d.path(f,p),y=n.insert(()=>g,":first-child");return y.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",u),i&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",i),y.attr("transform",`translate(${-h/2},0)`),o.attr("transform",`translate(${-h/2-a.width/2-(a.x-(a.left??0))}, ${-a.height/2-(a.y-(a.top??0))})`),_S(e,y),e.intersect=function(t){return iM.polygon(e,c,t)},n}async function tB(t,e){let r,{labelStyles:i,nodeStyles:n}=lx(e);e.labelStyle=i,r=e.cssClasses?"node "+e.cssClasses:"node default";let a=t.insert("g").attr("class",r).attr("id",e.domId||e.id),o=a.insert("g"),s=a.insert("g").attr("class","label").attr("style",n),l=e.description,h=e.label,c=s.node().appendChild(await IT(h,e.labelStyle,!0,!0)),u={width:0,height:0};if(af(qf()?.flowchart?.htmlLabels)){let t=c.children[0],e=Ke(c);u=t.getBoundingClientRect(),e.attr("width",u.width),e.attr("height",u.height)}y.info("Text 2",l);let d=l||[],p=c.getBBox(),f=s.node().appendChild(await IT(d.join?d.join("<br/>"):d,e.labelStyle,!0,!0)),g=f.children[0],m=Ke(f);u=g.getBoundingClientRect(),m.attr("width",u.width),m.attr("height",u.height);let x=(e.padding||0)/2;Ke(f).attr("transform","translate( "+(u.width>p.width?0:(p.width-u.width)/2)+", "+(p.height+x+5)+")"),Ke(c).attr("transform","translate( "+(u.width<p.width?0:-(p.width-u.width)/2)+", 0)"),u=s.node().getBBox(),s.attr("transform","translate("+-u.width/2+", "+(-u.height/2-x+3)+")");let b,k,C=u.width+(e.padding||0),w=u.height+(e.padding||0),_=-u.width/2-x,v=-u.height/2-x;if("handDrawn"===e.look){let t=LT.svg(a),r=hx(e,{}),i=t.path(NT(_,v,C,w,e.rx||0),r),n=t.line(-u.width/2-x,-u.height/2-x+p.height+x,u.width/2+x,-u.height/2-x+p.height+x,r);k=a.insert(()=>(y.debug("Rough node insert CXC",i),n),":first-child"),b=a.insert(()=>(y.debug("Rough node insert CXC",i),i),":first-child")}else b=o.insert("rect",":first-child"),k=o.insert("line"),b.attr("class","outer title-state").attr("style",n).attr("x",-u.width/2-x).attr("y",-u.height/2-x).attr("width",u.width+(e.padding||0)).attr("height",u.height+(e.padding||0)),k.attr("class","divider").attr("x1",-u.width/2-x).attr("x2",u.width/2+x).attr("y1",-u.height/2-x+p.height+x).attr("y2",-u.height/2-x+p.height+x);return _S(e,b),e.intersect=function(t){return iM.rect(e,t)},a}function eB(t,e,r,i,n,a,o){let s=(t+r)/2,l=(e+i)/2,h=Math.atan2(i-e,r-t),c=(r-t)/2/n,u=(i-e)/2/a,d=Math.sqrt(c**2+u**2);if(d>1)throw new Error("The given radii are too small to create an arc between the points.");let p=Math.sqrt(1-d**2),f=s+p*a*Math.sin(h)*(o?-1:1),g=l-p*n*Math.cos(h)*(o?-1:1),y=Math.atan2((e-g)/a,(t-f)/n),m=Math.atan2((i-g)/a,(r-f)/n)-y;o&&m<0&&(m+=2*Math.PI),!o&&m>0&&(m-=2*Math.PI);let x=[];for(let t=0;t<20;t++){let e=y+t/19*m,r=f+n*Math.cos(e),i=g+a*Math.sin(e);x.push({x:r,y:i})}return x}async function rB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=e?.padding??0,s=e?.padding??0,l=(e?.width?e?.width:a.width)+2*o,h=(e?.height?e?.height:a.height)+2*s,c=e.radius||5,u=e.taper||5,{cssStyles:d}=e,p=LT.svg(n),f=hx(e,{});e.stroke&&(f.stroke=e.stroke),"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=[{x:-l/2+u,y:-h/2},{x:l/2-u,y:-h/2},...eB(l/2-u,-h/2,l/2,-h/2+u,c,c,!0),{x:l/2,y:-h/2+u},{x:l/2,y:h/2-u},...eB(l/2,h/2-u,l/2-u,h/2,c,c,!0),{x:l/2-u,y:h/2},{x:-l/2+u,y:h/2},...eB(-l/2+u,h/2,-l/2,h/2-u,c,c,!0),{x:-l/2,y:h/2-u},{x:-l/2,y:-h/2+u},...eB(-l/2,-h/2+u,-l/2+u,-h/2,c,c,!0)],y=SS(g),m=p.path(y,f),x=n.insert(()=>m,":first-child");return x.attr("class","basic label-container outer-path"),d&&"handDrawn"!==e.look&&x.selectChildren("path").attr("style",d),i&&"handDrawn"!==e.look&&x.selectChildren("path").attr("style",i),_S(e,x),e.intersect=function(t){return iM.polygon(e,g,t)},n}async function iB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=e?.padding??0,l=Math.max(a.width+2*(e.padding??0),e?.width??0),h=Math.max(a.height+2*(e.padding??0),e?.height??0),c=-a.width/2-s,u=-a.height/2-s,{cssStyles:d}=e,p=LT.svg(n),f=hx(e,{});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=[{x:c,y:u},{x:c+l+8,y:u},{x:c+l+8,y:u+h},{x:c-8,y:u+h},{x:c-8,y:u},{x:c,y:u},{x:c,y:u+h}],y=p.polygon(g.map(t=>[t.x,t.y]),f),m=n.insert(()=>y,":first-child");return m.attr("class","basic label-container").attr("style",l_(d)),i&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",i),d&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",i),o.attr("transform",`translate(${-l/2+4+(e.padding??0)-(a.x-(a.left??0))},${-h/2+(e.padding??0)-(a.y-(a.top??0))})`),_S(e,m),e.intersect=function(t){return iM.rect(e,t)},n}async function nB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=-s/2,c=-l/2,{cssStyles:u}=e,d=LT.svg(n),p=hx(e,{});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=[{x:h,y:c},{x:h,y:c+l},{x:h+s,y:c+l},{x:h+s,y:c-l/2}],g=SS(f),y=d.path(g,p),m=n.insert(()=>y,":first-child");return m.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",u),i&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",i),m.attr("transform",`translate(0, ${l/4})`),o.attr("transform",`translate(${-s/2+(e.padding??0)-(a.x-(a.left??0))}, ${-l/4+(e.padding??0)-(a.y-(a.top??0))})`),_S(e,m),e.intersect=function(t){return iM.polygon(e,f,t)},n}async function aB(t,e){return RM(t,e,{rx:0,ry:0,labelPaddingX:e.labelPaddingX??2*(e?.padding||0),labelPaddingY:1*(e?.padding||0)})}async function oB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=a.height+e.padding,s=a.width+o/4+e.padding,l=o/2,{cssStyles:h}=e,c=LT.svg(n),u=hx(e,{});"handDrawn"!==e.look&&(u.roughness=0,u.fillStyle="solid");let d=[{x:-s/2+l,y:-o/2},{x:s/2-l,y:-o/2},...MS(-s/2+l,0,l,50,90,270),{x:s/2-l,y:o/2},...MS(s/2-l,0,l,50,270,450)],p=SS(d),f=c.path(p,u),g=n.insert(()=>f,":first-child");return g.attr("class","basic label-container outer-path"),h&&"handDrawn"!==e.look&&g.selectChildren("path").attr("style",h),i&&"handDrawn"!==e.look&&g.selectChildren("path").attr("style",i),_S(e,g),e.intersect=function(t){return iM.polygon(e,d,t)},n}async function sB(t,e){return RM(t,e,{rx:5,ry:5})}function lB(t,e,{config:{themeVariables:r}}){let{labelStyles:i,nodeStyles:n}=lx(e);e.labelStyle=i;let{cssStyles:a}=e,{lineColor:o,stateBorder:s,nodeBorder:l}=r,h=t.insert("g").attr("class","node default").attr("id",e.domId||e.id),c=LT.svg(h),u=hx(e,{});"handDrawn"!==e.look&&(u.roughness=0,u.fillStyle="solid");let d=c.circle(0,0,14,{...u,stroke:o,strokeWidth:2}),p=s??l,f=c.circle(0,0,5,{...u,fill:p,stroke:p,strokeWidth:2,fillStyle:"solid"}),g=h.insert(()=>d,":first-child");return g.insert(()=>f),a&&g.selectAll("path").attr("style",a),n&&g.selectAll("path").attr("style",n),_S(e,g),e.intersect=function(t){return iM.circle(e,7,t)},h}function hB(t,e,{config:{themeVariables:r}}){let i,{lineColor:n}=r,a=t.insert("g").attr("class","node default").attr("id",e.domId||e.id);if("handDrawn"===e.look){let t=LT.svg(a).circle(0,0,14,nx(n));i=a.insert(()=>t),i.attr("class","state-start").attr("r",7).attr("width",14).attr("height",14)}else i=a.insert("circle",":first-child"),i.attr("class","state-start").attr("r",7).attr("width",14).attr("height",14);return _S(e,i),e.intersect=function(t){return iM.circle(e,7,t)},a}async function cB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=(e?.padding||0)/2,s=a.width+e.padding,l=a.height+e.padding,h=-a.width/2-o,c=-a.height/2-o,u=[{x:0,y:0},{x:s,y:0},{x:s,y:-l},{x:0,y:-l},{x:0,y:0},{x:-8,y:0},{x:s+8,y:0},{x:s+8,y:-l},{x:-8,y:-l},{x:-8,y:0}];if("handDrawn"===e.look){let t=LT.svg(n),r=hx(e,{}),i=t.rectangle(h-8,c,s+16,l,r),a=t.line(h,c,h,c+l,r),o=t.line(h+s,c,h+s,c+l,r);n.insert(()=>a,":first-child"),n.insert(()=>o,":first-child");let u=n.insert(()=>i,":first-child"),{cssStyles:d}=e;u.attr("class","basic label-container").attr("style",l_(d)),_S(e,u)}else{let t=sM(n,s,l,u);i&&t.attr("style",i),_S(e,t)}return e.intersect=function(t){return iM.polygon(e,u,t)},n}async function uB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=Math.max(a.width+2*(e.padding??0),e?.width??0),s=Math.max(a.height+2*(e.padding??0),e?.height??0),l=-o/2,h=-s/2,c=.2*s,u=.2*s,{cssStyles:d}=e,p=LT.svg(n),f=hx(e,{}),g=[{x:l-c/2,y:h},{x:l+o+c/2,y:h},{x:l+o+c/2,y:h+s},{x:l-c/2,y:h+s}],y=[{x:l+o-c/2,y:h+s},{x:l+o+c/2,y:h+s},{x:l+o+c/2,y:h+s-u}];"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let m=SS(g),x=p.path(m,f),b=SS(y),k=p.path(b,{...f,fillStyle:"solid"}),C=n.insert(()=>k,":first-child");return C.insert(()=>x,":first-child"),C.attr("class","basic label-container"),d&&"handDrawn"!==e.look&&C.selectAll("path").attr("style",d),i&&"handDrawn"!==e.look&&C.selectAll("path").attr("style",i),_S(e,C),e.intersect=function(t){return iM.polygon(e,g,t)},n}async function dB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=l/4,c=.2*s,u=.2*l,d=l+h,{cssStyles:p}=e,f=LT.svg(n),g=hx(e,{});"handDrawn"!==e.look&&(g.roughness=0,g.fillStyle="solid");let y=[{x:-s/2-s/2*.1,y:d/2},...TS(-s/2-s/2*.1,d/2,s/2+s/2*.1,d/2,h,.8),{x:s/2+s/2*.1,y:-d/2},{x:-s/2-s/2*.1,y:-d/2}],m=-s/2+s/2*.1,x=-d/2-.4*u,b=[{x:m+s-c,y:1.4*(x+l)},{x:m+s,y:x+l-u},{x:m+s,y:.9*(x+l)},...TS(m+s,1.3*(x+l),m+s-c,1.5*(x+l),.03*-l,.5)],k=SS(y),C=f.path(k,g),w=SS(b),_=f.path(w,{...g,fillStyle:"solid"}),v=n.insert(()=>_,":first-child");return v.insert(()=>C,":first-child"),v.attr("class","basic label-container"),p&&"handDrawn"!==e.look&&v.selectAll("path").attr("style",p),i&&"handDrawn"!==e.look&&v.selectAll("path").attr("style",i),v.attr("transform",`translate(0,${-h/2})`),o.attr("transform",`translate(${-s/2+(e.padding??0)-(a.x-(a.left??0))},${-l/2+(e.padding??0)-h/2-(a.y-(a.top??0))})`),_S(e,v),e.intersect=function(t){return iM.polygon(e,y,t)},n}async function pB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=Math.max(a.width+e.padding,e?.width||0),s=Math.max(a.height+e.padding,e?.height||0),l=-o/2,h=-s/2,c=n.insert("rect",":first-child");return c.attr("class","text").attr("style",i).attr("rx",0).attr("ry",0).attr("x",l).attr("y",h).attr("width",o).attr("height",s),_S(e,c),e.intersect=function(t){return iM.rect(e,t)},n}s(KM,"question"),s(JM,"rect_left_inv_arrow"),s(tB,"rectWithTitle"),s(eB,"generateArcPoints"),s(rB,"roundedRect"),s(iB,"shadedProcess"),s(nB,"slopedRect"),s(aB,"squareRect"),s(oB,"stadium"),s(sB,"state"),s(lB,"stateEnd"),s(hB,"stateStart"),s(cB,"subroutine"),s(uB,"taggedRect"),s(dB,"taggedWaveEdgedRectangle"),s(pB,"text");var fB=s((t,e,r,i,n,a)=>`M${t},${e}\n    a${n},${a} 0,0,1 0,${-i}\n    l${r},0\n    a${n},${a} 0,0,1 0,${i}\n    M${r},${-i}\n    a${n},${a} 0,0,0 0,${i}\n    l${-r},0`,"createCylinderPathD"),gB=s((t,e,r,i,n,a)=>[`M${t},${e}`,`M${t+r},${e}`,`a${n},${a} 0,0,0 0,${-i}`,`l${-r},0`,`a${n},${a} 0,0,0 0,${i}`,`l${r},0`].join(" "),"createOuterCylinderPathD"),yB=s((t,e,r,i,n,a)=>[`M${t+r/2},${-i/2}`,`a${n},${a} 0,0,0 0,${i}`].join(" "),"createInnerCylinderPathD");async function mB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o,label:s,halfPadding:l}=await CS(t,e,vS(e)),h="neo"===e.look?2*l:l,c=o.height+h,u=c/2,d=u/(2.5+c/50),p=o.width+d+h,{cssStyles:f}=e;if("handDrawn"===e.look){let t=LT.svg(a),r=gB(0,0,p,c,d,u),i=yB(0,0,p,c,d,u),o=t.path(r,hx(e,{})),s=t.path(i,hx(e,{fill:"none"}));n=a.insert(()=>s,":first-child"),n=a.insert(()=>o,":first-child"),n.attr("class","basic label-container"),f&&n.attr("style",f)}else{let t=fB(0,0,p,c,d,u);n=a.insert("path",":first-child").attr("d",t).attr("class","basic label-container").attr("style",l_(f)).attr("style",i),n.attr("class","basic label-container"),f&&n.selectAll("path").attr("style",f),i&&n.selectAll("path").attr("style",i)}return n.attr("label-offset-x",d),n.attr("transform",`translate(${-p/2}, ${c/2} )`),s.attr("transform",`translate(${-o.width/2-d-(o.x-(o.left??0))}, ${-o.height/2-(o.y-(o.top??0))})`),_S(e,n),e.intersect=function(t){let r=iM.rect(e,t),i=r.y-(e.y??0);if(0!=u&&(Math.abs(i)<(e.height??0)/2||Math.abs(i)==(e.height??0)/2&&Math.abs(r.x-(e.x??0))>(e.width??0)/2-d)){let n=d*d*(1-i*i/(u*u));0!=n&&(n=Math.sqrt(Math.abs(n))),n=d-n,t.x-(e.x??0)>0&&(n=-n),r.x+=n}return r},a}async function xB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await CS(t,e,vS(e)),s=o.width+e.padding,l=o.height+e.padding,h=[{x:-3*l/6,y:0},{x:s+3*l/6,y:0},{x:s,y:-l},{x:0,y:-l}],{cssStyles:c}=e;if("handDrawn"===e.look){let t=LT.svg(a),r=hx(e,{}),i=SS(h),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-s/2}, ${l/2})`),c&&n.attr("style",c)}else n=sM(a,s,l,h);return i&&n.attr("style",i),e.width=s,e.height=l,_S(e,n),e.intersect=function(t){return iM.polygon(e,h,t)},a}async function bB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=Math.max(60,a.width+2*(e.padding??0),e?.width??0),s=Math.max(20,a.height+2*(e.padding??0),e?.height??0),{cssStyles:l}=e,h=LT.svg(n),c=hx(e,{});"handDrawn"!==e.look&&(c.roughness=0,c.fillStyle="solid");let u=[{x:-o/2*.8,y:-s/2},{x:o/2*.8,y:-s/2},{x:o/2,y:-s/2*.6},{x:o/2,y:s/2},{x:-o/2,y:s/2},{x:-o/2,y:-s/2*.6}],d=SS(u),p=h.path(d,c),f=n.insert(()=>p,":first-child");return f.attr("class","basic label-container"),l&&"handDrawn"!==e.look&&f.selectChildren("path").attr("style",l),i&&"handDrawn"!==e.look&&f.selectChildren("path").attr("style",i),_S(e,f),e.intersect=function(t){return iM.polygon(e,u,t)},n}async function kB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=af(qf().flowchart?.htmlLabels),l=a.width+(e.padding??0),h=l+a.height,c=l+a.height,u=[{x:0,y:0},{x:c,y:0},{x:c/2,y:-h}],{cssStyles:d}=e,p=LT.svg(n),f=hx(e,{});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=SS(u),m=p.path(g,f),x=n.insert(()=>m,":first-child").attr("transform",`translate(${-h/2}, ${h/2})`);return d&&"handDrawn"!==e.look&&x.selectChildren("path").attr("style",d),i&&"handDrawn"!==e.look&&x.selectChildren("path").attr("style",i),e.width=l,e.height=h,_S(e,x),o.attr("transform",`translate(${-a.width/2-(a.x-(a.left??0))}, ${h/2-(a.height+(e.padding??0)/(s?2:1)-(a.y-(a.top??0)))})`),e.intersect=function(t){return y.info("Triangle intersect",e,u,t),iM.polygon(e,u,t)},n}async function CB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=l/8,c=l+h,{cssStyles:u}=e,d=70-s,p=d>0?d/2:0,f=LT.svg(n),g=hx(e,{});"handDrawn"!==e.look&&(g.roughness=0,g.fillStyle="solid");let y=[{x:-s/2-p,y:c/2},...TS(-s/2-p,c/2,s/2+p,c/2,h,.8),{x:s/2+p,y:-c/2},{x:-s/2-p,y:-c/2}],m=SS(y),x=f.path(m,g),b=n.insert(()=>x,":first-child");return b.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",u),i&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",i),b.attr("transform",`translate(0,${-h/2})`),o.attr("transform",`translate(${-s/2+(e.padding??0)-(a.x-(a.left??0))},${-l/2+(e.padding??0)-h-(a.y-(a.top??0))})`),_S(e,b),e.intersect=function(t){return iM.polygon(e,y,t)},n}async function wB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await CS(t,e,vS(e)),o=Math.max(a.width+2*(e.padding??0),e?.width??0),s=Math.max(a.height+2*(e.padding??0),e?.height??0),l=o/s,h=o,c=s;h>c*l?c=h/l:h=c*l,h=Math.max(h,100),c=Math.max(c,50);let u=Math.min(.2*c,c/4),d=c+2*u,{cssStyles:p}=e,f=LT.svg(n),g=hx(e,{});"handDrawn"!==e.look&&(g.roughness=0,g.fillStyle="solid");let y=[{x:-h/2,y:d/2},...TS(-h/2,d/2,h/2,d/2,u,1),{x:h/2,y:-d/2},...TS(h/2,-d/2,-h/2,-d/2,u,-1)],m=SS(y),x=f.path(m,g),b=n.insert(()=>x,":first-child");return b.attr("class","basic label-container"),p&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",p),i&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",i),_S(e,b),e.intersect=function(t){return iM.polygon(e,y,t)},n}async function _B(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await CS(t,e,vS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=-s/2,c=-l/2,{cssStyles:u}=e,d=LT.svg(n),p=hx(e,{}),f=[{x:h-5,y:c-5},{x:h-5,y:c+l},{x:h+s,y:c+l},{x:h+s,y:c-5}],g=`M${h-5},${c-5} L${h+s},${c-5} L${h+s},${c+l} L${h-5},${c+l} L${h-5},${c-5}\n                M${h-5},${c} L${h+s},${c}\n                M${h},${c-5} L${h},${c+l}`;"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let y=d.path(g,p),m=n.insert(()=>y,":first-child");return m.attr("transform","translate(2.5, 2.5)"),m.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",u),i&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",i),o.attr("transform",`translate(${-a.width/2+2.5-(a.x-(a.left??0))}, ${-a.height/2+2.5-(a.y-(a.top??0))})`),_S(e,m),e.intersect=function(t){return iM.polygon(e,f,t)},n}async function vB(t,e){let r=e;if(r.alias&&(e.label=r.alias),"handDrawn"===e.look){let{themeVariables:r}=Bd(),{background:i}=r,n={...e,id:e.id+"-background",look:"default",cssStyles:["stroke: none",`fill: ${i}`]};await vB(t,n)}let i=Bd();e.useHtmlLabels=i.htmlLabels;let n=i.er?.diagramPadding??10,a=i.er?.entityPadding??6,{cssStyles:o}=e,{labelStyles:s,nodeStyles:l}=lx(e);if(0===r.attributes.length&&e.label){let r={rx:0,ry:0,labelPaddingX:n,labelPaddingY:1.5*n};Xw(e.label,i)+2*r.labelPaddingX<i.er.minEntityWidth&&(e.width=i.er.minEntityWidth);let a=await RM(t,e,r);if(!af(i.htmlLabels)){let t=a.select("text"),e=t.node()?.getBBox();t.attr("transform",`translate(${-e.width/2}, 0)`)}return a}i.htmlLabels||(n*=1.25,a*=1.25);let h=vS(e);h||(h="node default");let c=t.insert("g").attr("class",h).attr("id",e.domId||e.id),u=await SB(c,e.label??"",i,0,0,["name"],s);u.height+=a;let d=0,p=[],f=[],g=0,y=0,m=0,x=0,b=!0,k=!0;for(let t of r.attributes){let e=await SB(c,t.type,i,0,d,["attribute-type"],s);g=Math.max(g,e.width+n);let r=await SB(c,t.name,i,0,d,["attribute-name"],s);y=Math.max(y,r.width+n);let o=await SB(c,t.keys.join(),i,0,d,["attribute-keys"],s);m=Math.max(m,o.width+n);let l=await SB(c,t.comment,i,0,d,["attribute-comment"],s);x=Math.max(x,l.width+n);let h=Math.max(e.height,r.height,o.height,l.height)+a;f.push({yOffset:d,rowHeight:h}),d+=h}let C=4;m<=n&&(b=!1,m=0,C--),x<=n&&(k=!1,x=0,C--);let w=c.node().getBBox();if(u.width+2*n-(g+y+m+x)>0){let t=u.width+2*n-(g+y+m+x);g+=t/C,y+=t/C,m>0&&(m+=t/C),x>0&&(x+=t/C)}let _=g+y+m+x,v=LT.svg(c),S=hx(e,{});"handDrawn"!==e.look&&(S.roughness=0,S.fillStyle="solid");let T=0;f.length>0&&(T=f.reduce((t,e)=>t+(e?.rowHeight??0),0));let M=Math.max(w.width+2*n,e?.width||0,_),B=Math.max((T??0)+u.height,e?.height||0),A=-M/2,L=-B/2;c.selectAll("g:not(:first-child)").each((t,e,r)=>{let i=Ke(r[e]),o=i.attr("transform"),s=0,l=0;if(o){let t=RegExp(/translate\(([^,]+),([^)]+)\)/).exec(o);t&&(s=parseFloat(t[1]),l=parseFloat(t[2]),i.attr("class").includes("attribute-name")?s+=g:i.attr("class").includes("attribute-keys")?s+=g+y:i.attr("class").includes("attribute-comment")&&(s+=g+y+m))}i.attr("transform",`translate(${A+n/2+s}, ${l+L+u.height+a/2})`)}),c.select(".name").attr("transform","translate("+-u.width/2+", "+(L+a/2)+")");let F=v.rectangle(A,L,M,B,S),$=c.insert(()=>F,":first-child").attr("style",o.join("")),{themeVariables:E}=Bd(),{rowEven:D,rowOdd:O,nodeBorder:I}=E;p.push(0);for(let[t,e]of f.entries()){let r=(t+1)%2==0&&0!==e.yOffset,i=v.rectangle(A,u.height+L+e?.yOffset,M,e?.rowHeight,{...S,fill:r?D:O,stroke:I});c.insert(()=>i,"g.label").attr("style",o.join("")).attr("class","row-rect-"+(r?"even":"odd"))}let N=v.line(A,u.height+L,M+A,u.height+L,S);c.insert(()=>N).attr("class","divider"),N=v.line(g+A,u.height+L,g+A,B+L,S),c.insert(()=>N).attr("class","divider"),b&&(N=v.line(g+y+A,u.height+L,g+y+A,B+L,S),c.insert(()=>N).attr("class","divider")),k&&(N=v.line(g+y+m+A,u.height+L,g+y+m+A,B+L,S),c.insert(()=>N).attr("class","divider"));for(let t of p)N=v.line(A,u.height+L+t,M+A,u.height+L+t,S),c.insert(()=>N).attr("class","divider");if(_S(e,$),l&&"handDrawn"!==e.look){let t=l.split(";")?.filter(t=>t.includes("stroke"))?.map(t=>`${t}`).join("; ");c.selectAll("path").attr("style",t??""),c.selectAll(".row-rect-even path").attr("style",l)}return e.intersect=function(t){return iM.rect(e,t)},c}async function SB(t,e,r,i=0,n=0,a=[],o=""){let s=t.insert("g").attr("class",`label ${a.join(" ")}`).attr("transform",`translate(${i}, ${n})`).attr("style",o);e!==lf(e)&&(e=(e=lf(e)).replaceAll("<","&lt;").replaceAll(">","&gt;"));let l=s.node().appendChild(await kS(s,e,{width:Xw(e,r)+100,style:o,useHtmlLabels:r.htmlLabels},r));if(e.includes("&lt;")||e.includes("&gt;")){let t=l.children[0];for(t.textContent=t.textContent.replaceAll("&lt;","<").replaceAll("&gt;",">");t.childNodes[0];)t=t.childNodes[0],t.textContent=t.textContent.replaceAll("&lt;","<").replaceAll("&gt;",">")}let h=l.getBBox();if(af(r.htmlLabels)){let t=l.children[0];t.style.textAlign="start";let e=Ke(l);h=t.getBoundingClientRect(),e.attr("width",h.width),e.attr("height",h.height)}return h}async function TB(t,e,r,i,n=r.class.padding??12){let a=i?0:3,o=t.insert("g").attr("class",vS(e)).attr("id",e.domId||e.id),s=null,l=null,h=null,c=null,u=0,d=0,p=0;if(s=o.insert("g").attr("class","annotation-group text"),e.annotations.length>0){let t=e.annotations[0];await MB(s,{text:`«${t}»`},0),u=s.node().getBBox().height}l=o.insert("g").attr("class","label-group text"),await MB(l,e,0,["font-weight: bolder"]);let f=l.node().getBBox();d=f.height,h=o.insert("g").attr("class","members-group text");let g=0;for(let t of e.members){g+=await MB(h,t,g,[t.parseClassifier()])+a}p=h.node().getBBox().height,p<=0&&(p=n/2),c=o.insert("g").attr("class","methods-group text");let y=0;for(let t of e.methods){y+=await MB(c,t,y,[t.parseClassifier()])+a}let m=o.node().getBBox();if(null!==s){let t=s.node().getBBox();s.attr("transform",`translate(${-t.width/2})`)}return l.attr("transform",`translate(${-f.width/2}, ${u})`),m=o.node().getBBox(),h.attr("transform",`translate(0, ${u+d+2*n})`),m=o.node().getBBox(),c.attr("transform",`translate(0, ${u+d+(p?p+4*n:2*n)})`),m=o.node().getBBox(),{shapeSvg:o,bbox:m}}async function MB(t,e,r,i=[]){let n=t.insert("g").attr("class","label").attr("style",i.join("; ")),a=Bd(),o="useHtmlLabels"in e?e.useHtmlLabels:af(a.htmlLabels)??!0,l="";l="text"in e?e.text:e.label,!o&&l.startsWith("\\")&&(l=l.substring(1)),ff(l)&&(o=!0);let h,c=await kS(n,Hf(o_(l)),{width:Xw(l,a)+50,classes:"markdown-node-label",useHtmlLabels:o},a),u=1;if(o){let t=c.children[0],e=Ke(c);u=t.innerHTML.split("<br>").length,t.innerHTML.includes("</math>")&&(u+=t.innerHTML.split("<mrow>").length-1);let r=t.getElementsByTagName("img");if(r){let t=""===l.replace(/<img[^>]*>/g,"").trim();await Promise.all([...r].map(e=>new Promise(r=>{function i(){if(e.style.display="flex",e.style.flexDirection="column",t){let t=a.fontSize?.toString()??window.getComputedStyle(document.body).fontSize,r=5*parseInt(t,10)+"px";e.style.minWidth=r,e.style.maxWidth=r}else e.style.width="100%";r(e)}s(i,"setupImage"),setTimeout(()=>{e.complete&&i()}),e.addEventListener("error",i),e.addEventListener("load",i)})))}h=t.getBoundingClientRect(),e.attr("width",h.width),e.attr("height",h.height)}else{i.includes("font-weight: bolder")&&Ke(c).selectAll("tspan").attr("font-weight",""),u=c.children.length;let t=c.children[0];(""===c.textContent||c.textContent.includes("&gt"))&&(t.textContent=l[0]+l.substring(1).replaceAll("&gt;",">").replaceAll("&lt;","<").trim()," "===l[1]&&(t.textContent=t.textContent[0]+" "+t.textContent.substring(1))),"undefined"===t.textContent&&(t.textContent=""),h=c.getBBox()}return n.attr("transform","translate(0,"+(-h.height/(2*u)+r)+")"),h.height}async function BB(t,e){let r=qf(),i=r.class.padding??12,n=i,a=e.useHtmlLabels??af(r.htmlLabels)??!0,o=e;o.annotations=o.annotations??[],o.members=o.members??[],o.methods=o.methods??[];let{shapeSvg:s,bbox:l}=await TB(t,e,r,a,n),{labelStyles:h,nodeStyles:c}=lx(e);e.labelStyle=h,e.cssStyles=o.styles||"";let u=o.styles?.join(";")||c||"";e.cssStyles||(e.cssStyles=u.replaceAll("!important","").split(";"));let d=0===o.members.length&&0===o.methods.length&&!r.class?.hideEmptyMembersBox,p=LT.svg(s),f=hx(e,{});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=l.width,y=l.height;0===o.members.length&&0===o.methods.length?y+=n:o.members.length>0&&0===o.methods.length&&(y+=2*n);let m=-g/2,x=-y/2,b=p.rectangle(m-i,x-i-(d?i:0===o.members.length&&0===o.methods.length?-i/2:0),g+2*i,y+2*i+(d?2*i:0===o.members.length&&0===o.methods.length?-i:0),f),k=s.insert(()=>b,":first-child");k.attr("class","basic label-container");let C=k.node().getBBox();s.selectAll(".text").each((t,e,r)=>{let n=Ke(r[e]),l=n.attr("transform"),h=0;if(l){let t=RegExp(/translate\(([^,]+),([^)]+)\)/).exec(l);t&&(h=parseFloat(t[2]))}let c=h+x+i-(d?i:0===o.members.length&&0===o.methods.length?-i/2:0);a||(c-=4);let u=m;(n.attr("class").includes("label-group")||n.attr("class").includes("annotation-group"))&&(u=-n.node()?.getBBox().width/2||0,s.selectAll("text").each(function(t,e,r){"middle"===window.getComputedStyle(r[e]).textAnchor&&(u=0)})),n.attr("transform",`translate(${u}, ${c})`)});let w=s.select(".annotation-group").node().getBBox().height-(d?i/2:0)||0,_=s.select(".label-group").node().getBBox().height-(d?i/2:0)||0,v=s.select(".members-group").node().getBBox().height-(d?i/2:0)||0;if(o.members.length>0||o.methods.length>0||d){let t=p.line(C.x,w+_+x+i,C.x+C.width,w+_+x+i,f);s.insert(()=>t).attr("class","divider").attr("style",u)}if(d||o.members.length>0||o.methods.length>0){let t=p.line(C.x,w+_+v+x+2*n+i,C.x+C.width,w+_+v+x+i+2*n,f);s.insert(()=>t).attr("class","divider").attr("style",u)}if("handDrawn"!==o.look&&s.selectAll("path").attr("style",u),k.select(":nth-child(2)").attr("style",u),s.selectAll(".divider").select("path").attr("style",u),e.labelStyle?s.selectAll("span").attr("style",e.labelStyle):s.selectAll("span").attr("style",u),!a){let t=RegExp(/color\s*:\s*([^;]*)/),e=t.exec(u);if(e){let t=e[0].replace("color","fill");s.selectAll("tspan").attr("style",t)}else if(h){let e=t.exec(h);if(e){let t=e[0].replace("color","fill");s.selectAll("tspan").attr("style",t)}}}return _S(e,k),e.intersect=function(t){return iM.rect(e,t)},s}async function AB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,a=e,o=e,s="verifyMethod"in e,l=vS(e),h=t.insert("g").attr("class",l).attr("id",e.domId??e.id);n=s?await LB(h,`&lt;&lt;${a.type}&gt;&gt;`,0,e.labelStyle):await LB(h,"&lt;&lt;Element&gt;&gt;",0,e.labelStyle);let c=n,u=await LB(h,a.name,c,e.labelStyle+"; font-weight: bold;");if(c+=u+20,s){c+=await LB(h,""+(a.requirementId?`ID: ${a.requirementId}`:""),c,e.labelStyle),c+=await LB(h,""+(a.text?`Text: ${a.text}`:""),c,e.labelStyle),c+=await LB(h,""+(a.risk?`Risk: ${a.risk}`:""),c,e.labelStyle),await LB(h,""+(a.verifyMethod?`Verification: ${a.verifyMethod}`:""),c,e.labelStyle)}else{c+=await LB(h,""+(o.type?`Type: ${o.type}`:""),c,e.labelStyle),await LB(h,""+(o.docRef?`Doc Ref: ${o.docRef}`:""),c,e.labelStyle)}let d=(h.node()?.getBBox().width??200)+20,p=(h.node()?.getBBox().height??200)+20,f=-d/2,g=-p/2,y=LT.svg(h),m=hx(e,{});"handDrawn"!==e.look&&(m.roughness=0,m.fillStyle="solid");let x=y.rectangle(f,g,d,p,m),b=h.insert(()=>x,":first-child");if(b.attr("class","basic label-container").attr("style",i),h.selectAll(".label").each((t,e,r)=>{let i=Ke(r[e]),n=i.attr("transform"),a=0,o=0;if(n){let t=RegExp(/translate\(([^,]+),([^)]+)\)/).exec(n);t&&(a=parseFloat(t[1]),o=parseFloat(t[2]))}let s=o-p/2,l=f+10;(0===e||1===e)&&(l=a),i.attr("transform",`translate(${l}, ${s+20})`)}),c>n+u+20){let t=y.line(f,g+n+u+20,f+d,g+n+u+20,m);h.insert(()=>t).attr("style",i)}return _S(e,b),e.intersect=function(t){return iM.rect(e,t)},h}async function LB(t,e,r,i=""){if(""===e)return 0;let n,a=t.insert("g").attr("class","label").attr("style",i),o=qf(),s=o.htmlLabels??!0,l=await kS(a,Hf(o_(e)),{width:Xw(e,o)+50,classes:"markdown-node-label",useHtmlLabels:s,style:i},o);if(s){let t=l.children[0],e=Ke(l);n=t.getBoundingClientRect(),e.attr("width",n.width),e.attr("height",n.height)}else{let t=l.children[0];for(let e of t.children)e.textContent=e.textContent.replaceAll("&gt;",">").replaceAll("&lt;","<"),i&&e.setAttribute("style",i);n=l.getBBox(),n.height+=6}return a.attr("transform",`translate(${-n.width/2},${-n.height/2+r})`),n.height}s(mB,"tiltedCylinder"),s(xB,"trapezoid"),s(bB,"trapezoidalPentagon"),s(kB,"triangle"),s(CB,"waveEdgedRectangle"),s(wB,"waveRectangle"),s(_B,"windowPane"),s(vB,"erBox"),s(SB,"addText"),s(TB,"textHelper"),s(MB,"addText"),s(BB,"classBox"),s(AB,"requirementBox"),s(LB,"addText");var FB=s(t=>{switch(t){case"Very High":return"red";case"High":return"orange";case"Medium":return null;case"Low":return"blue";case"Very Low":return"lightblue"}},"colorFromPriority");async function $B(t,e,{config:r}){let{labelStyles:i,nodeStyles:n}=lx(e);e.labelStyle=i||"";let a=e.width;e.width=(e.width??200)-10;let o,{shapeSvg:s,bbox:l,label:h}=await CS(t,e,vS(e)),c=e.padding||10,u="";"ticket"in e&&e.ticket&&r?.kanban?.ticketBaseUrl&&(u=r?.kanban?.ticketBaseUrl.replace("#TICKET#",e.ticket),o=s.insert("svg:a",":first-child").attr("class","kanban-ticket-link").attr("xlink:href",u).attr("target","_blank"));let d,p,f={useHtmlLabels:e.useHtmlLabels,labelStyle:e.labelStyle||"",width:e.width,img:e.img,padding:e.padding||8,centerLabel:!1};({label:d,bbox:p}=o?await wS(o,"ticket"in e&&e.ticket||"",f):await wS(s,"ticket"in e&&e.ticket||"",f));let{label:g,bbox:y}=await wS(s,"assigned"in e&&e.assigned||"",f);e.width=a;let m=e?.width||0,x=Math.max(p.height,y.height)/2,b=Math.max(l.height+20,e?.height||0)+x,k=-m/2,C=-b/2;h.attr("transform","translate("+(c-m/2)+", "+(-x-l.height/2)+")"),d.attr("transform","translate("+(c-m/2)+", "+(-x+l.height/2)+")"),g.attr("transform","translate("+(c+m/2-y.width-20)+", "+(-x+l.height/2)+")");let w,{rx:_,ry:v}=e,{cssStyles:S}=e;if("handDrawn"===e.look){let t=LT.svg(s),r=hx(e,{}),i=_||v?t.path(NT(k,C,m,b,_||0),r):t.rectangle(k,C,m,b,r);w=s.insert(()=>i,":first-child"),w.attr("class","basic label-container").attr("style",S||null)}else{w=s.insert("rect",":first-child"),w.attr("class","basic label-container __APA__").attr("style",n).attr("rx",_??5).attr("ry",v??5).attr("x",k).attr("y",C).attr("width",m).attr("height",b);let t="priority"in e&&e.priority;if(t){let e=s.append("line"),r=k+2,i=C+Math.floor((_??0)/2),n=C+b-Math.floor((_??0)/2);e.attr("x1",r).attr("y1",i).attr("x2",r).attr("y2",n).attr("stroke-width","4").attr("stroke",FB(t))}}return _S(e,w),e.height=b,e.intersect=function(t){return iM.rect(e,t)},s}async function EB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,halfPadding:o,label:s}=await CS(t,e,vS(e)),l=a.width+10*o,h=a.height+8*o,c=.15*l,{cssStyles:u}=e,d=a.width+20,p=a.height+20,f=Math.max(l,d),g=Math.max(h,p);s.attr("transform",`translate(${-a.width/2}, ${-a.height/2})`);let m,x=`M0 0\n    a${c},${c} 1 0,0 ${.25*f},${-1*g*.1}\n    a${c},${c} 1 0,0 ${.25*f},0\n    a${c},${c} 1 0,0 ${.25*f},0\n    a${c},${c} 1 0,0 ${.25*f},${.1*g}\n\n    a${c},${c} 1 0,0 ${.15*f},${.33*g}\n    a${.8*c},${.8*c} 1 0,0 0,${.34*g}\n    a${c},${c} 1 0,0 ${-1*f*.15},${.33*g}\n\n    a${c},${c} 1 0,0 ${-1*f*.25},${.15*g}\n    a${c},${c} 1 0,0 ${-1*f*.25},0\n    a${c},${c} 1 0,0 ${-1*f*.25},0\n    a${c},${c} 1 0,0 ${-1*f*.25},${-1*g*.15}\n\n    a${c},${c} 1 0,0 ${-1*f*.1},${-1*g*.33}\n    a${.8*c},${.8*c} 1 0,0 0,${-1*g*.34}\n    a${c},${c} 1 0,0 ${.1*f},${-1*g*.33}\n  H0 V0 Z`;if("handDrawn"===e.look){let t=LT.svg(n),r=hx(e,{}),i=t.path(x,r);m=n.insert(()=>i,":first-child"),m.attr("class","basic label-container").attr("style",l_(u))}else m=n.insert("path",":first-child").attr("class","basic label-container").attr("style",i).attr("d",x);return m.attr("transform",`translate(${-f/2}, ${-g/2})`),_S(e,m),e.calcIntersect=function(t,e){return iM.rect(t,e)},e.intersect=function(t){return y.info("Bang intersect",e,t),iM.rect(e,t)},n}async function DB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o,halfPadding:s,label:l}=await CS(t,e,vS(e)),h=o.width+2*s,c=o.height+2*s,u=.15*h,d=.25*h,p=.35*h,f=.2*h,{cssStyles:g}=e,m=`M0 0\n    a${u},${u} 0 0,1 ${.25*h},${-1*h*.1}\n    a${p},${p} 1 0,1 ${.4*h},${-1*h*.1}\n    a${d},${d} 1 0,1 ${.35*h},${.2*h}\n\n    a${u},${u} 1 0,1 ${.15*h},${.35*c}\n    a${f},${f} 1 0,1 ${-1*h*.15},${.65*c}\n\n    a${d},${u} 1 0,1 ${-1*h*.25},${.15*h}\n    a${p},${p} 1 0,1 ${-1*h*.5},0\n    a${u},${u} 1 0,1 ${-1*h*.25},${-1*h*.15}\n\n    a${u},${u} 1 0,1 ${-1*h*.1},${-1*c*.35}\n    a${f},${f} 1 0,1 ${.1*h},${-1*c*.65}\n  H0 V0 Z`;if("handDrawn"===e.look){let t=LT.svg(a),r=hx(e,{}),i=t.path(m,r);n=a.insert(()=>i,":first-child"),n.attr("class","basic label-container").attr("style",l_(g))}else n=a.insert("path",":first-child").attr("class","basic label-container").attr("style",i).attr("d",m);return l.attr("transform",`translate(${-o.width/2}, ${-o.height/2})`),n.attr("transform",`translate(${-h/2}, ${-c/2})`),_S(e,n),e.calcIntersect=function(t,e){return iM.rect(t,e)},e.intersect=function(t){return y.info("Cloud intersect",e,t),iM.rect(e,t)},a}async function OB(t,e){let{labelStyles:r,nodeStyles:i}=lx(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,halfPadding:o,label:s}=await CS(t,e,vS(e)),l=a.width+8*o,h=a.height+2*o,c=`\n    M${-l/2} ${h/2-5}\n    v${10-h}\n    q0,-5 5,-5\n    h${l-10}\n    q5,0 5,5\n    v${h-10}\n    q0,5 -5,5\n    h${10-l}\n    q-5,0 -5,-5\n    Z\n  `,u=n.append("path").attr("id","node-"+e.id).attr("class","node-bkg node-"+e.type).attr("style",i).attr("d",c);return n.append("line").attr("class","node-line-").attr("x1",-l/2).attr("y1",h/2).attr("x2",l/2).attr("y2",h/2),s.attr("transform",`translate(${-a.width/2}, ${-a.height/2})`),n.append(()=>s.node()),_S(e,u),e.calcIntersect=function(t,e){return iM.rect(t,e)},e.intersect=function(t){return iM.rect(e,t)},n}async function IB(t,e){return cM(t,e,{padding:e.padding??0})}s($B,"kanbanItem"),s(EB,"bang"),s(DB,"cloud"),s(OB,"defaultMindmapNode"),s(IB,"mindmapCircle");var NB=[{semanticName:"Process",name:"Rectangle",shortName:"rect",description:"Standard process shape",aliases:["proc","process","rectangle"],internalAliases:["squareRect"],handler:aB},{semanticName:"Event",name:"Rounded Rectangle",shortName:"rounded",description:"Represents an event",aliases:["event"],internalAliases:["roundedRect"],handler:rB},{semanticName:"Terminal Point",name:"Stadium",shortName:"stadium",description:"Terminal point",aliases:["terminal","pill"],handler:oB},{semanticName:"Subprocess",name:"Framed Rectangle",shortName:"fr-rect",description:"Subprocess",aliases:["subprocess","subproc","framed-rectangle","subroutine"],handler:cB},{semanticName:"Database",name:"Cylinder",shortName:"cyl",description:"Database storage",aliases:["db","database","cylinder"],handler:_M},{semanticName:"Start",name:"Circle",shortName:"circle",description:"Starting point",aliases:["circ"],handler:cM},{semanticName:"Bang",name:"Bang",shortName:"bang",description:"Bang",aliases:["bang"],handler:EB},{semanticName:"Cloud",name:"Cloud",shortName:"cloud",description:"cloud",aliases:["cloud"],handler:DB},{semanticName:"Decision",name:"Diamond",shortName:"diam",description:"Decision-making step",aliases:["decision","diamond","question"],handler:KM},{semanticName:"Prepare Conditional",name:"Hexagon",shortName:"hex",description:"Preparation or condition step",aliases:["hexagon","prepare"],handler:LM},{semanticName:"Data Input/Output",name:"Lean Right",shortName:"lean-r",description:"Represents input or output",aliases:["lean-right","in-out"],internalAliases:["lean_right"],handler:qM},{semanticName:"Data Input/Output",name:"Lean Left",shortName:"lean-l",description:"Represents output or input",aliases:["lean-left","out-in"],internalAliases:["lean_left"],handler:zM},{semanticName:"Priority Action",name:"Trapezoid Base Bottom",shortName:"trap-b",description:"Priority action",aliases:["priority","trapezoid-bottom","trapezoid"],handler:xB},{semanticName:"Manual Operation",name:"Trapezoid Base Top",shortName:"trap-t",description:"Represents a manual task",aliases:["manual","trapezoid-top","inv-trapezoid"],internalAliases:["inv_trapezoid"],handler:NM},{semanticName:"Stop",name:"Double Circle",shortName:"dbl-circ",description:"Represents a stop point",aliases:["double-circle"],internalAliases:["doublecircle"],handler:SM},{semanticName:"Text Block",name:"Text Block",shortName:"text",description:"Text block",handler:pB},{semanticName:"Card",name:"Notched Rectangle",shortName:"notch-rect",description:"Represents a card",aliases:["card","notched-rectangle"],handler:lM},{semanticName:"Lined/Shaded Process",name:"Lined Rectangle",shortName:"lin-rect",description:"Lined process shape",aliases:["lined-rectangle","lined-process","lin-proc","shaded-process"],handler:iB},{semanticName:"Start",name:"Small Circle",shortName:"sm-circ",description:"Small starting point",aliases:["start","small-circle"],internalAliases:["stateStart"],handler:hB},{semanticName:"Stop",name:"Framed Circle",shortName:"fr-circ",description:"Stop point",aliases:["stop","framed-circle"],internalAliases:["stateEnd"],handler:lB},{semanticName:"Fork/Join",name:"Filled Rectangle",shortName:"fork",description:"Fork or join in process flow",aliases:["join"],internalAliases:["forkJoin"],handler:BM},{semanticName:"Collate",name:"Hourglass",shortName:"hourglass",description:"Represents a collate operation",aliases:["hourglass","collate"],handler:FM},{semanticName:"Comment",name:"Curly Brace",shortName:"brace",description:"Adds a comment",aliases:["comment","brace-l"],handler:fM},{semanticName:"Comment Right",name:"Curly Brace",shortName:"brace-r",description:"Adds a comment",handler:yM},{semanticName:"Comment with braces on both sides",name:"Curly Braces",shortName:"braces",description:"Adds a comment",handler:xM},{semanticName:"Com Link",name:"Lightning Bolt",shortName:"bolt",description:"Communication link",aliases:["com-link","lightning-bolt"],handler:jM},{semanticName:"Document",name:"Document",shortName:"doc",description:"Represents a document",aliases:["doc","document"],handler:CB},{semanticName:"Delay",name:"Half-Rounded Rectangle",shortName:"delay",description:"Represents a delay",aliases:["half-rounded-rectangle"],handler:AM},{semanticName:"Direct Access Storage",name:"Horizontal Cylinder",shortName:"h-cyl",description:"Direct access storage",aliases:["das","horizontal-cylinder"],handler:mB},{semanticName:"Disk Storage",name:"Lined Cylinder",shortName:"lin-cyl",description:"Disk storage",aliases:["disk","lined-cylinder"],handler:YM},{semanticName:"Display",name:"Curved Trapezoid",shortName:"curv-trap",description:"Represents a display",aliases:["curved-trapezoid","display"],handler:bM},{semanticName:"Divided Process",name:"Divided Rectangle",shortName:"div-rect",description:"Divided process shape",aliases:["div-proc","divided-rectangle","divided-process"],handler:vM},{semanticName:"Extract",name:"Triangle",shortName:"tri",description:"Extraction process",aliases:["extract","triangle"],handler:kB},{semanticName:"Internal Storage",name:"Window Pane",shortName:"win-pane",description:"Internal storage",aliases:["internal-storage","window-pane"],handler:_B},{semanticName:"Junction",name:"Filled Circle",shortName:"f-circ",description:"Junction point",aliases:["junction","filled-circle"],handler:TM},{semanticName:"Loop Limit",name:"Trapezoidal Pentagon",shortName:"notch-pent",description:"Loop limit step",aliases:["loop-limit","notched-pentagon"],handler:bB},{semanticName:"Manual File",name:"Flipped Triangle",shortName:"flip-tri",description:"Manual file operation",aliases:["manual-file","flipped-triangle"],handler:MM},{semanticName:"Manual Input",name:"Sloped Rectangle",shortName:"sl-rect",description:"Manual input step",aliases:["manual-input","sloped-rectangle"],handler:nB},{semanticName:"Multi-Document",name:"Stacked Document",shortName:"docs",description:"Multiple documents",aliases:["documents","st-doc","stacked-document"],handler:XM},{semanticName:"Multi-Process",name:"Stacked Rectangle",shortName:"st-rect",description:"Multiple processes",aliases:["procs","processes","stacked-rectangle"],handler:GM},{semanticName:"Stored Data",name:"Bow Tie Rectangle",shortName:"bow-rect",description:"Stored data",aliases:["stored-data","bow-tie-rectangle"],handler:oM},{semanticName:"Summary",name:"Crossed Circle",shortName:"cross-circ",description:"Summary",aliases:["summary","crossed-circle"],handler:dM},{semanticName:"Tagged Document",name:"Tagged Document",shortName:"tag-doc",description:"Tagged document",aliases:["tag-doc","tagged-document"],handler:dB},{semanticName:"Tagged Process",name:"Tagged Rectangle",shortName:"tag-rect",description:"Tagged process",aliases:["tagged-rectangle","tag-proc","tagged-process"],handler:uB},{semanticName:"Paper Tape",name:"Flag",shortName:"flag",description:"Paper tape",aliases:["paper-tape"],handler:wB},{semanticName:"Odd",name:"Odd",shortName:"odd",description:"Odd shape",internalAliases:["rect_left_inv_arrow"],handler:JM},{semanticName:"Lined Document",name:"Lined Document",shortName:"lin-doc",description:"Lined document",aliases:["lined-document"],handler:VM}],RB=s(()=>{let t=[...Object.entries({state:sB,choice:hM,note:ZM,rectWithTitle:tB,labelRect:PM,iconSquare:OM,iconCircle:EM,icon:$M,iconRounded:DM,imageSquare:IM,anchor:nM,kanbanItem:$B,mindmapCircle:IB,defaultMindmapNode:OB,classBox:BB,erBox:vB,requirementBox:AB}),...NB.flatMap(t=>[t.shortName,..."aliases"in t?t.aliases:[],..."internalAliases"in t?t.internalAliases:[]].map(e=>[e,t.handler]))];return Object.fromEntries(t)},"generateShapeMap"),PB=RB();function zB(t){return t in PB}s(zB,"isValidShape");var qB=new Map;async function jB(t,e,r){let i,n;"rect"===e.shape&&(e.rx&&e.ry?e.shape="roundedRect":e.shape="squareRect");let a=e.shape?PB[e.shape]:void 0;if(!a)throw new Error(`No such shape: ${e.shape}. Please check your syntax.`);if(e.link){let o;"sandbox"===r.config.securityLevel?o="_top":e.linkTarget&&(o=e.linkTarget||"_blank"),i=t.insert("svg:a").attr("xlink:href",e.link).attr("target",o??null),n=await a(i,e,r)}else n=await a(t,e,r),i=n;return e.tooltip&&n.attr("title",e.tooltip),qB.set(e.id,i),e.haveCallback&&i.attr("class",i.attr("class")+" clickable"),i}s(jB,"insertNode");var WB=s((t,e)=>{qB.set(e.id,t)},"setNodeElem"),HB=s(()=>{qB.clear()},"clear"),UB=s(t=>{let e=qB.get(t.id);y.trace("Transforming node",t.diff,t,"translate("+(t.x-t.width/2-5)+", "+t.width/2+")");let r=t.diff||0;return t.clusterNode?e.attr("transform","translate("+(t.x+r-t.width/2)+", "+(t.y-t.height/2-8)+")"):e.attr("transform","translate("+t.x+", "+t.y+")"),r},"positionNode"),YB=s((t,e,r,i,n,a)=>{e.arrowTypeStart&&GB(t,"start",e.arrowTypeStart,r,i,n,a),e.arrowTypeEnd&&GB(t,"end",e.arrowTypeEnd,r,i,n,a)},"addEdgeMarkers"),VB={arrow_cross:{type:"cross",fill:!1},arrow_point:{type:"point",fill:!0},arrow_barb:{type:"barb",fill:!0},arrow_circle:{type:"circle",fill:!1},aggregation:{type:"aggregation",fill:!1},extension:{type:"extension",fill:!1},composition:{type:"composition",fill:!0},dependency:{type:"dependency",fill:!0},lollipop:{type:"lollipop",fill:!1},only_one:{type:"onlyOne",fill:!1},zero_or_one:{type:"zeroOrOne",fill:!1},one_or_more:{type:"oneOrMore",fill:!1},zero_or_more:{type:"zeroOrMore",fill:!1},requirement_arrow:{type:"requirement_arrow",fill:!1},requirement_contains:{type:"requirement_contains",fill:!1}},GB=s((t,e,r,i,n,a,o)=>{let s=VB[r];if(!s)return void y.warn(`Unknown arrow type: ${r}`);let l=`${n}_${a}-${s.type}${"start"===e?"Start":"End"}`;if(o&&""!==o.trim()){let r=`${l}_${o.replace(/[^\dA-Za-z]/g,"_")}`;if(!document.getElementById(r)){let t=document.getElementById(l);if(t){let e=t.cloneNode(!0);e.id=r,e.querySelectorAll("path, circle, line").forEach(t=>{t.setAttribute("stroke",o),s.fill&&t.setAttribute("fill",o)}),t.parentNode?.appendChild(e)}}t.attr(`marker-${e}`,`url(${i}#${r})`)}else t.attr(`marker-${e}`,`url(${i}#${l})`)},"addEdgeMarker"),XB=new Map,ZB=new Map,QB=s(()=>{XB.clear(),ZB.clear()},"clear"),KB=s(t=>t?t.reduce((t,e)=>t+";"+e,""):"","getLabelStyles"),JB=s(async(t,e)=>{let r=af(qf().flowchart.htmlLabels),{labelStyles:i}=lx(e);e.labelStyle=i;let n=await kS(t,e.label,{style:e.labelStyle,useHtmlLabels:r,addSvgBackground:!0,isNode:!1});y.info("abc82",e,e.labelType);let a=t.insert("g").attr("class","edgeLabel"),o=a.insert("g").attr("class","label").attr("data-id",e.id);o.node().appendChild(n);let s,l=n.getBBox();if(r){let t=n.children[0],e=Ke(n);l=t.getBoundingClientRect(),e.attr("width",l.width),e.attr("height",l.height)}if(o.attr("transform","translate("+-l.width/2+", "+-l.height/2+")"),XB.set(e.id,a),e.width=l.width,e.height=l.height,e.startLabelLeft){let r=await IT(e.startLabelLeft,KB(e.labelStyle)),i=t.insert("g").attr("class","edgeTerminals"),n=i.insert("g").attr("class","inner");s=n.node().appendChild(r);let a=r.getBBox();n.attr("transform","translate("+-a.width/2+", "+-a.height/2+")"),ZB.get(e.id)||ZB.set(e.id,{}),ZB.get(e.id).startLeft=i,tA(s,e.startLabelLeft)}if(e.startLabelRight){let r=await IT(e.startLabelRight,KB(e.labelStyle)),i=t.insert("g").attr("class","edgeTerminals"),n=i.insert("g").attr("class","inner");s=i.node().appendChild(r),n.node().appendChild(r);let a=r.getBBox();n.attr("transform","translate("+-a.width/2+", "+-a.height/2+")"),ZB.get(e.id)||ZB.set(e.id,{}),ZB.get(e.id).startRight=i,tA(s,e.startLabelRight)}if(e.endLabelLeft){let r=await IT(e.endLabelLeft,KB(e.labelStyle)),i=t.insert("g").attr("class","edgeTerminals"),n=i.insert("g").attr("class","inner");s=n.node().appendChild(r);let a=r.getBBox();n.attr("transform","translate("+-a.width/2+", "+-a.height/2+")"),i.node().appendChild(r),ZB.get(e.id)||ZB.set(e.id,{}),ZB.get(e.id).endLeft=i,tA(s,e.endLabelLeft)}if(e.endLabelRight){let r=await IT(e.endLabelRight,KB(e.labelStyle)),i=t.insert("g").attr("class","edgeTerminals"),n=i.insert("g").attr("class","inner");s=n.node().appendChild(r);let a=r.getBBox();n.attr("transform","translate("+-a.width/2+", "+-a.height/2+")"),i.node().appendChild(r),ZB.get(e.id)||ZB.set(e.id,{}),ZB.get(e.id).endRight=i,tA(s,e.endLabelRight)}return n},"insertEdgeLabel");function tA(t,e){qf().flowchart.htmlLabels&&t&&(t.style.width=9*e.length+"px",t.style.height="12px")}s(tA,"setTerminalWidth");var eA=s((t,e)=>{y.debug("Moving label abc88 ",t.id,t.label,XB.get(t.id),e);let r=e.updatedPath?e.updatedPath:e.originalPath,i=qf(),{subGraphTitleTotalMargin:n}=ix(i);if(t.label){let i=XB.get(t.id),a=t.x,o=t.y;if(r){let i=n_.calcLabelPosition(r);y.debug("Moving label "+t.label+" from (",a,",",o,") to (",i.x,",",i.y,") abc88"),e.updatedPath&&(a=i.x,o=i.y)}i.attr("transform",`translate(${a}, ${o+n/2})`)}if(t.startLabelLeft){let e=ZB.get(t.id).startLeft,i=t.x,n=t.y;if(r){let e=n_.calcTerminalLabelPosition(t.arrowTypeStart?10:0,"start_left",r);i=e.x,n=e.y}e.attr("transform",`translate(${i}, ${n})`)}if(t.startLabelRight){let e=ZB.get(t.id).startRight,i=t.x,n=t.y;if(r){let e=n_.calcTerminalLabelPosition(t.arrowTypeStart?10:0,"start_right",r);i=e.x,n=e.y}e.attr("transform",`translate(${i}, ${n})`)}if(t.endLabelLeft){let e=ZB.get(t.id).endLeft,i=t.x,n=t.y;if(r){let e=n_.calcTerminalLabelPosition(t.arrowTypeEnd?10:0,"end_left",r);i=e.x,n=e.y}e.attr("transform",`translate(${i}, ${n})`)}if(t.endLabelRight){let e=ZB.get(t.id).endRight,i=t.x,n=t.y;if(r){let e=n_.calcTerminalLabelPosition(t.arrowTypeEnd?10:0,"end_right",r);i=e.x,n=e.y}e.attr("transform",`translate(${i}, ${n})`)}},"positionEdgeLabel"),rA=s((t,e)=>{let r=t.x,i=t.y,n=Math.abs(e.x-r),a=Math.abs(e.y-i),o=t.width/2,s=t.height/2;return n>=o||a>=s},"outsideNode"),iA=s((t,e,r)=>{y.debug(`intersection calc abc89:\n  outsidePoint: ${JSON.stringify(e)}\n  insidePoint : ${JSON.stringify(r)}\n  node        : x:${t.x} y:${t.y} w:${t.width} h:${t.height}`);let i=t.x,n=t.y,a=Math.abs(i-r.x),o=t.width/2,s=r.x<e.x?o-a:o+a,l=t.height/2,h=Math.abs(e.y-r.y),c=Math.abs(e.x-r.x);if(Math.abs(n-e.y)*o>Math.abs(i-e.x)*l){let t=r.y<e.y?e.y-l-n:n-l-e.y;s=c*t/h;let i={x:r.x<e.x?r.x+s:r.x-c+s,y:r.y<e.y?r.y+h-t:r.y-h+t};return 0===s&&(i.x=e.x,i.y=e.y),0===c&&(i.x=e.x),0===h&&(i.y=e.y),y.debug(`abc89 top/bottom calc, Q ${h}, q ${t}, R ${c}, r ${s}`,i),i}{s=r.x<e.x?e.x-o-i:i-o-e.x;let t=h*s/c,n=r.x<e.x?r.x+c-s:r.x-c+s,a=r.y<e.y?r.y+t:r.y-t;return y.debug(`sides calc abc89, Q ${h}, q ${t}, R ${c}, r ${s}`,{_x:n,_y:a}),0===s&&(n=e.x,a=e.y),0===c&&(n=e.x),0===h&&(a=e.y),{x:n,y:a}}},"intersection"),nA=s((t,e)=>{y.warn("abc88 cutPathAtIntersect",t,e);let r=[],i=t[0],n=!1;return t.forEach(t=>{if(y.info("abc88 checking point",t,e),rA(e,t)||n)y.warn("abc88 outside",t,i),i=t,n||r.push(t);else{let a=iA(e,i,t);y.debug("abc88 inside",t,i,a),y.debug("abc88 intersection",a,e);let o=!1;r.forEach(t=>{o=o||t.x===a.x&&t.y===a.y}),r.some(t=>t.x===a.x&&t.y===a.y)?y.warn("abc88 no intersect",a,r):r.push(a),n=!0}}),y.debug("returning points",r),r},"cutPathAtIntersect");function aA(t){let e=[],r=[];for(let i=1;i<t.length-1;i++){let n=t[i-1],a=t[i],o=t[i+1];(n.x===a.x&&a.y===o.y&&Math.abs(a.x-o.x)>5&&Math.abs(a.y-n.y)>5||n.y===a.y&&a.x===o.x&&Math.abs(a.x-n.x)>5&&Math.abs(a.y-o.y)>5)&&(e.push(a),r.push(i))}return{cornerPoints:e,cornerPointPositions:r}}s(aA,"extractCornerPoints");var oA=s(function(t,e,r){let i=e.x-t.x,n=e.y-t.y,a=r/Math.sqrt(i*i+n*n);return{x:e.x-a*i,y:e.y-a*n}},"findAdjacentPoint"),sA=s(function(t){let{cornerPointPositions:e}=aA(t),r=[];for(let i=0;i<t.length;i++)if(e.includes(i)){let e=t[i-1],n=t[i+1],a=t[i],o=oA(e,a,5),s=oA(n,a,5),l=s.x-o.x,h=s.y-o.y;r.push(o);let c=2*Math.sqrt(2),u={x:a.x,y:a.y};if(Math.abs(n.x-e.x)>10&&Math.abs(n.y-e.y)>=10){y.debug("Corner point fixing",Math.abs(n.x-e.x),Math.abs(n.y-e.y));let t=5;u=a.x===o.x?{x:l<0?o.x-t+c:o.x+t-c,y:h<0?o.y-c:o.y+c}:{x:l<0?o.x-c:o.x+c,y:h<0?o.y-t+c:o.y+t-c}}else y.debug("Corner point skipping fixing",Math.abs(n.x-e.x),Math.abs(n.y-e.y));r.push(u,s)}else r.push(t[i]);return r},"fixCorners"),lA=s((t,e,r)=>{let i=t-e-r,n=Math.floor(i/4);return`0 ${e} ${Array(n).fill("2 2").join(" ")} ${r}`},"generateDashArray"),hA=s(function(t,e,r,i,n,a,o,s=!1){let{handDrawnSeed:l}=qf(),h=e.points,c=!1,u=n;var d=a;let p=[];for(let t in e.cssCompiledStyles)sx(t)||p.push(e.cssCompiledStyles[t]);y.debug("UIO intersect check",e.points,d.x,u.x),d.intersect&&u.intersect&&!s&&(h=h.slice(1,e.points.length-1),h.unshift(u.intersect(h[0])),y.debug("Last point UIO",e.start,"--\x3e",e.end,h[h.length-1],d,d.intersect(h[h.length-1])),h.push(d.intersect(h[h.length-1])));let f=btoa(JSON.stringify(h));e.toCluster&&(y.info("to cluster abc88",r.get(e.toCluster)),h=nA(e.points,r.get(e.toCluster).node),c=!0),e.fromCluster&&(y.debug("from cluster abc88",r.get(e.fromCluster),JSON.stringify(h,null,2)),h=nA(h.reverse(),r.get(e.fromCluster).node).reverse(),c=!0);let g=h.filter(t=>!Number.isNaN(t.y));g=sA(g);let m=ll;switch(m=Xs,e.curve){case"linear":m=Xs;break;case"basis":default:m=ll;break;case"cardinal":m=xl;break;case"bumpX":m=nl;break;case"bumpY":m=al;break;case"catmullRom":m=Sl;break;case"monotoneX":m=Pl;break;case"monotoneY":m=zl;break;case"natural":m=Wl;break;case"step":m=Ul;break;case"stepAfter":m=Vl;break;case"stepBefore":m=Yl}let x,{x:b,y:k}=rx(e),C=Js().x(b).y(k).curve(m);switch(e.thickness){case"normal":default:x="edge-thickness-normal";break;case"thick":x="edge-thickness-thick";break;case"invisible":x="edge-thickness-invisible"}switch(e.pattern){case"solid":default:x+=" edge-pattern-solid";break;case"dotted":x+=" edge-pattern-dotted";break;case"dashed":x+=" edge-pattern-dashed"}let w,_="rounded"===e.curve?cA(dA(g,e),5):C(g),v=Array.isArray(e.style)?e.style:[e.style],S=v.find(t=>t?.startsWith("stroke:")),T=!1;if("handDrawn"===e.look){let r=LT.svg(t);Object.assign([],g),x+=" transition",w=Ke(r.path(_,{roughness:.3,seed:l})).select("path").attr("id",e.id).attr("class"," "+x+(e.classes?" "+e.classes:"")).attr("style",v?v.reduce((t,e)=>t+";"+e,""):"");let i=w.attr("d");w.attr("d",i),t.node().appendChild(w.node())}else{let r=p.join(";"),i=v?v.reduce((t,e)=>t+e+";",""):"",n="";e.animate&&(n=" edge-animation-fast"),e.animation&&(n=" edge-animation-"+e.animation);let a=(r?r+";"+i+";":i)+";"+(v?v.reduce((t,e)=>t+";"+e,""):"");w=t.append("path").attr("d",_).attr("id",e.id).attr("class"," "+x+(e.classes?" "+e.classes:"")+(n??"")).attr("style",a),S=a.match(/stroke:([^;]+)/)?.[1],T=!0===e.animate||!!e.animation||r.includes("animation");let o=w.node(),s="function"==typeof o.getTotalLength?o.getTotalLength():0,l=Jm[e.arrowTypeStart]||0,h=Jm[e.arrowTypeEnd]||0;if("neo"===e.look&&!T){let t=`stroke-dasharray: ${"dotted"===e.pattern||"dashed"===e.pattern?lA(s,l,h):`0 ${l} ${s-l-h} ${h}`}; stroke-dashoffset: 0;`;w.attr("style",t+w.attr("style"))}}w.attr("data-edge",!0),w.attr("data-et","edge"),w.attr("data-id",e.id),w.attr("data-points",f),e.showPoints&&g.forEach(e=>{t.append("circle").style("stroke","red").style("fill","red").attr("r",1).attr("cx",e.x).attr("cy",e.y)});let M="";(qf().flowchart.arrowMarkerAbsolute||qf().state.arrowMarkerAbsolute)&&(M=window.location.protocol+"//"+window.location.host+window.location.pathname+window.location.search,M=M.replace(/\(/g,"\\(").replace(/\)/g,"\\)")),y.info("arrowTypeStart",e.arrowTypeStart),y.info("arrowTypeEnd",e.arrowTypeEnd),YB(w,e,M,o,i,S);let B=h[Math.floor(h.length/2)];n_.isLabelCoordinateInPath(B,w.attr("d"))||(c=!0);let A={};return c&&(A.updatedPath=h),A.originalPath=e.points,A},"insertEdge");function cA(t,e){if(t.length<2)return"";let r="",i=t.length,n=1e-5;for(let a=0;a<i;a++){let o=t[a],s=t[a-1],l=t[a+1];if(0===a)r+=`M${o.x},${o.y}`;else if(a===i-1)r+=`L${o.x},${o.y}`;else{let t=o.x-s.x,i=o.y-s.y,a=l.x-o.x,h=l.y-o.y,c=Math.hypot(t,i),u=Math.hypot(a,h);if(c<n||u<n){r+=`L${o.x},${o.y}`;continue}let d=t/c,p=i/c,f=a/u,g=h/u,y=d*f+p*g,m=Math.max(-1,Math.min(1,y)),x=Math.acos(m);if(x<n||Math.abs(Math.PI-x)<n){r+=`L${o.x},${o.y}`;continue}let b=Math.min(e/Math.sin(x/2),c/2,u/2),k=o.x-d*b,C=o.y-p*b,w=o.x+f*b,_=o.y+g*b;r+=`L${k},${C}`,r+=`Q${o.x},${o.y} ${w},${_}`}}return r}function uA(t,e){if(!t||!e)return{angle:0,deltaX:0,deltaY:0};let r=e.x-t.x,i=e.y-t.y;return{angle:Math.atan2(i,r),deltaX:r,deltaY:i}}function dA(t,e){let r=t.map(t=>({...t}));if(t.length>=2&&Km[e.arrowTypeStart]){let i=Km[e.arrowTypeStart],n=t[0],a=t[1],{angle:o}=uA(n,a),s=i*Math.cos(o),l=i*Math.sin(o);r[0].x=n.x+s,r[0].y=n.y+l}let i=t.length;if(i>=2&&Km[e.arrowTypeEnd]){let n=Km[e.arrowTypeEnd],a=t[i-1],o=t[i-2],{angle:s}=uA(o,a),l=n*Math.cos(s),h=n*Math.sin(s);r[i-1].x=a.x-l,r[i-1].y=a.y-h}return r}s(cA,"generateRoundedPath"),s(uA,"calculateDeltaAndAngle"),s(dA,"applyMarkerOffsetsToPoints");var pA=s((t,e,r,i)=>{e.forEach(e=>{AA[e](t,r,i)})},"insertMarkers"),fA=s((t,e,r)=>{y.trace("Making markers for ",r),t.append("defs").append("marker").attr("id",r+"_"+e+"-extensionStart").attr("class","marker extension "+e).attr("refX",18).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("path").attr("d","M 1,7 L18,13 V 1 Z"),t.append("defs").append("marker").attr("id",r+"_"+e+"-extensionEnd").attr("class","marker extension "+e).attr("refX",1).attr("refY",7).attr("markerWidth",20).attr("markerHeight",28).attr("orient","auto").append("path").attr("d","M 1,1 V 13 L18,7 Z")},"extension"),gA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-compositionStart").attr("class","marker composition "+e).attr("refX",18).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("path").attr("d","M 18,7 L9,13 L1,7 L9,1 Z"),t.append("defs").append("marker").attr("id",r+"_"+e+"-compositionEnd").attr("class","marker composition "+e).attr("refX",1).attr("refY",7).attr("markerWidth",20).attr("markerHeight",28).attr("orient","auto").append("path").attr("d","M 18,7 L9,13 L1,7 L9,1 Z")},"composition"),yA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-aggregationStart").attr("class","marker aggregation "+e).attr("refX",18).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("path").attr("d","M 18,7 L9,13 L1,7 L9,1 Z"),t.append("defs").append("marker").attr("id",r+"_"+e+"-aggregationEnd").attr("class","marker aggregation "+e).attr("refX",1).attr("refY",7).attr("markerWidth",20).attr("markerHeight",28).attr("orient","auto").append("path").attr("d","M 18,7 L9,13 L1,7 L9,1 Z")},"aggregation"),mA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-dependencyStart").attr("class","marker dependency "+e).attr("refX",6).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("path").attr("d","M 5,7 L9,13 L1,7 L9,1 Z"),t.append("defs").append("marker").attr("id",r+"_"+e+"-dependencyEnd").attr("class","marker dependency "+e).attr("refX",13).attr("refY",7).attr("markerWidth",20).attr("markerHeight",28).attr("orient","auto").append("path").attr("d","M 18,7 L9,13 L14,7 L9,1 Z")},"dependency"),xA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-lollipopStart").attr("class","marker lollipop "+e).attr("refX",13).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("circle").attr("stroke","black").attr("fill","transparent").attr("cx",7).attr("cy",7).attr("r",6),t.append("defs").append("marker").attr("id",r+"_"+e+"-lollipopEnd").attr("class","marker lollipop "+e).attr("refX",1).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("circle").attr("stroke","black").attr("fill","transparent").attr("cx",7).attr("cy",7).attr("r",6)},"lollipop"),bA=s((t,e,r)=>{t.append("marker").attr("id",r+"_"+e+"-pointEnd").attr("class","marker "+e).attr("viewBox","0 0 10 10").attr("refX",5).attr("refY",5).attr("markerUnits","userSpaceOnUse").attr("markerWidth",8).attr("markerHeight",8).attr("orient","auto").append("path").attr("d","M 0 0 L 10 5 L 0 10 z").attr("class","arrowMarkerPath").style("stroke-width",1).style("stroke-dasharray","1,0"),t.append("marker").attr("id",r+"_"+e+"-pointStart").attr("class","marker "+e).attr("viewBox","0 0 10 10").attr("refX",4.5).attr("refY",5).attr("markerUnits","userSpaceOnUse").attr("markerWidth",8).attr("markerHeight",8).attr("orient","auto").append("path").attr("d","M 0 5 L 10 10 L 10 0 z").attr("class","arrowMarkerPath").style("stroke-width",1).style("stroke-dasharray","1,0")},"point"),kA=s((t,e,r)=>{t.append("marker").attr("id",r+"_"+e+"-circleEnd").attr("class","marker "+e).attr("viewBox","0 0 10 10").attr("refX",11).attr("refY",5).attr("markerUnits","userSpaceOnUse").attr("markerWidth",11).attr("markerHeight",11).attr("orient","auto").append("circle").attr("cx","5").attr("cy","5").attr("r","5").attr("class","arrowMarkerPath").style("stroke-width",1).style("stroke-dasharray","1,0"),t.append("marker").attr("id",r+"_"+e+"-circleStart").attr("class","marker "+e).attr("viewBox","0 0 10 10").attr("refX",-1).attr("refY",5).attr("markerUnits","userSpaceOnUse").attr("markerWidth",11).attr("markerHeight",11).attr("orient","auto").append("circle").attr("cx","5").attr("cy","5").attr("r","5").attr("class","arrowMarkerPath").style("stroke-width",1).style("stroke-dasharray","1,0")},"circle"),CA=s((t,e,r)=>{t.append("marker").attr("id",r+"_"+e+"-crossEnd").attr("class","marker cross "+e).attr("viewBox","0 0 11 11").attr("refX",12).attr("refY",5.2).attr("markerUnits","userSpaceOnUse").attr("markerWidth",11).attr("markerHeight",11).attr("orient","auto").append("path").attr("d","M 1,1 l 9,9 M 10,1 l -9,9").attr("class","arrowMarkerPath").style("stroke-width",2).style("stroke-dasharray","1,0"),t.append("marker").attr("id",r+"_"+e+"-crossStart").attr("class","marker cross "+e).attr("viewBox","0 0 11 11").attr("refX",-1).attr("refY",5.2).attr("markerUnits","userSpaceOnUse").attr("markerWidth",11).attr("markerHeight",11).attr("orient","auto").append("path").attr("d","M 1,1 l 9,9 M 10,1 l -9,9").attr("class","arrowMarkerPath").style("stroke-width",2).style("stroke-dasharray","1,0")},"cross"),wA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-barbEnd").attr("refX",19).attr("refY",7).attr("markerWidth",20).attr("markerHeight",14).attr("markerUnits","userSpaceOnUse").attr("orient","auto").append("path").attr("d","M 19,7 L9,13 L14,7 L9,1 Z")},"barb"),_A=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-onlyOneStart").attr("class","marker onlyOne "+e).attr("refX",0).attr("refY",9).attr("markerWidth",18).attr("markerHeight",18).attr("orient","auto").append("path").attr("d","M9,0 L9,18 M15,0 L15,18"),t.append("defs").append("marker").attr("id",r+"_"+e+"-onlyOneEnd").attr("class","marker onlyOne "+e).attr("refX",18).attr("refY",9).attr("markerWidth",18).attr("markerHeight",18).attr("orient","auto").append("path").attr("d","M3,0 L3,18 M9,0 L9,18")},"only_one"),vA=s((t,e,r)=>{let i=t.append("defs").append("marker").attr("id",r+"_"+e+"-zeroOrOneStart").attr("class","marker zeroOrOne "+e).attr("refX",0).attr("refY",9).attr("markerWidth",30).attr("markerHeight",18).attr("orient","auto");i.append("circle").attr("fill","white").attr("cx",21).attr("cy",9).attr("r",6),i.append("path").attr("d","M9,0 L9,18");let n=t.append("defs").append("marker").attr("id",r+"_"+e+"-zeroOrOneEnd").attr("class","marker zeroOrOne "+e).attr("refX",30).attr("refY",9).attr("markerWidth",30).attr("markerHeight",18).attr("orient","auto");n.append("circle").attr("fill","white").attr("cx",9).attr("cy",9).attr("r",6),n.append("path").attr("d","M21,0 L21,18")},"zero_or_one"),SA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-oneOrMoreStart").attr("class","marker oneOrMore "+e).attr("refX",18).attr("refY",18).attr("markerWidth",45).attr("markerHeight",36).attr("orient","auto").append("path").attr("d","M0,18 Q 18,0 36,18 Q 18,36 0,18 M42,9 L42,27"),t.append("defs").append("marker").attr("id",r+"_"+e+"-oneOrMoreEnd").attr("class","marker oneOrMore "+e).attr("refX",27).attr("refY",18).attr("markerWidth",45).attr("markerHeight",36).attr("orient","auto").append("path").attr("d","M3,9 L3,27 M9,18 Q27,0 45,18 Q27,36 9,18")},"one_or_more"),TA=s((t,e,r)=>{let i=t.append("defs").append("marker").attr("id",r+"_"+e+"-zeroOrMoreStart").attr("class","marker zeroOrMore "+e).attr("refX",18).attr("refY",18).attr("markerWidth",57).attr("markerHeight",36).attr("orient","auto");i.append("circle").attr("fill","white").attr("cx",48).attr("cy",18).attr("r",6),i.append("path").attr("d","M0,18 Q18,0 36,18 Q18,36 0,18");let n=t.append("defs").append("marker").attr("id",r+"_"+e+"-zeroOrMoreEnd").attr("class","marker zeroOrMore "+e).attr("refX",39).attr("refY",18).attr("markerWidth",57).attr("markerHeight",36).attr("orient","auto");n.append("circle").attr("fill","white").attr("cx",9).attr("cy",18).attr("r",6),n.append("path").attr("d","M21,18 Q39,0 57,18 Q39,36 21,18")},"zero_or_more"),MA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-requirement_arrowEnd").attr("refX",20).attr("refY",10).attr("markerWidth",20).attr("markerHeight",20).attr("orient","auto").append("path").attr("d","M0,0\n      L20,10\n      M20,10\n      L0,20")},"requirement_arrow"),BA=s((t,e,r)=>{let i=t.append("defs").append("marker").attr("id",r+"_"+e+"-requirement_containsStart").attr("refX",0).attr("refY",10).attr("markerWidth",20).attr("markerHeight",20).attr("orient","auto").append("g");i.append("circle").attr("cx",10).attr("cy",10).attr("r",9).attr("fill","none"),i.append("line").attr("x1",1).attr("x2",19).attr("y1",10).attr("y2",10),i.append("line").attr("y1",1).attr("y2",19).attr("x1",10).attr("x2",10)},"requirement_contains"),AA={extension:fA,composition:gA,aggregation:yA,dependency:mA,lollipop:xA,point:bA,circle:kA,cross:CA,barb:wA,only_one:_A,zero_or_one:vA,one_or_more:SA,zero_or_more:TA,requirement_arrow:MA,requirement_contains:BA},LA=pA,FA={common:xf,getConfig:Bd,insertCluster:UT,insertEdge:hA,insertEdgeLabel:JB,insertMarkers:LA,insertNode:jB,interpolateToCurve:Aw,labelHelper:CS,log:y,positionEdgeLabel:eA},$A={},EA=s(t=>{for(let e of t)$A[e.name]=e},"registerLayoutLoaders");s(()=>{EA([{name:"dagre",loader:s(async()=>await import("./dagre-X5LCLMGV-CeNFLozK.js"),"loader")},{name:"cose-bilkent",loader:s(async()=>await import("./cose-bilkent-AZ5BDB2T-t1iRvMQe.js"),"loader")}])},"registerDefaultLayoutLoaders")();var DA=s(async(t,e)=>{if(!(t.layoutAlgorithm in $A))throw new Error(`Unknown layout algorithm: ${t.layoutAlgorithm}`);let r=$A[t.layoutAlgorithm];return(await r.loader()).render(t,e,FA,{algorithm:r.algorithm})},"render"),OA=s((t="",{fallback:e="dagre"}={})=>{if(t in $A)return t;if(e in $A)return y.warn(`Layout algorithm ${t} is not registered. Using ${e} as fallback.`),e;throw new Error(`Both layout algorithms ${t} and ${e} are not registered.`)},"getRegisteredLayoutAlgorithm"),IA=Dk(Object.keys,Object),NA=Object.prototype.hasOwnProperty;function RA(t){if(!Rk(t))return IA(t);var e=[];for(var r in Object(t))NA.call(t,r)&&"constructor"!=r&&e.push(r);return e}s(RA,"baseKeys");var PA=RA,zA=Qx(gx,"DataView"),qA=Qx(gx,"Promise"),jA=Qx(gx,"Set"),WA=Qx(gx,"WeakMap"),HA="[object Map]",UA="[object Promise]",YA="[object Set]",VA="[object WeakMap]",GA="[object DataView]",XA=Px(zA),ZA=Px(Lb),QA=Px(qA),KA=Px(jA),JA=Px(WA),tL=Bx;(zA&&tL(new zA(new ArrayBuffer(1)))!=GA||Lb&&tL(new Lb)!=HA||qA&&tL(qA.resolve())!=UA||jA&&tL(new jA)!=YA||WA&&tL(new WA)!=VA)&&(tL=s(function(t){var e=Bx(t),r="[object Object]"==e?t.constructor:void 0,i=r?Px(r):"";if(i)switch(i){case XA:return GA;case ZA:return HA;case QA:return UA;case KA:return YA;case JA:return VA}return e},"getTag"));var eL=tL,rL=Object.prototype.hasOwnProperty;function iL(t){if(null==t)return!0;if(tC(t)&&(Zk(t)||"string"==typeof t||"function"==typeof t.splice||lC(t)||TC(t)||Xk(t)))return!t.length;var e=eL(t);if("[object Map]"==e||"[object Set]"==e)return!t.size;if(Rk(t))return!PA(t).length;for(var r in t)if(rL.call(t,r))return!1;return!0}s(iL,"isEmpty");var nL=iL,aL=s(t=>/^\s*C4Context|C4Container|C4Component|C4Dynamic|C4Deployment/.test(t),"detector"),oL=s(async()=>{let{diagram:t}=await import("./c4Diagram-Q5SP5FFD-C-qpa2nn.js");return{id:"c4",diagram:t}},"loader"),sL={id:"c4",detector:aL,loader:oL},lL="flowchart",hL=s((t,e)=>"dagre-wrapper"!==e?.flowchart?.defaultRenderer&&"elk"!==e?.flowchart?.defaultRenderer&&/^\s*graph/.test(t),"detector"),cL=s(async()=>{let{diagram:t}=await import("./flowDiagram-UML6HZQP-B86KOrdn.js");return{id:lL,diagram:t}},"loader"),uL={id:lL,detector:hL,loader:cL},dL="flowchart-v2",pL=s((t,e)=>"dagre-d3"!==e?.flowchart?.defaultRenderer&&("elk"===e?.flowchart?.defaultRenderer&&(e.layout="elk"),!(!/^\s*graph/.test(t)||"dagre-wrapper"!==e?.flowchart?.defaultRenderer)||/^\s*flowchart/.test(t)),"detector"),fL=s(async()=>{let{diagram:t}=await import("./flowDiagram-UML6HZQP-B86KOrdn.js");return{id:dL,diagram:t}},"loader"),gL={id:dL,detector:pL,loader:fL},yL=s(t=>/^\s*erDiagram/.test(t),"detector"),mL=s(async()=>{let{diagram:t}=await import("./erDiagram-MBDK6S7D-BtpSjsbV.js");return{id:"er",diagram:t}},"loader"),xL={id:"er",detector:yL,loader:mL},bL="gitGraph",kL=s(t=>/^\s*gitGraph/.test(t),"detector"),CL=s(async()=>{let{diagram:t}=await import("./gitGraphDiagram-JCGM6PWI-DUSWEYAD.js");return{id:bL,diagram:t}},"loader"),wL={id:bL,detector:kL,loader:CL},_L="gantt",vL=s(t=>/^\s*gantt/.test(t),"detector"),SL=s(async()=>{let{diagram:t}=await import("./ganttDiagram-SAESIEWH-BJSsx4M8.js");return{id:_L,diagram:t}},"loader"),TL={id:_L,detector:vL,loader:SL},ML="info",BL=s(t=>/^\s*info/.test(t),"detector"),AL=s(async()=>{let{diagram:t}=await import("./infoDiagram-GKI3LBYJ-ryZ0ChiZ.js");return{id:ML,diagram:t}},"loader"),LL={id:ML,detector:BL,loader:AL},FL=s(t=>/^\s*pie/.test(t),"detector"),$L=s(async()=>{let{diagram:t}=await import("./pieDiagram-QB62DFGK-mcumhtSU.js");return{id:"pie",diagram:t}},"loader"),EL={id:"pie",detector:FL,loader:$L},DL="quadrantChart",OL=s(t=>/^\s*quadrantChart/.test(t),"detector"),IL=s(async()=>{let{diagram:t}=await import("./quadrantDiagram-AGVETKZM-Adr2_gjR.js");return{id:DL,diagram:t}},"loader"),NL={id:DL,detector:OL,loader:IL},RL="xychart",PL=s(t=>/^\s*xychart(-beta)?/.test(t),"detector"),zL=s(async()=>{let{diagram:t}=await import("./xychartDiagram-6J6QOAP6-2Bu-TrRw.js");return{id:RL,diagram:t}},"loader"),qL={id:RL,detector:PL,loader:zL},jL="requirement",WL=s(t=>/^\s*requirement(Diagram)?/.test(t),"detector"),HL=s(async()=>{let{diagram:t}=await import("./requirementDiagram-BJFPASL3-ColPSlkw.js");return{id:jL,diagram:t}},"loader"),UL={id:jL,detector:WL,loader:HL},YL="sequence",VL=s(t=>/^\s*sequenceDiagram/.test(t),"detector"),GL=s(async()=>{let{diagram:t}=await import("./sequenceDiagram-W4XLKSBU-BGSeHn2k.js");return{id:YL,diagram:t}},"loader"),XL={id:YL,detector:VL,loader:GL},ZL="class",QL=s((t,e)=>"dagre-wrapper"!==e?.class?.defaultRenderer&&/^\s*classDiagram/.test(t),"detector"),KL=s(async()=>{let{diagram:t}=await import("./classDiagram-FKO7XAE5-BoSrpwgW.js");return{id:ZL,diagram:t}},"loader"),JL={id:ZL,detector:QL,loader:KL},tF="classDiagram",eF=s((t,e)=>!(!/^\s*classDiagram/.test(t)||"dagre-wrapper"!==e?.class?.defaultRenderer)||/^\s*classDiagram-v2/.test(t),"detector"),rF=s(async()=>{let{diagram:t}=await import("./classDiagram-v2-XZHHGUJO-BoSrpwgW.js");return{id:tF,diagram:t}},"loader"),iF={id:tF,detector:eF,loader:rF},nF="state",aF=s((t,e)=>"dagre-wrapper"!==e?.state?.defaultRenderer&&/^\s*stateDiagram/.test(t),"detector"),oF=s(async()=>{let{diagram:t}=await import("./stateDiagram-ZFDIVMDF-UXJc7GMs.js");return{id:nF,diagram:t}},"loader"),sF={id:nF,detector:aF,loader:oF},lF="stateDiagram",hF=s((t,e)=>!!(/^\s*stateDiagram-v2/.test(t)||/^\s*stateDiagram/.test(t)&&"dagre-wrapper"===e?.state?.defaultRenderer),"detector"),cF=s(async()=>{let{diagram:t}=await import("./stateDiagram-v2-GQU47BET-Dv3HW1hA.js");return{id:lF,diagram:t}},"loader"),uF={id:lF,detector:hF,loader:cF},dF="journey",pF=s(t=>/^\s*journey/.test(t),"detector"),fF=s(async()=>{let{diagram:t}=await import("./journeyDiagram-E42M6OD5-PpUj7TTA.js");return{id:dF,diagram:t}},"loader"),gF={id:dF,detector:pF,loader:fF},yF=s((t,e,r)=>{y.debug("rendering svg for syntax error\n");let i=Qf(e),n=i.append("g");i.attr("viewBox","0 0 2412 512"),Cf(i,100,512,!0),n.append("path").attr("class","error-icon").attr("d","m411.313,123.313c6.25-6.25 6.25-16.375 0-22.625s-16.375-6.25-22.625,0l-32,32-9.375,9.375-20.688-20.688c-12.484-12.5-32.766-12.5-45.25,0l-16,16c-1.261,1.261-2.304,2.648-3.31,4.051-21.739-8.561-45.324-13.426-70.065-13.426-105.867,0-192,86.133-192,192s86.133,192 192,192 192-86.133 192-192c0-24.741-4.864-48.327-13.426-70.065 1.402-1.007 2.79-2.049 4.051-3.31l16-16c12.5-12.492 12.5-32.758 0-45.25l-20.688-20.688 9.375-9.375 32.001-31.999zm-219.313,100.687c-52.938,0-96,43.063-96,96 0,8.836-7.164,16-16,16s-16-7.164-16-16c0-70.578 57.422-128 128-128 8.836,0 16,7.164 16,16s-7.164,16-16,16z"),n.append("path").attr("class","error-icon").attr("d","m459.02,148.98c-6.25-6.25-16.375-6.25-22.625,0s-6.25,16.375 0,22.625l16,16c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688 6.25-6.25 6.25-16.375 0-22.625l-16.001-16z"),n.append("path").attr("class","error-icon").attr("d","m340.395,75.605c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688 6.25-6.25 6.25-16.375 0-22.625l-16-16c-6.25-6.25-16.375-6.25-22.625,0s-6.25,16.375 0,22.625l15.999,16z"),n.append("path").attr("class","error-icon").attr("d","m400,64c8.844,0 16-7.164 16-16v-32c0-8.836-7.156-16-16-16-8.844,0-16,7.164-16,16v32c0,8.836 7.156,16 16,16z"),n.append("path").attr("class","error-icon").attr("d","m496,96.586h-32c-8.844,0-16,7.164-16,16 0,8.836 7.156,16 16,16h32c8.844,0 16-7.164 16-16 0-8.836-7.156-16-16-16z"),n.append("path").attr("class","error-icon").attr("d","m436.98,75.605c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688l32-32c6.25-6.25 6.25-16.375 0-22.625s-16.375-6.25-22.625,0l-32,32c-6.251,6.25-6.251,16.375-0.001,22.625z"),n.append("text").attr("class","error-text").attr("x",1440).attr("y",250).attr("font-size","150px").style("text-anchor","middle").text("Syntax error in text"),n.append("text").attr("class","error-text").attr("x",1250).attr("y",400).attr("font-size","100px").style("text-anchor","middle").text(`mermaid version ${r}`)},"draw"),mF={draw:yF},xF=mF,bF={db:{},renderer:mF,parser:{parse:s(()=>{},"parse")}},kF="flowchart-elk",CF=s((t,e={})=>!!(/^\s*flowchart-elk/.test(t)||/^\s*(flowchart|graph)/.test(t)&&"elk"===e?.flowchart?.defaultRenderer)&&(e.layout="elk",!0),"detector"),wF=s(async()=>{let{diagram:t}=await import("./flowDiagram-UML6HZQP-B86KOrdn.js");return{id:kF,diagram:t}},"loader"),_F={id:kF,detector:CF,loader:wF},vF="timeline",SF=s(t=>/^\s*timeline/.test(t),"detector"),TF=s(async()=>{let{diagram:t}=await import("./timeline-definition-DZOEFOHF-1rLOPiH3.js");return{id:vF,diagram:t}},"loader"),MF={id:vF,detector:SF,loader:TF},BF="mindmap",AF=s(t=>/^\s*mindmap/.test(t),"detector"),LF=s(async()=>{let{diagram:t}=await import("./mindmap-definition-ZYHNXUZP-sOG1CgBy.js");return{id:BF,diagram:t}},"loader"),FF={id:BF,detector:AF,loader:LF},$F="kanban",EF=s(t=>/^\s*kanban/.test(t),"detector"),DF=s(async()=>{let{diagram:t}=await import("./kanban-definition-D5DEDDHO-CP64diGu.js");return{id:$F,diagram:t}},"loader"),OF={id:$F,detector:EF,loader:DF},IF="sankey",NF=s(t=>/^\s*sankey(-beta)?/.test(t),"detector"),RF=s(async()=>{let{diagram:t}=await import("./sankeyDiagram-XSL23WO4-CiWF1Wt0.js");return{id:IF,diagram:t}},"loader"),PF={id:IF,detector:NF,loader:RF},zF="packet",qF=s(t=>/^\s*packet(-beta)?/.test(t),"detector"),jF=s(async()=>{let{diagram:t}=await import("./diagram-BZV4OSZQ-Dg9e8R6Y.js");return{id:zF,diagram:t}},"loader"),WF={id:zF,detector:qF,loader:jF},HF="radar",UF=s(t=>/^\s*radar-beta/.test(t),"detector"),YF=s(async()=>{let{diagram:t}=await import("./diagram-DKYQLJNW-BV5Nqf_u.js");return{id:HF,diagram:t}},"loader"),VF={id:HF,detector:UF,loader:YF},GF="block",XF=s(t=>/^\s*block(-beta)?/.test(t),"detector"),ZF=s(async()=>{let{diagram:t}=await import("./blockDiagram-BWRZOBD3-Cux5OLOg.js");return{id:GF,diagram:t}},"loader"),QF={id:GF,detector:XF,loader:ZF},KF="architecture",JF=s(t=>/^\s*architecture/.test(t),"detector"),t$=s(async()=>{let{diagram:t}=await import("./architectureDiagram-4X3Z3J56-1nSUwmjO.js");return{id:KF,diagram:t}},"loader"),e$={id:KF,detector:JF,loader:t$},r$="treemap",i$=s(t=>/^\s*treemap/.test(t),"detector"),n$=s(async()=>{let{diagram:t}=await import("./diagram-LL6QPXA2-CRMYRvhz.js");return{id:r$,diagram:t}},"loader"),a$={id:r$,detector:i$,loader:n$},o$=!1,s$=s(()=>{o$||(o$=!0,Gf("error",bF,t=>"error"===t.toLowerCase().trim()),Gf("---",{db:{clear:s(()=>{},"clear")},styles:{},renderer:{draw:s(()=>{},"draw")},parser:{parse:s(()=>{throw new Error("Diagrams beginning with --- are not valid. If you were trying to use a YAML front-matter, please ensure that you've correctly opened and closed the YAML front-matter with un-indented `---` blocks")},"parse")},init:s(()=>null,"init")},t=>t.toLowerCase().trimStart().startsWith("---")),Qc(_F,FF,e$),Qc(sL,OF,iF,JL,xL,TL,LL,EL,UL,XL,gL,uL,MF,wL,uF,sF,gF,NL,PF,WF,qL,QF,VF,a$))},"addDiagrams"),l$=s(async()=>{y.debug("Loading registered diagrams");let t=(await Promise.allSettled(Object.entries(Xc).map(async([t,{detector:e,loader:r}])=>{if(r)try{Xf(t)}catch{try{let{diagram:t,id:i}=await r();Gf(i,t,e)}catch(e){throw y.error(`Failed to load external diagram with key ${t}. Removing from detectors.`),delete Xc[t],e}}}))).filter(t=>"rejected"===t.status);if(t.length>0){y.error(`Failed to load ${t.length} external diagrams`);for(let e of t)y.error(e);throw new Error(`Failed to load ${t.length} external diagrams`)}},"loadRegisteredDiagrams"),h$="comm",c$="rule",u$="decl",d$=Math.abs,p$=String.fromCharCode;function f$(t){return t.trim()}function g$(t,e,r){return t.replace(e,r)}function y$(t,e,r){return t.indexOf(e,r)}function m$(t,e){return 0|t.charCodeAt(e)}function x$(t,e,r){return t.slice(e,r)}function b$(t){return t.length}function k$(t){return t.length}function C$(t,e){return e.push(t),t}s(f$,"trim"),s(g$,"replace"),s(y$,"indexof"),s(m$,"charat"),s(x$,"substr"),s(b$,"strlen"),s(k$,"sizeof"),s(C$,"append");var w$=1,_$=1,v$=0,S$=0,T$=0,M$="";function B$(t,e,r,i,n,a,o,s){return{value:t,root:e,parent:r,type:i,props:n,children:a,line:w$,column:_$,length:o,return:"",siblings:s}}function A$(){return T$}function L$(){return T$=S$>0?m$(M$,--S$):0,_$--,10===T$&&(_$=1,w$--),T$}function F$(){return T$=S$<v$?m$(M$,S$++):0,_$++,10===T$&&(_$=1,w$++),T$}function $$(){return m$(M$,S$)}function E$(){return S$}function D$(t,e){return x$(M$,t,e)}function O$(t){switch(t){case 0:case 9:case 10:case 13:case 32:return 5;case 33:case 43:case 44:case 47:case 62:case 64:case 126:case 59:case 123:case 125:return 4;case 58:return 3;case 34:case 39:case 40:case 91:return 2;case 41:case 93:return 1}return 0}function I$(t){return w$=_$=1,v$=b$(M$=t),S$=0,[]}function N$(t){return M$="",t}function R$(t){return f$(D$(S$-1,q$(91===t?t+2:40===t?t+1:t)))}function P$(t){for(;(T$=$$())&&T$<33;)F$();return O$(t)>2||O$(T$)>3?"":" "}function z$(t,e){for(;--e&&F$()&&!(T$<48||T$>102||T$>57&&T$<65||T$>70&&T$<97););return D$(t,E$()+(e<6&&32==$$()&&32==F$()))}function q$(t){for(;F$();)switch(T$){case t:return S$;case 34:case 39:34!==t&&39!==t&&q$(T$);break;case 40:41===t&&q$(t);break;case 92:F$()}return S$}function j$(t,e){for(;F$()&&t+T$!==57&&(t+T$!==84||47!==$$()););return"/*"+D$(e,S$-1)+"*"+p$(47===t?t:F$())}function W$(t){for(;!O$($$());)F$();return D$(t,S$)}function H$(t){return N$(U$("",null,null,null,[""],t=I$(t),0,[0],t))}function U$(t,e,r,i,n,a,o,s,l){for(var h=0,c=0,u=o,d=0,p=0,f=0,g=1,y=1,m=1,x=0,b="",k=n,C=a,w=i,_=b;y;)switch(f=x,x=F$()){case 40:if(108!=f&&58==m$(_,u-1)){-1!=y$(_+=g$(R$(x),"&","&\f"),"&\f",d$(h?s[h-1]:0))&&(m=-1);break}case 34:case 39:case 91:_+=R$(x);break;case 9:case 10:case 13:case 32:_+=P$(f);break;case 92:_+=z$(E$()-1,7);continue;case 47:switch($$()){case 42:case 47:C$(V$(j$(F$(),E$()),e,r,l),l),(5==O$(f||1)||5==O$($$()||1))&&b$(_)&&" "!==x$(_,-1,void 0)&&(_+=" ");break;default:_+="/"}break;case 123*g:s[h++]=b$(_)*m;case 125*g:case 59:case 0:switch(x){case 0:case 125:y=0;case 59+c:-1==m&&(_=g$(_,/\f/g,"")),p>0&&(b$(_)-u||0===g&&47===f)&&C$(p>32?G$(_+";",i,r,u-1,l):G$(g$(_," ","")+";",i,r,u-2,l),l);break;case 59:_+=";";default:if(C$(w=Y$(_,e,r,h,c,n,s,b,k=[],C=[],u,a),a),123===x)if(0===c)U$(_,e,w,w,k,a,u,s,C);else{switch(d){case 99:if(110===m$(_,3))break;case 108:if(97===m$(_,2))break;default:c=0;case 100:case 109:case 115:}c?U$(t,w,w,i&&C$(Y$(t,w,w,0,0,n,s,b,n,k=[],u,C),C),n,C,u,s,i?k:C):U$(_,w,w,w,[""],C,0,s,C)}}h=c=p=0,g=m=1,b=_="",u=o;break;case 58:u=1+b$(_),p=f;default:if(g<1)if(123==x)--g;else if(125==x&&0==g++&&125==L$())continue;switch(_+=p$(x),x*g){case 38:m=c>0?1:(_+="\f",-1);break;case 44:s[h++]=(b$(_)-1)*m,m=1;break;case 64:45===$$()&&(_+=R$(F$())),d=$$(),c=u=b$(b=_+=W$(E$())),x++;break;case 45:45===f&&2==b$(_)&&(g=0)}}return a}function Y$(t,e,r,i,n,a,o,s,l,h,c,u){for(var d=n-1,p=0===n?a:[""],f=k$(p),g=0,y=0,m=0;g<i;++g)for(var x=0,b=x$(t,d+1,d=d$(y=o[g])),k=t;x<f;++x)(k=f$(y>0?p[x]+" "+b:g$(b,/&\f/g,p[x])))&&(l[m++]=k);return B$(t,e,r,0===n?c$:s,l,h,c,u)}function V$(t,e,r,i){return B$(t,e,r,h$,p$(A$()),x$(t,2,-2),0,i)}function G$(t,e,r,i,n){return B$(t,e,r,u$,x$(t,0,i),x$(t,i+1,-1),i,n)}function X$(t,e){for(var r="",i=0;i<t.length;i++)r+=e(t[i],i,t,e)||"";return r}function Z$(t,e,r,i){switch(t.type){case"@layer":if(t.children.length)break;case"@import":case"@namespace":case u$:return t.return=t.return||t.value;case h$:return"";case"@keyframes":return t.return=t.value+"{"+X$(t.children,i)+"}";case c$:if(!b$(t.value=t.props.join(",")))return""}return b$(r=X$(t.children,i))?t.return=t.value+"{"+r+"}":""}s(B$,"node"),s(A$,"char"),s(L$,"prev"),s(F$,"next"),s($$,"peek"),s(E$,"caret"),s(D$,"slice"),s(O$,"token"),s(I$,"alloc"),s(N$,"dealloc"),s(R$,"delimit"),s(P$,"whitespace"),s(z$,"escaping"),s(q$,"delimiter"),s(j$,"commenter"),s(W$,"identifier"),s(H$,"compile"),s(U$,"parse"),s(Y$,"ruleset"),s(V$,"comment"),s(G$,"declaration"),s(X$,"serialize"),s(Z$,"stringify");function Q$(t,e){t.attr("role","graphics-document document"),""!==e&&t.attr("aria-roledescription",e)}function K$(t,e,r,i){if(void 0!==t.insert){if(r){let e=`chart-desc-${i}`;t.attr("aria-describedby",e),t.insert("desc",":first-child").attr("id",e).text(r)}if(e){let r=`chart-title-${i}`;t.attr("aria-labelledby",r),t.insert("title",":first-child").attr("id",r).text(e)}}}s(Q$,"setA11yDiagramInfo"),s(K$,"addSVGa11yTitleDescription");var J$=class t{constructor(t,e,r,i,n){this.type=t,this.text=e,this.db=r,this.parser=i,this.renderer=n}static{s(this,"Diagram")}static async fromText(e,r={}){let i=Bd(),n=Zc(e,i);e=a_(e)+"\n";try{Xf(n)}catch{let t=Jc(n);if(!t)throw new Gc(`Diagram ${n} not found.`);let{id:e,diagram:r}=await t();Gf(e,r)}let{db:a,parser:o,renderer:s,init:l}=Xf(n);return o.parser&&(o.parser.yy=a),a.clear?.(),l?.(i),r.title&&a.setDiagramTitle?.(r.title),await o.parse(e),new t(n,e,a,o,s)}async render(t,e){await this.renderer.draw(this.text,t,e,this)}getParser(){return this.parser}getType(){return this.type}},tE=[],eE=s(()=>{tE.forEach(t=>{t()}),tE=[]},"attachFunctions"),rE=s(t=>t.replace(/^\s*%%(?!{)[^\n]+\n?/gm,"").trimStart(),"cleanupComments");function iE(t){let e=t.match(Uc);if(!e)return{text:t,metadata:{}};let r=Qm(e[1],{schema:Zm})??{};r="object"!=typeof r||Array.isArray(r)?{}:r;let i={};return r.displayMode&&(i.displayMode=r.displayMode.toString()),r.title&&(i.title=r.title.toString()),r.config&&(i.config=r.config),{text:t.slice(e[0].length),metadata:i}}s(iE,"extractFrontMatter");var nE=s(t=>t.replace(/\r\n?/g,"\n").replace(/<(\w+)([^>]*)>/g,(t,e,r)=>"<"+e+r.replace(/="([^"]*)"/g,"='$1'")+">"),"cleanupText"),aE=s(t=>{let{text:e,metadata:r}=iE(t),{displayMode:i,title:n,config:a={}}=r;return i&&(a.gantt||(a.gantt={}),a.gantt.displayMode=i),{title:n,config:a,text:e}},"processFrontmatter"),oE=s(t=>{let e=n_.detectInit(t)??{},r=n_.detectDirective(t,"wrap");return Array.isArray(r)?e.wrap=r.some(({type:t})=>"wrap"===t):"wrap"===r?.type&&(e.wrap=!0),{text:Mw(t),directive:e}},"processDirectives");function sE(t){let e=nE(t),r=aE(e),i=oE(r.text),n=i_(r.config,i.directive);return{code:t=rE(i.text),title:r.title,config:n}}function lE(t){let e=(new TextEncoder).encode(t),r=Array.from(e,t=>String.fromCodePoint(t)).join("");return btoa(r)}s(sE,"preprocessDiagram"),s(lE,"toBase64");var hE=["foreignobject"],cE=["dominant-baseline"];function uE(t){let e=sE(t);return Fd(),Ld(e.config??{}),e}async function dE(t,e){s$();try{let{code:e,config:r}=uE(t);return{diagramType:(await _E(e)).type,config:r}}catch(t){if(e?.suppressErrors)return!1;throw t}}s(uE,"processAndSetConfigs"),s(dE,"parse");var pE=s((t,e,r=[])=>`\n.${t} ${e} { ${r.join(" !important; ")} !important; }`,"cssImportantStyles"),fE=s((t,e=new Map)=>{let r="";if(void 0!==t.themeCSS&&(r+=`\n${t.themeCSS}`),void 0!==t.fontFamily&&(r+=`\n:root { --mermaid-font-family: ${t.fontFamily}}`),void 0!==t.altFontFamily&&(r+=`\n:root { --mermaid-alt-font-family: ${t.altFontFamily}}`),e instanceof Map){let i=t.htmlLabels??t.flowchart?.htmlLabels?["> *","span"]:["rect","polygon","ellipse","circle","path"];e.forEach(t=>{nL(t.styles)||i.forEach(e=>{r+=pE(t.id,e,t.styles)}),nL(t.textStyles)||(r+=pE(t.id,"tspan",(t?.textStyles||[]).map(t=>t.replace("color","fill"))))})}return r},"createCssStyles"),gE=s((t,e,r,i)=>{let n=fE(t,r);return X$(H$(`${i}{${Tf(e,n,t.themeVariables)}}`),Z$)},"createUserStyles"),yE=s((t="",e,r)=>{let i=t;return!r&&!e&&(i=i.replace(/marker-end="url\([\d+./:=?A-Za-z-]*?#/g,'marker-end="url(#')),i=o_(i),i=i.replace(/<br>/g,"<br/>"),i},"cleanUpSvgCode"),mE=s((t="",e)=>`<iframe style="width:100%;height:${e?.viewBox?.baseVal?.height?e.viewBox.baseVal.height+"px":"100%"};border:0;margin:0;" src="data:text/html;charset=UTF-8;base64,${lE(`<body style="margin:0">${t}</body>`)}" sandbox="allow-top-navigation-by-user-activation allow-popups">\n  The "iframe" tag is not supported by your browser.\n</iframe>`,"putIntoIFrame"),xE=s((t,e,r,i,n)=>{let a=t.append("div");a.attr("id",r),i&&a.attr("style",i);let o=a.append("svg").attr("id",e).attr("width","100%").attr("xmlns","http://www.w3.org/2000/svg");return n&&o.attr("xmlns:xlink",n),o.append("g"),t},"appendDivSvgG");function bE(t,e){return t.append("iframe").attr("id",e).attr("style","width: 100%; height: 100%;").attr("sandbox","")}s(bE,"sandboxedIframe");var kE=s((t,e,r,i)=>{t.getElementById(e)?.remove(),t.getElementById(r)?.remove(),t.getElementById(i)?.remove()},"removeExistingElements"),CE=s(async function(e,r,i){s$();let n=uE(r);r=n.code;let a=Bd();y.debug(a),r.length>(a?.maxTextSize??5e4)&&(r="graph TB;a[Maximum text size in diagram exceeded];style a fill:#faa");let o,l,h="#"+e,c="i"+e,u="#"+c,d="d"+e,p="#"+d,f=s(()=>{let t=Ke(m?u:p).node();t&&"remove"in t&&t.remove()},"removeTempElements"),g=Ke("body"),m="sandbox"===a.securityLevel,x="loose"===a.securityLevel,b=a.fontFamily;if(void 0!==i){if(i&&(i.innerHTML=""),m){let t=bE(Ke(i),c);g=Ke(t.nodes()[0].contentDocument.body),g.node().style.margin=0}else g=Ke(i);xE(g,e,d,`font-family: ${b}`,"http://www.w3.org/1999/xlink")}else{if(kE(document,e,d,c),m){let t=bE(Ke("body"),c);g=Ke(t.nodes()[0].contentDocument.body),g.node().style.margin=0}else g=Ke("body");xE(g,e,d)}try{o=await J$.fromText(r,{title:n.title})}catch(t){if(a.suppressErrorRendering)throw f(),t;o=await J$.fromText("error"),l=t}let k=g.select(p).node(),C=o.type,w=k.firstChild,_=w.firstChild,v=o.renderer.getClasses?.(r,o),S=gE(a,C,v,h),T=document.createElement("style");T.innerHTML=S,w.insertBefore(T,_);try{await o.renderer.draw(r,e,t.version,o)}catch(i){throw a.suppressErrorRendering?f():xF.draw(r,e,t.version),i}let M=g.select(`${p} svg`),B=o.db.getAccTitle?.(),A=o.db.getAccDescription?.();vE(C,M,B,A),g.select(`[id="${e}"]`).selectAll("foreignobject > *").attr("xmlns","http://www.w3.org/1999/xhtml");let L=g.select(p).node().innerHTML;if(y.debug("config.arrowMarkerAbsolute",a.arrowMarkerAbsolute),L=yE(L,m,af(a.arrowMarkerAbsolute)),m){let t=g.select(p+" svg").node();L=mE(L,t)}else x||(L=Hp.sanitize(L,{ADD_TAGS:hE,ADD_ATTR:cE,HTML_INTEGRATION_POINTS:{foreignobject:!0}}));if(eE(),l)throw l;return f(),{diagramType:C,svg:L,bindFunctions:o.db.bindFunctions}},"render");function wE(t={}){let e=eu({},t);e?.fontFamily&&!e.themeVariables?.fontFamily&&(e.themeVariables||(e.themeVariables={}),e.themeVariables.fontFamily=e.fontFamily),vd(e),e?.theme&&e.theme in cd?e.themeVariables=cd[e.theme].getThemeVariables(e.themeVariables):e&&(e.themeVariables=cd.default.getThemeVariables(e.themeVariables));let r="object"==typeof e?_d(e):Td();m(r.logLevel),s$()}s(wE,"initialize");var _E=s((t,e={})=>{let{code:r}=sE(t);return J$.fromText(r,e)},"getDiagramFromText");function vE(t,e,r,i){Q$(e,t),K$(e,r,i,e.attr("id"))}s(vE,"addA11yInfo");var SE=Object.freeze({render:CE,parse:dE,getDiagramFromText:_E,initialize:wE,getConfig:Bd,setConfig:Md,getSiteConfig:Td,updateSiteConfig:Sd,reset:s(()=>{Fd()},"reset"),globalReset:s(()=>{Fd(xd)},"globalReset"),defaultConfig:xd});m(Bd().logLevel),Fd(Bd());var TE=s((t,e,r)=>{y.warn(t),t_(t)?(r&&r(t.str,t.hash),e.push({...t,message:t.str,error:t})):(r&&r(t),t instanceof Error&&e.push({str:t.message,message:t.message,hash:t.name,error:t}))},"handleError"),ME=s(async function(t={querySelector:".mermaid"}){try{await BE(t)}catch(e){if(t_(e)&&y.error(e.str),zE.parseError&&zE.parseError(e),!t.suppressErrors)throw y.error("Use the suppressErrors option to suppress these errors"),e}},"run"),BE=s(async function({postRenderCallback:t,querySelector:e,nodes:r}={querySelector:".mermaid"}){let i,n=SE.getConfig();if(y.debug((t?"":"No ")+"Callback function found"),r)i=r;else{if(!e)throw new Error("Nodes and querySelector are both undefined");i=document.querySelectorAll(e)}y.debug(`Found ${i.length} diagrams`),void 0!==n?.startOnLoad&&(y.debug("Start On Load: "+n?.startOnLoad),SE.updateSiteConfig({startOnLoad:n?.startOnLoad}));let a,o=new n_.InitIDGenerator(n.deterministicIds,n.deterministicIDSeed),s=[];for(let e of Array.from(i)){if(y.info("Rendering diagram: "+e.id),e.getAttribute("data-processed"))continue;e.setAttribute("data-processed","true");let r=`mermaid-${o.next()}`;a=e.innerHTML,a=W_(n_.entityDecode(a)).trim().replace(/<br\s*\/?>/gi,"<br/>");let i=n_.detectInit(a);i&&y.debug("Detected early reinit: ",i);try{let{svg:i,bindFunctions:n}=await RE(r,a,e);e.innerHTML=i,t&&await t(r),n&&n(e)}catch(t){TE(t,s,zE.parseError)}}if(s.length>0)throw s[0]},"runThrowsErrors"),AE=s(function(t){SE.initialize(t)},"initialize"),LE=s(async function(t,e,r){y.warn("mermaid.init is deprecated. Please use run instead."),t&&AE(t);let i={postRenderCallback:r,querySelector:".mermaid"};"string"==typeof e?i.querySelector=e:e&&(e instanceof HTMLElement?i.nodes=[e]:i.nodes=e),await ME(i)},"init"),FE=s(async(t,{lazyLoad:e=!0}={})=>{s$(),Qc(...t),!1===e&&await l$()},"registerExternalDiagrams"),$E=s(function(){if(zE.startOnLoad){let{startOnLoad:t}=SE.getConfig();t&&zE.run().catch(t=>y.error("Mermaid failed to initialize",t))}},"contentLoaded");typeof document<"u"&&window.addEventListener("load",$E,!1);var EE=s(function(t){zE.parseError=t},"setParseErrorHandler"),DE=[],OE=!1,IE=s(async()=>{if(!OE){for(OE=!0;DE.length>0;){let t=DE.shift();if(t)try{await t()}catch(t){y.error("Error executing queue",t)}}OE=!1}},"executeQueue"),NE=s(async(t,e)=>new Promise((r,i)=>{let n=s(()=>new Promise((n,a)=>{SE.parse(t,e).then(t=>{n(t),r(t)},t=>{y.error("Error parsing",t),zE.parseError?.(t),a(t),i(t)})}),"performCall");DE.push(n),IE().catch(i)}),"parse"),RE=s((t,e,r)=>new Promise((i,n)=>{let a=s(()=>new Promise((a,o)=>{SE.render(t,e,r).then(t=>{a(t),i(t)},t=>{y.error("Error parsing",t),zE.parseError?.(t),o(t),n(t)})}),"performCall");DE.push(a),IE().catch(n)}),"render"),PE=s(()=>Object.keys(Xc).map(t=>({id:t})),"getRegisteredDiagramsMetadata"),zE={startOnLoad:!0,mermaidAPI:SE,parse:NE,render:RE,init:LE,run:ME,registerExternalDiagrams:FE,registerLayoutLoaders:EA,initialize:AE,parseError:void 0,contentLoaded:$E,setParseErrorHandler:EE,detectType:Zc,registerIconPacks:P_,getRegisteredDiagramsMetadata:PE},qE=zE;/*! Check if previously processed */
/*!
 * Wait for document loaded before starting the execution
 */export{If as $,Wf as A,Aa as B,fa as C,ba as D,jf as E,xa as F,Of as G,Ef as H,ma as I,s_ as J,Uf as K,i_ as L,Xw as M,$f as N,Bd as O,$u as P,ya as Q,ga as R,Yw as S,ca as T,Df as U,OA as V,Cf as W,ka as X,ci as Y,Lu as Z,la as _,qf as a,nL as a$,oa as a0,aa as a1,na as a2,Z as a3,p as a4,l as a5,Qf as a6,t as a7,r_ as a8,Vs as a9,af as aA,kS as aB,ix as aC,bS as aD,o_ as aE,Pw as aF,j_ as aG,P_ as aH,I_ as aI,Zi as aJ,Cn as aK,Nn as aL,lx as aM,sx as aN,LA as aO,HB as aP,QB as aQ,YT as aR,_S as aS,WB as aT,JB as aU,hA as aV,eA as aW,kw as aX,Zb as aY,Zk as aZ,$x as a_,zn as aa,rl as ab,ad as ac,fs as ad,yS as ae,Js as af,gf as ag,ff as ah,ww as ai,nf as aj,mf as ak,lf as al,ll as am,qw as an,Up as ao,wf as ap,Ru as aq,ju as ar,Hu as as,Mf as at,Id as au,UT as av,jB as aw,UB as ax,ys as ay,rx as az,Gw as b,fw as b0,qC as b1,PA as b2,tC as b3,rw as b4,Lx as b5,Ak as b6,eL as b7,lC as b8,wk as b9,gx as bA,dk as bB,yk as bC,dw as bD,sw as bE,u as bF,qE as bG,zk as ba,lk as bb,kC as bc,GC as bd,FC as be,jA as bf,Yb as bg,EC as bh,Mk as bi,Sk as bj,vC as bk,jk as bl,Ok as bm,yx as bn,Bx as bo,Kk as bp,RC as bq,Xk as br,TC as bs,yb as bt,_k as bu,Gb as bv,xw as bw,Rk as bx,yw as by,rC as bz,DA as c,n_ as d,Rf as e,dx as f,Qm as g,xf as h,Ke as i,Nf as j,Zm as k,zB as l,s as m,h as n,Qp as o,y as p,d as q,gd as r,ps as s,k as t,b as u,eu as v,Ww as w,ta as x,Q as y,Wa as z};
//# sourceMappingURL=index-BDq3hoFe.js.map
